########################################################################
# test/xslt/js_20001004.py
# Jeremy J. Sydik <Jeremy.Sydik@iuniverse.com> is having trouble with 
# pattern matches

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_pattern_matching_js_20001004(xslt_test):
    source = stringsource("""<?xml version="1.0" ?>
<top>
  <p class="normal">spam</p>
  <p class="indent">eggs</p>
  <p class="naught">lumberjack</p>
  <p>ok</p>
</top>""")
    transform = stringsource("""<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
    <xsl:template match='p[@class="normal"]'>
       <p><xsl:apply-templates/></p>
    </xsl:template>
    <xsl:template match='p[@class="indent"]'>
       <blockquote><p><xsl:apply-templates/></p></blockquote>
    </xsl:template>
    <xsl:template match="*|@*" priority="-1">
        <xsl:copy>
            <xsl:apply-templates select="@*|*|text()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<top>
  <p>spam</p>
  <blockquote><p>eggs</p></blockquote>
  <p class='naught'>lumberjack</p>
  <p>ok</p>
</top>"""


if __name__ == '__main__':
    test_main()
