########################################################################
# test/xslt/jt_20001120.py
# Jeni Tennison <Jeni.Tennison@epistemics.co.uk> expores the world of NaN

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_NaN_jt_20001120(xslt_test):
    source = stringsource("""<source/>""")
    transform = stringsource("""<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

<xsl:template match="/">
   <xsl:variable name="NaN" select="number('abc')" />
   String value of NaN: <xsl:value-of select="$NaN" />
   String value of boolean value of NaN: <xsl:value-of select="boolean($NaN)" />
   String value of boolean value of string value of NaN: <xsl:value-of select="boolean(string($NaN))" />
   String value of numerical value of boolean value of NaN: <xsl:value-of select="number(boolean($NaN))" />
   String value of numerical value of boolean value of string value of NaN: <xsl:value-of select="number(boolean(string($NaN)))" />
</xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version="1.0" encoding="UTF-8"?>

   String value of NaN: NaN
   String value of boolean value of NaN: false
   String value of boolean value of string value of NaN: true
   String value of numerical value of boolean value of NaN: 0
   String value of numerical value of boolean value of string value of NaN: 1"""

   saxon_expected = """   String value of NaN: NaN
   String value of boolean value of NaN: false
   String value of boolean value of string value of NaN: true
   String value of numerical value of boolean value of NaN: 0
   String value of numerical value of boolean value of string value of NaN: 1
"""

if __name__ == '__main__':
    test_main()
