########################################################################
# test/xslt/mb_20011019.py
# expat2domlette.c seems to get confused about xmlns attributes,
# like which part is the localName and which part is the prefix.

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_x_namespace_copy_through_mb_20011019(xslt_test):
    source = stringsource("""\
<?xml version="1.0"?>
<foobar/>""")
    transform = stringsource("""\
<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0"
xmlns:ss="urn:wonky"
>
  <xsl:output method="xml" indent="yes"/>

  <xsl:template match="/">
    <results/>
  </xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<results xmlns:ss="urn:wonky"/>"""

if __name__ == '__main__':
    test_main()

