########################################################################
# test/xslt/mb_20020709.py
# Mike Brown reported a problem with minidom and children nodes

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_x_descendants_of_different_node_types_mb_20020709(xslt_test):
    source = stringsource("""<?xml version="1.0" encoding="utf-8"?>
<doc>
<elem xmlns:unused="urn:uuu000"/>
<elem xmlns="urn:sss111"/>
<y:elem xmlns:y="urn:yyyy222"/>
</doc>""")
    transform = stringsource("""<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" indent="no"/>

<xsl:template match="/">
<result xmlns:new="urn:added-by-stylesheet">
<xsl:text>&#10;</xsl:text>
<r>total nodes: <xsl:value-of select="count(//node()
|//node()/namespace::node())"/></r>
<xsl:text>&#10;</xsl:text>
<r>copy:&#10;<xsl:copy-of select="."/></r>
</result>
</xsl:template>

</xsl:stylesheet>
""")
    parameters = {}
    expected = """<?xml version="1.0" encoding="utf-8"?>
<result xmlns:new="urn:added-by-stylesheet">
<r>total nodes: 15</r>
<r>copy:
<doc>
<elem xmlns:unused="urn:uuu000"/>
<elem xmlns="urn:sss111"/>
<y:elem xmlns:y="urn:yyyy222"/>
</doc></r></result>"""

if __name__ == '__main__':
    test_main()
