########################################################################
# test/xslt/sb_20000628.py
# Steve Brown <prospect@flex.com.au> on 28 July 2000 posted what he felt
# was a bug in Xalan.  David Carlisle later confirmed it was a bug 
# pointing out the correct output from XT

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_test_xalan_bug_sb_20000628(xslt_test):
    source = stringsource("""<?xml version="1.0"?>
<list>
    <item a="1" include="yes"/>
    <item a="2" include="no"/>
    <item a="3" include="no"/>
    <item a="4" include="no"/>
    <item a="5" include="yes"/>
    <item a="6" include="yes"/>
    <item a="7" include="yes"/>
</list>""")
    transform = stringsource("""<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

<xsl:template match="list">
    <xsl:apply-templates select="item[@include='yes']"/>
</xsl:template>

<xsl:template match="item">
    *<xsl:value-of select="@a"/>*
    position = <xsl:value-of select="position()"/>
    last = <xsl:value-of select="last()"/>
</xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version="1.0" encoding="UTF-8"?>

    *1*
    position = 1
    last = 4
    *5*
    position = 2
    last = 4
    *6*
    position = 3
    last = 4
    *7*
    position = 4
    last = 4"""


if __name__ == '__main__':
    test_main()
