########################################################################
# test/xslt/spec_namespace_alias.py
# From the XSLT spec: 
# http://docs.local/REC-xslt-19991116.html#dt-literal-namespace-uri
import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_spec_namespace_alias(xslt_test):
    source = stringsource("""<elements>
              <block>p</block>
              <block>h1</block>
              <block>h2</block>
              <block>h3</block>
              <block>h4</block>
              </elements>""")
    transform = stringsource("""<xsl:stylesheet
                version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias">

              <xsl:namespace-alias stylesheet-prefix="axsl" result-prefix="xsl"/>

              <xsl:template match="/">
                <axsl:stylesheet>
                  <xsl:apply-templates/>
                </axsl:stylesheet>
              </xsl:template>

              <xsl:template match="block">
                <axsl:template match="{.}">
                   <fo:block><axsl:apply-templates/></fo:block>
                </axsl:template>
              </xsl:template>

              </xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet xmlns:fo='http://www.w3.org/1999/XSL/Format' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
              <xsl:template match='p'><fo:block><xsl:apply-templates/></fo:block></xsl:template>
              <xsl:template match='h1'><fo:block><xsl:apply-templates/></fo:block></xsl:template>
              <xsl:template match='h2'><fo:block><xsl:apply-templates/></fo:block></xsl:template>
              <xsl:template match='h3'><fo:block><xsl:apply-templates/></fo:block></xsl:template>
              <xsl:template match='h4'><fo:block><xsl:apply-templates/></fo:block></xsl:template>
              </xsl:stylesheet>"""


if __name__ == '__main__':
    test_main()
