# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeployedServiceReplicaDetailInfo(Model):
    """Information about a Service Fabric service replica deployed on a node.

    :param service_name:
    :type service_name: str
    :param partition_id:
    :type partition_id: str
    :param current_service_operation: Possible values include: 'Unknown',
     'None', 'Open', 'ChangeRole', 'Close', 'Abort'
    :type current_service_operation: str or :class:`enum
     <azure.servicefabric.models.enum>`
    :param current_service_operation_start_time_utc: The start time of the
     current service operation in UTC format.
    :type current_service_operation_start_time_utc: datetime
    :param reported_load:
    :type reported_load: list of :class:`LoadMetricReportInfo
     <azure.servicefabric.models.LoadMetricReportInfo>`
    :param service_kind: Polymorphic Discriminator
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'current_service_operation': {'key': 'CurrentServiceOperation', 'type': 'str'},
        'current_service_operation_start_time_utc': {'key': 'CurrentServiceOperationStartTimeUtc', 'type': 'iso-8601'},
        'reported_load': {'key': 'ReportedLoad', 'type': '[LoadMetricReportInfo]'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'DeployedStatefulServiceReplicaDetailInfo', 'Stateless': 'DeployedStatelessServiceInstanceDetailInfo'}
    }

    def __init__(self, service_name=None, partition_id=None, current_service_operation=None, current_service_operation_start_time_utc=None, reported_load=None):
        self.service_name = service_name
        self.partition_id = partition_id
        self.current_service_operation = current_service_operation
        self.current_service_operation_start_time_utc = current_service_operation_start_time_utc
        self.reported_load = reported_load
        self.service_kind = None
