# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NodeImpact(Model):
    """Describes the expected impact of a repair to a particular node.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.
    .

    :param node_name: The name of the impacted node.
    :type node_name: str
    :param impact_level: The level of impact expected. Possible values
     include: 'Invalid', 'None', 'Restart', 'RemoveData', 'RemoveNode'
    :type impact_level: str or :class:`enum <azure.servicefabric.models.enum>`
    """

    _validation = {
        'node_name': {'required': True},
    }

    _attribute_map = {
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'impact_level': {'key': 'ImpactLevel', 'type': 'str'},
    }

    def __init__(self, node_name, impact_level=None):
        self.node_name = node_name
        self.impact_level = impact_level
