# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PagedSubNameInfoList(Model):
    """A paged list of Service Fabric names. The list is paged when all of the
    results cannot fit in a single message. The next set of results can be
    obtained by executing the same query with the continuation token provided
    in this list.

    :param continuation_token:
    :type continuation_token: str
    :param is_consistent: Indicates whether any name under the given name has
     been modified during the enumeration. If there was a modification, this
     property value is false.
    :type is_consistent: bool
    :param sub_names:
    :type sub_names: list of str
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'is_consistent': {'key': 'IsConsistent', 'type': 'bool'},
        'sub_names': {'key': 'SubNames', 'type': '[str]'},
    }

    def __init__(self, continuation_token=None, is_consistent=None, sub_names=None):
        self.continuation_token = continuation_token
        self.is_consistent = is_consistent
        self.sub_names = sub_names
