# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .chaos_event import ChaosEvent


class StoppedChaosEvent(ChaosEvent):
    """Describes a Chaos event that gets generated when Chaos stops because either
    the user issued a stop or the time to run was up.

    :param time_stamp_utc:
    :type time_stamp_utc: datetime
    :param kind: Polymorphic Discriminator
    :type kind: str
    :param reason:
    :type reason: str
    """

    _validation = {
        'time_stamp_utc': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'reason': {'key': 'Reason', 'type': 'str'},
    }

    def __init__(self, time_stamp_utc, reason=None):
        super(StoppedChaosEvent, self).__init__(time_stamp_utc=time_stamp_utc)
        self.reason = reason
        self.kind = 'Stopped'
