# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .tipos_geral_cte_v4_00 import (
    TAMB,
    TCODUFIBGE,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"


class TconsStatServ(models.AbstractModel):
    "Tipo Pedido de Consulta do Status do Serviço CTe"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tconsstatserv"
    _inherit = "spec.mixin.cte"
    _binding_type = "TconsStatServ"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF a ser verificado o status",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
        help=("Código da UF a ser verificado o status\nUtilizar a Tabela do " "IBGE."),
    )

    cte40_xServ = fields.Char(
        string="Serviço Solicitado", xsd_required=True, xsd_type="TServ"
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True)


class TretConsStatServ(models.AbstractModel):
    "Tipo Resultado da Consulta do Status do Serviço CTe"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tretconsstatserv"
    _inherit = "spec.mixin.cte"
    _binding_type = "TretConsStatServ"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        help="Versão do Aplicativo que processou o CT-e",
    )

    cte40_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    cte40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF responsável pelo serviço",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    cte40_dhRecbto = fields.Datetime(
        string="AAAA-MM-DDTHH:MM:SS TZD", xsd_required=True, xsd_type="TDateTimeUTC"
    )

    cte40_tMed = fields.Char(
        string="Tempo médio de resposta do serviço",
        help=(
            "Tempo médio de resposta do serviço (em segundos) dos últimos 5 " "minutos"
        ),
    )

    cte40_dhRetorno = fields.Datetime(
        string="AAAA-MM-DDTHH:MM:SSDeve ser preenchida",
        xsd_type="TDateTimeUTC",
        help=(
            "AAAA-MM-DDTHH:MM:SSDeve ser preenchida com data e hora previstas "
            "para o retorno dos serviços prestados."
        ),
    )

    cte40_xObs = fields.Char(
        string="Campo observação utilizado",
        help=("Campo observação utilizado para incluir informações ao " "contribuinte"),
    )

    cte40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerConsStat"
    )
