# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

"Direção"
AQUAV_DIREC = [
    ("N", "Norte, L-Leste, S-Sul, O-Oeste"),
    ("S", "Sul, O-Oeste"),
    ("L", "Leste, S-Sul, O-Oeste"),
    ("O", "Oeste"),
]

"Tipo de Navegação"
AQUAV_TPNAV = [
    ("0", "Interior"),
    ("1", "Cabotagem"),
]


class Aquav(models.AbstractModel):
    "Informações do modal Aquaviário"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.aquav"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aquav"

    cte40_vPrest = fields.Monetary(
        string="Valor da Prestação Base de Cálculo",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor da Prestação Base de Cálculo do AFRMM",
    )

    cte40_vAFRMM = fields.Monetary(
        string="AFRMM",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=("AFRMM (Adicional de Frete para Renovação da Marinha Mercante)"),
    )

    cte40_xNavio = fields.Char(string="Identificação do Navio", xsd_required=True)

    cte40_balsa = fields.One2many(
        "cte.40.balsa", "cte40_balsa_aquav_id", string="Grupo de informações das balsas"
    )

    cte40_nViag = fields.Char(string="Número da Viagem")

    cte40_direc = fields.Selection(
        AQUAV_DIREC,
        string="Direção",
        xsd_required=True,
        help="Direção\nPreencher com: N-Norte, L-Leste, S-Sul, O-Oeste",
    )

    cte40_irin = fields.Char(
        string="Irin do navio sempre deverá",
        xsd_required=True,
        help="Irin do navio sempre deverá ser informado",
    )

    cte40_detCont = fields.One2many(
        "cte.40.detcont",
        "cte40_detCont_aquav_id",
        string="Grupo de informações de detalhamento",
        help=(
            "Grupo de informações de detalhamento dos conteiners \n(Somente "
            "para Redespacho Intermediário e Serviço Vinculado a Multimodal)"
        ),
    )

    cte40_tpNav = fields.Selection(
        AQUAV_TPNAV,
        string="Tipo de Navegação",
        help=(
            "Tipo de Navegação\nPreencher com: \n\t\t\t\t\t\t0 - "
            "Interior;\n\t\t\t\t\t\t1 - Cabotagem"
        ),
    )


class Balsa(models.AbstractModel):
    "Grupo de informações das balsas"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.balsa"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aquav.Balsa"

    cte40_balsa_aquav_id = fields.Many2one(
        comodel_name="cte.40.aquav", xsd_implicit=True, ondelete="cascade"
    )
    cte40_xBalsa = fields.Char(string="Identificador da Balsa", xsd_required=True)


class DetCont(models.AbstractModel):
    """Grupo de informações de detalhamento dos conteiners
    (Somente para Redespacho Intermediário e Serviço Vinculado a Multimodal)"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.detcont"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aquav.DetCont"

    cte40_detCont_aquav_id = fields.Many2one(
        comodel_name="cte.40.aquav", xsd_implicit=True, ondelete="cascade"
    )
    cte40_nCont = fields.Char(
        string="Identificação do Container", xsd_required=True, xsd_type="TContainer"
    )

    cte40_lacre = fields.One2many(
        "cte.40.lacre",
        "cte40_lacre_detCont_id",
        string="Grupo de informações dos lacres",
        help=("Grupo de informações dos lacres dos cointainers da qtde da carga"),
    )

    cte40_infDoc = fields.Many2one(
        comodel_name="cte.40.aquav_infdoc",
        string="Informações dos documentos",
        help="Informações dos documentos dos conteiners",
    )


class Lacre(models.AbstractModel):
    "Grupo de informações dos lacres dos cointainers da qtde da carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.lacre"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aquav.DetCont.Lacre"

    cte40_lacre_detCont_id = fields.Many2one(
        comodel_name="cte.40.detcont", xsd_implicit=True, ondelete="cascade"
    )
    cte40_nLacre = fields.Char(string="Lacre", xsd_required=True)


class AquavInfDoc(models.AbstractModel):
    "Informações dos documentos dos conteiners"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.aquav_infdoc"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aquav.DetCont.InfDoc"

    cte40_infNF = fields.One2many(
        "cte.40.aquav_infnf",
        "cte40_infNF_infDoc_id",
        string="Informações das NF",
        choice="infdoc",
        xsd_choice_required=True,
    )

    cte40_infNFe = fields.One2many(
        "cte.40.aquav_infnfe",
        "cte40_infNFe_infDoc_id",
        string="Informações das NFe",
        choice="infdoc",
        xsd_choice_required=True,
    )


class AquavInfNf(models.AbstractModel):
    "Informações das NF"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.aquav_infnf"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aquav.DetCont.InfDoc.InfNf"

    cte40_infNF_infDoc_id = fields.Many2one(
        comodel_name="cte.40.aquav_infdoc", xsd_implicit=True, ondelete="cascade"
    )
    cte40_serie = fields.Char(string="Série", xsd_required=True)

    cte40_nDoc = fields.Char(string="Número", xsd_required=True)

    cte40_unidRat = fields.Monetary(
        string="Unidade de medida rateada",
        xsd_type="TDec_0302_0303",
        currency_field="brl_currency_id",
        help="Unidade de medida rateada (Peso,Volume)",
    )


class AquavInfNfe(models.AbstractModel):
    "Informações das NFe"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.aquav_infnfe"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aquav.DetCont.InfDoc.InfNfe"

    cte40_infNFe_infDoc_id = fields.Many2one(
        comodel_name="cte.40.aquav_infdoc", xsd_implicit=True, ondelete="cascade"
    )
    cte40_chave = fields.Char(
        string="Chave de acesso da NF-e", xsd_required=True, xsd_type="TChDFe"
    )

    cte40_unidRat = fields.Monetary(
        string="Unidade de medida rateada",
        xsd_type="TDec_0302_0303",
        currency_field="brl_currency_id",
        help="Unidade de medida rateada (Peso,Volume)",
    )
