# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .tipos_geral_cte_v4_00 import TUF

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

"Tipo Fretamento"
INFFRETAMENTO_TPFRETAMENTO = [
    ("1", "Eventual 2 - Continuo"),
    ("2", "Continuo"),
]

"Tipo Proprietário ou possuidor"
PROP_TPPROP = [
    ("0", "TAC – Agregado"),
    ("1", "TAC Independente"),
    ("2", "Outros."),
]


class RodoOs(models.AbstractModel):
    "Informações do modal Rodoviário"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.rodoos"
    _inherit = "spec.mixin.cte"
    _binding_type = "RodoOs"

    cte40_TAF = fields.Char(
        string="Termo de Autorização de Fretamento – TAF",
        choice="rodoos",
        xsd_choice_required=True,
        xsd_type="TTermoAutFreta",
        help=(
            "Termo de Autorização de Fretamento – TAF\nRegistro obrigatório do"
            " emitente do CT-e OS junto à ANTT, de acordo com a Resolução ANTT"
            " nº 4.777/2015"
        ),
    )

    cte40_NroRegEstadual = fields.Char(
        string="Número do Registro Estadual",
        choice="rodoos",
        xsd_choice_required=True,
        xsd_type="TNroRegEstadual",
        help=(
            "Número do Registro Estadual\nRegistro obrigatório do emitente do "
            "CT-e OS junto à Agência Reguladora  Estadual."
        ),
    )

    cte40_veic = fields.Many2one(comodel_name="cte.40.veic", string="Dados do Veículo")

    cte40_infFretamento = fields.Many2one(
        comodel_name="cte.40.inffretamento",
        string="Dados do fretamento",
        help="Dados do fretamento (apenas para Transporte de Pessoas)",
    )


class Veic(models.AbstractModel):
    "Dados do Veículo"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.veic"
    _inherit = "spec.mixin.cte"
    _binding_type = "RodoOs.Veic"

    cte40_placa = fields.Char(string="Placa do veículo", xsd_required=True)

    cte40_RENAVAM = fields.Char(string="RENAVAM do veículo")

    cte40_prop = fields.Many2one(
        comodel_name="cte.40.prop",
        string="Proprietário ou possuidor do Veículo",
        help=(
            "Proprietário ou possuidor do Veículo.\nSó preenchido quando o "
            "veículo não pertencer à empresa emitente do CT-e OS"
        ),
    )

    cte40_UF = fields.Selection(
        TUF,
        string="UF em que veículo está licenciado",
        xsd_type="TUf",
        help=(
            "UF em que veículo está licenciado\nSigla da UF de licenciamento "
            "do veículo."
        ),
    )


class Prop(models.AbstractModel):
    """Proprietário ou possuidor do Veículo.
    Só preenchido quando o veículo não pertencer à empresa emitente do CT-e OS"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.prop"
    _inherit = "spec.mixin.cte"
    _binding_type = "RodoOs.Veic.Prop"

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="prop",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="prop",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help="Número do CNPJ\nInformar os zeros não significativos.",
    )

    cte40_TAF = fields.Char(
        string="Termo de Autorização de Fretamento – TAF",
        choice="prop",
        xsd_choice_required=True,
        xsd_type="TTermoAutFreta",
        help=(
            "Termo de Autorização de Fretamento – TAF\nDe acordo com a "
            "Resolução ANTT nº 4.777/2015"
        ),
    )

    cte40_NroRegEstadual = fields.Char(
        string="Número do Registro Estadual",
        choice="prop",
        xsd_choice_required=True,
        xsd_type="TNroRegEstadual",
        help=(
            "Número do Registro Estadual\nRegistro obrigatório do emitente do "
            "CT-e OS junto à Agência Reguladora  Estadual"
        ),
    )

    cte40_xNome = fields.Char(
        string="Razão Social ou Nome do proprietário", xsd_required=True
    )

    cte40_IE = fields.Char(string="Inscrição Estadual")

    cte40_UF = fields.Selection(TUF, string="UF", xsd_type="TUf")

    cte40_tpProp = fields.Selection(
        PROP_TPPROP,
        string="Tipo Proprietário ou possuidor",
        xsd_required=True,
        help=(
            "Tipo Proprietário ou possuidor\nPreencher "
            "com:\n\t\t\t\t\t\t\t\t\t\t\t\t0-TAC – "
            "Agregado;\n\t\t\t\t\t\t\t\t\t\t\t\t1-TAC Independente; ou "
            "\n\t\t\t\t\t\t\t\t\t\t\t\t2 – Outros."
        ),
    )


class InfFretamento(models.AbstractModel):
    "Dados do fretamento (apenas para Transporte de Pessoas)"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.inffretamento"
    _inherit = "spec.mixin.cte"
    _binding_type = "RodoOs.InfFretamento"

    cte40_tpFretamento = fields.Selection(
        INFFRETAMENTO_TPFRETAMENTO,
        string="Tipo Fretamento",
        xsd_required=True,
        help="Tipo Fretamento\nPreencher com:\n 1 - Eventual 2 - Continuo",
    )

    cte40_dhViagem = fields.Datetime(
        string="Data e hora da viagem",
        xsd_type="TDateTimeUTC",
        help=(
            "Data e hora da viagem (Apenas para fretamento eventual)\nFormato "
            "AAAA-MM-DDTHH:MM:DD TZD"
        ),
    )
