# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .cte_tipos_basico_v4_00 import INFESPECIE_TPESPECIE

from .tipos_geral_cte_v4_00 import TUF

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

"Descrição do Evento - “Informações da GTV”"
EVGTV_DESCEVENTO = [
    ("Informações da GTV", "Informações da GTV"),
    ("Informacoes da GTV", "Informacoes da GTV"),
]


class EvGtv(models.AbstractModel):
    "Schema XML de validação do evento informações da GTV 110170"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.evgtv"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvGtv"

    cte40_descEvento = fields.Selection(
        EVGTV_DESCEVENTO,
        string="Descrição do Evento",
        xsd_required=True,
        help="Descrição do Evento - “Informações da GTV”",
    )

    cte40_infGTV = fields.One2many(
        "cte.40.infgtv", "cte40_infGTV_evGTV_id", string="Grupo de Informações das GTV"
    )


class InfGtv(models.AbstractModel):
    "Grupo de Informações das GTV"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infgtv"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvGtv.InfGtv"

    cte40_infGTV_evGTV_id = fields.Many2one(
        comodel_name="cte.40.evgtv", xsd_implicit=True, ondelete="cascade"
    )
    cte40_nDoc = fields.Char(string="Número da GTV", xsd_required=True)

    cte40_id = fields.Char(
        string="Identificador para diferenciar GTV",
        xsd_required=True,
        help=(
            "Identificador para diferenciar GTV de mesmo número (Usar número "
            "do AIDF ou  identificador interno da empresa),"
        ),
    )

    cte40_serie = fields.Char(string="Série")

    cte40_subserie = fields.Char(string="Subsérie")

    cte40_dEmi = fields.Date(
        string="Data de Emissão",
        xsd_required=True,
        xsd_type="TData",
        help="Data de Emissão\nFormato AAAA-MM-DD",
    )

    cte40_nDV = fields.Char(string="Número Dígito Verificador", xsd_required=True)

    cte40_qCarga = fields.Float(
        string="Quantidade de volumes/malotes",
        xsd_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
    )

    cte40_infEspecie = fields.One2many(
        "cte.40.evgtv_infespecie",
        "cte40_infEspecie_infGTV_id",
        string="Informações das Espécies transportadas",
    )

    cte40_rem = fields.Many2one(
        comodel_name="cte.40.evgtv_rem",
        string="Informações do Remetente da GTV",
        xsd_required=True,
    )

    cte40_dest = fields.Many2one(
        comodel_name="cte.40.evgtv_dest",
        string="Informações do Destinatário da GTV",
        xsd_required=True,
    )

    cte40_placa = fields.Char(string="Placa do veículo", xsd_type="TPlaca")

    cte40_UF = fields.Selection(
        TUF,
        string="UF em que veículo está licenciado",
        xsd_type="TUf",
        help=(
            "UF em que veículo está licenciado\nSigla da UF de licenciamento "
            "do veículo."
        ),
    )

    cte40_RNTRC = fields.Char(string="RNTRC do transportador")


class EvGtvInfEspecie(models.AbstractModel):
    "Informações das Espécies transportadas"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.evgtv_infespecie"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvGtv.InfGtv.InfEspecie"

    cte40_infEspecie_infGTV_id = fields.Many2one(
        comodel_name="cte.40.infgtv", xsd_implicit=True, ondelete="cascade"
    )
    cte40_tpEspecie = fields.Selection(
        INFESPECIE_TPESPECIE,
        string="Tipo da Espécie",
        xsd_required=True,
        help=("Tipo da Espécie\n1 - Numerário\n2 - Cheque\n3 - Moeda\n4 - Outros"),
    )

    cte40_vEspecie = fields.Monetary(
        string="Valor Transportada em Espécie indicada",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class EvGtvRem(models.AbstractModel):
    "Informações do Remetente da GTV"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.evgtv_rem"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvGtv.InfGtv.Rem"

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="rem",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\n\t\t\t\t\t\t\t\t\t\t\t\tInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="rem",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        help=(
            "Inscrição Estadual\nInformar a IE do remetente ou ISENTO se "
            "remetente é contribuinte do ICMS isento de inscrição no cadastro "
            "de contribuintes do ICMS. Caso o remetente não seja contribuinte "
            "do ICMS não informar o conteúdo."
        ),
    )

    cte40_UF = fields.Selection(
        TUF,
        string="Sigla da UF",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF\nInformar EX para operações com o exterior.",
    )

    cte40_xNome = fields.Char(
        string="Razão social ou nome do remetente", xsd_required=True
    )


class EvGtvDest(models.AbstractModel):
    "Informações do Destinatário da GTV"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.evgtv_dest"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvGtv.InfGtv.Dest"

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="dest",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com zeros.\n\t\t\t\t\t\t\tInformar os zeros"
            " não significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="dest",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        help=(
            "Inscrição Estadual\nInformar a IE do destinatário ou ISENTO se "
            "remetente é contribuinte do ICMS isento de inscrição no cadastro "
            "de contribuintes do ICMS. Caso o remetente não seja contribuinte "
            "do ICMS não informar o conteúdo."
        ),
    )

    cte40_UF = fields.Selection(
        TUF,
        string="Sigla da UF",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF\nInformar EX para operações com o exterior.",
    )

    cte40_xNome = fields.Char(
        string="Razão social ou nome do destinatário", xsd_required=True
    )
