# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

"Descrição do Evento - “Insucesso na Entrega do CT-e”"
EVIECTE_DESCEVENTO = [
    ("Insucesso na Entrega do CT-e", "Insucesso na Entrega do CT-e"),
]

"Motivo do insucesso"
EVIECTE_TPMOTIVO = [
    ("1", " Recebedor não encontrado"),
    ("2", " Recusa do recebedor"),
    ("3", " Endereço inexistente"),
    ("4", " Outros (exige informar justificativa)"),
]


class EvIecte(models.AbstractModel):
    """Schema XML de validação do evento insucesso na entrega eletrônico do
    CT-e
    110190"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.eviecte"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvIecte"

    cte40_descEvento = fields.Selection(
        EVIECTE_DESCEVENTO,
        string="Descrição do Evento",
        xsd_required=True,
        help="Descrição do Evento - “Insucesso na Entrega do CT-e”",
    )

    cte40_nProt = fields.Char(
        string="Número do Protocolo de autorização",
        xsd_required=True,
        xsd_type="TProt",
        help="Número do Protocolo de autorização do CT-e",
    )

    cte40_dhTentativaEntrega = fields.Char(
        string="Data e hora da tentativa da entrega",
        xsd_required=True,
        help=(
            "Data e hora da tentativa da entrega da NF-e\nFormato AAAA-MM-"
            "DDTHH:MM:DD TZD"
        ),
    )

    cte40_nTentativa = fields.Char(
        string="Número da tentativa de entrega",
        help="Número da tentativa de entrega que não teve insucesso",
    )

    cte40_tpMotivo = fields.Selection(
        EVIECTE_TPMOTIVO,
        string="Motivo do insucesso",
        xsd_required=True,
        help=(
            "Motivo do insucesso\n1- Recebedor não encontrado;\n2- Recusa do "
            "recebedor;\n3- Endereço inexistente;\n4- Outros (exige informar "
            "justificativa)"
        ),
    )

    cte40_xJustMotivo = fields.Char(
        string="Justificativa do Motivo de insucesso",
        help=(
            "Justificativa do Motivo de insucesso, informar apenas para " "tpMotivo = 4"
        ),
    )

    cte40_latitude = fields.Char(
        string="Latitude do ponto de entrega", xsd_type="TLatitude"
    )

    cte40_longitude = fields.Char(
        string="Longitude do ponto de entrega", xsd_type="TLongitude"
    )

    cte40_hashTentativaEntrega = fields.Char(
        string="Hash",
        help=(
            "Hash (SHA1) no formato Base64 resultante da concatenação: Chave "
            "de acesso do CT-e + Base64 da imagem capturada da tentativa com "
            "insucesso da entrega (Exemplo: foto do local que não recebeu a "
            "entrega ou do local sem recebedor)\nO hashCSRT é o resultado das "
            "funções SHA-1 e base64 do token CSRT fornecido pelo fisco + chave"
            " de acesso do DF-e. (Implementação em futura NT)\nObservação: 28 "
            "caracteres são representados no schema como 20 bytes do tipo "
            "base64Binary"
        ),
    )

    cte40_dhHashTentativaEntrega = fields.Char(
        string="Data e hora de geração",
        help=(
            "Data e hora de geração do hash tentativa entrega\nFormato AAAA-"
            "MM-DDTHH:MM:DD TZD"
        ),
    )

    cte40_infEntrega = fields.One2many(
        "cte.40.eviecte_infentrega",
        "cte40_infEntrega_evIECTe_id",
        string="Grupo de informações das NF-e",
        help=(
            "Grupo de informações das NF-e que não tiveram sucesso na entrega "
            "ao Destinatário\nInformar o grupo apenas para CT-e com tipo de "
            "serviço Normal"
        ),
    )


class EvIecteInfEntrega(models.AbstractModel):
    """Grupo de informações das NF-e que não tiveram sucesso na entrega ao
    Destinatário
    Informar o grupo apenas para CT-e com tipo de serviço Normal"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.eviecte_infentrega"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvIecte.InfEntrega"

    cte40_infEntrega_evIECTe_id = fields.Many2one(
        comodel_name="cte.40.eviecte", xsd_implicit=True, ondelete="cascade"
    )
    cte40_chNFe = fields.Char(
        string="Chave de acesso da NF-e com insucesso",
        xsd_required=True,
        xsd_type="TChDFe",
        help=("Chave de acesso da NF-e com insucesso na tentativa de entrega"),
    )
