# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .tipos_geral_mdfe_v3_00 import (
    TAMB,
    TCODUFIBGE,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"


class TconsMdfeNaoEnc(models.AbstractModel):
    "Tipo Pedido de Consulta MDF-e Não Encerrados"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tconsmdfenaoenc"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TconsMdfeNaoEnc"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_xServ = fields.Char(
        string="Serviço Solicitado", xsd_required=True, xsd_type="TServ"
    )

    mdfe30_CNPJ = fields.Char(
        string="CNPJ do emitente do MDF-e",
        choice="tconsmdfenaoenc",
        xsd_choice_required=True,
        xsd_type="TCnpj",
        help="CNPJ do emitente do MDF-e\nInformar zeros não significativos",
    )

    mdfe30_CPF = fields.Char(
        string="CPF do emitente do MDF-e",
        choice="tconsmdfenaoenc",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help=(
            "CPF do emitente do MDF-e\nInformar zeros não significativos\nUsar"
            " com serie específica 920-969 para emitente pessoa física com "
            "inscrição estadual"
        ),
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True)


class TretConsMdfeNaoEnc(models.AbstractModel):
    "Tipo Retorno de Pedido de Consulta MDF-e não Encerrados"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tretconsmdfenaoenc"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretConsMdfeNaoEnc"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou o MDF-e",
    )

    mdfe30_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    mdfe30_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    mdfe30_cUF = fields.Selection(
        TCODUFIBGE,
        string="código da UF de atendimento",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    mdfe30_infMDFe = fields.One2many(
        "mdfe.30.tretconsmdfenaoenc_infmdfe",
        "mdfe30_infMDFe_TRetConsMDFeNaoEnc_id",
        string="infMDFe",
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerConsMDFeNaoEnc"
    )


class TretConsMdfeNaoEncInfMdfe(models.AbstractModel):
    _description = "infMDFe"
    _name = "mdfe.30.tretconsmdfenaoenc_infmdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretConsMdfeNaoEnc.InfMdfe"

    mdfe30_infMDFe_TRetConsMDFeNaoEnc_id = fields.Many2one(
        comodel_name="mdfe.30.tretconsmdfenaoenc", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_chMDFe = fields.Char(
        string="Chaves de acesso do MDF-e não encerrado",
        xsd_required=True,
        xsd_type="TChMDFe",
    )

    mdfe30_nProt = fields.Char(
        string="Número do Protocolo de autorização",
        xsd_required=True,
        xsd_type="TProt",
        help="Número do Protocolo de autorização do MDF-e não encerrado",
    )
