# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .tipos_geral_mdfe_v3_00 import TAMB

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"


class TmdfeDfe(models.AbstractModel):
    "Tipo Documento Fiscal Eletrônico MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tmdfedfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TmdfeDfe"

    mdfe30_procMDFe = fields.Many2one(
        comodel_name="mdfe.30.procmdfe", string="procMDFe", xsd_required=True
    )

    mdfe30_procEventoMDFe = fields.One2many(
        "mdfe.30.tmdfedfe_proceventomdfe",
        "mdfe30_procEventoMDFe_TMDFeDFe_id",
        string="procEventoMDFe",
    )


class ProcMdfe(models.AbstractModel):
    _description = "procMDFe"
    _name = "mdfe.30.procmdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TmdfeDfe.ProcMdfe"

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerMDFeConsultaDFe"
    )


class TmdfeDfeProcEventoMdfe(models.AbstractModel):
    _description = "procEventoMDFe"
    _name = "mdfe.30.tmdfedfe_proceventomdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TmdfeDfe.ProcEventoMdfe"

    mdfe30_procEventoMDFe_TMDFeDFe_id = fields.Many2one(
        comodel_name="mdfe.30.tmdfedfe", xsd_implicit=True, ondelete="cascade"
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerMDFeConsultaDFe"
    )


class TmdfeConsultaDfe(models.AbstractModel):
    """Tipo Pedido de Consulta do Manifesto Eletrônico de Documentos Fiscais"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tmdfeconsultadfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TmdfeConsultaDfe"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_xServ = fields.Char(
        string="Serviço Solicitado", xsd_required=True, xsd_type="TServ"
    )

    mdfe30_chMDFe = fields.Char(
        string="Chaves de acesso do MDF-e",
        xsd_required=True,
        xsd_type="TChNFe",
        help=(
            "Chaves de acesso do MDF-e, compostas por: UF do emitente, AAMM da"
            " emissão do MDF-e, CNPJ do emitente, modelo, série e número do "
            "MDF-e e código numérico + DV."
        ),
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerMDFeConsultaDFe"
    )


class TretMdfeConsultaDfe(models.AbstractModel):
    """Tipo Retorno de Pedido de Consulta do Manifesto Eletrônico de Documentos
    Fiscais"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tretmdfeconsultadfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretMdfeConsultaDfe"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a consulta do MDF-e",
    )

    mdfe30_cStat = fields.Char(
        string="Código do status da consulta do MDF-e",
        xsd_required=True,
        xsd_type="TStat",
    )

    mdfe30_xMotivo = fields.Char(
        string="Descrição literal do status da consulta",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status da consulta do MDF-e",
    )

    mdfe30_MDFeDFe = fields.Many2one(
        comodel_name="mdfe.30.tmdfedfe", string="MDFeDFe", xsd_type="TMDFeDFe"
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerMDFeConsultaDFe"
    )
