# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .mdfe_tipos_basico_v3_00 import (
    Tmdfe,
    TprotMdfe,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"


class MdfeProc(models.AbstractModel):
    "MDF-e processado"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.mdfeproc"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "MdfeProc"

    mdfe30_MDFe = fields.Many2one(
        comodel_name="mdfe.30.tmdfe", string="MDFe", xsd_required=True, xsd_type="TMDFe"
    )

    mdfe30_protMDFe = fields.Many2one(
        comodel_name="mdfe.30.tprotmdfe",
        string="protMDFe",
        xsd_required=True,
        xsd_type="TProtMDFe",
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerMDe")

    mdfe30_ipTransmissor = fields.Char(
        string="IP do transmissor",
        xsd_type="TIPv4",
        help=("IP do transmissor do documento fiscal para o ambiente autorizador"),
    )

    mdfe30_nPortaCon = fields.Char(
        string="Porta de origem utilizada na conexão",
        help="Porta de origem utilizada na conexão (De 0 a 65535)",
    )

    mdfe30_dhConexao = fields.Datetime(
        string="Data e Hora da Conexão de Origem", xsd_type="TDateTimeUTC"
    )
