
/* #########################################################################
 * [2016-01-15 15:35:30.331000] THIS FILE IS AUTOGENERATED - DO NOT EDIT!
 * ######################################################################### */
#ifndef ___DROPBOT_DX__COMMAND_PROCESSOR___
#define ___DROPBOT_DX__COMMAND_PROCESSOR___

#include "CArrayDefs.h"
#include "Commands.h"



namespace dropbot_dx {

template <typename Obj>
class CommandProcessor {
  /* # `CommandProcessor` #
   *
   * Each call to this functor processes a single command.
   *
   * All arguments are passed by reference, such that they may be used to form
   * a response.  If the integer return value of the call is zero, the call is
   * assumed to have no response required.  Otherwise, the arguments contain
   * must contain response values. */
protected:
  Obj &obj_;
public:
  CommandProcessor(Obj &obj) : obj_(obj) {}

  UInt8Array process_command(UInt8Array request_arr, UInt8Array buffer) {
    /* ## Call operator ##
     *
     * Arguments:
     *
     *  - `request_arr`: Serialized command request structure array,
     *  - `buffer`: Buffer array (available for writing output). */

    UInt8Array result;
    uint16_t &command = *reinterpret_cast<uint16_t *>(&request_arr.data[0]);

    // Interpret first byte of request as command code.
    switch (command) {

        case CMD_BASE_NODE_SOFTWARE_VERSION:
          {
            /* Cast buffer as request. */
    
    
            BaseNodeSoftwareVersionResponse response;

            response.result =
            obj_.base_node_software_version();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_PACKAGE_NAME:
          {
            /* Cast buffer as request. */
    
    
            PackageNameResponse response;

            response.result =
            obj_.package_name();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_DISPLAY_NAME:
          {
            /* Cast buffer as request. */
    
    
            DisplayNameResponse response;

            response.result =
            obj_.display_name();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_MANUFACTURER:
          {
            /* Cast buffer as request. */
    
    
            ManufacturerResponse response;

            response.result =
            obj_.manufacturer();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_SOFTWARE_VERSION:
          {
            /* Cast buffer as request. */
    
    
            SoftwareVersionResponse response;

            response.result =
            obj_.software_version();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_URL:
          {
            /* Cast buffer as request. */
    
    
            UrlResponse response;

            response.result =
            obj_.url();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_MICROSECONDS:
          {
            /* Cast buffer as request. */
    
    
            MicrosecondsResponse response;

            response.result =
            obj_.microseconds();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MicrosecondsResponse &output = *(reinterpret_cast
                                                 <MicrosecondsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_MILLISECONDS:
          {
            /* Cast buffer as request. */
    
    
            MillisecondsResponse response;

            response.result =
            obj_.milliseconds();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MillisecondsResponse &output = *(reinterpret_cast
                                                 <MillisecondsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DELAY_US:
          {
            /* Cast buffer as request. */
    
            DelayUsRequest &request = *(reinterpret_cast
                                          <DelayUsRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.delay_us(request.us);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DELAY_MS:
          {
            /* Cast buffer as request. */
    
            DelayMsRequest &request = *(reinterpret_cast
                                          <DelayMsRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.delay_ms(request.ms);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_RAM_FREE:
          {
            /* Cast buffer as request. */
    
    
            RamFreeResponse response;

            response.result =
            obj_.ram_free();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            RamFreeResponse &output = *(reinterpret_cast
                                                 <RamFreeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_PIN_MODE:
          {
            /* Cast buffer as request. */
    
            PinModeRequest &request = *(reinterpret_cast
                                          <PinModeRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.pin_mode(request.pin, request.mode);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DIGITAL_READ:
          {
            /* Cast buffer as request. */
    
            DigitalReadRequest &request = *(reinterpret_cast
                                          <DigitalReadRequest *>
                                          (&request_arr.data[2]));
    
    
            DigitalReadResponse response;

            response.result =
            obj_.digital_read(request.pin);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            DigitalReadResponse &output = *(reinterpret_cast
                                                 <DigitalReadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DIGITAL_WRITE:
          {
            /* Cast buffer as request. */
    
            DigitalWriteRequest &request = *(reinterpret_cast
                                          <DigitalWriteRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.digital_write(request.pin, request.value);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ANALOG_READ:
          {
            /* Cast buffer as request. */
    
            AnalogReadRequest &request = *(reinterpret_cast
                                          <AnalogReadRequest *>
                                          (&request_arr.data[2]));
    
    
            AnalogReadResponse response;

            response.result =
            obj_.analog_read(request.pin);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            AnalogReadResponse &output = *(reinterpret_cast
                                                 <AnalogReadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ANALOG_WRITE:
          {
            /* Cast buffer as request. */
    
            AnalogWriteRequest &request = *(reinterpret_cast
                                          <AnalogWriteRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.analog_write(request.pin, request.value);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ARRAY_LENGTH:
          {
            /* Cast buffer as request. */
    
            ArrayLengthRequest &request = *(reinterpret_cast
                                          <ArrayLengthRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.array.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.array.data);
            ArrayLengthResponse response;

            response.result =
            obj_.array_length(request.array);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            ArrayLengthResponse &output = *(reinterpret_cast
                                                 <ArrayLengthResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ECHO_ARRAY:
          {
            /* Cast buffer as request. */
    
            EchoArrayRequest &request = *(reinterpret_cast
                                          <EchoArrayRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.array.data = (uint32_t *)((uint8_t *)&request + (unsigned int)request.array.data);
            EchoArrayResponse response;

            response.result =
            obj_.echo_array(request.array);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_STR_ECHO:
          {
            /* Cast buffer as request. */
    
            StrEchoRequest &request = *(reinterpret_cast
                                          <StrEchoRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.msg.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.msg.data);
            StrEchoResponse response;

            response.result =
            obj_.str_echo(request.msg);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_MAX_SERIAL_PAYLOAD_SIZE:
          {
            /* Cast buffer as request. */
    
    
            MaxSerialPayloadSizeResponse response;

            response.result =
            obj_.max_serial_payload_size();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MaxSerialPayloadSizeResponse &output = *(reinterpret_cast
                                                 <MaxSerialPayloadSizeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_UPDATE_EEPROM_BLOCK:
          {
            /* Cast buffer as request. */
    
            UpdateEepromBlockRequest &request = *(reinterpret_cast
                                          <UpdateEepromBlockRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.data.data);
            obj_.update_eeprom_block(request.address, request.data);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_READ_EEPROM_BLOCK:
          {
            /* Cast buffer as request. */
    
            ReadEepromBlockRequest &request = *(reinterpret_cast
                                          <ReadEepromBlockRequest *>
                                          (&request_arr.data[2]));
    
    
            ReadEepromBlockResponse response;

            response.result =
            obj_.read_eeprom_block(request.address, request.n);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_EEPROM_E2END:
          {
            /* Cast buffer as request. */
    
    
            EepromE2endResponse response;

            response.result =
            obj_.eeprom_e2end();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            EepromE2endResponse &output = *(reinterpret_cast
                                                 <EepromE2endResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_ADDRESS:
          {
            /* Cast buffer as request. */
    
    
            I2cAddressResponse response;

            response.result =
            obj_.i2c_address();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cAddressResponse &output = *(reinterpret_cast
                                                 <I2cAddressResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_BUFFER_SIZE:
          {
            /* Cast buffer as request. */
    
    
            I2cBufferSizeResponse response;

            response.result =
            obj_.i2c_buffer_size();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cBufferSizeResponse &output = *(reinterpret_cast
                                                 <I2cBufferSizeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_SCAN:
          {
            /* Cast buffer as request. */
    
    
            I2cScanResponse response;

            response.result =
            obj_.i2c_scan();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_I2C_AVAILABLE:
          {
            /* Cast buffer as request. */
    
    
            I2cAvailableResponse response;

            response.result =
            obj_.i2c_available();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cAvailableResponse &output = *(reinterpret_cast
                                                 <I2cAvailableResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_READ_BYTE:
          {
            /* Cast buffer as request. */
    
    
            I2cReadByteResponse response;

            response.result =
            obj_.i2c_read_byte();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cReadByteResponse &output = *(reinterpret_cast
                                                 <I2cReadByteResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_REQUEST_FROM:
          {
            /* Cast buffer as request. */
    
            I2cRequestFromRequest &request = *(reinterpret_cast
                                          <I2cRequestFromRequest *>
                                          (&request_arr.data[2]));
    
    
            I2cRequestFromResponse response;

            response.result =
            obj_.i2c_request_from(request.address, request.n_bytes_to_read);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cRequestFromResponse &output = *(reinterpret_cast
                                                 <I2cRequestFromResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_READ:
          {
            /* Cast buffer as request. */
    
            I2cReadRequest &request = *(reinterpret_cast
                                          <I2cReadRequest *>
                                          (&request_arr.data[2]));
    
    
            I2cReadResponse response;

            response.result =
            obj_.i2c_read(request.address, request.n_bytes_to_read);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_I2C_WRITE:
          {
            /* Cast buffer as request. */
    
            I2cWriteRequest &request = *(reinterpret_cast
                                          <I2cWriteRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.data.data);
            obj_.i2c_write(request.address, request.data);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_I2C_ENABLE_BROADCAST:
          {
            /* Cast buffer as request. */
    
    
            obj_.i2c_enable_broadcast();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_I2C_DISABLE_BROADCAST:
          {
            /* Cast buffer as request. */
    
    
            obj_.i2c_disable_broadcast();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_MAX_I2C_PAYLOAD_SIZE:
          {
            /* Cast buffer as request. */
    
    
            MaxI2cPayloadSizeResponse response;

            response.result =
            obj_.max_i2c_payload_size();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MaxI2cPayloadSizeResponse &output = *(reinterpret_cast
                                                 <MaxI2cPayloadSizeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_REQUEST:
          {
            /* Cast buffer as request. */
    
            I2cRequestRequest &request = *(reinterpret_cast
                                          <I2cRequestRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.data.data);
            I2cRequestResponse response;

            response.result =
            obj_.i2c_request(request.address, request.data);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_I2C_PACKET_RESET:
          {
            /* Cast buffer as request. */
    
    
            obj_.i2c_packet_reset();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_LOAD_CONFIG:
          {
            /* Cast buffer as request. */
    
    
            obj_.load_config();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SAVE_CONFIG:
          {
            /* Cast buffer as request. */
    
    
            obj_.save_config();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_RESET_CONFIG:
          {
            /* Cast buffer as request. */
    
    
            obj_.reset_config();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SERIALIZE_CONFIG:
          {
            /* Cast buffer as request. */
    
    
            SerializeConfigResponse response;

            response.result =
            obj_.serialize_config();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_UPDATE_CONFIG:
          {
            /* Cast buffer as request. */
    
            UpdateConfigRequest &request = *(reinterpret_cast
                                          <UpdateConfigRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized.data);
            UpdateConfigResponse response;

            response.result =
            obj_.update_config(request.serialized);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdateConfigResponse &output = *(reinterpret_cast
                                                 <UpdateConfigResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_CONFIG_SERIAL_NUMBER_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnConfigSerialNumberChangedRequest &request = *(reinterpret_cast
                                          <OnConfigSerialNumberChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnConfigSerialNumberChangedResponse response;

            response.result =
            obj_.on_config_serial_number_changed(request.new_value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnConfigSerialNumberChangedResponse &output = *(reinterpret_cast
                                                 <OnConfigSerialNumberChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_CONFIG_BAUD_RATE_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnConfigBaudRateChangedRequest &request = *(reinterpret_cast
                                          <OnConfigBaudRateChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnConfigBaudRateChangedResponse response;

            response.result =
            obj_.on_config_baud_rate_changed(request.new_value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnConfigBaudRateChangedResponse &output = *(reinterpret_cast
                                                 <OnConfigBaudRateChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_CONFIG_I2C_ADDRESS_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnConfigI2cAddressChangedRequest &request = *(reinterpret_cast
                                          <OnConfigI2cAddressChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnConfigI2cAddressChangedResponse response;

            response.result =
            obj_.on_config_i2c_address_changed(request.new_value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnConfigI2cAddressChangedResponse &output = *(reinterpret_cast
                                                 <OnConfigI2cAddressChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_RESET_STATE:
          {
            /* Cast buffer as request. */
    
    
            obj_.reset_state();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SERIALIZE_STATE:
          {
            /* Cast buffer as request. */
    
    
            SerializeStateResponse response;

            response.result =
            obj_.serialize_state();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_UPDATE_STATE:
          {
            /* Cast buffer as request. */
    
            UpdateStateRequest &request = *(reinterpret_cast
                                          <UpdateStateRequest *>
                                          (&request_arr.data[2]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.serialized.data = (uint8_t *)((uint8_t *)&request + (unsigned int)request.serialized.data);
            UpdateStateResponse response;

            response.result =
            obj_.update_state(request.serialized);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            UpdateStateResponse &output = *(reinterpret_cast
                                                 <UpdateStateResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_GET_BUFFER:
          {
            /* Cast buffer as request. */
    
    
            GetBufferResponse response;

            response.result =
            obj_.get_buffer();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint32_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_BEGIN:
          {
            /* Cast buffer as request. */
    
    
            obj_.begin();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SET_I2C_ADDRESS:
          {
            /* Cast buffer as request. */
    
            SetI2cAddressRequest &request = *(reinterpret_cast
                                          <SetI2cAddressRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.set_i2c_address(request.value);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SERVO_READ:
          {
            /* Cast buffer as request. */
    
    
            ServoReadResponse response;

            response.result =
            obj_.servo_read();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            ServoReadResponse &output = *(reinterpret_cast
                                                 <ServoReadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_SERVO_WRITE:
          {
            /* Cast buffer as request. */
    
            ServoWriteRequest &request = *(reinterpret_cast
                                          <ServoWriteRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.servo_write(request.angle);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SERVO_WRITE_MICROSECONDS:
          {
            /* Cast buffer as request. */
    
            ServoWriteMicrosecondsRequest &request = *(reinterpret_cast
                                          <ServoWriteMicrosecondsRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_.servo_write_microseconds(request.us);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_SERVO_ATTACHED:
          {
            /* Cast buffer as request. */
    
    
            ServoAttachedResponse response;

            response.result =
            obj_.servo_attached();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            ServoAttachedResponse &output = *(reinterpret_cast
                                                 <ServoAttachedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_MAGNET_ENGAGED:
          {
            /* Cast buffer as request. */
    
    
            MagnetEngagedResponse response;

            response.result =
            obj_.magnet_engaged();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MagnetEngagedResponse &output = *(reinterpret_cast
                                                 <MagnetEngagedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_LOOP:
          {
            /* Cast buffer as request. */
    
    
            obj_.loop();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ON_STATE_MAGNET_ENGAGED_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnStateMagnetEngagedChangedRequest &request = *(reinterpret_cast
                                          <OnStateMagnetEngagedChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnStateMagnetEngagedChangedResponse response;

            response.result =
            obj_.on_state_magnet_engaged_changed(request.new_value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnStateMagnetEngagedChangedResponse &output = *(reinterpret_cast
                                                 <OnStateMagnetEngagedChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_STATE_LIGHT_ENABLED_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnStateLightEnabledChangedRequest &request = *(reinterpret_cast
                                          <OnStateLightEnabledChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnStateLightEnabledChangedResponse response;

            response.result =
            obj_.on_state_light_enabled_changed(request.new_value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnStateLightEnabledChangedResponse &output = *(reinterpret_cast
                                                 <OnStateLightEnabledChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ON_CONFIG_LIGHT_INTENSITY_CHANGED:
          {
            /* Cast buffer as request. */
    
            OnConfigLightIntensityChangedRequest &request = *(reinterpret_cast
                                          <OnConfigLightIntensityChangedRequest *>
                                          (&request_arr.data[2]));
    
    
            OnConfigLightIntensityChangedResponse response;

            response.result =
            obj_.on_config_light_intensity_changed(request.new_value);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            OnConfigLightIntensityChangedResponse &output = *(reinterpret_cast
                                                 <OnConfigLightIntensityChangedResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD__MAGNET_ENGAGE:
          {
            /* Cast buffer as request. */
    
    
            obj_._magnet_engage();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD__MAGNET_DISENGAGE:
          {
            /* Cast buffer as request. */
    
    
            obj_._magnet_disengage();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD__SET_LIGHT_INTENSITY:
          {
            /* Cast buffer as request. */
    
            _SetLightIntensityRequest &request = *(reinterpret_cast
                                          <_SetLightIntensityRequest *>
                                          (&request_arr.data[2]));
    
    
            obj_._set_light_intensity(request.value);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD__DISABLE_LIGHT:
          {
            /* Cast buffer as request. */
    
    
            obj_._disable_light();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

      default:
        result.length = 0xFFFFFFFF;
        result.data = NULL;
    }
    return result;
  }
};

}  // namespace dropbot_dx



#endif  // ifndef ___DROPBOT_DX___
