from colonyzer2.functions import *
import time


print("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
print("Note that this script requires a Colonyzer.txt file (as generated by ColonyzerParametryzer) describing initial guess for culture array")
print("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
start=time.time()

InsData=readInstructions(os.getcwd())

imList=getImageNames(os.getcwd())
# Setup output directories if not already present
rept=setupDirectories(imList)

# Disabling lighting correction
correction=True
if len(sys.argv)>1:
    if '--nolc' in sys.argv:
        print "No lighting correction..."
        correction=False

while len(imList)>0:
    imName=imList[0]
    print(imName)
    imRoot=os.path.basename(imName).split(".")[0]
    
    # Indicate that imName is currently being analysed, to allow parallel analysis
    tmp=open(os.path.join(os.path.dirname(imName),"Output_Data",os.path.basename(imName).split(".")[0]+".out"),"w").close()

    # Get image and pixel array
    im,arrN=openImage(imName)

    # If we have ColonyzerParametryzer output for this filename, use it for initial culture location estimates
    if imName in InsData:
        (candx,candy,dx,dy)=SetUp(InsData[os.path.basename(imName)])
    # If there are multiple calibrations available, choose the best one based on date of image capture
    elif any(isinstance(el, list) for el in InsData['default']):
        imname=os.path.basename(imName).split(".")[0]
        imdate=imname[-19:-9]
        (candx,candy,dx,dy)=SetUp(InsData['default'],imdate)
    else:
        (candx,candy,dx,dy)=SetUp(InsData['default'])

    # Automatically generate guesses for gridded array locations
    #(candx,candy,dx,dy)=estimateLocations(arrN,nx,ny,diam,showPlt=False)

    # Update guesses and initialise locations data frame
    locations=locateCultures([int(round(cx-dx/2.0)) for cx in candx],[int(round(cy-dy/2.0)) for cy in candy],dx,dy,arrN)

    # Trim outer part of image to remove plate walls
    trimmed_arr=arrN[max(0,int(round(min(locationsN.y)-dy/2.0))):min(arrN.shape[0],int(round((max(locationsN.y)+dy/2.0)))),max(0,int(round(min(locationsN.x)-dx/2.0))):min(arrN.shape[1],int(round((max(locationsN.x)+dx/2.0))))]
    (thresh,bindat)=automaticThreshold(trimmed_arr)

    print("Markov")
    # Cutout thresholded pixels and fill with Markov field
    (finalMask,arrM)=makeMask(arrN,thresh,9999999999)   
    print("correction map")
    # Smooth (pseudo-)empty image 
    arr=numpy.copy(arrM)
    (correction_map,average_back)=makeCorrectionMap(arrM,locations,printMess=correction)

    # Correct spatial gradient
    if correction:
            arr=arr*correction_map
    # Calculate intensity at each culture location
    locations=measureSizeAndColour(locations,arr,im,finalMask,average_back,imRoot,imRoot)

    # Write results to file
    locations.to_csv(os.path.join(os.path.dirname(imName),"Output_Data",os.path.basename(imName).split(".")[0]+".out"),"\t",index=False,engine='python')
    dataf=saveColonyzer(os.path.join(os.path.dirname(imName),"Output_Data",os.path.basename(imName).split(".")[0]+".dat"),locations,thresh,dx,dy)

    # Visual check of culture locations
    imthresh=threshPreview(arr,thresh,locations)
    #imthresh.show()
    imthresh.save(os.path.join(os.path.dirname(imName),"Output_Images",os.path.basename(imName).split(".")[0]+".png"))

    # Get ready for next image
    print("Finished: "+str(time.time()-start)+" s")
    imList=getImageNames(os.getcwd())
    # Setup output directories if not already present
    rept=setupDirectories(imList)
print("No more images to analyse... I'm done.")

