# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ODataError(Model):
    """Error information in OData format.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The machine-readable description of the error, such as
     'InvalidRequest' or 'InternalServerError'
    :vartype code: str
    :ivar message: The human-readable description of the error
    :vartype message: str
    :ivar details: Inner errors that caused this error
    :vartype details: list[~azure.mgmt.datamigration.models.ODataError]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ODataError]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ODataError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None
