import openpyxl
import docx
import shutil
import os
import fiona
import pandas as pd
from docx.shared import Cm
from docx import Document
from docx.enum.text import WD_PARAGRAPH_ALIGNMENT, WD_ALIGN_PARAGRAPH
from docx.oxml.ns import qn


def fileName(FilePath):
    """
    获取给定路径所指向文件的文件名。
    :param FilePath: 文件路径
    :return:
    """
    return os.path.basename(FilePath)


def fileFatherPath(FilePath):
    """
    获取给定路径所指向文件的父文件夹的名称。
    :param FilePath: 路径
    :return:
    """
    return os.path.dirname(FilePath)


def copyFile(FileOriginalPath, FileNewPath):
    """
    本函数用于复制文件，在复制的同时可以根据需求修改函数名字。通常与for循环结合进行批量复制并改名的操作。

    注意，这里文件路径为包含文件名的路径，可以是相对路径，也可以是绝对路径。如：(1)D:Example/EasyWork/example.png;(2)example.png。

    :param FileOriginalPath: 文件原始路径
    :param FileNewPath: 文件新路径
    :return:
    """
    FileNewFatherPath = os.path.dirname(FileNewPath)
    if not os.path.exists(FileNewFatherPath):
        os.makedirs(FileNewFatherPath)
    shutil.copy2(FileOriginalPath, FileNewPath)


def moveFile(FileOriginalPath, FileNewPath):
    """
    本函数用于剪切文件，在剪切的同时可以根据需求修改文件名字。通常与for循环结合进行批量剪切并改名的操作。

    注意，这里文件路径为包含文件名的路径，可以是相对路径，也可以是绝对路径。如：(1)D:Example/EasyWork/example.png;(2)example.png。

    :param FileOriginalPath: 文件原始路径
    :param FileNewPath: 文件新路径
    :return:
    """
    FileNewFatherPath = os.path.dirname(FileNewPath)
    if not os.path.exists(FileNewFatherPath):
        os.makedirs(FileNewFatherPath)
    shutil.move(FileOriginalPath, FileNewPath)


def excleRead(ExclePath, SheetIndex, Rowlow, Rowmax, Collow, Colmax):
    """
    读取Excle文件(.xlsx/.xls)的函数。

    注意：

    1.这里所有的序号均是从1开始而不是0！而且列号为数字，请不要填写字母。

    2.文件路径同样为包含文件名的路径，可以是相对路径，也可以是绝对路径。

    :param ExclePath: Excle路径
    :param SheetIndex: Sheet序号
    :param Rowlow: 最小行号
    :param Rowmax: 最大行号
    :param Collow: 最小列号
    :param Colmax: 最大列号
    :return: 数据表或数据，数据表是二维列表，数据与单元格数据的性质相同。
    """
    if Rowlow > Rowmax:
        t = Rowmax
        Rowmax = Rowlow
        Rowlow = t
    if Collow > Colmax:
        t = Rowmax
        Colmax = Collow
        Collow = t
    RowNum = Rowmax - Rowlow + 1
    ColNum = Colmax - Collow + 1
    # 打开工作簿
    workbook = openpyxl.load_workbook(ExclePath)
    # 获取所有工作表
    sheets = workbook.sheetnames
    # 选择第一个工作表
    sheet = workbook[sheets[SheetIndex - 1]]
    # 存储为列表

    m = 0
    i = 0
    SheetData = [[None for j in range(Colmax - Collow + 1)] for i in range(Rowmax - Rowlow + 1)]
    for row in sheet.iter_rows():
        n = 0
        j = 0
        for cell in row:

            if Rowlow <= m + 1 <= Rowmax and Collow <= n + 1 <= Colmax:
                # 获取单元格的值
                a = cell.value
                SheetData[i][j] = a
                j = j + 1
            n = n + 1
        if Rowlow <= m + 1 <= Rowmax:
            i = i + 1
        m = m + 1
    if RowNum == 1:
        SheetSingle = list()
        i = 0
        for data in SheetData[0]:
            SheetSingle.append(data)
            i = i + 1
        if ColNum == 1:
            SheetData = SheetSingle[0]
        else:
            SheetData = SheetSingle
    elif ColNum == 1:
        SheetSingle = list()
        for i in range(0, RowNum):
            SheetSingle.append(SheetData[i][0])
        SheetData = SheetSingle
    return SheetData


def excleWrite(ExclePath, SheetIndex, Row, Col, Value, SaveAsNewFile):
    """
    写入Excle文件(.xlsx/.xls)的函数。

    注意：

    1.这里所有的序号均是从1开始而不是0！而且列号为数字，请不要填写字母。

    2.文件路径同样为包含文件名的路径，可以是相对路径，也可以是绝对路径。
    :param ExclePath: Excle路径
    :param SheetIndex: Sheet序号
    :param Row: 单元格行号
    :param Col: 单元格列号
    :param Value: 要赋的值
    :param SaveAsNewFile: 是否保存为新文件(True/False)
    :return:
    """
    if SaveAsNewFile:
        FileNewName = "New_" + fileName(ExclePath)
        if fileFatherPath(ExclePath) != "":
            ExcleNewPath = fileFatherPath(ExclePath) + "\\" + FileNewName
        else:
            ExcleNewPath = FileNewName
        workbook = openpyxl.load_workbook(ExclePath)
        sheet_names = workbook.sheetnames
        SheetName = sheet_names[SheetIndex - 1]
        # 选择要操作的工作表
        sheet = workbook[SheetName]
        # 在指定的单元格写入数据
        sheet.cell(row=Row, column=Col, value=Value)
        # 保存文件
        workbook.save(ExcleNewPath)
    else:
        workbook = openpyxl.load_workbook(ExclePath)
        sheet_names = workbook.sheetnames
        SheetName = sheet_names[SheetIndex - 1]
        # 选择要操作的工作表
        sheet = workbook[SheetName]
        # 在指定的单元格写入数据
        sheet.cell(row=Row, column=Col, value=Value)
        # 保存文件
        workbook.save(ExclePath)


def wordTableRead(WordPath, TableIndex):
    """
    读取Word表格的函数。

    注意：这里表格索引为全局索引。文件路径同样为包含文件名的路径，可以是相对路径，也可以是绝对路径，与前面的函数所需的路径形式相同。
    :param WordPath: Word路径
    :param TableIndex: 表格索引
    :return:
    """
    doc = docx.Document(WordPath)
    table = doc.tables[TableIndex - 1]
    RowNum = 0
    for row in table.rows:
        ColNum = 0
        for cell in row.cells:
            ColNum = ColNum + 1
        RowNum = RowNum + 1
    SheetData = [[None for j in range(ColNum)] for i in range(RowNum)]
    i = 0
    for row in table.rows:
        j = 0
        for cell in row.cells:
            if i == 0 and j == 0:
                cell_text = cell.text
                SheetData[i][j] = cell_text
            else:
                bcell_text = cell_text
                cell_text = cell.text
                if bcell_text != cell_text:
                    SheetData[i][j] = cell_text
                else:
                    SheetData[i][j] = None
            j = j + 1
        i = i + 1
    return SheetData


def wordTableWrite(WordPath, TableIndex, Row, Col, Text, SaveAsNewFile):
    """
    写入Word表格的函数。

    注意：这里行号与Excle的不同，加入表格1的未合并前为6个单元格，此时将1、2单元格合并。此时“行号”参数填写1与2均会写入第一个单元格，当填入3时才会写入第二个单元格。列与行的情况相同。

    如果想要插入如下的上标下标：

    from FreeWork import OfficeWork as ow

    ow.WordTableWrite(WordPath, TableIndex, Row, Col, "面积 S_(1)=123 hm^(2)", SaveAsNewFile(True / False))

    其中括号是必不可少的，否则“^”符号后面的所有文本均将以上标的形式写入段落，“_”符号后面的所有文本均将以下标的形式写入段落，直至本条插入文本结束！还有请注意，这里括号需以英文状态下输入，否则将不会起到其应有的作用。
    :param WordPath: Word路径
    :param TableIndex: 表格索引
    :param Row: 行号
    :param Col: 列号
    :param Text: 欲写入的文本
    :param SaveAsNewFile: 是否保存为新文件(True/False)
    :return:
    """
    if SaveAsNewFile:
        FileNewName = "New_" + fileName(WordPath)
        if fileFatherPath(WordPath) != "":
            WordNewPath = fileFatherPath(WordPath) + "\\" + FileNewName
        else:
            WordNewPath = FileNewName
        doc = docx.Document(WordPath)
        table = doc.tables[TableIndex - 1]
        Cell = table.cell(Row - 1, Col - 1)
        paragraph = Cell.paragraphs[0]  # 获取单元格中的段落
        alignmentOrl = paragraph.paragraph_format.alignment  # 获取单元格段落对齐状态
        ## 新增代码段 ##
        SuperTextBefor = ""
        SuperText = ""
        SuperTextAfter = ""
        SubTextBefor = ""
        SubText = ""
        SubTextAfter = ""
        for i in range(0, len(Text)):
            if Text[i] == "^" and i + 1 < len(Text):
                SubTextBefor = ""
                if Text[i + 1] == "(" and i + 2 < len(Text):
                    for j in range(i + 2, len(Text)):
                        if Text[j] == ")":
                            for k in range(j + 1, len(Text)):
                                SuperTextAfter = SuperTextAfter + Text[k]
                            break
                        SuperText = SuperText + Text[j]
                    break
                else:
                    for j in range(i + 1, len(Text)):
                        SuperText = SuperText + Text[j]
                    break
            elif Text[i] == "_" and i + 1 < len(Text):
                SuperTextBefor = ""
                if Text[i + 1] == "(" and i + 2 < len(Text):
                    for j in range(i + 2, len(Text)):
                        if Text[j] == ")":
                            for k in range(j + 1, len(Text)):
                                SubTextAfter = SubTextAfter + Text[k]
                            break
                        SubText = SubText + Text[j]
                    break
                else:
                    for j in range(i + 1, len(Text)):
                        SubText = SubText + Text[j]
                    break
            SuperTextBefor = SuperTextBefor + Text[i]
            SubTextBefor = SubTextBefor + Text[i]

        if SuperTextBefor == Text and SubTextBefor == Text:
            Cell.text = Text
        elif SuperText != "":
            Cell.text = SuperTextBefor
            paragraph = Cell.paragraphs[0]  # 获取单元格中的段落
            AddedSuperText = paragraph.add_run(SuperText)
            AddedSuperText.font.superscript = True
            paragraph.add_run(SuperTextAfter)
        else:
            Cell.text = SubTextBefor
            paragraph = Cell.paragraphs[0]  # 获取单元格中的段落
            AddedSuperText = paragraph.add_run(SubText)
            AddedSuperText.font.subscript = True
            paragraph.add_run(SubTextAfter)
        ## 新增代码段 ##
        for paragraph in Cell.paragraphs:
            paragraph.paragraph_format.left_indent = 0  # 预先对缩进赋值，防止对象为空报错
            paragraph.paragraph_format.element.pPr.ind.set(qn("w:firstLineChars"), '-1')  # 去除缩进
            paragraph_format = paragraph.paragraph_format
            paragraph_format.alignment = alignmentOrl  # 设置为原段落的对齐方式
        doc.save(WordNewPath)
    else:
        doc = docx.Document(WordPath)
        table = doc.tables[TableIndex - 1]
        Cell = table.cell(Row - 1, Col - 1)
        paragraph = Cell.paragraphs[0]  # 获取单元格中的段落
        alignmentOrl = paragraph.paragraph_format.alignment  # 获取单元格段落对齐状态
        ## 新增代码段 ##
        SuperTextBefor = ""
        SuperText = ""
        SuperTextAfter = ""
        SubTextBefor = ""
        SubText = ""
        SubTextAfter = ""
        for i in range(0, len(Text)):
            if Text[i] == "^" and i + 1 < len(Text):
                SubTextBefor = ""
                if Text[i + 1] == "(" and i + 2 < len(Text):
                    for j in range(i + 2, len(Text)):
                        if Text[j] == ")":
                            for k in range(j + 1, len(Text)):
                                SuperTextAfter = SuperTextAfter + Text[k]
                            break
                        SuperText = SuperText + Text[j]
                    break
                else:
                    for j in range(i + 1, len(Text)):
                        SuperText = SuperText + Text[j]
                    break
            elif Text[i] == "_" and i + 1 < len(Text):
                SuperTextBefor = ""
                if Text[i + 1] == "(" and i + 2 < len(Text):
                    for j in range(i + 2, len(Text)):
                        if Text[j] == ")":
                            for k in range(j + 1, len(Text)):
                                SubTextAfter = SubTextAfter + Text[k]
                            break
                        SubText = SubText + Text[j]
                    break
                else:
                    for j in range(i + 1, len(Text)):
                        SubText = SubText + Text[j]
                    break
            SuperTextBefor = SuperTextBefor + Text[i]
            SubTextBefor = SubTextBefor + Text[i]

        if SuperTextBefor == Text and SubTextBefor == Text:
            Cell.text = Text
        elif SuperText != "":
            Cell.text = SuperTextBefor
            paragraph = Cell.paragraphs[0]  # 获取单元格中的段落
            AddedSuperText = paragraph.add_run(SuperText)
            AddedSuperText.font.superscript = True
            paragraph.add_run(SuperTextAfter)
        else:
            Cell.text = SubTextBefor
            paragraph = Cell.paragraphs[0]  # 获取单元格中的段落
            AddedSuperText = paragraph.add_run(SubText)
            AddedSuperText.font.subscript = True
            paragraph.add_run(SubTextAfter)
        ## 新增代码段 ##
        for paragraph in Cell.paragraphs:
            paragraph.paragraph_format.left_indent = 0  # 预先对缩进赋值，防止对象为空报错
            paragraph.paragraph_format.element.pPr.ind.set(qn("w:firstLineChars"), '-1')  # 去除缩进
            paragraph_format = paragraph.paragraph_format
            paragraph_format.alignment = alignmentOrl  # 设置为原段落的对齐方式
        doc.save(WordPath)


def wordTableInsertFig(WordPath, TableIndex, Row, Col, ImagePath, ImageHeight_cm, ImageWidth_cm, SaveAsNewFile):
    """
    Word表格追加图片函数，不删除原有文字。

    注意：这里图片高度可以为“None”。
    :param WordPath: Word路径
    :param TableIndex: 表格索引
    :param Row: 行号
    :param Col: 列号
    :param ImagePath: 图片路径
    :param ImageHeight_cm: 插入后图片的高度（厘米为单位）
    :param ImageWidth_cm: 插入后图片的宽度（厘米为单位）
    :param SaveAsNewFile: 是否保存为新文件(True/False)
    :return:
    """
    if SaveAsNewFile:
        FileNewName = "New_" + fileName(WordPath)
        if fileFatherPath(WordPath) != "":
            WordNewPath = fileFatherPath(WordPath) + "\\" + FileNewName
        else:
            WordNewPath = FileNewName
        doc = docx.Document(WordPath)
        table = doc.tables[TableIndex - 1]
        Cell = table.cell(Row - 1, Col - 1)
        paragraph = Cell.paragraphs[0]  # 获取单元格中的段落
        alignmentOrl = paragraph.paragraph_format.alignment  # 获取单元格段落对齐状态
        if ImageHeight_cm is not None and ImageWidth_cm is not None:
            Cell.add_paragraph().add_run().add_picture(ImagePath, height=Cm(ImageHeight_cm), width=Cm(ImageWidth_cm))
        elif ImageHeight_cm is not None:
            Cell.add_paragraph().add_run().add_picture(ImagePath, height=Cm(ImageHeight_cm))
        elif ImageWidth_cm is not None:
            Cell.add_paragraph().add_run().add_picture(ImagePath, width=Cm(ImageWidth_cm))
        else:
            Cell.add_paragraph().add_run().add_picture(ImagePath)
        for paragraph in Cell.paragraphs:
            paragraph.paragraph_format.left_indent = 0  # 预先对缩进赋值，防止对象为空报错
            paragraph.paragraph_format.element.pPr.ind.set(qn("w:firstLineChars"), '-1')  # 去除缩进
            paragraph_format = paragraph.paragraph_format
            paragraph_format.alignment = alignmentOrl  # 设置为原段落的对齐方式
        doc.save(WordNewPath)
    else:
        doc = docx.Document(WordPath)
        table = doc.tables[TableIndex - 1]
        Cell = table.cell(Row - 1, Col - 1)
        paragraph = Cell.paragraphs[0]  # 获取单元格中的段落
        alignmentOrl = paragraph.paragraph_format.alignment  # 获取单元格段落对齐状态
        if ImageHeight_cm is not None and ImageWidth_cm is not None:
            Cell.add_paragraph().add_run().add_picture(ImagePath, height=Cm(ImageHeight_cm), width=Cm(ImageWidth_cm))
        elif ImageHeight_cm is not None:
            Cell.add_paragraph().add_run().add_picture(ImagePath, height=Cm(ImageHeight_cm))
        elif ImageWidth_cm is not None:
            Cell.add_paragraph().add_run().add_picture(ImagePath, width=Cm(ImageWidth_cm))
        else:
            Cell.add_paragraph().add_run().add_picture(ImagePath)
        for paragraph in Cell.paragraphs:
            paragraph.paragraph_format.left_indent = 0  # 预先对缩进赋值，防止对象为空报错
            paragraph.paragraph_format.element.pPr.ind.set(qn("w:firstLineChars"), '-1')  # 去除缩进
            paragraph_format = paragraph.paragraph_format
            paragraph_format.alignment = alignmentOrl  # 设置为原段落的对齐方式
        doc.save(WordPath)


def wordTableParaAlignment(WordPath, TableIndex, Row, Col, Alignment_left_right_center_None, SaveAsNewFile):
    """
    Word表格单元格对齐设置函数。

    注意：对齐方式只能填写left/right/center/None，否则均会设置为None两端对齐。
    :param WordPath: Word路径
    :param TableIndex: 表格索引
    :param Row: 行号
    :param Col: 列号
    :param Alignment_left_right_center_None: 对齐方式
    :param SaveAsNewFile: 是否保存为新文件(True/False)
    :return:
    """
    if SaveAsNewFile:
        FileNewName = "New_" + fileName(WordPath)
        if fileFatherPath(WordPath) != "":
            WordNewPath = fileFatherPath(WordPath) + "\\" + FileNewName
        else:
            WordNewPath = FileNewName
        doc = docx.Document(WordPath)
        table = doc.tables[TableIndex - 1]
        Cell = table.cell(Row - 1, Col - 1)
        if Alignment_left_right_center_None == "left":
            alignment = WD_PARAGRAPH_ALIGNMENT.LEFT
        elif Alignment_left_right_center_None == "right":
            alignment = WD_PARAGRAPH_ALIGNMENT.RIGHT
        elif Alignment_left_right_center_None == "center":
            alignment = WD_PARAGRAPH_ALIGNMENT.CENTER
        else:
            alignment = None
        for paragraph in Cell.paragraphs:
            paragraph.paragraph_format.left_indent = 0  # 预先对缩进赋值，防止对象为空报错
            paragraph.paragraph_format.element.pPr.ind.set(qn("w:firstLineChars"), '-1')  # 去除缩进
            paragraph_format = paragraph.paragraph_format
            paragraph_format.alignment = alignment  # 设置为原段落的对齐方式
        doc.save(WordNewPath)
    else:
        doc = docx.Document(WordPath)
        table = doc.tables[TableIndex - 1]
        Cell = table.cell(Row - 1, Col - 1)
        if Alignment_left_right_center_None == "left":
            alignment = WD_PARAGRAPH_ALIGNMENT.LEFT
        elif Alignment_left_right_center_None == "right":
            alignment = WD_PARAGRAPH_ALIGNMENT.RIGHT
        elif Alignment_left_right_center_None == "center":
            alignment = WD_PARAGRAPH_ALIGNMENT.CENTER
        else:
            alignment = None
        for paragraph in Cell.paragraphs:
            paragraph.paragraph_format.left_indent = 0  # 预先对缩进赋值，防止对象为空报错
            paragraph.paragraph_format.element.pPr.ind.set(qn("w:firstLineChars"), '-1')  # 去除缩进
            paragraph_format = paragraph.paragraph_format
            paragraph_format.alignment = alignment  # 设置为原段落的对齐方式
        doc.save(WordPath)


def ShpToXlsx(ShpPath, XlsxPath):
    """
    Shapefile转出Excle函数。
    :param ShpPath: Shp路径
    :param XlsxPath: Xlsx路径
    :return:
    """
    with fiona.open(ShpPath, "r") as shapefile:
        # 读取SHP文件的属性表
        properties = [feature["properties"] for feature in shapefile]

        # 将属性表转换为DataFrame
        df = pd.DataFrame(properties)

        # 将DataFrame写入Excel文件
        df.to_excel(XlsxPath, index=False)


def wordAdd(wordPath, wordSavePath, new_text, FontName=None, FontSize=None, IsBold=None, IsItalic=None):
    """
    在文档的末尾添加文字(不开新段落)。
    :param wordPath: Word路径
    :param wordSavePath: Word保存路径
    :param new_text: 添加文本
    :param FontName: 字体名称
    :param FontSize: 字体大小
    :param IsBold: 是否加粗
    :param IsItalic: 是否斜体
    :return:
    """
    doc = Document(wordPath)
    # 获取文档的最后一段
    last_paragraph = doc.paragraphs[-1]

    if last_paragraph.runs:
        # 获取最后一段的最后一个run
        last_run = last_paragraph.runs[-1]
        # 创建一个新的run
        new_run = last_paragraph.add_run(new_text)

        # 复制字体名称
        if FontName is None:
            if last_run.font.name:
                new_run.font.name = last_run.font.name
                new_run.font._element.rPr.rFonts.set(qn('w:eastAsia'), last_run.font.name)
        else:
            new_run.font.name = FontName
            new_run.font._element.rPr.rFonts.set(qn('w:eastAsia'), FontName)
        # 复制字体大小
        if FontSize is None:
            if last_run.font.size:
                new_run.font.size = last_run.font.size
        else:
            new_run.font.size = FontSize
        # 复制加粗、斜体等其他属性
        if IsBold is None:
            new_run.bold = last_run.bold
        else:
            if IsBold:
                new_run.bold = True
            else:
                new_run.bold = False
        if IsItalic is None:
            new_run.italic = last_run.italic
        else:
            if IsItalic:
                new_run.italic = True
            else:
                new_run.italic = False
    else:
        # 如果最后一段是空的，则直接添加新文本
        last_paragraph.add_run(new_text)

    # 保存修改后的文档
    doc.save(wordSavePath)


def wordParagraphAdd(wordPath, wordSavePath, new_text, FontName=None, FontSize=None, IsBold=None, IsItalic=None,
                     Indent=None, Alignment="l"):
    """
    在文档的末尾添加文字(开新段落)。
    :param wordPath: Word路径
    :param wordSavePath: Word保存路径
    :param new_text: 添加文本
    :param FontName: 字体名称
    :param FontSize: 字体大小
    :param IsBold: 是否加粗
    :param IsItalic: 是否斜体
    :param Indent: 缩进值
    :param Alignment: 对其方式(l/c/r/j)
    :return:
    """
    doc = Document(wordPath)
    # 获取文档的最后一段
    last_paragraph = doc.paragraphs[-1]

    if last_paragraph.runs:
        # 获取最后一段的最后一个run
        last_run = last_paragraph.runs[-1]
        # 创建一个新的run
        new_paragraph = doc.add_paragraph()
        new_run = new_paragraph.add_run(new_text)

        format = last_paragraph.paragraph_format

        # 获取左缩进和首行缩进（单位是英寸，Word中的默认单位）
        left_indent = format.left_indent
        first_line_indent = format.first_line_indent
        if Indent is None:
            new_paragraph.paragraph_format.first_line_indent = first_line_indent
        else:
            try:
                new_paragraph.paragraph_format.first_line_indent = Indent
            except:
                new_paragraph.paragraph_format.first_line_indent = first_line_indent
        if Alignment == "l":
            new_paragraph.alignment = WD_ALIGN_PARAGRAPH.LEFT
        elif Alignment == "c":
            new_paragraph.alignment = WD_ALIGN_PARAGRAPH.CENTER
        elif Alignment == "r":
            new_paragraph.alignment = WD_ALIGN_PARAGRAPH.RIGHT
        elif Alignment == "j":
            new_paragraph.alignment = WD_ALIGN_PARAGRAPH.JUSTIFY
        else:
            new_paragraph.alignment = WD_ALIGN_PARAGRAPH.LEFT
        # 复制字体名称
        if FontName is None:
            if last_run.font.name:
                new_run.font.name = last_run.font.name
                new_run.font._element.rPr.rFonts.set(qn('w:eastAsia'), last_run.font.name)
        else:
            new_run.font.name = FontName
            new_run.font._element.rPr.rFonts.set(qn('w:eastAsia'), FontName)
        # 复制字体大小
        if FontSize is None:
            if last_run.font.size:
                new_run.font.size = last_run.font.size
        else:
            new_run.font.size = FontSize
        # 复制加粗、斜体等其他属性
        if IsBold is None:
            new_run.bold = last_run.bold
        else:
            if IsBold:
                new_run.bold = True
            else:
                new_run.bold = False
        if IsItalic is None:
            new_run.italic = last_run.italic
        else:
            if IsItalic:
                new_run.italic = True
            else:
                new_run.italic = False
    else:
        # 如果最后一段是空的，则直接添加新文本
        last_paragraph.add_run(new_text)

    # 保存修改后的文档
    doc.save(wordSavePath)


def wordParaFormat(wordPath):
    doc = Document(wordPath)
    # 获取文档的最后一段
    last_paragraph = doc.paragraphs[-1]
    last_run = last_paragraph.runs[-1]
    format = last_paragraph.paragraph_format
    return format
