/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.exception;

import java.util.Map;
import java.util.Stack;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.exception.SchedulerException;
import org.ow2.proactive.scheduler.common.job.factories.XMLAttributes;
import org.ow2.proactive.scheduler.common.job.factories.XMLTags;

@PublicAPI
public class JobCreationException
extends SchedulerException {
    private String taskName = null;
    private Stack<XMLTags> tags = new Stack();
    private XMLAttributes attribute = null;
    private boolean isSchemaException = false;
    private Map<String, String> updatedVariables = null;
    private Map<String, String> updatedModels = null;
    private Map<String, String> updatedDescriptions = null;
    private Map<String, String> updatedGroups = null;
    private Map<String, Boolean> updatedAdvanced = null;
    private Map<String, Boolean> updatedHidden = null;

    public JobCreationException(String message) {
        super(message);
    }

    public JobCreationException(Throwable cause) {
        super(cause.getMessage(), cause);
    }

    public JobCreationException(String message, Throwable cause) {
        super(message, cause);
    }

    public JobCreationException(boolean schemaException, Throwable cause) {
        super(cause.getMessage(), cause);
        this.isSchemaException = schemaException;
    }

    public JobCreationException(String tag, String attribute, Exception cause) {
        this(tag == null ? null : XMLTags.getFromXMLName(tag), attribute, cause);
    }

    public JobCreationException(XMLTags tag, String attribute, Exception cause) {
        super(cause.getMessage(), cause);
        if (tag != null) {
            this.tags.push(tag);
        }
        if (attribute != null) {
            this.attribute = XMLAttributes.getFromXMLName(attribute);
        }
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void pushTag(String currentTag) {
        this.pushTag(XMLTags.getFromXMLName(currentTag));
    }

    public void pushTag(XMLTags currentTag) {
        this.tags.push(currentTag);
    }

    public Stack<XMLTags> getXMLTagsStack() {
        return this.tags;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.taskName != null) {
            sb.append("[task=" + this.taskName + "] ");
        }
        if (this.tags != null && this.tags.size() > 0) {
            sb.append("[tag:" + this.tags.elementAt(this.tags.size() - 1));
            for (int i = this.tags.size() - 2; i >= 0; --i) {
                sb.append("/" + this.tags.elementAt(i));
            }
            sb.append("] ");
        }
        if (this.attribute != null) {
            sb.append("[attribute:" + (Object)((Object)this.attribute) + "] ");
        }
        if (sb.length() > 0) {
            sb = new StringBuilder("At " + sb.toString() + ": ");
        }
        sb.append(this.getShortMessage());
        return sb.toString();
    }

    public String getShortMessage() {
        return super.getMessage();
    }

    public boolean isSchemaException() {
        return this.isSchemaException;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public XMLAttributes getAttribute() {
        return this.attribute;
    }

    public Map<String, String> getUpdatedVariables() {
        return this.updatedVariables;
    }

    public void setUpdatedVariables(Map<String, String> updatedVariables) {
        this.updatedVariables = updatedVariables;
    }

    public Map<String, String> getUpdatedModels() {
        return this.updatedModels;
    }

    public void setUpdatedModels(Map<String, String> updatedModels) {
        this.updatedModels = updatedModels;
    }

    public Map<String, String> getUpdatedDescriptions() {
        return this.updatedDescriptions;
    }

    public void setUpdatedDescriptions(Map<String, String> updatedDescriptions) {
        this.updatedDescriptions = updatedDescriptions;
    }

    public Map<String, String> getUpdatedGroups() {
        return this.updatedGroups;
    }

    public void setUpdatedGroups(Map<String, String> updatedGroups) {
        this.updatedGroups = updatedGroups;
    }

    public Map<String, Boolean> getUpdatedAdvanced() {
        return this.updatedAdvanced;
    }

    public void setUpdatedAdvanced(Map<String, Boolean> updatedAdvanced) {
        this.updatedAdvanced = updatedAdvanced;
    }

    public Map<String, Boolean> getUpdatedHidden() {
        return this.updatedHidden;
    }

    public void setUpdatedHidden(Map<String, Boolean> updatedHidden) {
        this.updatedHidden = updatedHidden;
    }
}

