/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ow2.proactive.scheduler.common.Scheduler;
import org.ow2.proactive.scheduler.common.SchedulerSpaceInterface;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedMethodResolver;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedPropertyAccessor;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedTypeLocator;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ModelValidatorContext {
    private final StandardEvaluationContext spelContext;
    private final Scheduler scheduler;
    private final SchedulerSpaceInterface space;
    private final String sessionId;
    private String variableName;
    private SpELVariables spELVariables;

    public ModelValidatorContext(StandardEvaluationContext context, Scheduler scheduler, SchedulerSpaceInterface space, String sessionId) {
        this.spelContext = context;
        this.scheduler = scheduler;
        this.space = space;
        this.sessionId = sessionId;
    }

    public ModelValidatorContext(Map<String, Serializable> variablesValues, Map<String, String> models, Set<String> groupNames, Scheduler scheduler, SchedulerSpaceInterface space, String sessionId) {
        this.spELVariables = new SpELVariables(variablesValues, models, groupNames);
        this.spelContext = new StandardEvaluationContext((Object)this.spELVariables);
        this.spelContext.setTypeLocator((TypeLocator)new RestrictedTypeLocator());
        this.spelContext.setMethodResolvers(Collections.singletonList(new RestrictedMethodResolver()));
        this.spelContext.addPropertyAccessor((PropertyAccessor)new RestrictedPropertyAccessor());
        this.scheduler = scheduler;
        this.space = space;
        this.sessionId = sessionId;
    }

    public ModelValidatorContext(Task task, Scheduler scheduler, SchedulerSpaceInterface space, String sessionId) {
        this(task.getVariables().values().stream().collect(LinkedHashMap::new, (m, v) -> {
            Serializable cfr_ignored_0 = (Serializable)((Object)m.put(v.getName(), v.getValue()));
        }, HashMap::putAll), task.getVariables().values().stream().collect(LinkedHashMap::new, (m, v) -> m.put(v.getName(), v.getModel()), HashMap::putAll), ModelValidatorContext.getGroups(task.getVariables()), scheduler, space, sessionId);
    }

    public static Set<String> getGroups(Map<String, ? extends JobVariable> variables) {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        if (variables != null) {
            for (JobVariable jobVariable : variables.values()) {
                String groupName = jobVariable.getGroup();
                if (Strings.isNullOrEmpty((String)groupName)) continue;
                groups.add(groupName);
            }
        }
        return groups;
    }

    public ModelValidatorContext(TaskFlowJob job, Scheduler scheduler, SchedulerSpaceInterface space, String sessionId) {
        this(job.getVariables().values().stream().collect(LinkedHashMap::new, (m, v) -> {
            Serializable cfr_ignored_0 = (Serializable)((Object)m.put(v.getName(), v.getValue()));
        }, HashMap::putAll), job.getVariables().values().stream().collect(LinkedHashMap::new, (m, v) -> m.put(v.getName(), v.getModel()), HashMap::putAll), ModelValidatorContext.getGroups(job.getVariables()), scheduler, space, sessionId);
    }

    public ModelValidatorContext(StandardEvaluationContext context) {
        this(context, null, null, null);
    }

    public ModelValidatorContext(Map<String, Serializable> variablesValues, Map<String, String> models, Set<String> groupNames) {
        this(variablesValues, models, groupNames, null, null, null);
    }

    public ModelValidatorContext(Task task) {
        this(task, null, null, null);
    }

    public ModelValidatorContext(TaskFlowJob job) {
        this(job, null, null, null);
    }

    public StandardEvaluationContext getSpELContext() {
        return this.spelContext;
    }

    public SpELVariables getSpELVariables() {
        return this.spELVariables;
    }

    public void setSpELVariables(SpELVariables spELVariables) {
        this.spELVariables = spELVariables;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SchedulerSpaceInterface getSpace() {
        return this.space;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void updateJobWithContext(TaskFlowJob job) {
        for (JobVariable jobVariable : job.getVariables().values()) {
            Boolean hiddenVariableStatus;
            Boolean hiddenGroupStatus;
            jobVariable.setValue(this.spELVariables.getVariables().get(jobVariable.getName()).toString());
            jobVariable.setModel(this.spELVariables.getModels().get(jobVariable.getName()));
            String groupName = jobVariable.getGroup();
            if (!Strings.isNullOrEmpty((String)groupName) && (hiddenGroupStatus = this.spELVariables.getHiddenGroups().get(groupName)) != null) {
                jobVariable.setHidden(hiddenGroupStatus);
            }
            if ((hiddenVariableStatus = this.spELVariables.getHiddenVariables().get(jobVariable.getName())) == null) continue;
            jobVariable.setHidden(hiddenVariableStatus);
        }
    }

    public void updateJobVariablesWithContext(List<JobVariable> jobVariables) {
        for (JobVariable jobVariable : jobVariables) {
            Boolean hiddenVariableStatus;
            Boolean hiddenGroupStatus;
            jobVariable.setValue(this.spELVariables.getVariables().get(jobVariable.getName()).toString());
            jobVariable.setModel(this.spELVariables.getModels().get(jobVariable.getName()));
            String groupName = jobVariable.getGroup();
            if (!Strings.isNullOrEmpty((String)groupName) && (hiddenGroupStatus = this.spELVariables.getHiddenGroups().get(groupName)) != null) {
                jobVariable.setHidden(hiddenGroupStatus);
            }
            if ((hiddenVariableStatus = this.spELVariables.getHiddenVariables().get(jobVariable.getName())) == null) continue;
            jobVariable.setHidden(hiddenVariableStatus);
        }
    }

    public void updateTaskWithContext(Task task) {
        for (TaskVariable taskVariable : task.getVariables().values()) {
            Boolean hiddenVariableStatus;
            Boolean hiddenGroupStatus;
            taskVariable.setValue(this.spELVariables.getVariables().get(taskVariable.getName()).toString());
            taskVariable.setModel(this.spELVariables.getModels().get(taskVariable.getName()));
            String groupName = taskVariable.getGroup();
            if (!Strings.isNullOrEmpty((String)groupName) && (hiddenGroupStatus = this.spELVariables.getHiddenGroups().get(groupName)) != null) {
                taskVariable.setHidden(hiddenGroupStatus);
            }
            if ((hiddenVariableStatus = this.spELVariables.getHiddenVariables().get(taskVariable.getName())) == null) continue;
            taskVariable.setHidden(hiddenVariableStatus);
        }
    }

    public static class SpELVariables {
        private Map<String, Serializable> variables;
        private Map<String, String> models;
        private Map<String, Boolean> hiddenVariables;
        private Map<String, Boolean> hiddenGroups;
        private Object temp;
        private Map<String, Object> tempMap;
        private Boolean valid;

        public SpELVariables(Map<String, Serializable> variables, Map<String, String> models, Set<String> groupsNames) {
            this.variables = variables != null ? variables.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue() != null ? (Serializable)e.getValue() : "")) : null;
            this.models = models;
            this.tempMap = new LinkedHashMap<String, Object>();
            this.hiddenVariables = new LinkedHashMap<String, Boolean>();
            if (variables != null) {
                for (String variableName : variables.keySet()) {
                    this.hiddenVariables.put(variableName, null);
                }
            }
            this.hiddenGroups = new LinkedHashMap<String, Boolean>();
            if (groupsNames != null) {
                for (String groupName : groupsNames) {
                    this.hiddenGroups.put(groupName, null);
                }
            }
        }

        public static boolean t(Object expression) {
            return true;
        }

        public static boolean f(Object expression) {
            return false;
        }

        public static String s(Object expression) {
            return "";
        }

        public Map<String, Serializable> getVariables() {
            return this.variables;
        }

        public void setVariables(Map<String, Serializable> variables) {
            this.variables = variables;
        }

        public Map<String, String> getModels() {
            return this.models;
        }

        public void setModels(Map<String, String> models) {
            this.models = models;
        }

        public Map<String, Boolean> getHiddenVariables() {
            return this.hiddenVariables;
        }

        public Map<String, Boolean> getHiddenGroups() {
            return this.hiddenGroups;
        }

        public Object getTemp() {
            return this.temp;
        }

        public void setTemp(Object temp) {
            this.temp = temp;
        }

        public Map<String, Object> getTempMap() {
            return this.tempMap;
        }

        public void setTempMap(Map<String, Object> tempMap) {
            this.tempMap = tempMap;
        }

        public Boolean getValid() {
            return this.valid;
        }

        public void setValid(Boolean valid) {
            this.valid = valid;
        }

        public boolean hideVar(String variableName) {
            if (this.hiddenVariables.containsKey(variableName)) {
                this.hiddenVariables.put(variableName, true);
                return true;
            }
            return false;
        }

        public boolean showVar(String variableName) {
            if (this.hiddenVariables.containsKey(variableName)) {
                this.hiddenVariables.put(variableName, false);
                return true;
            }
            return false;
        }

        public boolean hideGroup(String groupName) {
            if (this.hiddenGroups.containsKey(groupName)) {
                this.hiddenGroups.put(groupName, true);
                return true;
            }
            return false;
        }

        public boolean showGroup(String groupName) {
            if (this.hiddenGroups.containsKey(groupName)) {
                this.hiddenGroups.put(groupName, false);
                return true;
            }
            return false;
        }
    }
}

