/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import com.google.common.collect.Range;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class RangeValidator<T extends Comparable<T>>
implements Validator<T> {
    private final Range<T> range;

    public RangeValidator() {
        this.range = Range.all();
    }

    public RangeValidator(T minValue) {
        this.range = Range.atLeast(minValue);
    }

    public RangeValidator(T minValue, T maxValue) {
        this.range = Range.closed(minValue, maxValue);
    }

    public RangeValidator(Range range) {
        this.range = range;
    }

    @Override
    public T validate(T parameterValue, ModelValidatorContext context, boolean isVariableHidden) throws ValidationException {
        if (!this.range.contains(parameterValue)) {
            throw new ValidationException("Expected value should be in range " + this.range.toString() + ", received " + parameterValue);
        }
        return parameterValue;
    }
}

