/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Objects;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;

public abstract class FileSystemConfigBuilder {
    private static final String PREFIX = "vfs.";
    private static final String ROOTURI = "rootURI";
    private final String prefix;

    protected FileSystemConfigBuilder() {
        this.prefix = PREFIX;
    }

    protected FileSystemConfigBuilder(String component) {
        this.prefix = PREFIX + component;
    }

    protected Boolean getBoolean(FileSystemOptions fileSystemOptions, String name) {
        return this.getBoolean(fileSystemOptions, name, null);
    }

    protected boolean getBoolean(FileSystemOptions fileSystemOptions, String name, boolean defaultValue) {
        return this.getBoolean(fileSystemOptions, name, (Boolean)defaultValue);
    }

    protected Boolean getBoolean(FileSystemOptions fileSystemOptions, String name, Boolean defaultValue) {
        Boolean value = (Boolean)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null) {
                return defaultValue;
            }
            value = Boolean.valueOf(str);
        }
        return value;
    }

    protected Byte getByte(FileSystemOptions fileSystemOptions, String name) {
        return this.getByte(fileSystemOptions, name, null);
    }

    protected byte getByte(FileSystemOptions fileSystemOptions, String name, byte defaultValue) {
        return this.getByte(fileSystemOptions, name, (Byte)defaultValue);
    }

    protected Byte getByte(FileSystemOptions fileSystemOptions, String name, Byte defaultValue) {
        Byte value = (Byte)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null) {
                return defaultValue;
            }
            value = Byte.valueOf(str);
        }
        return value;
    }

    protected Character getCharacter(FileSystemOptions fileSystemOptions, String name) {
        return this.getCharacter(fileSystemOptions, name, null);
    }

    protected char getCharacter(FileSystemOptions fileSystemOptions, String name, char defaultValue) {
        return this.getCharacter(fileSystemOptions, name, new Character(defaultValue)).charValue();
    }

    protected Character getCharacter(FileSystemOptions fileSystemOptions, String name, Character defaultValue) {
        Character value = (Character)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null || str.length() <= 0) {
                return defaultValue;
            }
            value = new Character(str.charAt(0));
        }
        return value;
    }

    protected abstract Class<? extends FileSystem> getConfigClass();

    protected Double getDouble(FileSystemOptions fileSystemOptions, String name) {
        return this.getDouble(fileSystemOptions, name, null);
    }

    protected double getDouble(FileSystemOptions fileSystemOptions, String name, double defaultValue) {
        return this.getDouble(fileSystemOptions, name, new Double(defaultValue));
    }

    protected Double getDouble(FileSystemOptions fileSystemOptions, String name, Double defaultValue) {
        Double value = (Double)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null || str.length() <= 0) {
                return defaultValue;
            }
            value = Double.valueOf(str);
        }
        return value;
    }

    protected <E extends Enum<E>> E getEnum(Class<E> enumClass, FileSystemOptions fileSystemOptions, String name) {
        return this.getEnum(enumClass, fileSystemOptions, name, null);
    }

    protected <E extends Enum<E>> E getEnum(Class<E> enumClass, FileSystemOptions fileSystemOptions, String name, E defaultValue) {
        Enum value = (Enum)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null) {
                return defaultValue;
            }
            value = Enum.valueOf(enumClass, str);
        }
        return (E)value;
    }

    protected Float getFloat(FileSystemOptions fileSystemOptions, String name) {
        return this.getFloat(fileSystemOptions, name, null);
    }

    protected float getFloat(FileSystemOptions fileSystemOptions, String name, float defaultValue) {
        return this.getFloat(fileSystemOptions, name, new Float(defaultValue)).floatValue();
    }

    protected Float getFloat(FileSystemOptions fileSystemOptions, String name, Float defaultValue) {
        Float value = (Float)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null || str.length() <= 0) {
                return defaultValue;
            }
            value = Float.valueOf(str);
        }
        return value;
    }

    protected Integer getInteger(FileSystemOptions fileSystemOptions, String name) {
        return this.getInteger(fileSystemOptions, name, null);
    }

    protected int getInteger(FileSystemOptions fileSystemOptions, String name, int defaultValue) {
        return this.getInteger(fileSystemOptions, name, (Integer)defaultValue);
    }

    protected Integer getInteger(FileSystemOptions fileSystemOptions, String name, Integer defaultValue) {
        Integer value = (Integer)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null) {
                return defaultValue;
            }
            value = Integer.valueOf(str);
        }
        return value;
    }

    protected Long getLong(FileSystemOptions fileSystemOptions, String name) {
        return this.getLong(fileSystemOptions, name, null);
    }

    protected long getLong(FileSystemOptions fileSystemOptions, String name, long defaultValue) {
        return this.getLong(fileSystemOptions, name, (Long)defaultValue);
    }

    protected Long getLong(FileSystemOptions fileSystemOptions, String name, Long defaultValue) {
        Long value = (Long)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null) {
                return defaultValue;
            }
            value = Long.valueOf(str);
        }
        return value;
    }

    protected Object getParam(FileSystemOptions fileSystemOptions, String name) {
        return fileSystemOptions == null ? null : fileSystemOptions.getOption(this.getConfigClass(), name);
    }

    private String getProperty(String name) {
        return System.getProperty(this.toPropertyKey(name));
    }

    public String getRootURI(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, ROOTURI);
    }

    protected Short getShort(FileSystemOptions fileSystemOptions, String name) {
        return this.getShort(fileSystemOptions, name, null);
    }

    protected short getShort(FileSystemOptions fileSystemOptions, String name, short defaultValue) {
        return this.getShort(fileSystemOptions, name, (Short)defaultValue);
    }

    protected Short getShort(FileSystemOptions fileSystemOptions, String name, Short defaultValue) {
        Short value = (Short)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null) {
                return defaultValue;
            }
            value = Short.valueOf(str);
        }
        return value;
    }

    protected String getString(FileSystemOptions fileSystemOptions, String name) {
        return this.getString(fileSystemOptions, name, null);
    }

    protected String getString(FileSystemOptions fileSystemOptions, String name, String defaultValue) {
        String value = (String)this.getParam(fileSystemOptions, name);
        if (value == null && (value = this.getProperty(name)) == null) {
            return defaultValue;
        }
        return value;
    }

    protected boolean hasObject(FileSystemOptions fileSystemOptions, String name) {
        return this.hasParam(fileSystemOptions, name) || System.getProperties().containsKey(this.toPropertyKey(name));
    }

    protected boolean hasParam(FileSystemOptions fileSystemOptions, String name) {
        return fileSystemOptions != null && fileSystemOptions.hasOption(this.getConfigClass(), name);
    }

    protected void setParam(FileSystemOptions fileSystemOptions, String name, boolean value) {
        this.setParam(fileSystemOptions, name, (Object)value);
    }

    protected void setParam(FileSystemOptions fileSystemOptions, String name, Object value) {
        Objects.requireNonNull(fileSystemOptions, "fileSystemOptions").setOption(this.getConfigClass(), name, value);
    }

    public void setRootURI(FileSystemOptions fileSystemOptions, String rootURI) {
        this.setParam(fileSystemOptions, ROOTURI, rootURI);
    }

    protected Boolean toBooleanObject(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    private String toPropertyKey(String name) {
        return this.prefix + name;
    }
}

