/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.objectweb.proactive.utils.AggregateException;

public class AggregateRuntimeException
extends RuntimeException {
    List<Throwable> causes = new ArrayList<Throwable>();
    private static final String CAUSE_CAPTION = "Caused by: ";

    public AggregateRuntimeException() {
    }

    public AggregateRuntimeException(List<Throwable> causes) {
        this.causes = causes;
    }

    public AggregateRuntimeException(String message) {
        super(message);
    }

    public AggregateRuntimeException(String message, List<Throwable> causes) {
        super(message);
        this.causes = causes;
    }

    public void addCause(Throwable cause) {
        this.causes.add(cause);
    }

    public synchronized List<Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new AggregateException.WrappedPrintStream(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(AggregateException.PrintStreamOrWriter s) {
        Set dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        dejaVu.add(this);
        Object object = s.lock();
        synchronized (object) {
            StackTraceElement[] trace;
            s.println(this);
            for (StackTraceElement traceElement : trace = this.getStackTrace()) {
                s.println("\tat " + traceElement);
            }
            List<Throwable> ourCauses = this.getCauses();
            s.println("");
            AggregateException.printTheCauses(s, this.causes);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(new AggregateException.WrappedPrintWriter(s));
    }
}

