# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AADProperties(Model):
    """AADProperties.

    :param service_principal_client_id:
    :type service_principal_client_id: str
    :param tenant_id:
    :type tenant_id: str
    :param authority:
    :type authority: str
    :param audience:
    :type audience: str
    :param service_principal_object_id:
    :type service_principal_object_id: str
    """

    _attribute_map = {
        'service_principal_client_id': {'key': 'servicePrincipalClientId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'authority': {'key': 'authority', 'type': 'str'},
        'audience': {'key': 'audience', 'type': 'str'},
        'service_principal_object_id': {'key': 'servicePrincipalObjectId', 'type': 'str'},
    }

    def __init__(self, *, service_principal_client_id: str=None, tenant_id: str=None, authority: str=None, audience: str=None, service_principal_object_id: str=None, **kwargs) -> None:
        super(AADProperties, self).__init__(**kwargs)
        self.service_principal_client_id = service_principal_client_id
        self.tenant_id = tenant_id
        self.authority = authority
        self.audience = audience
        self.service_principal_object_id = service_principal_object_id


class Resource(Model):
    """ARM Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.e_tag = e_tag


class AADPropertiesResource(Resource):
    """AADPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: AADPropertiesResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.AADProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AADProperties'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(AADPropertiesResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class FeatureSupportRequest(Model):
    """Base class for feature request.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupGoalFeatureSupportRequest,
    AzureVMResourceFeatureSupportRequest

    All required parameters must be populated in order to send to Azure.

    :param feature_type: Required. Constant filled by server.
    :type feature_type: str
    """

    _validation = {
        'feature_type': {'required': True},
    }

    _attribute_map = {
        'feature_type': {'key': 'featureType', 'type': 'str'},
    }

    _subtype_map = {
        'feature_type': {'AzureBackupGoals': 'AzureBackupGoalFeatureSupportRequest', 'AzureVMResourceBackup': 'AzureVMResourceFeatureSupportRequest'}
    }

    def __init__(self, **kwargs) -> None:
        super(FeatureSupportRequest, self).__init__(**kwargs)
        self.feature_type = None


class AzureBackupGoalFeatureSupportRequest(FeatureSupportRequest):
    """Azure backup goal feature specific request.

    All required parameters must be populated in order to send to Azure.

    :param feature_type: Required. Constant filled by server.
    :type feature_type: str
    """

    _validation = {
        'feature_type': {'required': True},
    }

    _attribute_map = {
        'feature_type': {'key': 'featureType', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureBackupGoalFeatureSupportRequest, self).__init__(**kwargs)
        self.feature_type = 'AzureBackupGoals'


class ProtectionContainer(Model):
    """Base class for container with backup items. Containers with specific
    workloads are derived from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureSqlContainer, AzureStorageContainer,
    AzureWorkloadContainer, DpmContainer, GenericContainer, IaaSVMContainer,
    MabContainer

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
    }

    _subtype_map = {
        'container_type': {'AzureSqlContainer': 'AzureSqlContainer', 'StorageContainer': 'AzureStorageContainer', 'AzureWorkloadContainer': 'AzureWorkloadContainer', 'DPMContainer': 'DpmContainer', 'GenericContainer': 'GenericContainer', 'IaaSVMContainer': 'IaaSVMContainer', 'Windows': 'MabContainer'}
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, **kwargs) -> None:
        super(ProtectionContainer, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.backup_management_type = backup_management_type
        self.registration_status = registration_status
        self.health_status = health_status
        self.container_type = None


class DpmContainer(ProtectionContainer):
    """DPM workload-specific protection container.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupServerContainer

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param can_re_register: Specifies whether the container is re-registrable.
    :type can_re_register: bool
    :param container_id: ID of container.
    :type container_id: str
    :param protected_item_count: Number of protected items in the BackupEngine
    :type protected_item_count: long
    :param dpm_agent_version: Backup engine Agent version
    :type dpm_agent_version: str
    :param dpm_servers: List of BackupEngines protecting the container
    :type dpm_servers: list[str]
    :param upgrade_available: To check if upgrade available
    :type upgrade_available: bool
    :param protection_status: Protection status of the container.
    :type protection_status: str
    :param extended_info: Extended Info of the container.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.DPMContainerExtendedInfo
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'long'},
        'dpm_agent_version': {'key': 'dpmAgentVersion', 'type': 'str'},
        'dpm_servers': {'key': 'dpmServers', 'type': '[str]'},
        'upgrade_available': {'key': 'upgradeAvailable', 'type': 'bool'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'DPMContainerExtendedInfo'},
    }

    _subtype_map = {
        'container_type': {'AzureBackupServerContainer': 'AzureBackupServerContainer'}
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, can_re_register: bool=None, container_id: str=None, protected_item_count: int=None, dpm_agent_version: str=None, dpm_servers=None, upgrade_available: bool=None, protection_status: str=None, extended_info=None, **kwargs) -> None:
        super(DpmContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, **kwargs)
        self.can_re_register = can_re_register
        self.container_id = container_id
        self.protected_item_count = protected_item_count
        self.dpm_agent_version = dpm_agent_version
        self.dpm_servers = dpm_servers
        self.upgrade_available = upgrade_available
        self.protection_status = protection_status
        self.extended_info = extended_info
        self.container_type = 'DPMContainer'


class AzureBackupServerContainer(DpmContainer):
    """AzureBackupServer (DPMVenus) workload-specific protection container.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param can_re_register: Specifies whether the container is re-registrable.
    :type can_re_register: bool
    :param container_id: ID of container.
    :type container_id: str
    :param protected_item_count: Number of protected items in the BackupEngine
    :type protected_item_count: long
    :param dpm_agent_version: Backup engine Agent version
    :type dpm_agent_version: str
    :param dpm_servers: List of BackupEngines protecting the container
    :type dpm_servers: list[str]
    :param upgrade_available: To check if upgrade available
    :type upgrade_available: bool
    :param protection_status: Protection status of the container.
    :type protection_status: str
    :param extended_info: Extended Info of the container.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.DPMContainerExtendedInfo
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'long'},
        'dpm_agent_version': {'key': 'dpmAgentVersion', 'type': 'str'},
        'dpm_servers': {'key': 'dpmServers', 'type': '[str]'},
        'upgrade_available': {'key': 'upgradeAvailable', 'type': 'bool'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'DPMContainerExtendedInfo'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, can_re_register: bool=None, container_id: str=None, protected_item_count: int=None, dpm_agent_version: str=None, dpm_servers=None, upgrade_available: bool=None, protection_status: str=None, extended_info=None, **kwargs) -> None:
        super(AzureBackupServerContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, can_re_register=can_re_register, container_id=container_id, protected_item_count=protected_item_count, dpm_agent_version=dpm_agent_version, dpm_servers=dpm_servers, upgrade_available=upgrade_available, protection_status=protection_status, extended_info=extended_info, **kwargs)
        self.container_type = 'AzureBackupServerContainer'


class BackupEngineBase(Model):
    """The base backup engine class. All workload specific backup engines derive
    from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupServerEngine, DpmBackupEngine

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the backup engine.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the backup
     engine. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Registration status of the backup engine with
     the Recovery Services Vault.
    :type registration_status: str
    :param backup_engine_state: Status of the backup engine with the Recovery
     Services Vault. = {Active/Deleting/DeleteFailed}
    :type backup_engine_state: str
    :param health_status: Backup status of the backup engine.
    :type health_status: str
    :param can_re_register: Flag indicating if the backup engine be
     registered, once already registered.
    :type can_re_register: bool
    :param backup_engine_id: ID of the backup engine.
    :type backup_engine_id: str
    :param dpm_version: Backup engine version
    :type dpm_version: str
    :param azure_backup_agent_version: Backup agent version
    :type azure_backup_agent_version: str
    :param is_azure_backup_agent_upgrade_available: To check if backup agent
     upgrade available
    :type is_azure_backup_agent_upgrade_available: bool
    :param is_dpm_upgrade_available: To check if backup engine upgrade
     available
    :type is_dpm_upgrade_available: bool
    :param extended_info: Extended info of the backupengine
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.BackupEngineExtendedInfo
    :param backup_engine_type: Required. Constant filled by server.
    :type backup_engine_type: str
    """

    _validation = {
        'backup_engine_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'backup_engine_state': {'key': 'backupEngineState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'backup_engine_id': {'key': 'backupEngineId', 'type': 'str'},
        'dpm_version': {'key': 'dpmVersion', 'type': 'str'},
        'azure_backup_agent_version': {'key': 'azureBackupAgentVersion', 'type': 'str'},
        'is_azure_backup_agent_upgrade_available': {'key': 'isAzureBackupAgentUpgradeAvailable', 'type': 'bool'},
        'is_dpm_upgrade_available': {'key': 'isDpmUpgradeAvailable', 'type': 'bool'},
        'extended_info': {'key': 'extendedInfo', 'type': 'BackupEngineExtendedInfo'},
        'backup_engine_type': {'key': 'backupEngineType', 'type': 'str'},
    }

    _subtype_map = {
        'backup_engine_type': {'AzureBackupServerEngine': 'AzureBackupServerEngine', 'DpmBackupEngine': 'DpmBackupEngine'}
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, backup_engine_state: str=None, health_status: str=None, can_re_register: bool=None, backup_engine_id: str=None, dpm_version: str=None, azure_backup_agent_version: str=None, is_azure_backup_agent_upgrade_available: bool=None, is_dpm_upgrade_available: bool=None, extended_info=None, **kwargs) -> None:
        super(BackupEngineBase, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.backup_management_type = backup_management_type
        self.registration_status = registration_status
        self.backup_engine_state = backup_engine_state
        self.health_status = health_status
        self.can_re_register = can_re_register
        self.backup_engine_id = backup_engine_id
        self.dpm_version = dpm_version
        self.azure_backup_agent_version = azure_backup_agent_version
        self.is_azure_backup_agent_upgrade_available = is_azure_backup_agent_upgrade_available
        self.is_dpm_upgrade_available = is_dpm_upgrade_available
        self.extended_info = extended_info
        self.backup_engine_type = None


class AzureBackupServerEngine(BackupEngineBase):
    """Backup engine type when Azure Backup Server is used to manage the backups.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the backup engine.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the backup
     engine. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Registration status of the backup engine with
     the Recovery Services Vault.
    :type registration_status: str
    :param backup_engine_state: Status of the backup engine with the Recovery
     Services Vault. = {Active/Deleting/DeleteFailed}
    :type backup_engine_state: str
    :param health_status: Backup status of the backup engine.
    :type health_status: str
    :param can_re_register: Flag indicating if the backup engine be
     registered, once already registered.
    :type can_re_register: bool
    :param backup_engine_id: ID of the backup engine.
    :type backup_engine_id: str
    :param dpm_version: Backup engine version
    :type dpm_version: str
    :param azure_backup_agent_version: Backup agent version
    :type azure_backup_agent_version: str
    :param is_azure_backup_agent_upgrade_available: To check if backup agent
     upgrade available
    :type is_azure_backup_agent_upgrade_available: bool
    :param is_dpm_upgrade_available: To check if backup engine upgrade
     available
    :type is_dpm_upgrade_available: bool
    :param extended_info: Extended info of the backupengine
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.BackupEngineExtendedInfo
    :param backup_engine_type: Required. Constant filled by server.
    :type backup_engine_type: str
    """

    _validation = {
        'backup_engine_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'backup_engine_state': {'key': 'backupEngineState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'backup_engine_id': {'key': 'backupEngineId', 'type': 'str'},
        'dpm_version': {'key': 'dpmVersion', 'type': 'str'},
        'azure_backup_agent_version': {'key': 'azureBackupAgentVersion', 'type': 'str'},
        'is_azure_backup_agent_upgrade_available': {'key': 'isAzureBackupAgentUpgradeAvailable', 'type': 'bool'},
        'is_dpm_upgrade_available': {'key': 'isDpmUpgradeAvailable', 'type': 'bool'},
        'extended_info': {'key': 'extendedInfo', 'type': 'BackupEngineExtendedInfo'},
        'backup_engine_type': {'key': 'backupEngineType', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, backup_engine_state: str=None, health_status: str=None, can_re_register: bool=None, backup_engine_id: str=None, dpm_version: str=None, azure_backup_agent_version: str=None, is_azure_backup_agent_upgrade_available: bool=None, is_dpm_upgrade_available: bool=None, extended_info=None, **kwargs) -> None:
        super(AzureBackupServerEngine, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, backup_engine_state=backup_engine_state, health_status=health_status, can_re_register=can_re_register, backup_engine_id=backup_engine_id, dpm_version=dpm_version, azure_backup_agent_version=azure_backup_agent_version, is_azure_backup_agent_upgrade_available=is_azure_backup_agent_upgrade_available, is_dpm_upgrade_available=is_dpm_upgrade_available, extended_info=extended_info, **kwargs)
        self.backup_engine_type = 'AzureBackupServerEngine'


class BackupRequest(Model):
    """Base class for backup request. Workload-specific backup requests are
    derived from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileShareBackupRequest, AzureWorkloadBackupRequest,
    IaasVMBackupRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureFileShareBackupRequest': 'AzureFileShareBackupRequest', 'AzureWorkloadBackupRequest': 'AzureWorkloadBackupRequest', 'IaasVMBackupRequest': 'IaasVMBackupRequest'}
    }

    def __init__(self, **kwargs) -> None:
        super(BackupRequest, self).__init__(**kwargs)
        self.object_type = None


class AzureFileShareBackupRequest(BackupRequest):
    """AzureFileShare workload-specific backup request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_expiry_time_in_utc: Backup copy will expire after
     the time specified (UTC).
    :type recovery_point_expiry_time_in_utc: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_expiry_time_in_utc': {'key': 'recoveryPointExpiryTimeInUTC', 'type': 'iso-8601'},
    }

    def __init__(self, *, recovery_point_expiry_time_in_utc=None, **kwargs) -> None:
        super(AzureFileShareBackupRequest, self).__init__(**kwargs)
        self.recovery_point_expiry_time_in_utc = recovery_point_expiry_time_in_utc
        self.object_type = 'AzureFileShareBackupRequest'


class WorkloadProtectableItem(Model):
    """Base class for backup item. Workload-specific backup items are derived from
    this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileShareProtectableItem,
    AzureVmWorkloadProtectableItem, IaaSVMProtectableItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protectable_item_type': {'AzureFileShare': 'AzureFileShareProtectableItem', 'AzureVmWorkloadProtectableItem': 'AzureVmWorkloadProtectableItem', 'IaaSVMProtectableItem': 'IaaSVMProtectableItem'}
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, **kwargs) -> None:
        super(WorkloadProtectableItem, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_type = workload_type
        self.friendly_name = friendly_name
        self.protection_state = protection_state
        self.protectable_item_type = None


class AzureFileShareProtectableItem(WorkloadProtectableItem):
    """Protectable item for Azure Fileshare workloads.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_container_fabric_id: Full Fabric ID of container to which
     this protectable item belongs. For example, ARM ID.
    :type parent_container_fabric_id: str
    :param parent_container_friendly_name: Friendly name of container to which
     this protectable item belongs.
    :type parent_container_friendly_name: str
    :param azure_file_share_type: File Share type XSync or XSMB. Possible
     values include: 'Invalid', 'XSMB', 'XSync'
    :type azure_file_share_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.AzureFileShareType
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_container_fabric_id': {'key': 'parentContainerFabricId', 'type': 'str'},
        'parent_container_friendly_name': {'key': 'parentContainerFriendlyName', 'type': 'str'},
        'azure_file_share_type': {'key': 'azureFileShareType', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_container_fabric_id: str=None, parent_container_friendly_name: str=None, azure_file_share_type=None, **kwargs) -> None:
        super(AzureFileShareProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, **kwargs)
        self.parent_container_fabric_id = parent_container_fabric_id
        self.parent_container_friendly_name = parent_container_friendly_name
        self.azure_file_share_type = azure_file_share_type
        self.protectable_item_type = 'AzureFileShare'


class ProtectedItem(Model):
    """Base class for backup items.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileshareProtectedItem, AzureIaaSVMProtectedItem,
    AzureSqlProtectedItem, AzureVmWorkloadProtectedItem, DPMProtectedItem,
    GenericProtectedItem, MabFileFolderProtectedItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protected_item_type': {'AzureFileShareProtectedItem': 'AzureFileshareProtectedItem', 'AzureIaaSVMProtectedItem': 'AzureIaaSVMProtectedItem', 'Microsoft.Sql/servers/databases': 'AzureSqlProtectedItem', 'AzureVmWorkloadProtectedItem': 'AzureVmWorkloadProtectedItem', 'DPMProtectedItem': 'DPMProtectedItem', 'GenericProtectedItem': 'GenericProtectedItem', 'MabFileFolderProtectedItem': 'MabFileFolderProtectedItem'}
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, **kwargs) -> None:
        super(ProtectedItem, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_type = workload_type
        self.container_name = container_name
        self.source_resource_id = source_resource_id
        self.policy_id = policy_id
        self.last_recovery_point = last_recovery_point
        self.backup_set_name = backup_set_name
        self.create_mode = create_mode
        self.deferred_delete_time_in_utc = deferred_delete_time_in_utc
        self.is_scheduled_for_deferred_delete = is_scheduled_for_deferred_delete
        self.deferred_delete_time_remaining = deferred_delete_time_remaining
        self.is_deferred_delete_schedule_upcoming = is_deferred_delete_schedule_upcoming
        self.is_rehydrate = is_rehydrate
        self.protected_item_type = None


class AzureFileshareProtectedItem(ProtectedItem):
    """Azure File Share workload-specific backup item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the fileshare represented by this
     backup item.
    :type friendly_name: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param last_backup_status: Last backup operation status. Possible values:
     Healthy, Unhealthy.
    :type last_backup_status: str
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param kpis_healths: Health details of different KPIs
    :type kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.KPIResourceHealthDetails]
    :param extended_info: Additional information with this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureFileshareProtectedItemExtendedInfo
    :param health_status: backups running status for this backup item.
     Possible values include: 'Passed', 'ActionRequired', 'ActionSuggested',
     'Invalid'
    :type health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.HealthStatus
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'kpis_healths': {'key': 'kpisHealths', 'type': '{KPIResourceHealthDetails}'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureFileshareProtectedItemExtendedInfo'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, protection_status: str=None, protection_state=None, last_backup_status: str=None, last_backup_time=None, kpis_healths=None, extended_info=None, health_status=None, **kwargs) -> None:
        super(AzureFileshareProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, **kwargs)
        self.friendly_name = friendly_name
        self.protection_status = protection_status
        self.protection_state = protection_state
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.kpis_healths = kpis_healths
        self.extended_info = extended_info
        self.health_status = health_status
        self.protected_item_type = 'AzureFileShareProtectedItem'


class AzureFileshareProtectedItemExtendedInfo(Model):
    """Additional information about Azure File Share backup item.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param oldest_recovery_point: The oldest backup copy available for this
     item in the service.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: Number of available backup copies associated
     with this backup item.
    :type recovery_point_count: int
    :param policy_state: Indicates consistency of policy object and policy
     applied to this backup item.
    :type policy_state: str
    :ivar resource_state: Indicates the state of this resource. Possible
     values are from enum ResourceState {Invalid, Active, SoftDeleted, Deleted}
    :vartype resource_state: str
    :ivar resource_state_sync_time: The resource state sync time for this
     backup item.
    :vartype resource_state_sync_time: datetime
    """

    _validation = {
        'resource_state': {'readonly': True},
        'resource_state_sync_time': {'readonly': True},
    }

    _attribute_map = {
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'policy_state': {'key': 'policyState', 'type': 'str'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'resource_state_sync_time': {'key': 'resourceStateSyncTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, oldest_recovery_point=None, recovery_point_count: int=None, policy_state: str=None, **kwargs) -> None:
        super(AzureFileshareProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.policy_state = policy_state
        self.resource_state = None
        self.resource_state_sync_time = None


class ProtectionPolicy(Model):
    """Base class for backup policy. Workload-specific backup policies are derived
    from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureVmWorkloadProtectionPolicy,
    AzureFileShareProtectionPolicy, AzureIaaSVMProtectionPolicy,
    AzureSqlProtectionPolicy, GenericProtectionPolicy, MabProtectionPolicy

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
    }

    _subtype_map = {
        'backup_management_type': {'AzureWorkload': 'AzureVmWorkloadProtectionPolicy', 'AzureStorage': 'AzureFileShareProtectionPolicy', 'AzureIaasVM': 'AzureIaaSVMProtectionPolicy', 'AzureSql': 'AzureSqlProtectionPolicy', 'GenericProtectionPolicy': 'GenericProtectionPolicy', 'MAB': 'MabProtectionPolicy'}
    }

    def __init__(self, *, protected_items_count: int=None, **kwargs) -> None:
        super(ProtectionPolicy, self).__init__(**kwargs)
        self.protected_items_count = protected_items_count
        self.backup_management_type = None


class AzureFileShareProtectionPolicy(ProtectionPolicy):
    """AzureStorage backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param work_load_type: Type of workload for the backup management.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type work_load_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param schedule_policy: Backup schedule specified as part of backup
     policy.
    :type schedule_policy:
     ~azure.mgmt.recoveryservicesbackup.models.SchedulePolicy
    :param retention_policy: Retention policy with the details on backup copy
     retention ranges.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    :param time_zone: TimeZone optional input as string. For example: TimeZone
     = "Pacific Standard Time".
    :type time_zone: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'work_load_type': {'key': 'workLoadType', 'type': 'str'},
        'schedule_policy': {'key': 'schedulePolicy', 'type': 'SchedulePolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
    }

    def __init__(self, *, protected_items_count: int=None, work_load_type=None, schedule_policy=None, retention_policy=None, time_zone: str=None, **kwargs) -> None:
        super(AzureFileShareProtectionPolicy, self).__init__(protected_items_count=protected_items_count, **kwargs)
        self.work_load_type = work_load_type
        self.schedule_policy = schedule_policy
        self.retention_policy = retention_policy
        self.time_zone = time_zone
        self.backup_management_type = 'AzureStorage'


class ILRRequest(Model):
    """Parameters to Provision ILR API.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileShareProvisionILRRequest,
    IaasVMILRRegistrationRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureFileShareProvisionILRRequest': 'AzureFileShareProvisionILRRequest', 'IaasVMILRRegistrationRequest': 'IaasVMILRRegistrationRequest'}
    }

    def __init__(self, **kwargs) -> None:
        super(ILRRequest, self).__init__(**kwargs)
        self.object_type = None


class AzureFileShareProvisionILRRequest(ILRRequest):
    """Update snapshot Uri with the correct friendly Name of the source Azure file
    share.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_id: Recovery point ID.
    :type recovery_point_id: str
    :param source_resource_id: Source Storage account ARM Id
    :type source_resource_id: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
    }

    def __init__(self, *, recovery_point_id: str=None, source_resource_id: str=None, **kwargs) -> None:
        super(AzureFileShareProvisionILRRequest, self).__init__(**kwargs)
        self.recovery_point_id = recovery_point_id
        self.source_resource_id = source_resource_id
        self.object_type = 'AzureFileShareProvisionILRRequest'


class RecoveryPoint(Model):
    """Base class for backup copies. Workload-specific backup copies are derived
    from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileShareRecoveryPoint, AzureWorkloadRecoveryPoint,
    GenericRecoveryPoint, IaasVMRecoveryPoint

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureFileShareRecoveryPoint': 'AzureFileShareRecoveryPoint', 'AzureWorkloadRecoveryPoint': 'AzureWorkloadRecoveryPoint', 'GenericRecoveryPoint': 'GenericRecoveryPoint', 'IaasVMRecoveryPoint': 'IaasVMRecoveryPoint'}
    }

    def __init__(self, **kwargs) -> None:
        super(RecoveryPoint, self).__init__(**kwargs)
        self.object_type = None


class AzureFileShareRecoveryPoint(RecoveryPoint):
    """Azure File Share workload specific backup copy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_type: Type of the backup copy. Specifies whether it
     is a crash consistent backup or app consistent.
    :vartype recovery_point_type: str
    :ivar recovery_point_time: Time at which this backup copy was created.
    :vartype recovery_point_time: datetime
    :ivar file_share_snapshot_uri: Contains Url to the snapshot of fileshare,
     if applicable
    :vartype file_share_snapshot_uri: str
    :ivar recovery_point_size_in_gb: Contains recovery point size
    :vartype recovery_point_size_in_gb: int
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_type': {'readonly': True},
        'recovery_point_time': {'readonly': True},
        'file_share_snapshot_uri': {'readonly': True},
        'recovery_point_size_in_gb': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
        'file_share_snapshot_uri': {'key': 'fileShareSnapshotUri', 'type': 'str'},
        'recovery_point_size_in_gb': {'key': 'recoveryPointSizeInGB', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureFileShareRecoveryPoint, self).__init__(**kwargs)
        self.recovery_point_type = None
        self.recovery_point_time = None
        self.file_share_snapshot_uri = None
        self.recovery_point_size_in_gb = None
        self.object_type = 'AzureFileShareRecoveryPoint'


class RestoreRequest(Model):
    """Base class for restore request. Workload-specific restore requests are
    derived from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileShareRestoreRequest, AzureWorkloadRestoreRequest,
    IaasVMRestoreRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureFileShareRestoreRequest': 'AzureFileShareRestoreRequest', 'AzureWorkloadRestoreRequest': 'AzureWorkloadRestoreRequest', 'IaasVMRestoreRequest': 'IaasVMRestoreRequest'}
    }

    def __init__(self, **kwargs) -> None:
        super(RestoreRequest, self).__init__(**kwargs)
        self.object_type = None


class AzureFileShareRestoreRequest(RestoreRequest):
    """AzureFileShare Restore Request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Source storage account ARM Id
    :type source_resource_id: str
    :param copy_options: Options to resolve copy conflicts. Possible values
     include: 'Invalid', 'CreateCopy', 'Skip', 'Overwrite', 'FailOnConflict'
    :type copy_options: str or
     ~azure.mgmt.recoveryservicesbackup.models.CopyOptions
    :param restore_request_type: Restore Type (FullShareRestore or
     ItemLevelRestore). Possible values include: 'Invalid', 'FullShareRestore',
     'ItemLevelRestore'
    :type restore_request_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestoreRequestType
    :param restore_file_specs: List of Source Files/Folders(which need to
     recover) and TargetFolderPath details
    :type restore_file_specs:
     list[~azure.mgmt.recoveryservicesbackup.models.RestoreFileSpecs]
    :param target_details: Target File Share Details
    :type target_details:
     ~azure.mgmt.recoveryservicesbackup.models.TargetAFSRestoreInfo
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'copy_options': {'key': 'copyOptions', 'type': 'str'},
        'restore_request_type': {'key': 'restoreRequestType', 'type': 'str'},
        'restore_file_specs': {'key': 'restoreFileSpecs', 'type': '[RestoreFileSpecs]'},
        'target_details': {'key': 'targetDetails', 'type': 'TargetAFSRestoreInfo'},
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, copy_options=None, restore_request_type=None, restore_file_specs=None, target_details=None, **kwargs) -> None:
        super(AzureFileShareRestoreRequest, self).__init__(**kwargs)
        self.recovery_type = recovery_type
        self.source_resource_id = source_resource_id
        self.copy_options = copy_options
        self.restore_request_type = restore_request_type
        self.restore_file_specs = restore_file_specs
        self.target_details = target_details
        self.object_type = 'AzureFileShareRestoreRequest'


class IaaSVMContainer(ProtectionContainer):
    """IaaS VM workload-specific container.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureIaaSClassicComputeVMContainer,
    AzureIaaSComputeVMContainer

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param virtual_machine_id: Fully qualified ARM url of the virtual machine
     represented by this Azure IaaS VM container.
    :type virtual_machine_id: str
    :param virtual_machine_version: Specifies whether the container represents
     a Classic or an Azure Resource Manager VM.
    :type virtual_machine_version: str
    :param resource_group: Resource group name of Recovery Services Vault.
    :type resource_group: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'virtual_machine_version': {'key': 'virtualMachineVersion', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    _subtype_map = {
        'container_type': {'Microsoft.ClassicCompute/virtualMachines': 'AzureIaaSClassicComputeVMContainer', 'Microsoft.Compute/virtualMachines': 'AzureIaaSComputeVMContainer'}
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, virtual_machine_id: str=None, virtual_machine_version: str=None, resource_group: str=None, **kwargs) -> None:
        super(IaaSVMContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, **kwargs)
        self.virtual_machine_id = virtual_machine_id
        self.virtual_machine_version = virtual_machine_version
        self.resource_group = resource_group
        self.container_type = 'IaaSVMContainer'


class AzureIaaSClassicComputeVMContainer(IaaSVMContainer):
    """IaaS VM workload-specific backup item representing a classic virtual
    machine.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param virtual_machine_id: Fully qualified ARM url of the virtual machine
     represented by this Azure IaaS VM container.
    :type virtual_machine_id: str
    :param virtual_machine_version: Specifies whether the container represents
     a Classic or an Azure Resource Manager VM.
    :type virtual_machine_version: str
    :param resource_group: Resource group name of Recovery Services Vault.
    :type resource_group: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'virtual_machine_version': {'key': 'virtualMachineVersion', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, virtual_machine_id: str=None, virtual_machine_version: str=None, resource_group: str=None, **kwargs) -> None:
        super(AzureIaaSClassicComputeVMContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, virtual_machine_id=virtual_machine_id, virtual_machine_version=virtual_machine_version, resource_group=resource_group, **kwargs)
        self.container_type = 'Microsoft.ClassicCompute/virtualMachines'


class IaaSVMProtectableItem(WorkloadProtectableItem):
    """IaaS VM workload-specific backup item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureIaaSClassicComputeVMProtectableItem,
    AzureIaaSComputeVMProtectableItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine.
    :type virtual_machine_id: str
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
    }

    _subtype_map = {
        'protectable_item_type': {'Microsoft.ClassicCompute/virtualMachines': 'AzureIaaSClassicComputeVMProtectableItem', 'Microsoft.Compute/virtualMachines': 'AzureIaaSComputeVMProtectableItem'}
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, virtual_machine_id: str=None, **kwargs) -> None:
        super(IaaSVMProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, **kwargs)
        self.virtual_machine_id = virtual_machine_id
        self.protectable_item_type = 'IaaSVMProtectableItem'


class AzureIaaSClassicComputeVMProtectableItem(IaaSVMProtectableItem):
    """IaaS VM workload-specific backup item representing the Classic Compute VM.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine.
    :type virtual_machine_id: str
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, virtual_machine_id: str=None, **kwargs) -> None:
        super(AzureIaaSClassicComputeVMProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, virtual_machine_id=virtual_machine_id, **kwargs)
        self.protectable_item_type = 'Microsoft.ClassicCompute/virtualMachines'


class AzureIaaSVMProtectedItem(ProtectedItem):
    """IaaS VM workload-specific backup item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureIaaSClassicComputeVMProtectedItem,
    AzureIaaSComputeVMProtectedItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the VM represented by this backup
     item.
    :type friendly_name: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine
     represented by this item.
    :type virtual_machine_id: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param health_status: Health status of protected item. Possible values
     include: 'Passed', 'ActionRequired', 'ActionSuggested', 'Invalid'
    :type health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.HealthStatus
    :param health_details: Health details on this backup item.
    :type health_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMHealthDetails]
    :param kpis_healths: Health details of different KPIs
    :type kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.KPIResourceHealthDetails]
    :param last_backup_status: Last backup operation status.
    :type last_backup_status: str
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param protected_item_data_id: Data ID of the protected item.
    :type protected_item_data_id: str
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMProtectedItemExtendedInfo
    :param extended_properties:
    :type extended_properties:
     ~azure.mgmt.recoveryservicesbackup.models.ExtendedProperties
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'health_details': {'key': 'healthDetails', 'type': '[AzureIaaSVMHealthDetails]'},
        'kpis_healths': {'key': 'kpisHealths', 'type': '{KPIResourceHealthDetails}'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'protected_item_data_id': {'key': 'protectedItemDataId', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureIaaSVMProtectedItemExtendedInfo'},
        'extended_properties': {'key': 'extendedProperties', 'type': 'ExtendedProperties'},
    }

    _subtype_map = {
        'protected_item_type': {'Microsoft.ClassicCompute/virtualMachines': 'AzureIaaSClassicComputeVMProtectedItem', 'Microsoft.Compute/virtualMachines': 'AzureIaaSComputeVMProtectedItem'}
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, virtual_machine_id: str=None, protection_status: str=None, protection_state=None, health_status=None, health_details=None, kpis_healths=None, last_backup_status: str=None, last_backup_time=None, protected_item_data_id: str=None, extended_info=None, extended_properties=None, **kwargs) -> None:
        super(AzureIaaSVMProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, **kwargs)
        self.friendly_name = friendly_name
        self.virtual_machine_id = virtual_machine_id
        self.protection_status = protection_status
        self.protection_state = protection_state
        self.health_status = health_status
        self.health_details = health_details
        self.kpis_healths = kpis_healths
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.protected_item_data_id = protected_item_data_id
        self.extended_info = extended_info
        self.extended_properties = extended_properties
        self.protected_item_type = 'AzureIaaSVMProtectedItem'


class AzureIaaSClassicComputeVMProtectedItem(AzureIaaSVMProtectedItem):
    """IaaS VM workload-specific backup item representing the Classic Compute VM.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the VM represented by this backup
     item.
    :type friendly_name: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine
     represented by this item.
    :type virtual_machine_id: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param health_status: Health status of protected item. Possible values
     include: 'Passed', 'ActionRequired', 'ActionSuggested', 'Invalid'
    :type health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.HealthStatus
    :param health_details: Health details on this backup item.
    :type health_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMHealthDetails]
    :param kpis_healths: Health details of different KPIs
    :type kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.KPIResourceHealthDetails]
    :param last_backup_status: Last backup operation status.
    :type last_backup_status: str
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param protected_item_data_id: Data ID of the protected item.
    :type protected_item_data_id: str
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMProtectedItemExtendedInfo
    :param extended_properties:
    :type extended_properties:
     ~azure.mgmt.recoveryservicesbackup.models.ExtendedProperties
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'health_details': {'key': 'healthDetails', 'type': '[AzureIaaSVMHealthDetails]'},
        'kpis_healths': {'key': 'kpisHealths', 'type': '{KPIResourceHealthDetails}'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'protected_item_data_id': {'key': 'protectedItemDataId', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureIaaSVMProtectedItemExtendedInfo'},
        'extended_properties': {'key': 'extendedProperties', 'type': 'ExtendedProperties'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, virtual_machine_id: str=None, protection_status: str=None, protection_state=None, health_status=None, health_details=None, kpis_healths=None, last_backup_status: str=None, last_backup_time=None, protected_item_data_id: str=None, extended_info=None, extended_properties=None, **kwargs) -> None:
        super(AzureIaaSClassicComputeVMProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, friendly_name=friendly_name, virtual_machine_id=virtual_machine_id, protection_status=protection_status, protection_state=protection_state, health_status=health_status, health_details=health_details, kpis_healths=kpis_healths, last_backup_status=last_backup_status, last_backup_time=last_backup_time, protected_item_data_id=protected_item_data_id, extended_info=extended_info, extended_properties=extended_properties, **kwargs)
        self.protected_item_type = 'Microsoft.ClassicCompute/virtualMachines'


class AzureIaaSComputeVMContainer(IaaSVMContainer):
    """IaaS VM workload-specific backup item representing an Azure Resource
    Manager virtual machine.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param virtual_machine_id: Fully qualified ARM url of the virtual machine
     represented by this Azure IaaS VM container.
    :type virtual_machine_id: str
    :param virtual_machine_version: Specifies whether the container represents
     a Classic or an Azure Resource Manager VM.
    :type virtual_machine_version: str
    :param resource_group: Resource group name of Recovery Services Vault.
    :type resource_group: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'virtual_machine_version': {'key': 'virtualMachineVersion', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, virtual_machine_id: str=None, virtual_machine_version: str=None, resource_group: str=None, **kwargs) -> None:
        super(AzureIaaSComputeVMContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, virtual_machine_id=virtual_machine_id, virtual_machine_version=virtual_machine_version, resource_group=resource_group, **kwargs)
        self.container_type = 'Microsoft.Compute/virtualMachines'


class AzureIaaSComputeVMProtectableItem(IaaSVMProtectableItem):
    """IaaS VM workload-specific backup item representing the Azure Resource
    Manager VM.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine.
    :type virtual_machine_id: str
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, virtual_machine_id: str=None, **kwargs) -> None:
        super(AzureIaaSComputeVMProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, virtual_machine_id=virtual_machine_id, **kwargs)
        self.protectable_item_type = 'Microsoft.Compute/virtualMachines'


class AzureIaaSComputeVMProtectedItem(AzureIaaSVMProtectedItem):
    """IaaS VM workload-specific backup item representing the Azure Resource
    Manager VM.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the VM represented by this backup
     item.
    :type friendly_name: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine
     represented by this item.
    :type virtual_machine_id: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param health_status: Health status of protected item. Possible values
     include: 'Passed', 'ActionRequired', 'ActionSuggested', 'Invalid'
    :type health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.HealthStatus
    :param health_details: Health details on this backup item.
    :type health_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMHealthDetails]
    :param kpis_healths: Health details of different KPIs
    :type kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.KPIResourceHealthDetails]
    :param last_backup_status: Last backup operation status.
    :type last_backup_status: str
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param protected_item_data_id: Data ID of the protected item.
    :type protected_item_data_id: str
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMProtectedItemExtendedInfo
    :param extended_properties:
    :type extended_properties:
     ~azure.mgmt.recoveryservicesbackup.models.ExtendedProperties
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'health_details': {'key': 'healthDetails', 'type': '[AzureIaaSVMHealthDetails]'},
        'kpis_healths': {'key': 'kpisHealths', 'type': '{KPIResourceHealthDetails}'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'protected_item_data_id': {'key': 'protectedItemDataId', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureIaaSVMProtectedItemExtendedInfo'},
        'extended_properties': {'key': 'extendedProperties', 'type': 'ExtendedProperties'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, virtual_machine_id: str=None, protection_status: str=None, protection_state=None, health_status=None, health_details=None, kpis_healths=None, last_backup_status: str=None, last_backup_time=None, protected_item_data_id: str=None, extended_info=None, extended_properties=None, **kwargs) -> None:
        super(AzureIaaSComputeVMProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, friendly_name=friendly_name, virtual_machine_id=virtual_machine_id, protection_status=protection_status, protection_state=protection_state, health_status=health_status, health_details=health_details, kpis_healths=kpis_healths, last_backup_status=last_backup_status, last_backup_time=last_backup_time, protected_item_data_id=protected_item_data_id, extended_info=extended_info, extended_properties=extended_properties, **kwargs)
        self.protected_item_type = 'Microsoft.Compute/virtualMachines'


class AzureIaaSVMErrorInfo(Model):
    """Azure IaaS VM workload-specific error information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error_code: Error code.
    :vartype error_code: int
    :ivar error_title: Title: Typically, the entity that the error pertains
     to.
    :vartype error_title: str
    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations for above error
     code.
    :vartype recommendations: list[str]
    """

    _validation = {
        'error_code': {'readonly': True},
        'error_title': {'readonly': True},
        'error_string': {'readonly': True},
        'recommendations': {'readonly': True},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'error_title': {'key': 'errorTitle', 'type': 'str'},
        'error_string': {'key': 'errorString', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureIaaSVMErrorInfo, self).__init__(**kwargs)
        self.error_code = None
        self.error_title = None
        self.error_string = None
        self.recommendations = None


class ResourceHealthDetails(Model):
    """Health Details for backup items.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Health Code
    :vartype code: int
    :ivar title: Health Title
    :vartype title: str
    :ivar message: Health Message
    :vartype message: str
    :ivar recommendations: Health Recommended Actions
    :vartype recommendations: list[str]
    """

    _validation = {
        'code': {'readonly': True},
        'title': {'readonly': True},
        'message': {'readonly': True},
        'recommendations': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'int'},
        'title': {'key': 'title', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ResourceHealthDetails, self).__init__(**kwargs)
        self.code = None
        self.title = None
        self.message = None
        self.recommendations = None


class AzureIaaSVMHealthDetails(ResourceHealthDetails):
    """Azure IaaS VM workload-specific Health Details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Health Code
    :vartype code: int
    :ivar title: Health Title
    :vartype title: str
    :ivar message: Health Message
    :vartype message: str
    :ivar recommendations: Health Recommended Actions
    :vartype recommendations: list[str]
    """

    _validation = {
        'code': {'readonly': True},
        'title': {'readonly': True},
        'message': {'readonly': True},
        'recommendations': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'int'},
        'title': {'key': 'title', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureIaaSVMHealthDetails, self).__init__(**kwargs)


class Job(Model):
    """Defines workload agnostic properties for a job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureIaaSVMJob, AzureStorageJob, AzureWorkloadJob, DpmJob,
    MabJob, VaultJob

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
    }

    _subtype_map = {
        'job_type': {'AzureIaaSVMJob': 'AzureIaaSVMJob', 'AzureStorageJob': 'AzureStorageJob', 'AzureWorkloadJob': 'AzureWorkloadJob', 'DpmJob': 'DpmJob', 'MabJob': 'MabJob', 'VaultJob': 'VaultJob'}
    }

    def __init__(self, *, entity_friendly_name: str=None, backup_management_type=None, operation: str=None, status: str=None, start_time=None, end_time=None, activity_id: str=None, **kwargs) -> None:
        super(Job, self).__init__(**kwargs)
        self.entity_friendly_name = entity_friendly_name
        self.backup_management_type = backup_management_type
        self.operation = operation
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.activity_id = activity_id
        self.job_type = None


class AzureIaaSVMJob(Job):
    """Azure IaaS VM workload-specific job object.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param duration: Time elapsed during the execution of this job.
    :type duration: timedelta
    :param actions_info: Gets or sets the state/actions applicable on this job
     like cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param error_details: Error details on execution of this job.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMErrorInfo]
    :param virtual_machine_version: Specifies whether the backup item is a
     Classic or an Azure Resource Manager VM.
    :type virtual_machine_version: str
    :param extended_info: Additional information for this job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'error_details': {'key': 'errorDetails', 'type': '[AzureIaaSVMErrorInfo]'},
        'virtual_machine_version': {'key': 'virtualMachineVersion', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureIaaSVMJobExtendedInfo'},
    }

    def __init__(self, *, entity_friendly_name: str=None, backup_management_type=None, operation: str=None, status: str=None, start_time=None, end_time=None, activity_id: str=None, duration=None, actions_info=None, error_details=None, virtual_machine_version: str=None, extended_info=None, **kwargs) -> None:
        super(AzureIaaSVMJob, self).__init__(entity_friendly_name=entity_friendly_name, backup_management_type=backup_management_type, operation=operation, status=status, start_time=start_time, end_time=end_time, activity_id=activity_id, **kwargs)
        self.duration = duration
        self.actions_info = actions_info
        self.error_details = error_details
        self.virtual_machine_version = virtual_machine_version
        self.extended_info = extended_info
        self.job_type = 'AzureIaaSVMJob'


class AzureIaaSVMJobExtendedInfo(Model):
    """Azure IaaS VM workload-specific additional information for job.

    :param tasks_list: List of tasks associated with this job.
    :type tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMJobTaskDetails]
    :param property_bag: Job properties.
    :type property_bag: dict[str, str]
    :param internal_property_bag: Job internal properties.
    :type internal_property_bag: dict[str, str]
    :param progress_percentage: Indicates progress of the job. Null if it has
     not started or completed.
    :type progress_percentage: float
    :param estimated_remaining_duration: Time remaining for execution of this
     job.
    :type estimated_remaining_duration: str
    :param dynamic_error_message: Non localized error message on job
     execution.
    :type dynamic_error_message: str
    """

    _attribute_map = {
        'tasks_list': {'key': 'tasksList', 'type': '[AzureIaaSVMJobTaskDetails]'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'internal_property_bag': {'key': 'internalPropertyBag', 'type': '{str}'},
        'progress_percentage': {'key': 'progressPercentage', 'type': 'float'},
        'estimated_remaining_duration': {'key': 'estimatedRemainingDuration', 'type': 'str'},
        'dynamic_error_message': {'key': 'dynamicErrorMessage', 'type': 'str'},
    }

    def __init__(self, *, tasks_list=None, property_bag=None, internal_property_bag=None, progress_percentage: float=None, estimated_remaining_duration: str=None, dynamic_error_message: str=None, **kwargs) -> None:
        super(AzureIaaSVMJobExtendedInfo, self).__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.internal_property_bag = internal_property_bag
        self.progress_percentage = progress_percentage
        self.estimated_remaining_duration = estimated_remaining_duration
        self.dynamic_error_message = dynamic_error_message


class AzureIaaSVMJobTaskDetails(Model):
    """Azure IaaS VM workload-specific job task details.

    :param task_id: The task display name.
    :type task_id: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param instance_id: The instanceId.
    :type instance_id: str
    :param duration: Time elapsed for task.
    :type duration: timedelta
    :param status: The status.
    :type status: str
    :param progress_percentage: Progress of the task.
    :type progress_percentage: float
    :param task_execution_details: Details about execution of the task.
     eg: number of bytes transferred etc
    :type task_execution_details: str
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'status': {'key': 'status', 'type': 'str'},
        'progress_percentage': {'key': 'progressPercentage', 'type': 'float'},
        'task_execution_details': {'key': 'taskExecutionDetails', 'type': 'str'},
    }

    def __init__(self, *, task_id: str=None, start_time=None, end_time=None, instance_id: str=None, duration=None, status: str=None, progress_percentage: float=None, task_execution_details: str=None, **kwargs) -> None:
        super(AzureIaaSVMJobTaskDetails, self).__init__(**kwargs)
        self.task_id = task_id
        self.start_time = start_time
        self.end_time = end_time
        self.instance_id = instance_id
        self.duration = duration
        self.status = status
        self.progress_percentage = progress_percentage
        self.task_execution_details = task_execution_details


class AzureIaaSVMProtectedItemExtendedInfo(Model):
    """Additional information on Azure IaaS VM specific backup item.

    :param oldest_recovery_point: The oldest backup copy available for this
     backup item.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: Number of backup copies available for this
     backup item.
    :type recovery_point_count: int
    :param policy_inconsistent: Specifies if backup policy associated with the
     backup item is inconsistent.
    :type policy_inconsistent: bool
    """

    _attribute_map = {
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'policy_inconsistent': {'key': 'policyInconsistent', 'type': 'bool'},
    }

    def __init__(self, *, oldest_recovery_point=None, recovery_point_count: int=None, policy_inconsistent: bool=None, **kwargs) -> None:
        super(AzureIaaSVMProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.policy_inconsistent = policy_inconsistent


class AzureIaaSVMProtectionPolicy(ProtectionPolicy):
    """IaaS VM workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param instant_rp_details:
    :type instant_rp_details:
     ~azure.mgmt.recoveryservicesbackup.models.InstantRPAdditionalDetails
    :param schedule_policy: Backup schedule specified as part of backup
     policy.
    :type schedule_policy:
     ~azure.mgmt.recoveryservicesbackup.models.SchedulePolicy
    :param retention_policy: Retention policy with the details on backup copy
     retention ranges.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    :param instant_rp_retention_range_in_days: Instant RP retention policy
     range in days
    :type instant_rp_retention_range_in_days: int
    :param time_zone: TimeZone optional input as string. For example: TimeZone
     = "Pacific Standard Time".
    :type time_zone: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'instant_rp_details': {'key': 'instantRPDetails', 'type': 'InstantRPAdditionalDetails'},
        'schedule_policy': {'key': 'schedulePolicy', 'type': 'SchedulePolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
        'instant_rp_retention_range_in_days': {'key': 'instantRpRetentionRangeInDays', 'type': 'int'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
    }

    def __init__(self, *, protected_items_count: int=None, instant_rp_details=None, schedule_policy=None, retention_policy=None, instant_rp_retention_range_in_days: int=None, time_zone: str=None, **kwargs) -> None:
        super(AzureIaaSVMProtectionPolicy, self).__init__(protected_items_count=protected_items_count, **kwargs)
        self.instant_rp_details = instant_rp_details
        self.schedule_policy = schedule_policy
        self.retention_policy = retention_policy
        self.instant_rp_retention_range_in_days = instant_rp_retention_range_in_days
        self.time_zone = time_zone
        self.backup_management_type = 'AzureIaasVM'


class ProtectionIntent(Model):
    """Base class for backup ProtectionIntent.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureRecoveryServiceVaultProtectionIntent,
    AzureResourceProtectionIntent

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param item_id: ID of the item which is getting protected, In case of
     Azure Vm , it is ProtectedItemId
    :type item_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protection_intent_item_type: Required. Constant filled by server.
    :type protection_intent_item_type: str
    """

    _validation = {
        'protection_intent_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_intent_item_type': {'key': 'protectionIntentItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protection_intent_item_type': {'RecoveryServiceVaultItem': 'AzureRecoveryServiceVaultProtectionIntent', 'AzureResourceItem': 'AzureResourceProtectionIntent'}
    }

    def __init__(self, *, backup_management_type=None, source_resource_id: str=None, item_id: str=None, policy_id: str=None, protection_state=None, **kwargs) -> None:
        super(ProtectionIntent, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.source_resource_id = source_resource_id
        self.item_id = item_id
        self.policy_id = policy_id
        self.protection_state = protection_state
        self.protection_intent_item_type = None


class AzureRecoveryServiceVaultProtectionIntent(ProtectionIntent):
    """Azure Recovery Services Vault specific protection intent item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadAutoProtectionIntent

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param item_id: ID of the item which is getting protected, In case of
     Azure Vm , it is ProtectedItemId
    :type item_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protection_intent_item_type: Required. Constant filled by server.
    :type protection_intent_item_type: str
    """

    _validation = {
        'protection_intent_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_intent_item_type': {'key': 'protectionIntentItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protection_intent_item_type': {'AzureWorkloadAutoProtectionIntent': 'AzureWorkloadAutoProtectionIntent'}
    }

    def __init__(self, *, backup_management_type=None, source_resource_id: str=None, item_id: str=None, policy_id: str=None, protection_state=None, **kwargs) -> None:
        super(AzureRecoveryServiceVaultProtectionIntent, self).__init__(backup_management_type=backup_management_type, source_resource_id=source_resource_id, item_id=item_id, policy_id=policy_id, protection_state=protection_state, **kwargs)
        self.protection_intent_item_type = 'RecoveryServiceVaultItem'


class AzureResourceProtectionIntent(ProtectionIntent):
    """IaaS VM specific backup protection intent item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param item_id: ID of the item which is getting protected, In case of
     Azure Vm , it is ProtectedItemId
    :type item_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protection_intent_item_type: Required. Constant filled by server.
    :type protection_intent_item_type: str
    :param friendly_name: Friendly name of the VM represented by this backup
     item.
    :type friendly_name: str
    """

    _validation = {
        'protection_intent_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_intent_item_type': {'key': 'protectionIntentItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, source_resource_id: str=None, item_id: str=None, policy_id: str=None, protection_state=None, friendly_name: str=None, **kwargs) -> None:
        super(AzureResourceProtectionIntent, self).__init__(backup_management_type=backup_management_type, source_resource_id=source_resource_id, item_id=item_id, policy_id=policy_id, protection_state=protection_state, **kwargs)
        self.friendly_name = friendly_name
        self.protection_intent_item_type = 'AzureResourceItem'


class AzureWorkloadContainer(ProtectionContainer):
    """Container for the workloads running inside Azure Compute or Classic
    Compute.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureSQLAGWorkloadContainerProtectionContainer,
    AzureVMAppContainerProtectionContainer

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param source_resource_id: ARM ID of the virtual machine represented by
     this Azure Workload Container
    :type source_resource_id: str
    :param last_updated_time: Time stamp when this container was updated.
    :type last_updated_time: datetime
    :param extended_info: Additional details of a workload container.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadContainerExtendedInfo
    :param workload_type: Workload type for which registration was sent.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param operation_type: Re-Do Operation. Possible values include:
     'Invalid', 'Register', 'Reregister'
    :type operation_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.OperationType
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadContainerExtendedInfo'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'str'},
    }

    _subtype_map = {
        'container_type': {'SQLAGWorkLoadContainer': 'AzureSQLAGWorkloadContainerProtectionContainer', 'VMAppContainer': 'AzureVMAppContainerProtectionContainer'}
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, source_resource_id: str=None, last_updated_time=None, extended_info=None, workload_type=None, operation_type=None, **kwargs) -> None:
        super(AzureWorkloadContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, **kwargs)
        self.source_resource_id = source_resource_id
        self.last_updated_time = last_updated_time
        self.extended_info = extended_info
        self.workload_type = workload_type
        self.operation_type = operation_type
        self.container_type = 'AzureWorkloadContainer'


class AzureSQLAGWorkloadContainerProtectionContainer(AzureWorkloadContainer):
    """Container for SQL workloads under SQL Availability Group.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param source_resource_id: ARM ID of the virtual machine represented by
     this Azure Workload Container
    :type source_resource_id: str
    :param last_updated_time: Time stamp when this container was updated.
    :type last_updated_time: datetime
    :param extended_info: Additional details of a workload container.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadContainerExtendedInfo
    :param workload_type: Workload type for which registration was sent.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param operation_type: Re-Do Operation. Possible values include:
     'Invalid', 'Register', 'Reregister'
    :type operation_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.OperationType
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadContainerExtendedInfo'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, source_resource_id: str=None, last_updated_time=None, extended_info=None, workload_type=None, operation_type=None, **kwargs) -> None:
        super(AzureSQLAGWorkloadContainerProtectionContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, source_resource_id=source_resource_id, last_updated_time=last_updated_time, extended_info=extended_info, workload_type=workload_type, operation_type=operation_type, **kwargs)
        self.container_type = 'SQLAGWorkLoadContainer'


class AzureSqlContainer(ProtectionContainer):
    """Azure Sql workload-specific container.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, **kwargs) -> None:
        super(AzureSqlContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, **kwargs)
        self.container_type = 'AzureSqlContainer'


class AzureSqlProtectedItem(ProtectedItem):
    """Azure SQL workload-specific backup item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param protected_item_data_id: Internal ID of a backup item. Used by Azure
     SQL Backup engine to contact Recovery Services.
    :type protected_item_data_id: str
    :param protection_state: Backup state of the backed up item. Possible
     values include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemState
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureSqlProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'protected_item_data_id': {'key': 'protectedItemDataId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureSqlProtectedItemExtendedInfo'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, protected_item_data_id: str=None, protection_state=None, extended_info=None, **kwargs) -> None:
        super(AzureSqlProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, **kwargs)
        self.protected_item_data_id = protected_item_data_id
        self.protection_state = protection_state
        self.extended_info = extended_info
        self.protected_item_type = 'Microsoft.Sql/servers/databases'


class AzureSqlProtectedItemExtendedInfo(Model):
    """Additional information on Azure Sql specific protected item.

    :param oldest_recovery_point: The oldest backup copy available for this
     item in the service.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: Number of available backup copies associated
     with this backup item.
    :type recovery_point_count: int
    :param policy_state: State of the backup policy associated with this
     backup item.
    :type policy_state: str
    """

    _attribute_map = {
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'policy_state': {'key': 'policyState', 'type': 'str'},
    }

    def __init__(self, *, oldest_recovery_point=None, recovery_point_count: int=None, policy_state: str=None, **kwargs) -> None:
        super(AzureSqlProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.policy_state = policy_state


class AzureSqlProtectionPolicy(ProtectionPolicy):
    """Azure SQL workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param retention_policy: Retention policy details.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, *, protected_items_count: int=None, retention_policy=None, **kwargs) -> None:
        super(AzureSqlProtectionPolicy, self).__init__(protected_items_count=protected_items_count, **kwargs)
        self.retention_policy = retention_policy
        self.backup_management_type = 'AzureSql'


class AzureStorageContainer(ProtectionContainer):
    """Azure Storage Account workload-specific container.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param source_resource_id: Fully qualified ARM url.
    :type source_resource_id: str
    :param storage_account_version: Storage account version.
    :type storage_account_version: str
    :param resource_group: Resource group name of Recovery Services Vault.
    :type resource_group: str
    :param protected_item_count: Number of items backed up in this container.
    :type protected_item_count: long
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'storage_account_version': {'key': 'storageAccountVersion', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'long'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, source_resource_id: str=None, storage_account_version: str=None, resource_group: str=None, protected_item_count: int=None, **kwargs) -> None:
        super(AzureStorageContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, **kwargs)
        self.source_resource_id = source_resource_id
        self.storage_account_version = storage_account_version
        self.resource_group = resource_group
        self.protected_item_count = protected_item_count
        self.container_type = 'StorageContainer'


class AzureStorageErrorInfo(Model):
    """Azure storage specific error information.

    :param error_code: Error code.
    :type error_code: int
    :param error_string: Localized error string.
    :type error_string: str
    :param recommendations: List of localized recommendations for above error
     code.
    :type recommendations: list[str]
    """

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'error_string': {'key': 'errorString', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, *, error_code: int=None, error_string: str=None, recommendations=None, **kwargs) -> None:
        super(AzureStorageErrorInfo, self).__init__(**kwargs)
        self.error_code = error_code
        self.error_string = error_string
        self.recommendations = recommendations


class AzureStorageJob(Job):
    """Azure storage specific job.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param duration: Time elapsed during the execution of this job.
    :type duration: timedelta
    :param actions_info: Gets or sets the state/actions applicable on this job
     like cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param error_details: Error details on execution of this job.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureStorageErrorInfo]
    :param storage_account_name: Specifies friendly name of the storage
     account.
    :type storage_account_name: str
    :param storage_account_version: Specifies whether the Storage account is a
     Classic or an Azure Resource Manager Storage account.
    :type storage_account_version: str
    :param extended_info: Additional information about the job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureStorageJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'error_details': {'key': 'errorDetails', 'type': '[AzureStorageErrorInfo]'},
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
        'storage_account_version': {'key': 'storageAccountVersion', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureStorageJobExtendedInfo'},
    }

    def __init__(self, *, entity_friendly_name: str=None, backup_management_type=None, operation: str=None, status: str=None, start_time=None, end_time=None, activity_id: str=None, duration=None, actions_info=None, error_details=None, storage_account_name: str=None, storage_account_version: str=None, extended_info=None, **kwargs) -> None:
        super(AzureStorageJob, self).__init__(entity_friendly_name=entity_friendly_name, backup_management_type=backup_management_type, operation=operation, status=status, start_time=start_time, end_time=end_time, activity_id=activity_id, **kwargs)
        self.duration = duration
        self.actions_info = actions_info
        self.error_details = error_details
        self.storage_account_name = storage_account_name
        self.storage_account_version = storage_account_version
        self.extended_info = extended_info
        self.job_type = 'AzureStorageJob'


class AzureStorageJobExtendedInfo(Model):
    """Azure Storage workload-specific additional information for job.

    :param tasks_list: List of tasks for this job
    :type tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureStorageJobTaskDetails]
    :param property_bag: Job properties.
    :type property_bag: dict[str, str]
    :param dynamic_error_message: Non localized error message on job
     execution.
    :type dynamic_error_message: str
    """

    _attribute_map = {
        'tasks_list': {'key': 'tasksList', 'type': '[AzureStorageJobTaskDetails]'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'dynamic_error_message': {'key': 'dynamicErrorMessage', 'type': 'str'},
    }

    def __init__(self, *, tasks_list=None, property_bag=None, dynamic_error_message: str=None, **kwargs) -> None:
        super(AzureStorageJobExtendedInfo, self).__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class AzureStorageJobTaskDetails(Model):
    """Azure storage workload specific job task details.

    :param task_id: The task display name.
    :type task_id: str
    :param status: The status.
    :type status: str
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, task_id: str=None, status: str=None, **kwargs) -> None:
        super(AzureStorageJobTaskDetails, self).__init__(**kwargs)
        self.task_id = task_id
        self.status = status


class ProtectableContainer(Model):
    """Protectable Container Class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureStorageProtectableContainer,
    AzureVMAppContainerProtectableContainer

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_id: Fabric Id of the container such as ARM Id.
    :type container_id: str
    :param protectable_container_type: Required. Constant filled by server.
    :type protectable_container_type: str
    """

    _validation = {
        'protectable_container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'protectable_container_type': {'key': 'protectableContainerType', 'type': 'str'},
    }

    _subtype_map = {
        'protectable_container_type': {'StorageContainer': 'AzureStorageProtectableContainer', 'VMAppContainer': 'AzureVMAppContainerProtectableContainer'}
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, health_status: str=None, container_id: str=None, **kwargs) -> None:
        super(ProtectableContainer, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.backup_management_type = backup_management_type
        self.health_status = health_status
        self.container_id = container_id
        self.protectable_container_type = None


class AzureStorageProtectableContainer(ProtectableContainer):
    """Azure Storage-specific protectable containers.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_id: Fabric Id of the container such as ARM Id.
    :type container_id: str
    :param protectable_container_type: Required. Constant filled by server.
    :type protectable_container_type: str
    """

    _validation = {
        'protectable_container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'protectable_container_type': {'key': 'protectableContainerType', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, health_status: str=None, container_id: str=None, **kwargs) -> None:
        super(AzureStorageProtectableContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, health_status=health_status, container_id=container_id, **kwargs)
        self.protectable_container_type = 'StorageContainer'


class AzureVMAppContainerProtectableContainer(ProtectableContainer):
    """Azure workload-specific container.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_id: Fabric Id of the container such as ARM Id.
    :type container_id: str
    :param protectable_container_type: Required. Constant filled by server.
    :type protectable_container_type: str
    """

    _validation = {
        'protectable_container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'protectable_container_type': {'key': 'protectableContainerType', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, health_status: str=None, container_id: str=None, **kwargs) -> None:
        super(AzureVMAppContainerProtectableContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, health_status=health_status, container_id=container_id, **kwargs)
        self.protectable_container_type = 'VMAppContainer'


class AzureVMAppContainerProtectionContainer(AzureWorkloadContainer):
    """Container for SQL workloads under Azure Virtual Machines.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param source_resource_id: ARM ID of the virtual machine represented by
     this Azure Workload Container
    :type source_resource_id: str
    :param last_updated_time: Time stamp when this container was updated.
    :type last_updated_time: datetime
    :param extended_info: Additional details of a workload container.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadContainerExtendedInfo
    :param workload_type: Workload type for which registration was sent.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param operation_type: Re-Do Operation. Possible values include:
     'Invalid', 'Register', 'Reregister'
    :type operation_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.OperationType
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadContainerExtendedInfo'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, source_resource_id: str=None, last_updated_time=None, extended_info=None, workload_type=None, operation_type=None, **kwargs) -> None:
        super(AzureVMAppContainerProtectionContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, source_resource_id=source_resource_id, last_updated_time=last_updated_time, extended_info=extended_info, workload_type=workload_type, operation_type=operation_type, **kwargs)
        self.container_type = 'VMAppContainer'


class AzureVMResourceFeatureSupportRequest(FeatureSupportRequest):
    """AzureResource(IaaS VM) Specific feature support request.

    All required parameters must be populated in order to send to Azure.

    :param feature_type: Required. Constant filled by server.
    :type feature_type: str
    :param vm_size: Size of the resource: VM size(A/D series etc) in case of
     IaasVM
    :type vm_size: str
    :param vm_sku: SKUs (Premium/Managed etc) in case of IaasVM
    :type vm_sku: str
    """

    _validation = {
        'feature_type': {'required': True},
    }

    _attribute_map = {
        'feature_type': {'key': 'featureType', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'vm_sku': {'key': 'vmSku', 'type': 'str'},
    }

    def __init__(self, *, vm_size: str=None, vm_sku: str=None, **kwargs) -> None:
        super(AzureVMResourceFeatureSupportRequest, self).__init__(**kwargs)
        self.vm_size = vm_size
        self.vm_sku = vm_sku
        self.feature_type = 'AzureVMResourceBackup'


class AzureVMResourceFeatureSupportResponse(Model):
    """Response for feature support requests for Azure IaasVm.

    :param support_status: Support status of feature. Possible values include:
     'Invalid', 'Supported', 'DefaultOFF', 'DefaultON', 'NotSupported'
    :type support_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.SupportStatus
    """

    _attribute_map = {
        'support_status': {'key': 'supportStatus', 'type': 'str'},
    }

    def __init__(self, *, support_status=None, **kwargs) -> None:
        super(AzureVMResourceFeatureSupportResponse, self).__init__(**kwargs)
        self.support_status = support_status


class WorkloadItem(Model):
    """Base class for backup item. Workload-specific backup items are derived from
    this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureVmWorkloadItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
    }

    _subtype_map = {
        'workload_item_type': {'AzureVmWorkloadItem': 'AzureVmWorkloadItem'}
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, **kwargs) -> None:
        super(WorkloadItem, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_type = workload_type
        self.friendly_name = friendly_name
        self.protection_state = protection_state
        self.workload_item_type = None


class AzureVmWorkloadItem(WorkloadItem):
    """Azure VM workload-specific workload item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureVmWorkloadSAPAseDatabaseWorkloadItem,
    AzureVmWorkloadSAPAseSystemWorkloadItem,
    AzureVmWorkloadSAPHanaDatabaseWorkloadItem,
    AzureVmWorkloadSAPHanaSystemWorkloadItem,
    AzureVmWorkloadSQLDatabaseWorkloadItem,
    AzureVmWorkloadSQLInstanceWorkloadItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    _subtype_map = {
        'workload_item_type': {'SAPAseDatabase': 'AzureVmWorkloadSAPAseDatabaseWorkloadItem', 'SAPAseSystem': 'AzureVmWorkloadSAPAseSystemWorkloadItem', 'SAPHanaDatabase': 'AzureVmWorkloadSAPHanaDatabaseWorkloadItem', 'SAPHanaSystem': 'AzureVmWorkloadSAPHanaSystemWorkloadItem', 'SQLDataBase': 'AzureVmWorkloadSQLDatabaseWorkloadItem', 'SQLInstance': 'AzureVmWorkloadSQLInstanceWorkloadItem'}
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, server_name: str=None, is_auto_protectable: bool=None, subinquireditemcount: int=None, sub_workload_item_count: int=None, **kwargs) -> None:
        super(AzureVmWorkloadItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, **kwargs)
        self.parent_name = parent_name
        self.server_name = server_name
        self.is_auto_protectable = is_auto_protectable
        self.subinquireditemcount = subinquireditemcount
        self.sub_workload_item_count = sub_workload_item_count
        self.workload_item_type = 'AzureVmWorkloadItem'


class AzureVmWorkloadProtectableItem(WorkloadProtectableItem):
    """Azure VM workload-specific protectable item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureVmWorkloadSAPAseSystemProtectableItem,
    AzureVmWorkloadSAPHanaDatabaseProtectableItem,
    AzureVmWorkloadSAPHanaSystemProtectableItem,
    AzureVmWorkloadSQLAvailabilityGroupProtectableItem,
    AzureVmWorkloadSQLDatabaseProtectableItem,
    AzureVmWorkloadSQLInstanceProtectableItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    _subtype_map = {
        'protectable_item_type': {'SAPAseSystem': 'AzureVmWorkloadSAPAseSystemProtectableItem', 'SAPHanaDatabase': 'AzureVmWorkloadSAPHanaDatabaseProtectableItem', 'SAPHanaSystem': 'AzureVmWorkloadSAPHanaSystemProtectableItem', 'SQLAvailabilityGroupContainer': 'AzureVmWorkloadSQLAvailabilityGroupProtectableItem', 'SQLDataBase': 'AzureVmWorkloadSQLDatabaseProtectableItem', 'SQLInstance': 'AzureVmWorkloadSQLInstanceProtectableItem'}
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, parent_unique_name: str=None, server_name: str=None, is_auto_protectable: bool=None, is_auto_protected: bool=None, subinquireditemcount: int=None, subprotectableitemcount: int=None, prebackupvalidation=None, **kwargs) -> None:
        super(AzureVmWorkloadProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, **kwargs)
        self.parent_name = parent_name
        self.parent_unique_name = parent_unique_name
        self.server_name = server_name
        self.is_auto_protectable = is_auto_protectable
        self.is_auto_protected = is_auto_protected
        self.subinquireditemcount = subinquireditemcount
        self.subprotectableitemcount = subprotectableitemcount
        self.prebackupvalidation = prebackupvalidation
        self.protectable_item_type = 'AzureVmWorkloadProtectableItem'


class AzureVmWorkloadProtectedItem(ProtectedItem):
    """Azure VM workload-specific protected item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureVmWorkloadSAPAseDatabaseProtectedItem,
    AzureVmWorkloadSAPHanaDatabaseProtectedItem,
    AzureVmWorkloadSQLDatabaseProtectedItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the DB represented by this backup
     item.
    :type friendly_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param parent_name: Parent name of the DB such as Instance or Availability
     Group.
    :type parent_name: str
    :param parent_type: Parent type of protected item, example: for a DB,
     standalone server or distributed
    :type parent_type: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param last_backup_status: Last backup operation status. Possible values:
     Healthy, Unhealthy. Possible values include: 'Invalid', 'Healthy',
     'Unhealthy', 'IRPending'
    :type last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.LastBackupStatus
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param last_backup_error_detail: Error details in last backup
    :type last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param protected_item_data_source_id: Data ID of the protected item.
    :type protected_item_data_source_id: str
    :param protected_item_health_status: Health status of the backup item,
     evaluated based on last heartbeat received. Possible values include:
     'Invalid', 'Healthy', 'Unhealthy', 'NotReachable', 'IRPending'
    :type protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemHealthStatus
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureVmWorkloadProtectedItemExtendedInfo
    :param kpis_healths: Health details of different KPIs
    :type kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.KPIResourceHealthDetails]
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_type': {'key': 'parentType', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'last_backup_error_detail': {'key': 'lastBackupErrorDetail', 'type': 'ErrorDetail'},
        'protected_item_data_source_id': {'key': 'protectedItemDataSourceId', 'type': 'str'},
        'protected_item_health_status': {'key': 'protectedItemHealthStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureVmWorkloadProtectedItemExtendedInfo'},
        'kpis_healths': {'key': 'kpisHealths', 'type': '{KPIResourceHealthDetails}'},
    }

    _subtype_map = {
        'protected_item_type': {'AzureVmWorkloadSAPAseDatabase': 'AzureVmWorkloadSAPAseDatabaseProtectedItem', 'AzureVmWorkloadSAPHanaDatabase': 'AzureVmWorkloadSAPHanaDatabaseProtectedItem', 'AzureVmWorkloadSQLDatabase': 'AzureVmWorkloadSQLDatabaseProtectedItem'}
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, server_name: str=None, parent_name: str=None, parent_type: str=None, protection_status: str=None, protection_state=None, last_backup_status=None, last_backup_time=None, last_backup_error_detail=None, protected_item_data_source_id: str=None, protected_item_health_status=None, extended_info=None, kpis_healths=None, **kwargs) -> None:
        super(AzureVmWorkloadProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, **kwargs)
        self.friendly_name = friendly_name
        self.server_name = server_name
        self.parent_name = parent_name
        self.parent_type = parent_type
        self.protection_status = protection_status
        self.protection_state = protection_state
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.last_backup_error_detail = last_backup_error_detail
        self.protected_item_data_source_id = protected_item_data_source_id
        self.protected_item_health_status = protected_item_health_status
        self.extended_info = extended_info
        self.kpis_healths = kpis_healths
        self.protected_item_type = 'AzureVmWorkloadProtectedItem'


class AzureVmWorkloadProtectedItemExtendedInfo(Model):
    """Additional information on Azure Workload for SQL specific backup item.

    :param oldest_recovery_point: The oldest backup copy available for this
     backup item.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: Number of backup copies available for this
     backup item.
    :type recovery_point_count: int
    :param policy_state: Indicates consistency of policy object and policy
     applied to this backup item.
    :type policy_state: str
    """

    _attribute_map = {
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'policy_state': {'key': 'policyState', 'type': 'str'},
    }

    def __init__(self, *, oldest_recovery_point=None, recovery_point_count: int=None, policy_state: str=None, **kwargs) -> None:
        super(AzureVmWorkloadProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.policy_state = policy_state


class AzureVmWorkloadProtectionPolicy(ProtectionPolicy):
    """Azure VM (Mercury) workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param work_load_type: Type of workload for the backup management.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type work_load_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param settings: Common settings for the backup management
    :type settings: ~azure.mgmt.recoveryservicesbackup.models.Settings
    :param sub_protection_policy: List of sub-protection policies which
     includes schedule and retention
    :type sub_protection_policy:
     list[~azure.mgmt.recoveryservicesbackup.models.SubProtectionPolicy]
    :param make_policy_consistent: Fix the policy inconsistency
    :type make_policy_consistent: bool
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'work_load_type': {'key': 'workLoadType', 'type': 'str'},
        'settings': {'key': 'settings', 'type': 'Settings'},
        'sub_protection_policy': {'key': 'subProtectionPolicy', 'type': '[SubProtectionPolicy]'},
        'make_policy_consistent': {'key': 'makePolicyConsistent', 'type': 'bool'},
    }

    def __init__(self, *, protected_items_count: int=None, work_load_type=None, settings=None, sub_protection_policy=None, make_policy_consistent: bool=None, **kwargs) -> None:
        super(AzureVmWorkloadProtectionPolicy, self).__init__(protected_items_count=protected_items_count, **kwargs)
        self.work_load_type = work_load_type
        self.settings = settings
        self.sub_protection_policy = sub_protection_policy
        self.make_policy_consistent = make_policy_consistent
        self.backup_management_type = 'AzureWorkload'


class AzureVmWorkloadSAPAseDatabaseProtectedItem(AzureVmWorkloadProtectedItem):
    """Azure VM workload-specific protected item representing SAP ASE Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the DB represented by this backup
     item.
    :type friendly_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param parent_name: Parent name of the DB such as Instance or Availability
     Group.
    :type parent_name: str
    :param parent_type: Parent type of protected item, example: for a DB,
     standalone server or distributed
    :type parent_type: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param last_backup_status: Last backup operation status. Possible values:
     Healthy, Unhealthy. Possible values include: 'Invalid', 'Healthy',
     'Unhealthy', 'IRPending'
    :type last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.LastBackupStatus
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param last_backup_error_detail: Error details in last backup
    :type last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param protected_item_data_source_id: Data ID of the protected item.
    :type protected_item_data_source_id: str
    :param protected_item_health_status: Health status of the backup item,
     evaluated based on last heartbeat received. Possible values include:
     'Invalid', 'Healthy', 'Unhealthy', 'NotReachable', 'IRPending'
    :type protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemHealthStatus
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureVmWorkloadProtectedItemExtendedInfo
    :param kpis_healths: Health details of different KPIs
    :type kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.KPIResourceHealthDetails]
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_type': {'key': 'parentType', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'last_backup_error_detail': {'key': 'lastBackupErrorDetail', 'type': 'ErrorDetail'},
        'protected_item_data_source_id': {'key': 'protectedItemDataSourceId', 'type': 'str'},
        'protected_item_health_status': {'key': 'protectedItemHealthStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureVmWorkloadProtectedItemExtendedInfo'},
        'kpis_healths': {'key': 'kpisHealths', 'type': '{KPIResourceHealthDetails}'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, server_name: str=None, parent_name: str=None, parent_type: str=None, protection_status: str=None, protection_state=None, last_backup_status=None, last_backup_time=None, last_backup_error_detail=None, protected_item_data_source_id: str=None, protected_item_health_status=None, extended_info=None, kpis_healths=None, **kwargs) -> None:
        super(AzureVmWorkloadSAPAseDatabaseProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, friendly_name=friendly_name, server_name=server_name, parent_name=parent_name, parent_type=parent_type, protection_status=protection_status, protection_state=protection_state, last_backup_status=last_backup_status, last_backup_time=last_backup_time, last_backup_error_detail=last_backup_error_detail, protected_item_data_source_id=protected_item_data_source_id, protected_item_health_status=protected_item_health_status, extended_info=extended_info, kpis_healths=kpis_healths, **kwargs)
        self.protected_item_type = 'AzureVmWorkloadSAPAseDatabase'


class AzureVmWorkloadSAPAseDatabaseWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP ASE Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, server_name: str=None, is_auto_protectable: bool=None, subinquireditemcount: int=None, sub_workload_item_count: int=None, **kwargs) -> None:
        super(AzureVmWorkloadSAPAseDatabaseWorkloadItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, server_name=server_name, is_auto_protectable=is_auto_protectable, subinquireditemcount=subinquireditemcount, sub_workload_item_count=sub_workload_item_count, **kwargs)
        self.workload_item_type = 'SAPAseDatabase'


class AzureVmWorkloadSAPAseSystemProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SAP ASE System.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, parent_unique_name: str=None, server_name: str=None, is_auto_protectable: bool=None, is_auto_protected: bool=None, subinquireditemcount: int=None, subprotectableitemcount: int=None, prebackupvalidation=None, **kwargs) -> None:
        super(AzureVmWorkloadSAPAseSystemProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, parent_unique_name=parent_unique_name, server_name=server_name, is_auto_protectable=is_auto_protectable, is_auto_protected=is_auto_protected, subinquireditemcount=subinquireditemcount, subprotectableitemcount=subprotectableitemcount, prebackupvalidation=prebackupvalidation, **kwargs)
        self.protectable_item_type = 'SAPAseSystem'


class AzureVmWorkloadSAPAseSystemWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP ASE System.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, server_name: str=None, is_auto_protectable: bool=None, subinquireditemcount: int=None, sub_workload_item_count: int=None, **kwargs) -> None:
        super(AzureVmWorkloadSAPAseSystemWorkloadItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, server_name=server_name, is_auto_protectable=is_auto_protectable, subinquireditemcount=subinquireditemcount, sub_workload_item_count=sub_workload_item_count, **kwargs)
        self.workload_item_type = 'SAPAseSystem'


class AzureVmWorkloadSAPHanaDatabaseProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SAP HANA Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, parent_unique_name: str=None, server_name: str=None, is_auto_protectable: bool=None, is_auto_protected: bool=None, subinquireditemcount: int=None, subprotectableitemcount: int=None, prebackupvalidation=None, **kwargs) -> None:
        super(AzureVmWorkloadSAPHanaDatabaseProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, parent_unique_name=parent_unique_name, server_name=server_name, is_auto_protectable=is_auto_protectable, is_auto_protected=is_auto_protected, subinquireditemcount=subinquireditemcount, subprotectableitemcount=subprotectableitemcount, prebackupvalidation=prebackupvalidation, **kwargs)
        self.protectable_item_type = 'SAPHanaDatabase'


class AzureVmWorkloadSAPHanaDatabaseProtectedItem(AzureVmWorkloadProtectedItem):
    """Azure VM workload-specific protected item representing SAP HANA Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the DB represented by this backup
     item.
    :type friendly_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param parent_name: Parent name of the DB such as Instance or Availability
     Group.
    :type parent_name: str
    :param parent_type: Parent type of protected item, example: for a DB,
     standalone server or distributed
    :type parent_type: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param last_backup_status: Last backup operation status. Possible values:
     Healthy, Unhealthy. Possible values include: 'Invalid', 'Healthy',
     'Unhealthy', 'IRPending'
    :type last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.LastBackupStatus
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param last_backup_error_detail: Error details in last backup
    :type last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param protected_item_data_source_id: Data ID of the protected item.
    :type protected_item_data_source_id: str
    :param protected_item_health_status: Health status of the backup item,
     evaluated based on last heartbeat received. Possible values include:
     'Invalid', 'Healthy', 'Unhealthy', 'NotReachable', 'IRPending'
    :type protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemHealthStatus
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureVmWorkloadProtectedItemExtendedInfo
    :param kpis_healths: Health details of different KPIs
    :type kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.KPIResourceHealthDetails]
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_type': {'key': 'parentType', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'last_backup_error_detail': {'key': 'lastBackupErrorDetail', 'type': 'ErrorDetail'},
        'protected_item_data_source_id': {'key': 'protectedItemDataSourceId', 'type': 'str'},
        'protected_item_health_status': {'key': 'protectedItemHealthStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureVmWorkloadProtectedItemExtendedInfo'},
        'kpis_healths': {'key': 'kpisHealths', 'type': '{KPIResourceHealthDetails}'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, server_name: str=None, parent_name: str=None, parent_type: str=None, protection_status: str=None, protection_state=None, last_backup_status=None, last_backup_time=None, last_backup_error_detail=None, protected_item_data_source_id: str=None, protected_item_health_status=None, extended_info=None, kpis_healths=None, **kwargs) -> None:
        super(AzureVmWorkloadSAPHanaDatabaseProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, friendly_name=friendly_name, server_name=server_name, parent_name=parent_name, parent_type=parent_type, protection_status=protection_status, protection_state=protection_state, last_backup_status=last_backup_status, last_backup_time=last_backup_time, last_backup_error_detail=last_backup_error_detail, protected_item_data_source_id=protected_item_data_source_id, protected_item_health_status=protected_item_health_status, extended_info=extended_info, kpis_healths=kpis_healths, **kwargs)
        self.protected_item_type = 'AzureVmWorkloadSAPHanaDatabase'


class AzureVmWorkloadSAPHanaDatabaseWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP HANA Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, server_name: str=None, is_auto_protectable: bool=None, subinquireditemcount: int=None, sub_workload_item_count: int=None, **kwargs) -> None:
        super(AzureVmWorkloadSAPHanaDatabaseWorkloadItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, server_name=server_name, is_auto_protectable=is_auto_protectable, subinquireditemcount=subinquireditemcount, sub_workload_item_count=sub_workload_item_count, **kwargs)
        self.workload_item_type = 'SAPHanaDatabase'


class AzureVmWorkloadSAPHanaSystemProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SAP HANA System.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, parent_unique_name: str=None, server_name: str=None, is_auto_protectable: bool=None, is_auto_protected: bool=None, subinquireditemcount: int=None, subprotectableitemcount: int=None, prebackupvalidation=None, **kwargs) -> None:
        super(AzureVmWorkloadSAPHanaSystemProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, parent_unique_name=parent_unique_name, server_name=server_name, is_auto_protectable=is_auto_protectable, is_auto_protected=is_auto_protected, subinquireditemcount=subinquireditemcount, subprotectableitemcount=subprotectableitemcount, prebackupvalidation=prebackupvalidation, **kwargs)
        self.protectable_item_type = 'SAPHanaSystem'


class AzureVmWorkloadSAPHanaSystemWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP HANA System.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, server_name: str=None, is_auto_protectable: bool=None, subinquireditemcount: int=None, sub_workload_item_count: int=None, **kwargs) -> None:
        super(AzureVmWorkloadSAPHanaSystemWorkloadItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, server_name=server_name, is_auto_protectable=is_auto_protectable, subinquireditemcount=subinquireditemcount, sub_workload_item_count=sub_workload_item_count, **kwargs)
        self.workload_item_type = 'SAPHanaSystem'


class AzureVmWorkloadSQLAvailabilityGroupProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SQL Availability
    Group.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, parent_unique_name: str=None, server_name: str=None, is_auto_protectable: bool=None, is_auto_protected: bool=None, subinquireditemcount: int=None, subprotectableitemcount: int=None, prebackupvalidation=None, **kwargs) -> None:
        super(AzureVmWorkloadSQLAvailabilityGroupProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, parent_unique_name=parent_unique_name, server_name=server_name, is_auto_protectable=is_auto_protectable, is_auto_protected=is_auto_protected, subinquireditemcount=subinquireditemcount, subprotectableitemcount=subprotectableitemcount, prebackupvalidation=prebackupvalidation, **kwargs)
        self.protectable_item_type = 'SQLAvailabilityGroupContainer'


class AzureVmWorkloadSQLDatabaseProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SQL Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, parent_unique_name: str=None, server_name: str=None, is_auto_protectable: bool=None, is_auto_protected: bool=None, subinquireditemcount: int=None, subprotectableitemcount: int=None, prebackupvalidation=None, **kwargs) -> None:
        super(AzureVmWorkloadSQLDatabaseProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, parent_unique_name=parent_unique_name, server_name=server_name, is_auto_protectable=is_auto_protectable, is_auto_protected=is_auto_protected, subinquireditemcount=subinquireditemcount, subprotectableitemcount=subprotectableitemcount, prebackupvalidation=prebackupvalidation, **kwargs)
        self.protectable_item_type = 'SQLDataBase'


class AzureVmWorkloadSQLDatabaseProtectedItem(AzureVmWorkloadProtectedItem):
    """Azure VM workload-specific protected item representing SQL Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the DB represented by this backup
     item.
    :type friendly_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param parent_name: Parent name of the DB such as Instance or Availability
     Group.
    :type parent_name: str
    :param parent_type: Parent type of protected item, example: for a DB,
     standalone server or distributed
    :type parent_type: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param last_backup_status: Last backup operation status. Possible values:
     Healthy, Unhealthy. Possible values include: 'Invalid', 'Healthy',
     'Unhealthy', 'IRPending'
    :type last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.LastBackupStatus
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param last_backup_error_detail: Error details in last backup
    :type last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param protected_item_data_source_id: Data ID of the protected item.
    :type protected_item_data_source_id: str
    :param protected_item_health_status: Health status of the backup item,
     evaluated based on last heartbeat received. Possible values include:
     'Invalid', 'Healthy', 'Unhealthy', 'NotReachable', 'IRPending'
    :type protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemHealthStatus
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureVmWorkloadProtectedItemExtendedInfo
    :param kpis_healths: Health details of different KPIs
    :type kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.KPIResourceHealthDetails]
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_type': {'key': 'parentType', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'last_backup_error_detail': {'key': 'lastBackupErrorDetail', 'type': 'ErrorDetail'},
        'protected_item_data_source_id': {'key': 'protectedItemDataSourceId', 'type': 'str'},
        'protected_item_health_status': {'key': 'protectedItemHealthStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureVmWorkloadProtectedItemExtendedInfo'},
        'kpis_healths': {'key': 'kpisHealths', 'type': '{KPIResourceHealthDetails}'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, server_name: str=None, parent_name: str=None, parent_type: str=None, protection_status: str=None, protection_state=None, last_backup_status=None, last_backup_time=None, last_backup_error_detail=None, protected_item_data_source_id: str=None, protected_item_health_status=None, extended_info=None, kpis_healths=None, **kwargs) -> None:
        super(AzureVmWorkloadSQLDatabaseProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, friendly_name=friendly_name, server_name=server_name, parent_name=parent_name, parent_type=parent_type, protection_status=protection_status, protection_state=protection_state, last_backup_status=last_backup_status, last_backup_time=last_backup_time, last_backup_error_detail=last_backup_error_detail, protected_item_data_source_id=protected_item_data_source_id, protected_item_health_status=protected_item_health_status, extended_info=extended_info, kpis_healths=kpis_healths, **kwargs)
        self.protected_item_type = 'AzureVmWorkloadSQLDatabase'


class AzureVmWorkloadSQLDatabaseWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SQL Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, server_name: str=None, is_auto_protectable: bool=None, subinquireditemcount: int=None, sub_workload_item_count: int=None, **kwargs) -> None:
        super(AzureVmWorkloadSQLDatabaseWorkloadItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, server_name=server_name, is_auto_protectable=is_auto_protectable, subinquireditemcount=subinquireditemcount, sub_workload_item_count=sub_workload_item_count, **kwargs)
        self.workload_item_type = 'SQLDataBase'


class AzureVmWorkloadSQLInstanceProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SQL Instance.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, parent_unique_name: str=None, server_name: str=None, is_auto_protectable: bool=None, is_auto_protected: bool=None, subinquireditemcount: int=None, subprotectableitemcount: int=None, prebackupvalidation=None, **kwargs) -> None:
        super(AzureVmWorkloadSQLInstanceProtectableItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, parent_unique_name=parent_unique_name, server_name=server_name, is_auto_protectable=is_auto_protectable, is_auto_protected=is_auto_protected, subinquireditemcount=subinquireditemcount, subprotectableitemcount=subprotectableitemcount, prebackupvalidation=prebackupvalidation, **kwargs)
        self.protectable_item_type = 'SQLInstance'


class AzureVmWorkloadSQLInstanceWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SQL Instance.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    :param data_directory_paths: Data Directory Paths for default directories
    :type data_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectory]
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
        'data_directory_paths': {'key': 'dataDirectoryPaths', 'type': '[SQLDataDirectory]'},
    }

    def __init__(self, *, backup_management_type: str=None, workload_type: str=None, friendly_name: str=None, protection_state=None, parent_name: str=None, server_name: str=None, is_auto_protectable: bool=None, subinquireditemcount: int=None, sub_workload_item_count: int=None, data_directory_paths=None, **kwargs) -> None:
        super(AzureVmWorkloadSQLInstanceWorkloadItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, friendly_name=friendly_name, protection_state=protection_state, parent_name=parent_name, server_name=server_name, is_auto_protectable=is_auto_protectable, subinquireditemcount=subinquireditemcount, sub_workload_item_count=sub_workload_item_count, **kwargs)
        self.data_directory_paths = data_directory_paths
        self.workload_item_type = 'SQLInstance'


class AzureWorkloadAutoProtectionIntent(AzureRecoveryServiceVaultProtectionIntent):
    """Azure Recovery Services Vault specific protection intent item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSQLAutoProtectionIntent

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param item_id: ID of the item which is getting protected, In case of
     Azure Vm , it is ProtectedItemId
    :type item_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protection_intent_item_type: Required. Constant filled by server.
    :type protection_intent_item_type: str
    """

    _validation = {
        'protection_intent_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_intent_item_type': {'key': 'protectionIntentItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protection_intent_item_type': {'AzureWorkloadSQLAutoProtectionIntent': 'AzureWorkloadSQLAutoProtectionIntent'}
    }

    def __init__(self, *, backup_management_type=None, source_resource_id: str=None, item_id: str=None, policy_id: str=None, protection_state=None, **kwargs) -> None:
        super(AzureWorkloadAutoProtectionIntent, self).__init__(backup_management_type=backup_management_type, source_resource_id=source_resource_id, item_id=item_id, policy_id=policy_id, protection_state=protection_state, **kwargs)
        self.protection_intent_item_type = 'AzureWorkloadAutoProtectionIntent'


class AzureWorkloadBackupRequest(BackupRequest):
    """AzureWorkload workload-specific backup request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param backup_type: Type of backup, viz. Full, Differential, Log or
     CopyOnlyFull. Possible values include: 'Invalid', 'Full', 'Differential',
     'Log', 'CopyOnlyFull', 'Incremental'
    :type backup_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupType
    :param enable_compression: Bool for Compression setting
    :type enable_compression: bool
    :param recovery_point_expiry_time_in_utc: Backup copy will expire after
     the time specified (UTC).
    :type recovery_point_expiry_time_in_utc: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'backup_type': {'key': 'backupType', 'type': 'str'},
        'enable_compression': {'key': 'enableCompression', 'type': 'bool'},
        'recovery_point_expiry_time_in_utc': {'key': 'recoveryPointExpiryTimeInUTC', 'type': 'iso-8601'},
    }

    def __init__(self, *, backup_type=None, enable_compression: bool=None, recovery_point_expiry_time_in_utc=None, **kwargs) -> None:
        super(AzureWorkloadBackupRequest, self).__init__(**kwargs)
        self.backup_type = backup_type
        self.enable_compression = enable_compression
        self.recovery_point_expiry_time_in_utc = recovery_point_expiry_time_in_utc
        self.object_type = 'AzureWorkloadBackupRequest'


class AzureWorkloadContainerExtendedInfo(Model):
    """Extended information of the container.

    :param host_server_name: Host Os Name in case of Stand Alone and Cluster
     Name in case of distributed container.
    :type host_server_name: str
    :param inquiry_info: Inquiry Status for the container.
    :type inquiry_info: ~azure.mgmt.recoveryservicesbackup.models.InquiryInfo
    :param nodes_list: List of the nodes in case of distributed container.
    :type nodes_list:
     list[~azure.mgmt.recoveryservicesbackup.models.DistributedNodesInfo]
    """

    _attribute_map = {
        'host_server_name': {'key': 'hostServerName', 'type': 'str'},
        'inquiry_info': {'key': 'inquiryInfo', 'type': 'InquiryInfo'},
        'nodes_list': {'key': 'nodesList', 'type': '[DistributedNodesInfo]'},
    }

    def __init__(self, *, host_server_name: str=None, inquiry_info=None, nodes_list=None, **kwargs) -> None:
        super(AzureWorkloadContainerExtendedInfo, self).__init__(**kwargs)
        self.host_server_name = host_server_name
        self.inquiry_info = inquiry_info
        self.nodes_list = nodes_list


class AzureWorkloadErrorInfo(Model):
    """Azure storage specific error information.

    :param error_code: Error code.
    :type error_code: int
    :param error_string: Localized error string.
    :type error_string: str
    :param error_title: Title: Typically, the entity that the error pertains
     to.
    :type error_title: str
    :param recommendations: List of localized recommendations for above error
     code.
    :type recommendations: list[str]
    :param additional_details: Additional details for above error code.
    :type additional_details: str
    """

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'error_string': {'key': 'errorString', 'type': 'str'},
        'error_title': {'key': 'errorTitle', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
        'additional_details': {'key': 'additionalDetails', 'type': 'str'},
    }

    def __init__(self, *, error_code: int=None, error_string: str=None, error_title: str=None, recommendations=None, additional_details: str=None, **kwargs) -> None:
        super(AzureWorkloadErrorInfo, self).__init__(**kwargs)
        self.error_code = error_code
        self.error_string = error_string
        self.error_title = error_title
        self.recommendations = recommendations
        self.additional_details = additional_details


class AzureWorkloadJob(Job):
    """Azure storage specific job.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param workload_type: Workload type of the job
    :type workload_type: str
    :param duration: Time elapsed during the execution of this job.
    :type duration: timedelta
    :param actions_info: Gets or sets the state/actions applicable on this job
     like cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param error_details: Error details on execution of this job.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadErrorInfo]
    :param extended_info: Additional information about the job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'error_details': {'key': 'errorDetails', 'type': '[AzureWorkloadErrorInfo]'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadJobExtendedInfo'},
    }

    def __init__(self, *, entity_friendly_name: str=None, backup_management_type=None, operation: str=None, status: str=None, start_time=None, end_time=None, activity_id: str=None, workload_type: str=None, duration=None, actions_info=None, error_details=None, extended_info=None, **kwargs) -> None:
        super(AzureWorkloadJob, self).__init__(entity_friendly_name=entity_friendly_name, backup_management_type=backup_management_type, operation=operation, status=status, start_time=start_time, end_time=end_time, activity_id=activity_id, **kwargs)
        self.workload_type = workload_type
        self.duration = duration
        self.actions_info = actions_info
        self.error_details = error_details
        self.extended_info = extended_info
        self.job_type = 'AzureWorkloadJob'


class AzureWorkloadJobExtendedInfo(Model):
    """Azure VM workload-specific additional information for job.

    :param tasks_list: List of tasks for this job
    :type tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadJobTaskDetails]
    :param property_bag: Job properties.
    :type property_bag: dict[str, str]
    :param dynamic_error_message: Non localized error message on job
     execution.
    :type dynamic_error_message: str
    """

    _attribute_map = {
        'tasks_list': {'key': 'tasksList', 'type': '[AzureWorkloadJobTaskDetails]'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'dynamic_error_message': {'key': 'dynamicErrorMessage', 'type': 'str'},
    }

    def __init__(self, *, tasks_list=None, property_bag=None, dynamic_error_message: str=None, **kwargs) -> None:
        super(AzureWorkloadJobExtendedInfo, self).__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class AzureWorkloadJobTaskDetails(Model):
    """Azure VM workload specific job task details.

    :param task_id: The task display name.
    :type task_id: str
    :param status: The status.
    :type status: str
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, task_id: str=None, status: str=None, **kwargs) -> None:
        super(AzureWorkloadJobTaskDetails, self).__init__(**kwargs)
        self.task_id = task_id
        self.status = status


class AzureWorkloadRecoveryPoint(RecoveryPoint):
    """Workload specific recovery point, specifically encapsulates full/diff
    recovery point.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadPointInTimeRecoveryPoint,
    AzureWorkloadSAPHanaRecoveryPoint, AzureWorkloadSQLRecoveryPoint

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential', 'Incremental'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    :param recovery_point_tier_details: Recovery point tier information.
    :type recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierInformation]
    :param recovery_point_move_readiness_info: Eligibility of RP to be moved
     to another tier
    :type recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointMoveReadinessInfo]
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'recovery_point_tier_details': {'key': 'recoveryPointTierDetails', 'type': '[RecoveryPointTierInformation]'},
        'recovery_point_move_readiness_info': {'key': 'recoveryPointMoveReadinessInfo', 'type': '{RecoveryPointMoveReadinessInfo}'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadPointInTimeRecoveryPoint': 'AzureWorkloadPointInTimeRecoveryPoint', 'AzureWorkloadSAPHanaRecoveryPoint': 'AzureWorkloadSAPHanaRecoveryPoint', 'AzureWorkloadSQLRecoveryPoint': 'AzureWorkloadSQLRecoveryPoint'}
    }

    def __init__(self, *, recovery_point_tier_details=None, recovery_point_move_readiness_info=None, **kwargs) -> None:
        super(AzureWorkloadRecoveryPoint, self).__init__(**kwargs)
        self.recovery_point_time_in_utc = None
        self.type = None
        self.recovery_point_tier_details = recovery_point_tier_details
        self.recovery_point_move_readiness_info = recovery_point_move_readiness_info
        self.object_type = 'AzureWorkloadRecoveryPoint'


class AzureWorkloadPointInTimeRecoveryPoint(AzureWorkloadRecoveryPoint):
    """Recovery point specific to PointInTime.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSAPHanaPointInTimeRecoveryPoint

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential', 'Incremental'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    :param recovery_point_tier_details: Recovery point tier information.
    :type recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierInformation]
    :param recovery_point_move_readiness_info: Eligibility of RP to be moved
     to another tier
    :type recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointMoveReadinessInfo]
    :param time_ranges: List of log ranges
    :type time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.models.PointInTimeRange]
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'recovery_point_tier_details': {'key': 'recoveryPointTierDetails', 'type': '[RecoveryPointTierInformation]'},
        'recovery_point_move_readiness_info': {'key': 'recoveryPointMoveReadinessInfo', 'type': '{RecoveryPointMoveReadinessInfo}'},
        'time_ranges': {'key': 'timeRanges', 'type': '[PointInTimeRange]'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSAPHanaPointInTimeRecoveryPoint': 'AzureWorkloadSAPHanaPointInTimeRecoveryPoint'}
    }

    def __init__(self, *, recovery_point_tier_details=None, recovery_point_move_readiness_info=None, time_ranges=None, **kwargs) -> None:
        super(AzureWorkloadPointInTimeRecoveryPoint, self).__init__(recovery_point_tier_details=recovery_point_tier_details, recovery_point_move_readiness_info=recovery_point_move_readiness_info, **kwargs)
        self.time_ranges = time_ranges
        self.object_type = 'AzureWorkloadPointInTimeRecoveryPoint'


class AzureWorkloadRestoreRequest(RestoreRequest):
    """AzureWorkload-specific restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadPointInTimeRestoreRequest,
    AzureWorkloadSAPHanaRestoreRequest, AzureWorkloadSQLRestoreRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param target_virtual_machine_id: This is the complete ARM Id of the
     target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadPointInTimeRestoreRequest': 'AzureWorkloadPointInTimeRestoreRequest', 'AzureWorkloadSAPHanaRestoreRequest': 'AzureWorkloadSAPHanaRestoreRequest', 'AzureWorkloadSQLRestoreRequest': 'AzureWorkloadSQLRestoreRequest'}
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, property_bag=None, target_info=None, recovery_mode=None, target_virtual_machine_id: str=None, **kwargs) -> None:
        super(AzureWorkloadRestoreRequest, self).__init__(**kwargs)
        self.recovery_type = recovery_type
        self.source_resource_id = source_resource_id
        self.property_bag = property_bag
        self.target_info = target_info
        self.recovery_mode = recovery_mode
        self.target_virtual_machine_id = target_virtual_machine_id
        self.object_type = 'AzureWorkloadRestoreRequest'


class AzureWorkloadPointInTimeRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log
    restore.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param target_virtual_machine_id: This is the complete ARM Id of the
     target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param point_in_time: PointInTime value
    :type point_in_time: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'point_in_time': {'key': 'pointInTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, property_bag=None, target_info=None, recovery_mode=None, target_virtual_machine_id: str=None, point_in_time=None, **kwargs) -> None:
        super(AzureWorkloadPointInTimeRestoreRequest, self).__init__(recovery_type=recovery_type, source_resource_id=source_resource_id, property_bag=property_bag, target_info=target_info, recovery_mode=recovery_mode, target_virtual_machine_id=target_virtual_machine_id, **kwargs)
        self.point_in_time = point_in_time
        self.object_type = 'AzureWorkloadPointInTimeRestoreRequest'


class AzureWorkloadSAPHanaPointInTimeRecoveryPoint(AzureWorkloadPointInTimeRecoveryPoint):
    """Recovery point specific to PointInTime in SAPHana.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential', 'Incremental'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    :param recovery_point_tier_details: Recovery point tier information.
    :type recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierInformation]
    :param recovery_point_move_readiness_info: Eligibility of RP to be moved
     to another tier
    :type recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointMoveReadinessInfo]
    :param time_ranges: List of log ranges
    :type time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.models.PointInTimeRange]
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'recovery_point_tier_details': {'key': 'recoveryPointTierDetails', 'type': '[RecoveryPointTierInformation]'},
        'recovery_point_move_readiness_info': {'key': 'recoveryPointMoveReadinessInfo', 'type': '{RecoveryPointMoveReadinessInfo}'},
        'time_ranges': {'key': 'timeRanges', 'type': '[PointInTimeRange]'},
    }

    def __init__(self, *, recovery_point_tier_details=None, recovery_point_move_readiness_info=None, time_ranges=None, **kwargs) -> None:
        super(AzureWorkloadSAPHanaPointInTimeRecoveryPoint, self).__init__(recovery_point_tier_details=recovery_point_tier_details, recovery_point_move_readiness_info=recovery_point_move_readiness_info, time_ranges=time_ranges, **kwargs)
        self.object_type = 'AzureWorkloadSAPHanaPointInTimeRecoveryPoint'


class AzureWorkloadSAPHanaRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SAP Hana-specific restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSAPHanaPointInTimeRestoreRequest,
    AzureWorkloadSAPHanaRestoreWithRehydrateRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param target_virtual_machine_id: This is the complete ARM Id of the
     target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSAPHanaPointInTimeRestoreRequest': 'AzureWorkloadSAPHanaPointInTimeRestoreRequest', 'AzureWorkloadSAPHanaRestoreWithRehydrateRequest': 'AzureWorkloadSAPHanaRestoreWithRehydrateRequest'}
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, property_bag=None, target_info=None, recovery_mode=None, target_virtual_machine_id: str=None, **kwargs) -> None:
        super(AzureWorkloadSAPHanaRestoreRequest, self).__init__(recovery_type=recovery_type, source_resource_id=source_resource_id, property_bag=property_bag, target_info=target_info, recovery_mode=recovery_mode, target_virtual_machine_id=target_virtual_machine_id, **kwargs)
        self.object_type = 'AzureWorkloadSAPHanaRestoreRequest'


class AzureWorkloadSAPHanaPointInTimeRestoreRequest(AzureWorkloadSAPHanaRestoreRequest):
    """AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log
    restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param target_virtual_machine_id: This is the complete ARM Id of the
     target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param point_in_time: PointInTime value
    :type point_in_time: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'point_in_time': {'key': 'pointInTime', 'type': 'iso-8601'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest': 'AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest'}
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, property_bag=None, target_info=None, recovery_mode=None, target_virtual_machine_id: str=None, point_in_time=None, **kwargs) -> None:
        super(AzureWorkloadSAPHanaPointInTimeRestoreRequest, self).__init__(recovery_type=recovery_type, source_resource_id=source_resource_id, property_bag=property_bag, target_info=target_info, recovery_mode=recovery_mode, target_virtual_machine_id=target_virtual_machine_id, **kwargs)
        self.point_in_time = point_in_time
        self.object_type = 'AzureWorkloadSAPHanaPointInTimeRestoreRequest'


class AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest(AzureWorkloadSAPHanaPointInTimeRestoreRequest):
    """AzureWorkload SAP Hana-specific restore with integrated rehydration of
    recovery point.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param target_virtual_machine_id: This is the complete ARM Id of the
     target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param point_in_time: PointInTime value
    :type point_in_time: datetime
    :param recovery_point_rehydration_info: RP Rehydration Info
    :type recovery_point_rehydration_info:
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointRehydrationInfo
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'point_in_time': {'key': 'pointInTime', 'type': 'iso-8601'},
        'recovery_point_rehydration_info': {'key': 'recoveryPointRehydrationInfo', 'type': 'RecoveryPointRehydrationInfo'},
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, property_bag=None, target_info=None, recovery_mode=None, target_virtual_machine_id: str=None, point_in_time=None, recovery_point_rehydration_info=None, **kwargs) -> None:
        super(AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest, self).__init__(recovery_type=recovery_type, source_resource_id=source_resource_id, property_bag=property_bag, target_info=target_info, recovery_mode=recovery_mode, target_virtual_machine_id=target_virtual_machine_id, point_in_time=point_in_time, **kwargs)
        self.recovery_point_rehydration_info = recovery_point_rehydration_info
        self.object_type = 'AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest'


class AzureWorkloadSAPHanaRecoveryPoint(AzureWorkloadRecoveryPoint):
    """SAPHana specific recoverypoint, specifically encapsulates full/diff
    recoverypoints.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential', 'Incremental'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    :param recovery_point_tier_details: Recovery point tier information.
    :type recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierInformation]
    :param recovery_point_move_readiness_info: Eligibility of RP to be moved
     to another tier
    :type recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointMoveReadinessInfo]
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'recovery_point_tier_details': {'key': 'recoveryPointTierDetails', 'type': '[RecoveryPointTierInformation]'},
        'recovery_point_move_readiness_info': {'key': 'recoveryPointMoveReadinessInfo', 'type': '{RecoveryPointMoveReadinessInfo}'},
    }

    def __init__(self, *, recovery_point_tier_details=None, recovery_point_move_readiness_info=None, **kwargs) -> None:
        super(AzureWorkloadSAPHanaRecoveryPoint, self).__init__(recovery_point_tier_details=recovery_point_tier_details, recovery_point_move_readiness_info=recovery_point_move_readiness_info, **kwargs)
        self.object_type = 'AzureWorkloadSAPHanaRecoveryPoint'


class AzureWorkloadSAPHanaRestoreWithRehydrateRequest(AzureWorkloadSAPHanaRestoreRequest):
    """AzureWorkload SAP Hana-specific restore with integrated rehydration of
    recovery point.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param target_virtual_machine_id: This is the complete ARM Id of the
     target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param recovery_point_rehydration_info: RP Rehydration Info
    :type recovery_point_rehydration_info:
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointRehydrationInfo
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'recovery_point_rehydration_info': {'key': 'recoveryPointRehydrationInfo', 'type': 'RecoveryPointRehydrationInfo'},
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, property_bag=None, target_info=None, recovery_mode=None, target_virtual_machine_id: str=None, recovery_point_rehydration_info=None, **kwargs) -> None:
        super(AzureWorkloadSAPHanaRestoreWithRehydrateRequest, self).__init__(recovery_type=recovery_type, source_resource_id=source_resource_id, property_bag=property_bag, target_info=target_info, recovery_mode=recovery_mode, target_virtual_machine_id=target_virtual_machine_id, **kwargs)
        self.recovery_point_rehydration_info = recovery_point_rehydration_info
        self.object_type = 'AzureWorkloadSAPHanaRestoreWithRehydrateRequest'


class AzureWorkloadSQLAutoProtectionIntent(AzureWorkloadAutoProtectionIntent):
    """Azure Workload SQL Auto Protection intent item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param item_id: ID of the item which is getting protected, In case of
     Azure Vm , it is ProtectedItemId
    :type item_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protection_intent_item_type: Required. Constant filled by server.
    :type protection_intent_item_type: str
    :param workload_item_type: Workload item type of the item for which intent
     is to be set. Possible values include: 'Invalid', 'SQLInstance',
     'SQLDataBase', 'SAPHanaSystem', 'SAPHanaDatabase', 'SAPAseSystem',
     'SAPAseDatabase'
    :type workload_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadItemType
    """

    _validation = {
        'protection_intent_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_intent_item_type': {'key': 'protectionIntentItemType', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, source_resource_id: str=None, item_id: str=None, policy_id: str=None, protection_state=None, workload_item_type=None, **kwargs) -> None:
        super(AzureWorkloadSQLAutoProtectionIntent, self).__init__(backup_management_type=backup_management_type, source_resource_id=source_resource_id, item_id=item_id, policy_id=policy_id, protection_state=protection_state, **kwargs)
        self.workload_item_type = workload_item_type
        self.protection_intent_item_type = 'AzureWorkloadSQLAutoProtectionIntent'


class AzureWorkloadSQLRecoveryPoint(AzureWorkloadRecoveryPoint):
    """SQL specific recoverypoint, specifically encapsulates full/diff
    recoverypoint along with extended info.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSQLPointInTimeRecoveryPoint

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential', 'Incremental'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    :param recovery_point_tier_details: Recovery point tier information.
    :type recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierInformation]
    :param recovery_point_move_readiness_info: Eligibility of RP to be moved
     to another tier
    :type recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointMoveReadinessInfo]
    :param extended_info: Extended Info that provides data directory details.
     Will be populated in two cases:
     When a specific recovery point is accessed using GetRecoveryPoint
     Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo
     query filter
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadSQLRecoveryPointExtendedInfo
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'recovery_point_tier_details': {'key': 'recoveryPointTierDetails', 'type': '[RecoveryPointTierInformation]'},
        'recovery_point_move_readiness_info': {'key': 'recoveryPointMoveReadinessInfo', 'type': '{RecoveryPointMoveReadinessInfo}'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadSQLRecoveryPointExtendedInfo'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSQLPointInTimeRecoveryPoint': 'AzureWorkloadSQLPointInTimeRecoveryPoint'}
    }

    def __init__(self, *, recovery_point_tier_details=None, recovery_point_move_readiness_info=None, extended_info=None, **kwargs) -> None:
        super(AzureWorkloadSQLRecoveryPoint, self).__init__(recovery_point_tier_details=recovery_point_tier_details, recovery_point_move_readiness_info=recovery_point_move_readiness_info, **kwargs)
        self.extended_info = extended_info
        self.object_type = 'AzureWorkloadSQLRecoveryPoint'


class AzureWorkloadSQLPointInTimeRecoveryPoint(AzureWorkloadSQLRecoveryPoint):
    """Recovery point specific to PointInTime.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential', 'Incremental'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    :param recovery_point_tier_details: Recovery point tier information.
    :type recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierInformation]
    :param recovery_point_move_readiness_info: Eligibility of RP to be moved
     to another tier
    :type recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointMoveReadinessInfo]
    :param extended_info: Extended Info that provides data directory details.
     Will be populated in two cases:
     When a specific recovery point is accessed using GetRecoveryPoint
     Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo
     query filter
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadSQLRecoveryPointExtendedInfo
    :param time_ranges: List of log ranges
    :type time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.models.PointInTimeRange]
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'recovery_point_tier_details': {'key': 'recoveryPointTierDetails', 'type': '[RecoveryPointTierInformation]'},
        'recovery_point_move_readiness_info': {'key': 'recoveryPointMoveReadinessInfo', 'type': '{RecoveryPointMoveReadinessInfo}'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadSQLRecoveryPointExtendedInfo'},
        'time_ranges': {'key': 'timeRanges', 'type': '[PointInTimeRange]'},
    }

    def __init__(self, *, recovery_point_tier_details=None, recovery_point_move_readiness_info=None, extended_info=None, time_ranges=None, **kwargs) -> None:
        super(AzureWorkloadSQLPointInTimeRecoveryPoint, self).__init__(recovery_point_tier_details=recovery_point_tier_details, recovery_point_move_readiness_info=recovery_point_move_readiness_info, extended_info=extended_info, **kwargs)
        self.time_ranges = time_ranges
        self.object_type = 'AzureWorkloadSQLPointInTimeRecoveryPoint'


class AzureWorkloadSQLRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SQL -specific restore. Specifically for full/diff restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSQLPointInTimeRestoreRequest,
    AzureWorkloadSQLRestoreWithRehydrateRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param target_virtual_machine_id: This is the complete ARM Id of the
     target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param should_use_alternate_target_location: Default option set to true.
     If this is set to false, alternate data directory must be provided
    :type should_use_alternate_target_location: bool
    :param is_non_recoverable: SQL specific property where user can chose to
     set no-recovery when restore operation is tried
    :type is_non_recoverable: bool
    :param alternate_directory_paths: Data directory details
    :type alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectoryMapping]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'should_use_alternate_target_location': {'key': 'shouldUseAlternateTargetLocation', 'type': 'bool'},
        'is_non_recoverable': {'key': 'isNonRecoverable', 'type': 'bool'},
        'alternate_directory_paths': {'key': 'alternateDirectoryPaths', 'type': '[SQLDataDirectoryMapping]'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSQLPointInTimeRestoreRequest': 'AzureWorkloadSQLPointInTimeRestoreRequest', 'AzureWorkloadSQLRestoreWithRehydrateRequest': 'AzureWorkloadSQLRestoreWithRehydrateRequest'}
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, property_bag=None, target_info=None, recovery_mode=None, target_virtual_machine_id: str=None, should_use_alternate_target_location: bool=None, is_non_recoverable: bool=None, alternate_directory_paths=None, **kwargs) -> None:
        super(AzureWorkloadSQLRestoreRequest, self).__init__(recovery_type=recovery_type, source_resource_id=source_resource_id, property_bag=property_bag, target_info=target_info, recovery_mode=recovery_mode, target_virtual_machine_id=target_virtual_machine_id, **kwargs)
        self.should_use_alternate_target_location = should_use_alternate_target_location
        self.is_non_recoverable = is_non_recoverable
        self.alternate_directory_paths = alternate_directory_paths
        self.object_type = 'AzureWorkloadSQLRestoreRequest'


class AzureWorkloadSQLPointInTimeRestoreRequest(AzureWorkloadSQLRestoreRequest):
    """AzureWorkload SQL -specific restore. Specifically for PointInTime/Log
    restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param target_virtual_machine_id: This is the complete ARM Id of the
     target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param should_use_alternate_target_location: Default option set to true.
     If this is set to false, alternate data directory must be provided
    :type should_use_alternate_target_location: bool
    :param is_non_recoverable: SQL specific property where user can chose to
     set no-recovery when restore operation is tried
    :type is_non_recoverable: bool
    :param alternate_directory_paths: Data directory details
    :type alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectoryMapping]
    :param point_in_time: PointInTime value
    :type point_in_time: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'should_use_alternate_target_location': {'key': 'shouldUseAlternateTargetLocation', 'type': 'bool'},
        'is_non_recoverable': {'key': 'isNonRecoverable', 'type': 'bool'},
        'alternate_directory_paths': {'key': 'alternateDirectoryPaths', 'type': '[SQLDataDirectoryMapping]'},
        'point_in_time': {'key': 'pointInTime', 'type': 'iso-8601'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest': 'AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest'}
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, property_bag=None, target_info=None, recovery_mode=None, target_virtual_machine_id: str=None, should_use_alternate_target_location: bool=None, is_non_recoverable: bool=None, alternate_directory_paths=None, point_in_time=None, **kwargs) -> None:
        super(AzureWorkloadSQLPointInTimeRestoreRequest, self).__init__(recovery_type=recovery_type, source_resource_id=source_resource_id, property_bag=property_bag, target_info=target_info, recovery_mode=recovery_mode, target_virtual_machine_id=target_virtual_machine_id, should_use_alternate_target_location=should_use_alternate_target_location, is_non_recoverable=is_non_recoverable, alternate_directory_paths=alternate_directory_paths, **kwargs)
        self.point_in_time = point_in_time
        self.object_type = 'AzureWorkloadSQLPointInTimeRestoreRequest'


class AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest(AzureWorkloadSQLPointInTimeRestoreRequest):
    """AzureWorkload SQL-specific restore with integrated rehydration of recovery
    point.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param target_virtual_machine_id: This is the complete ARM Id of the
     target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param should_use_alternate_target_location: Default option set to true.
     If this is set to false, alternate data directory must be provided
    :type should_use_alternate_target_location: bool
    :param is_non_recoverable: SQL specific property where user can chose to
     set no-recovery when restore operation is tried
    :type is_non_recoverable: bool
    :param alternate_directory_paths: Data directory details
    :type alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectoryMapping]
    :param point_in_time: PointInTime value
    :type point_in_time: datetime
    :param recovery_point_rehydration_info: RP Rehydration Info
    :type recovery_point_rehydration_info:
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointRehydrationInfo
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'should_use_alternate_target_location': {'key': 'shouldUseAlternateTargetLocation', 'type': 'bool'},
        'is_non_recoverable': {'key': 'isNonRecoverable', 'type': 'bool'},
        'alternate_directory_paths': {'key': 'alternateDirectoryPaths', 'type': '[SQLDataDirectoryMapping]'},
        'point_in_time': {'key': 'pointInTime', 'type': 'iso-8601'},
        'recovery_point_rehydration_info': {'key': 'recoveryPointRehydrationInfo', 'type': 'RecoveryPointRehydrationInfo'},
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, property_bag=None, target_info=None, recovery_mode=None, target_virtual_machine_id: str=None, should_use_alternate_target_location: bool=None, is_non_recoverable: bool=None, alternate_directory_paths=None, point_in_time=None, recovery_point_rehydration_info=None, **kwargs) -> None:
        super(AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest, self).__init__(recovery_type=recovery_type, source_resource_id=source_resource_id, property_bag=property_bag, target_info=target_info, recovery_mode=recovery_mode, target_virtual_machine_id=target_virtual_machine_id, should_use_alternate_target_location=should_use_alternate_target_location, is_non_recoverable=is_non_recoverable, alternate_directory_paths=alternate_directory_paths, point_in_time=point_in_time, **kwargs)
        self.recovery_point_rehydration_info = recovery_point_rehydration_info
        self.object_type = 'AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest'


class AzureWorkloadSQLRecoveryPointExtendedInfo(Model):
    """Extended info class details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar data_directory_time_in_utc: UTC time at which data directory info
     was captured
    :vartype data_directory_time_in_utc: datetime
    :ivar data_directory_paths: List of data directory paths during restore
     operation.
    :vartype data_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectory]
    """

    _validation = {
        'data_directory_time_in_utc': {'readonly': True},
        'data_directory_paths': {'readonly': True},
    }

    _attribute_map = {
        'data_directory_time_in_utc': {'key': 'dataDirectoryTimeInUTC', 'type': 'iso-8601'},
        'data_directory_paths': {'key': 'dataDirectoryPaths', 'type': '[SQLDataDirectory]'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureWorkloadSQLRecoveryPointExtendedInfo, self).__init__(**kwargs)
        self.data_directory_time_in_utc = None
        self.data_directory_paths = None


class AzureWorkloadSQLRestoreWithRehydrateRequest(AzureWorkloadSQLRestoreRequest):
    """AzureWorkload SQL-specific restore with integrated rehydration of recovery
    point.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param target_virtual_machine_id: This is the complete ARM Id of the
     target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param should_use_alternate_target_location: Default option set to true.
     If this is set to false, alternate data directory must be provided
    :type should_use_alternate_target_location: bool
    :param is_non_recoverable: SQL specific property where user can chose to
     set no-recovery when restore operation is tried
    :type is_non_recoverable: bool
    :param alternate_directory_paths: Data directory details
    :type alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectoryMapping]
    :param recovery_point_rehydration_info: RP Rehydration Info
    :type recovery_point_rehydration_info:
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointRehydrationInfo
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'should_use_alternate_target_location': {'key': 'shouldUseAlternateTargetLocation', 'type': 'bool'},
        'is_non_recoverable': {'key': 'isNonRecoverable', 'type': 'bool'},
        'alternate_directory_paths': {'key': 'alternateDirectoryPaths', 'type': '[SQLDataDirectoryMapping]'},
        'recovery_point_rehydration_info': {'key': 'recoveryPointRehydrationInfo', 'type': 'RecoveryPointRehydrationInfo'},
    }

    def __init__(self, *, recovery_type=None, source_resource_id: str=None, property_bag=None, target_info=None, recovery_mode=None, target_virtual_machine_id: str=None, should_use_alternate_target_location: bool=None, is_non_recoverable: bool=None, alternate_directory_paths=None, recovery_point_rehydration_info=None, **kwargs) -> None:
        super(AzureWorkloadSQLRestoreWithRehydrateRequest, self).__init__(recovery_type=recovery_type, source_resource_id=source_resource_id, property_bag=property_bag, target_info=target_info, recovery_mode=recovery_mode, target_virtual_machine_id=target_virtual_machine_id, should_use_alternate_target_location=should_use_alternate_target_location, is_non_recoverable=is_non_recoverable, alternate_directory_paths=alternate_directory_paths, **kwargs)
        self.recovery_point_rehydration_info = recovery_point_rehydration_info
        self.object_type = 'AzureWorkloadSQLRestoreWithRehydrateRequest'


class BackupEngineBaseResource(Resource):
    """The base backup engine class. All workload specific backup engines derive
    from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: BackupEngineBaseResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.BackupEngineBase
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackupEngineBase'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(BackupEngineBaseResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BackupEngineExtendedInfo(Model):
    """Additional information on backup engine.

    :param database_name: Database name of backup engine.
    :type database_name: str
    :param protected_items_count: Number of protected items in the backup
     engine.
    :type protected_items_count: int
    :param protected_servers_count: Number of protected servers in the backup
     engine.
    :type protected_servers_count: int
    :param disk_count: Number of disks in the backup engine.
    :type disk_count: int
    :param used_disk_space: Disk space used in the backup engine.
    :type used_disk_space: float
    :param available_disk_space: Disk space currently available in the backup
     engine.
    :type available_disk_space: float
    :param refreshed_at: Last refresh time in the backup engine.
    :type refreshed_at: datetime
    :param azure_protected_instances: Protected instances in the backup
     engine.
    :type azure_protected_instances: int
    """

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'protected_servers_count': {'key': 'protectedServersCount', 'type': 'int'},
        'disk_count': {'key': 'diskCount', 'type': 'int'},
        'used_disk_space': {'key': 'usedDiskSpace', 'type': 'float'},
        'available_disk_space': {'key': 'availableDiskSpace', 'type': 'float'},
        'refreshed_at': {'key': 'refreshedAt', 'type': 'iso-8601'},
        'azure_protected_instances': {'key': 'azureProtectedInstances', 'type': 'int'},
    }

    def __init__(self, *, database_name: str=None, protected_items_count: int=None, protected_servers_count: int=None, disk_count: int=None, used_disk_space: float=None, available_disk_space: float=None, refreshed_at=None, azure_protected_instances: int=None, **kwargs) -> None:
        super(BackupEngineExtendedInfo, self).__init__(**kwargs)
        self.database_name = database_name
        self.protected_items_count = protected_items_count
        self.protected_servers_count = protected_servers_count
        self.disk_count = disk_count
        self.used_disk_space = used_disk_space
        self.available_disk_space = available_disk_space
        self.refreshed_at = refreshed_at
        self.azure_protected_instances = azure_protected_instances


class BackupManagementUsage(Model):
    """Backup management usages of a vault.

    :param unit: Unit of the usage. Possible values include: 'Count', 'Bytes',
     'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
    :type unit: str or ~azure.mgmt.recoveryservicesbackup.models.UsagesUnit
    :param quota_period: Quota period of usage.
    :type quota_period: str
    :param next_reset_time: Next reset time of usage.
    :type next_reset_time: datetime
    :param current_value: Current value of usage.
    :type current_value: long
    :param limit: Limit of usage.
    :type limit: long
    :param name: Name of usage.
    :type name: ~azure.mgmt.recoveryservicesbackup.models.NameInfo
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'NameInfo'},
    }

    def __init__(self, *, unit=None, quota_period: str=None, next_reset_time=None, current_value: int=None, limit: int=None, name=None, **kwargs) -> None:
        super(BackupManagementUsage, self).__init__(**kwargs)
        self.unit = unit
        self.quota_period = quota_period
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class BackupRequestResource(Resource):
    """Base class for backup request. Workload-specific backup requests are
    derived from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: BackupRequestResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.BackupRequest
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackupRequest'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(BackupRequestResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BackupResourceConfig(Model):
    """The resource storage details.

    :param storage_model_type: Storage type. Possible values include:
     'Invalid', 'GeoRedundant', 'LocallyRedundant', 'ZoneRedundant',
     'ReadAccessGeoZoneRedundant'
    :type storage_model_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageType
    :param storage_type: Storage type. Possible values include: 'Invalid',
     'GeoRedundant', 'LocallyRedundant', 'ZoneRedundant',
     'ReadAccessGeoZoneRedundant'
    :type storage_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageType
    :param storage_type_state: Locked or Unlocked. Once a machine is
     registered against a resource, the storageTypeState is always Locked.
     Possible values include: 'Invalid', 'Locked', 'Unlocked'
    :type storage_type_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageTypeState
    :param cross_region_restore_flag: Opt in details of Cross Region Restore
     feature.
    :type cross_region_restore_flag: bool
    """

    _attribute_map = {
        'storage_model_type': {'key': 'storageModelType', 'type': 'str'},
        'storage_type': {'key': 'storageType', 'type': 'str'},
        'storage_type_state': {'key': 'storageTypeState', 'type': 'str'},
        'cross_region_restore_flag': {'key': 'crossRegionRestoreFlag', 'type': 'bool'},
    }

    def __init__(self, *, storage_model_type=None, storage_type=None, storage_type_state=None, cross_region_restore_flag: bool=None, **kwargs) -> None:
        super(BackupResourceConfig, self).__init__(**kwargs)
        self.storage_model_type = storage_model_type
        self.storage_type = storage_type
        self.storage_type_state = storage_type_state
        self.cross_region_restore_flag = cross_region_restore_flag


class BackupResourceConfigResource(Resource):
    """The resource storage details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: BackupResourceConfigResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.BackupResourceConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackupResourceConfig'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(BackupResourceConfigResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BackupResourceEncryptionConfig(Model):
    """BackupResourceEncryptionConfig.

    :param encryption_at_rest_type: Encryption At Rest Type. Possible values
     include: 'Invalid', 'MicrosoftManaged', 'CustomerManaged'
    :type encryption_at_rest_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.EncryptionAtRestType
    :param key_uri: Key Vault Key URI
    :type key_uri: str
    :param subscription_id: Key Vault Subscription Id
    :type subscription_id: str
    :param last_update_status: Possible values include: 'Invalid',
     'NotEnabled', 'PartiallySucceeded', 'PartiallyFailed', 'Failed',
     'Succeeded'
    :type last_update_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.LastUpdateStatus
    :param infrastructure_encryption_state: Possible values include:
     'Invalid', 'Disabled', 'Enabled'
    :type infrastructure_encryption_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.InfrastructureEncryptionState
    """

    _attribute_map = {
        'encryption_at_rest_type': {'key': 'encryptionAtRestType', 'type': 'str'},
        'key_uri': {'key': 'keyUri', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'last_update_status': {'key': 'lastUpdateStatus', 'type': 'str'},
        'infrastructure_encryption_state': {'key': 'infrastructureEncryptionState', 'type': 'str'},
    }

    def __init__(self, *, encryption_at_rest_type=None, key_uri: str=None, subscription_id: str=None, last_update_status=None, infrastructure_encryption_state=None, **kwargs) -> None:
        super(BackupResourceEncryptionConfig, self).__init__(**kwargs)
        self.encryption_at_rest_type = encryption_at_rest_type
        self.key_uri = key_uri
        self.subscription_id = subscription_id
        self.last_update_status = last_update_status
        self.infrastructure_encryption_state = infrastructure_encryption_state


class BackupResourceEncryptionConfigResource(Resource):
    """BackupResourceEncryptionConfigResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: BackupResourceEncryptionConfigResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.BackupResourceEncryptionConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackupResourceEncryptionConfig'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(BackupResourceEncryptionConfigResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BackupResourceVaultConfig(Model):
    """Backup resource vault config details.

    :param storage_model_type: Storage type. Possible values include:
     'Invalid', 'GeoRedundant', 'LocallyRedundant', 'ZoneRedundant',
     'ReadAccessGeoZoneRedundant'
    :type storage_model_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageType
    :param storage_type: Storage type. Possible values include: 'Invalid',
     'GeoRedundant', 'LocallyRedundant', 'ZoneRedundant',
     'ReadAccessGeoZoneRedundant'
    :type storage_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageType
    :param storage_type_state: Locked or Unlocked. Once a machine is
     registered against a resource, the storageTypeState is always Locked.
     Possible values include: 'Invalid', 'Locked', 'Unlocked'
    :type storage_type_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageTypeState
    :param enhanced_security_state: Enabled or Disabled. Possible values
     include: 'Invalid', 'Enabled', 'Disabled'
    :type enhanced_security_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.EnhancedSecurityState
    :param soft_delete_feature_state: Soft Delete feature state. Possible
     values include: 'Invalid', 'Enabled', 'Disabled'
    :type soft_delete_feature_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.SoftDeleteFeatureState
    """

    _attribute_map = {
        'storage_model_type': {'key': 'storageModelType', 'type': 'str'},
        'storage_type': {'key': 'storageType', 'type': 'str'},
        'storage_type_state': {'key': 'storageTypeState', 'type': 'str'},
        'enhanced_security_state': {'key': 'enhancedSecurityState', 'type': 'str'},
        'soft_delete_feature_state': {'key': 'softDeleteFeatureState', 'type': 'str'},
    }

    def __init__(self, *, storage_model_type=None, storage_type=None, storage_type_state=None, enhanced_security_state=None, soft_delete_feature_state=None, **kwargs) -> None:
        super(BackupResourceVaultConfig, self).__init__(**kwargs)
        self.storage_model_type = storage_model_type
        self.storage_type = storage_type
        self.storage_type_state = storage_type_state
        self.enhanced_security_state = enhanced_security_state
        self.soft_delete_feature_state = soft_delete_feature_state


class BackupResourceVaultConfigResource(Resource):
    """Backup resource vault config details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: BackupResourceVaultConfigResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.BackupResourceVaultConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackupResourceVaultConfig'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(BackupResourceVaultConfigResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BackupStatusRequest(Model):
    """BackupStatus request.

    :param resource_type: Container Type - VM, SQLPaaS, DPM, AzureFileShare.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type resource_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param resource_id: Entire ARM resource id of the resource
    :type resource_id: str
    :param po_logical_name: Protectable Item Logical Name
    :type po_logical_name: str
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'po_logical_name': {'key': 'poLogicalName', 'type': 'str'},
    }

    def __init__(self, *, resource_type=None, resource_id: str=None, po_logical_name: str=None, **kwargs) -> None:
        super(BackupStatusRequest, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.po_logical_name = po_logical_name


class BackupStatusResponse(Model):
    """BackupStatus response.

    :param protection_status: Specifies whether the container is registered or
     not. Possible values include: 'Invalid', 'NotProtected', 'Protecting',
     'Protected', 'ProtectionFailed'
    :type protection_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param vault_id: Specifies the arm resource id of the vault
    :type vault_id: str
    :param fabric_name: Specifies the fabric name - Azure or AD. Possible
     values include: 'Invalid', 'Azure'
    :type fabric_name: str or
     ~azure.mgmt.recoveryservicesbackup.models.FabricName
    :param container_name: Specifies the product specific container name. E.g.
     iaasvmcontainer;iaasvmcontainer;csname;vmname.
    :type container_name: str
    :param protected_item_name: Specifies the product specific ds name. E.g.
     vm;iaasvmcontainer;csname;vmname.
    :type protected_item_name: str
    :param error_code: ErrorCode in case of intent failed
    :type error_code: str
    :param error_message: ErrorMessage in case of intent failed.
    :type error_message: str
    :param policy_name: Specifies the policy name which is used for protection
    :type policy_name: str
    :param registration_status: Container registration status
    :type registration_status: str
    """

    _attribute_map = {
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'vault_id': {'key': 'vaultId', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'protected_item_name': {'key': 'protectedItemName', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
    }

    def __init__(self, *, protection_status=None, vault_id: str=None, fabric_name=None, container_name: str=None, protected_item_name: str=None, error_code: str=None, error_message: str=None, policy_name: str=None, registration_status: str=None, **kwargs) -> None:
        super(BackupStatusResponse, self).__init__(**kwargs)
        self.protection_status = protection_status
        self.vault_id = vault_id
        self.fabric_name = fabric_name
        self.container_name = container_name
        self.protected_item_name = protected_item_name
        self.error_code = error_code
        self.error_message = error_message
        self.policy_name = policy_name
        self.registration_status = registration_status


class BEKDetails(Model):
    """BEK is bitlocker encryption key.

    :param secret_url: Secret is BEK.
    :type secret_url: str
    :param secret_vault_id: ID of the Key Vault where this Secret is stored.
    :type secret_vault_id: str
    :param secret_data: BEK data.
    :type secret_data: str
    """

    _attribute_map = {
        'secret_url': {'key': 'secretUrl', 'type': 'str'},
        'secret_vault_id': {'key': 'secretVaultId', 'type': 'str'},
        'secret_data': {'key': 'secretData', 'type': 'str'},
    }

    def __init__(self, *, secret_url: str=None, secret_vault_id: str=None, secret_data: str=None, **kwargs) -> None:
        super(BEKDetails, self).__init__(**kwargs)
        self.secret_url = secret_url
        self.secret_vault_id = secret_vault_id
        self.secret_data = secret_data


class BMSAADPropertiesQueryObject(Model):
    """Filters to list backup items.

    :param backup_management_type: Backup management type for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, **kwargs) -> None:
        super(BMSAADPropertiesQueryObject, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type


class BMSBackupEngineQueryObject(Model):
    """Query parameters to fetch list of backup engines.

    :param expand: attribute to add extended info
    :type expand: str
    """

    _attribute_map = {
        'expand': {'key': 'expand', 'type': 'str'},
    }

    def __init__(self, *, expand: str=None, **kwargs) -> None:
        super(BMSBackupEngineQueryObject, self).__init__(**kwargs)
        self.expand = expand


class BMSBackupEnginesQueryObject(Model):
    """Query parameters to fetch list of backup engines.

    :param backup_management_type: Backup management type for the backup
     engine. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param friendly_name: Friendly name of the backup engine.
    :type friendly_name: str
    :param expand: Attribute to add extended info.
    :type expand: str
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'expand': {'key': 'expand', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, friendly_name: str=None, expand: str=None, **kwargs) -> None:
        super(BMSBackupEnginesQueryObject, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.friendly_name = friendly_name
        self.expand = expand


class BMSBackupSummariesQueryObject(Model):
    """Query parameters to fetch backup summaries.

    :param type: Backup management type for this container. Possible values
     include: 'Invalid', 'BackupProtectedItemCountSummary',
     'BackupProtectionContainerCountSummary'
    :type type: str or ~azure.mgmt.recoveryservicesbackup.models.Type
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(BMSBackupSummariesQueryObject, self).__init__(**kwargs)
        self.type = type


class BMSContainerQueryObject(Model):
    """The query filters that can be used with the list containers API.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Required. Backup management type for this
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param container_type: Type of container for filter. Possible values
     include: 'Invalid', 'Unknown', 'IaasVMContainer',
     'IaasVMServiceContainer', 'DPMContainer', 'AzureBackupServerContainer',
     'MABContainer', 'Cluster', 'AzureSqlContainer', 'Windows', 'VCenter',
     'VMAppContainer', 'SQLAGWorkLoadContainer', 'StorageContainer',
     'GenericContainer'
    :type container_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.ContainerType
    :param backup_engine_name: Backup engine name
    :type backup_engine_name: str
    :param fabric_name: Fabric name for filter
    :type fabric_name: str
    :param status: Status of registration of this container with the Recovery
     Services Vault.
    :type status: str
    :param friendly_name: Friendly name of this container.
    :type friendly_name: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'backup_engine_name': {'key': 'backupEngineName', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type, container_type=None, backup_engine_name: str=None, fabric_name: str=None, status: str=None, friendly_name: str=None, **kwargs) -> None:
        super(BMSContainerQueryObject, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.container_type = container_type
        self.backup_engine_name = backup_engine_name
        self.fabric_name = fabric_name
        self.status = status
        self.friendly_name = friendly_name


class BMSContainersInquiryQueryObject(Model):
    """The query filters that can be used with the inquire container API.

    :param backup_management_type: Backup management type for this container.
     Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Workload type for this container. Possible values
     include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange',
     'Sharepoint', 'VMwareVM', 'SystemState', 'Client', 'GenericDataSource',
     'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, **kwargs) -> None:
        super(BMSContainersInquiryQueryObject, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_type = workload_type


class BMSPOQueryObject(Model):
    """Filters to list items that can be backed up.

    :param backup_management_type: Backup management type. Possible values
     include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM', 'AzureBackupServer',
     'AzureSql', 'AzureStorage', 'AzureWorkload', 'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Workload type. Possible values include: 'Invalid',
     'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange', 'Sharepoint',
     'VMwareVM', 'SystemState', 'Client', 'GenericDataSource', 'SQLDataBase',
     'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param container_name: Full name of the container whose Protectable
     Objects should be returned.
    :type container_name: str
    :param status: Backup status query parameter.
    :type status: str
    :param friendly_name: Friendly name.
    :type friendly_name: str
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, status: str=None, friendly_name: str=None, **kwargs) -> None:
        super(BMSPOQueryObject, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_type = workload_type
        self.container_name = container_name
        self.status = status
        self.friendly_name = friendly_name


class BMSRefreshContainersQueryObject(Model):
    """The query filters that can be used with the refresh container API.

    :param backup_management_type: Backup management type for this container.
     Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, **kwargs) -> None:
        super(BMSRefreshContainersQueryObject, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type


class BMSRPQueryObject(Model):
    """Filters to list backup copies.

    :param start_date: Backup copies created after this time.
    :type start_date: datetime
    :param end_date: Backup copies created before this time.
    :type end_date: datetime
    :param restore_point_query_type: RestorePoint type. Possible values
     include: 'Invalid', 'Full', 'Log', 'Differential', 'FullAndDifferential',
     'All', 'Incremental'
    :type restore_point_query_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointQueryType
    :param extended_info: In Get Recovery Point, it tells whether extended
     information about recovery point is asked.
    :type extended_info: bool
    :param move_ready_rp_only: Whether the RP can be moved to another tier
    :type move_ready_rp_only: bool
    """

    _attribute_map = {
        'start_date': {'key': 'startDate', 'type': 'iso-8601'},
        'end_date': {'key': 'endDate', 'type': 'iso-8601'},
        'restore_point_query_type': {'key': 'restorePointQueryType', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'bool'},
        'move_ready_rp_only': {'key': 'moveReadyRPOnly', 'type': 'bool'},
    }

    def __init__(self, *, start_date=None, end_date=None, restore_point_query_type=None, extended_info: bool=None, move_ready_rp_only: bool=None, **kwargs) -> None:
        super(BMSRPQueryObject, self).__init__(**kwargs)
        self.start_date = start_date
        self.end_date = end_date
        self.restore_point_query_type = restore_point_query_type
        self.extended_info = extended_info
        self.move_ready_rp_only = move_ready_rp_only


class BMSWorkloadItemQueryObject(Model):
    """Filters to list items that can be backed up.

    :param backup_management_type: Backup management type. Possible values
     include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM', 'AzureBackupServer',
     'AzureSql', 'AzureStorage', 'AzureWorkload', 'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_item_type: Workload Item type. Possible values include:
     'Invalid', 'SQLInstance', 'SQLDataBase', 'SAPHanaSystem',
     'SAPHanaDatabase', 'SAPAseSystem', 'SAPAseDatabase'
    :type workload_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadItemType
    :param workload_type: Workload type. Possible values include: 'Invalid',
     'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange', 'Sharepoint',
     'VMwareVM', 'SystemState', 'Client', 'GenericDataSource', 'SQLDataBase',
     'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param protection_status: Backup status query parameter. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, workload_item_type=None, workload_type=None, protection_status=None, **kwargs) -> None:
        super(BMSWorkloadItemQueryObject, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_item_type = workload_item_type
        self.workload_type = workload_type
        self.protection_status = protection_status


class ClientDiscoveryDisplay(Model):
    """Localized display information of an operation.

    :param provider: Name of the provider for display purposes
    :type provider: str
    :param resource: ResourceType for which this Operation can be performed.
    :type resource: str
    :param operation: Operations Name itself.
    :type operation: str
    :param description: Description of the operation having details of what
     operation is about.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(ClientDiscoveryDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ClientDiscoveryForLogSpecification(Model):
    """Class to represent shoebox log specification in json client discovery.

    :param name: Name for shoebox log specification.
    :type name: str
    :param display_name: Localized display name
    :type display_name: str
    :param blob_duration: blob duration of shoebox log specification
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, blob_duration: str=None, **kwargs) -> None:
        super(ClientDiscoveryForLogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ClientDiscoveryForProperties(Model):
    """Class to represent shoebox properties in json client discovery.

    :param service_specification: Operation properties.
    :type service_specification:
     ~azure.mgmt.recoveryservicesbackup.models.ClientDiscoveryForServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ClientDiscoveryForServiceSpecification'},
    }

    def __init__(self, *, service_specification=None, **kwargs) -> None:
        super(ClientDiscoveryForProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class ClientDiscoveryForServiceSpecification(Model):
    """Class to represent shoebox service specification in json client discovery.

    :param log_specifications: List of log specifications of this operation.
    :type log_specifications:
     list[~azure.mgmt.recoveryservicesbackup.models.ClientDiscoveryForLogSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[ClientDiscoveryForLogSpecification]'},
    }

    def __init__(self, *, log_specifications=None, **kwargs) -> None:
        super(ClientDiscoveryForServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = log_specifications


class ClientDiscoveryValueForSingleApi(Model):
    """Available operation details.

    :param name: Name of the Operation.
    :type name: str
    :param display: Contains the localized display information for this
     particular operation
    :type display:
     ~azure.mgmt.recoveryservicesbackup.models.ClientDiscoveryDisplay
    :param origin: The intended executor of the operation;governs the display
     of the operation in the RBAC UX and the audit logs UX
    :type origin: str
    :param properties: ShoeBox properties for the given operation.
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.ClientDiscoveryForProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'ClientDiscoveryDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ClientDiscoveryForProperties'},
    }

    def __init__(self, *, name: str=None, display=None, origin: str=None, properties=None, **kwargs) -> None:
        super(ClientDiscoveryValueForSingleApi, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class ClientScriptForConnect(Model):
    """Client script details for file / folder restore.

    :param script_content: File content of the client script for file / folder
     restore.
    :type script_content: str
    :param script_extension: File extension of the client script for file /
     folder restore - .ps1 , .sh , etc.
    :type script_extension: str
    :param os_type: OS type - Windows, Linux etc. for which this file / folder
     restore client script works.
    :type os_type: str
    :param url: URL of Executable from where to source the content. If this is
     not null then ScriptContent should not be used
    :type url: str
    :param script_name_suffix: Mandatory suffix that should be added to the
     name of script that is given for download to user.
     If its null or empty then , ignore it.
    :type script_name_suffix: str
    """

    _attribute_map = {
        'script_content': {'key': 'scriptContent', 'type': 'str'},
        'script_extension': {'key': 'scriptExtension', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'script_name_suffix': {'key': 'scriptNameSuffix', 'type': 'str'},
    }

    def __init__(self, *, script_content: str=None, script_extension: str=None, os_type: str=None, url: str=None, script_name_suffix: str=None, **kwargs) -> None:
        super(ClientScriptForConnect, self).__init__(**kwargs)
        self.script_content = script_content
        self.script_extension = script_extension
        self.os_type = os_type
        self.url = url
        self.script_name_suffix = script_name_suffix


class CloudError(Model):
    """An error response from the Container Instance service.

    :param error: The error object.
    :type error: ~azure.mgmt.recoveryservicesbackup.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from the Container Instance service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for
     display in a user interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of
     the property in error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details:
     list[~azure.mgmt.recoveryservicesbackup.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.recoveryservicesbackup.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(self, **kwargs) -> None:
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ContainerIdentityInfo(Model):
    """Container identity information.

    :param unique_name: Unique name of the container
    :type unique_name: str
    :param aad_tenant_id: Protection container identity - AAD Tenant
    :type aad_tenant_id: str
    :param service_principal_client_id: Protection container identity - AAD
     Service Principal
    :type service_principal_client_id: str
    :param audience: Protection container identity - Audience
    :type audience: str
    """

    _attribute_map = {
        'unique_name': {'key': 'uniqueName', 'type': 'str'},
        'aad_tenant_id': {'key': 'aadTenantId', 'type': 'str'},
        'service_principal_client_id': {'key': 'servicePrincipalClientId', 'type': 'str'},
        'audience': {'key': 'audience', 'type': 'str'},
    }

    def __init__(self, *, unique_name: str=None, aad_tenant_id: str=None, service_principal_client_id: str=None, audience: str=None, **kwargs) -> None:
        super(ContainerIdentityInfo, self).__init__(**kwargs)
        self.unique_name = unique_name
        self.aad_tenant_id = aad_tenant_id
        self.service_principal_client_id = service_principal_client_id
        self.audience = audience


class CrossRegionRestoreRequest(Model):
    """CrossRegionRestoreRequest.

    :param cross_region_restore_access_details: Access details for cross
     region restore
    :type cross_region_restore_access_details:
     ~azure.mgmt.recoveryservicesbackup.models.CrrAccessToken
    :param restore_request: Request object for triggering restore
    :type restore_request:
     ~azure.mgmt.recoveryservicesbackup.models.RestoreRequest
    """

    _attribute_map = {
        'cross_region_restore_access_details': {'key': 'crossRegionRestoreAccessDetails', 'type': 'CrrAccessToken'},
        'restore_request': {'key': 'restoreRequest', 'type': 'RestoreRequest'},
    }

    def __init__(self, *, cross_region_restore_access_details=None, restore_request=None, **kwargs) -> None:
        super(CrossRegionRestoreRequest, self).__init__(**kwargs)
        self.cross_region_restore_access_details = cross_region_restore_access_details
        self.restore_request = restore_request


class CrossRegionRestoreRequestResource(Resource):
    """CrossRegionRestoreRequestResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: CrossRegionRestoreRequestResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.CrossRegionRestoreRequest
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CrossRegionRestoreRequest'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(CrossRegionRestoreRequestResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class CrrAccessToken(Model):
    """CrrAccessToken.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: WorkloadCrrAccessToken

    All required parameters must be populated in order to send to Azure.

    :param access_token_string: Access token used for authentication
    :type access_token_string: str
    :param subscription_id: Subscription Id of the source vault
    :type subscription_id: str
    :param resource_group_name: Resource Group name of the source vault
    :type resource_group_name: str
    :param resource_name: Resource Name of the source vault
    :type resource_name: str
    :param resource_id: Resource Id of the source vault
    :type resource_id: str
    :param protection_container_id: Protected item container id
    :type protection_container_id: long
    :param recovery_point_id: Recovery Point Id
    :type recovery_point_id: str
    :param recovery_point_time: Recovery Point Time
    :type recovery_point_time: str
    :param container_name: Container Unique name
    :type container_name: str
    :param container_type: Container Type
    :type container_type: str
    :param backup_management_type: Backup Management Type
    :type backup_management_type: str
    :param datasource_type: Datasource Type
    :type datasource_type: str
    :param datasource_name: Datasource Friendly Name
    :type datasource_name: str
    :param datasource_id: Datasource Id
    :type datasource_id: str
    :param datasource_container_name: Datasource Container Unique Name
    :type datasource_container_name: str
    :param coordinator_service_stamp_id: CoordinatorServiceStampId to be used
     by BCM in restore call
    :type coordinator_service_stamp_id: str
    :param coordinator_service_stamp_uri: CoordinatorServiceStampUri to be
     used by BCM in restore call
    :type coordinator_service_stamp_uri: str
    :param protection_service_stamp_id: ProtectionServiceStampId to be used by
     BCM in restore call
    :type protection_service_stamp_id: str
    :param protection_service_stamp_uri: ProtectionServiceStampUri to be used
     by BCM in restore call
    :type protection_service_stamp_uri: str
    :param token_extended_information: Extended Information about the token
     like FileSpec etc.
    :type token_extended_information: str
    :param rp_tier_information: Recovery point Tier Information
    :type rp_tier_information: dict[str, str]
    :param rp_original_sa_option: Recovery point information: Original SA
     option
    :type rp_original_sa_option: bool
    :param rp_is_managed_virtual_machine: Recovery point information: Managed
     virtual machine
    :type rp_is_managed_virtual_machine: bool
    :param rp_vm_size_description: Recovery point information: VM size
     description
    :type rp_vm_size_description: str
    :param b_ms_active_region: Active region name of BMS Stamp
    :type b_ms_active_region: str
    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'access_token_string': {'key': 'accessTokenString', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'protection_container_id': {'key': 'protectionContainerId', 'type': 'long'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'datasource_type': {'key': 'datasourceType', 'type': 'str'},
        'datasource_name': {'key': 'datasourceName', 'type': 'str'},
        'datasource_id': {'key': 'datasourceId', 'type': 'str'},
        'datasource_container_name': {'key': 'datasourceContainerName', 'type': 'str'},
        'coordinator_service_stamp_id': {'key': 'coordinatorServiceStampId', 'type': 'str'},
        'coordinator_service_stamp_uri': {'key': 'coordinatorServiceStampUri', 'type': 'str'},
        'protection_service_stamp_id': {'key': 'protectionServiceStampId', 'type': 'str'},
        'protection_service_stamp_uri': {'key': 'protectionServiceStampUri', 'type': 'str'},
        'token_extended_information': {'key': 'tokenExtendedInformation', 'type': 'str'},
        'rp_tier_information': {'key': 'rpTierInformation', 'type': '{str}'},
        'rp_original_sa_option': {'key': 'rpOriginalSAOption', 'type': 'bool'},
        'rp_is_managed_virtual_machine': {'key': 'rpIsManagedVirtualMachine', 'type': 'bool'},
        'rp_vm_size_description': {'key': 'rpVMSizeDescription', 'type': 'str'},
        'b_ms_active_region': {'key': 'bMSActiveRegion', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'WorkloadCrrAccessToken': 'WorkloadCrrAccessToken'}
    }

    def __init__(self, *, access_token_string: str=None, subscription_id: str=None, resource_group_name: str=None, resource_name: str=None, resource_id: str=None, protection_container_id: int=None, recovery_point_id: str=None, recovery_point_time: str=None, container_name: str=None, container_type: str=None, backup_management_type: str=None, datasource_type: str=None, datasource_name: str=None, datasource_id: str=None, datasource_container_name: str=None, coordinator_service_stamp_id: str=None, coordinator_service_stamp_uri: str=None, protection_service_stamp_id: str=None, protection_service_stamp_uri: str=None, token_extended_information: str=None, rp_tier_information=None, rp_original_sa_option: bool=None, rp_is_managed_virtual_machine: bool=None, rp_vm_size_description: str=None, b_ms_active_region: str=None, **kwargs) -> None:
        super(CrrAccessToken, self).__init__(**kwargs)
        self.access_token_string = access_token_string
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.resource_name = resource_name
        self.resource_id = resource_id
        self.protection_container_id = protection_container_id
        self.recovery_point_id = recovery_point_id
        self.recovery_point_time = recovery_point_time
        self.container_name = container_name
        self.container_type = container_type
        self.backup_management_type = backup_management_type
        self.datasource_type = datasource_type
        self.datasource_name = datasource_name
        self.datasource_id = datasource_id
        self.datasource_container_name = datasource_container_name
        self.coordinator_service_stamp_id = coordinator_service_stamp_id
        self.coordinator_service_stamp_uri = coordinator_service_stamp_uri
        self.protection_service_stamp_id = protection_service_stamp_id
        self.protection_service_stamp_uri = protection_service_stamp_uri
        self.token_extended_information = token_extended_information
        self.rp_tier_information = rp_tier_information
        self.rp_original_sa_option = rp_original_sa_option
        self.rp_is_managed_virtual_machine = rp_is_managed_virtual_machine
        self.rp_vm_size_description = rp_vm_size_description
        self.b_ms_active_region = b_ms_active_region
        self.object_type = None


class CrrAccessTokenResource(Resource):
    """CrrAccessTokenResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: CrrAccessTokenResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.CrrAccessToken
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CrrAccessToken'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(CrrAccessTokenResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class CrrJobRequest(Model):
    """Request object for fetching CRR jobs.

    :param resource_id: Entire ARM resource id of the resource
    :type resource_id: str
    :param job_name: Job Name of the job to be fetched
    :type job_name: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'job_name': {'key': 'jobName', 'type': 'str'},
    }

    def __init__(self, *, resource_id: str=None, job_name: str=None, **kwargs) -> None:
        super(CrrJobRequest, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.job_name = job_name


class CrrJobRequestResource(Resource):
    """Request object for fetching CRR jobs.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: CrrJobRequestResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.CrrJobRequest
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CrrJobRequest'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(CrrJobRequestResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class DailyRetentionFormat(Model):
    """Daily retention format.

    :param days_of_the_month: List of days of the month.
    :type days_of_the_month:
     list[~azure.mgmt.recoveryservicesbackup.models.Day]
    """

    _attribute_map = {
        'days_of_the_month': {'key': 'daysOfTheMonth', 'type': '[Day]'},
    }

    def __init__(self, *, days_of_the_month=None, **kwargs) -> None:
        super(DailyRetentionFormat, self).__init__(**kwargs)
        self.days_of_the_month = days_of_the_month


class DailyRetentionSchedule(Model):
    """Daily retention schedule.

    :param retention_times: Retention times of retention policy.
    :type retention_times: list[datetime]
    :param retention_duration: Retention duration of retention Policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _attribute_map = {
        'retention_times': {'key': 'retentionTimes', 'type': '[iso-8601]'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, *, retention_times=None, retention_duration=None, **kwargs) -> None:
        super(DailyRetentionSchedule, self).__init__(**kwargs)
        self.retention_times = retention_times
        self.retention_duration = retention_duration


class Day(Model):
    """Day of the week.

    :param date_property: Date of the month
    :type date_property: int
    :param is_last: Whether Date is last date of month
    :type is_last: bool
    """

    _attribute_map = {
        'date_property': {'key': 'date', 'type': 'int'},
        'is_last': {'key': 'isLast', 'type': 'bool'},
    }

    def __init__(self, *, date_property: int=None, is_last: bool=None, **kwargs) -> None:
        super(Day, self).__init__(**kwargs)
        self.date_property = date_property
        self.is_last = is_last


class DiskExclusionProperties(Model):
    """DiskExclusionProperties.

    :param disk_lun_list: List of Disks' Logical Unit Numbers (LUN) to be used
     for VM Protection.
    :type disk_lun_list: list[int]
    :param is_inclusion_list: Flag to indicate whether DiskLunList is to be
     included/ excluded from backup.
    :type is_inclusion_list: bool
    """

    _attribute_map = {
        'disk_lun_list': {'key': 'diskLunList', 'type': '[int]'},
        'is_inclusion_list': {'key': 'isInclusionList', 'type': 'bool'},
    }

    def __init__(self, *, disk_lun_list=None, is_inclusion_list: bool=None, **kwargs) -> None:
        super(DiskExclusionProperties, self).__init__(**kwargs)
        self.disk_lun_list = disk_lun_list
        self.is_inclusion_list = is_inclusion_list


class DiskInformation(Model):
    """Disk information.

    :param lun:
    :type lun: int
    :param name:
    :type name: str
    """

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, lun: int=None, name: str=None, **kwargs) -> None:
        super(DiskInformation, self).__init__(**kwargs)
        self.lun = lun
        self.name = name


class DistributedNodesInfo(Model):
    """This is used to represent the various nodes of the distributed container.

    :param node_name: Name of the node under a distributed container.
    :type node_name: str
    :param status: Status of this Node.
     Failed | Succeeded
    :type status: str
    :param error_detail: Error Details if the Status is non-success.
    :type error_detail: ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    """

    _attribute_map = {
        'node_name': {'key': 'nodeName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error_detail': {'key': 'errorDetail', 'type': 'ErrorDetail'},
    }

    def __init__(self, *, node_name: str=None, status: str=None, error_detail=None, **kwargs) -> None:
        super(DistributedNodesInfo, self).__init__(**kwargs)
        self.node_name = node_name
        self.status = status
        self.error_detail = error_detail


class DpmBackupEngine(BackupEngineBase):
    """Data Protection Manager (DPM) specific backup engine.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the backup engine.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the backup
     engine. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Registration status of the backup engine with
     the Recovery Services Vault.
    :type registration_status: str
    :param backup_engine_state: Status of the backup engine with the Recovery
     Services Vault. = {Active/Deleting/DeleteFailed}
    :type backup_engine_state: str
    :param health_status: Backup status of the backup engine.
    :type health_status: str
    :param can_re_register: Flag indicating if the backup engine be
     registered, once already registered.
    :type can_re_register: bool
    :param backup_engine_id: ID of the backup engine.
    :type backup_engine_id: str
    :param dpm_version: Backup engine version
    :type dpm_version: str
    :param azure_backup_agent_version: Backup agent version
    :type azure_backup_agent_version: str
    :param is_azure_backup_agent_upgrade_available: To check if backup agent
     upgrade available
    :type is_azure_backup_agent_upgrade_available: bool
    :param is_dpm_upgrade_available: To check if backup engine upgrade
     available
    :type is_dpm_upgrade_available: bool
    :param extended_info: Extended info of the backupengine
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.BackupEngineExtendedInfo
    :param backup_engine_type: Required. Constant filled by server.
    :type backup_engine_type: str
    """

    _validation = {
        'backup_engine_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'backup_engine_state': {'key': 'backupEngineState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'backup_engine_id': {'key': 'backupEngineId', 'type': 'str'},
        'dpm_version': {'key': 'dpmVersion', 'type': 'str'},
        'azure_backup_agent_version': {'key': 'azureBackupAgentVersion', 'type': 'str'},
        'is_azure_backup_agent_upgrade_available': {'key': 'isAzureBackupAgentUpgradeAvailable', 'type': 'bool'},
        'is_dpm_upgrade_available': {'key': 'isDpmUpgradeAvailable', 'type': 'bool'},
        'extended_info': {'key': 'extendedInfo', 'type': 'BackupEngineExtendedInfo'},
        'backup_engine_type': {'key': 'backupEngineType', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, backup_engine_state: str=None, health_status: str=None, can_re_register: bool=None, backup_engine_id: str=None, dpm_version: str=None, azure_backup_agent_version: str=None, is_azure_backup_agent_upgrade_available: bool=None, is_dpm_upgrade_available: bool=None, extended_info=None, **kwargs) -> None:
        super(DpmBackupEngine, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, backup_engine_state=backup_engine_state, health_status=health_status, can_re_register=can_re_register, backup_engine_id=backup_engine_id, dpm_version=dpm_version, azure_backup_agent_version=azure_backup_agent_version, is_azure_backup_agent_upgrade_available=is_azure_backup_agent_upgrade_available, is_dpm_upgrade_available=is_dpm_upgrade_available, extended_info=extended_info, **kwargs)
        self.backup_engine_type = 'DpmBackupEngine'


class DPMContainerExtendedInfo(Model):
    """Additional information of the DPMContainer.

    :param last_refreshed_at: Last refresh time of the DPMContainer.
    :type last_refreshed_at: datetime
    """

    _attribute_map = {
        'last_refreshed_at': {'key': 'lastRefreshedAt', 'type': 'iso-8601'},
    }

    def __init__(self, *, last_refreshed_at=None, **kwargs) -> None:
        super(DPMContainerExtendedInfo, self).__init__(**kwargs)
        self.last_refreshed_at = last_refreshed_at


class DpmErrorInfo(Model):
    """DPM workload-specific error information.

    :param error_string: Localized error string.
    :type error_string: str
    :param recommendations: List of localized recommendations for above error
     code.
    :type recommendations: list[str]
    """

    _attribute_map = {
        'error_string': {'key': 'errorString', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, *, error_string: str=None, recommendations=None, **kwargs) -> None:
        super(DpmErrorInfo, self).__init__(**kwargs)
        self.error_string = error_string
        self.recommendations = recommendations


class DpmJob(Job):
    """DPM workload-specific job object.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param duration: Time elapsed for job.
    :type duration: timedelta
    :param dpm_server_name: DPM server name managing the backup item or backup
     job.
    :type dpm_server_name: str
    :param container_name: Name of cluster/server protecting current backup
     item, if any.
    :type container_name: str
    :param container_type: Type of container.
    :type container_type: str
    :param workload_type: Type of backup item.
    :type workload_type: str
    :param actions_info: The state/actions applicable on this job like
     cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param error_details: The errors.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.DpmErrorInfo]
    :param extended_info: Additional information for this job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.DpmJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'dpm_server_name': {'key': 'dpmServerName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'error_details': {'key': 'errorDetails', 'type': '[DpmErrorInfo]'},
        'extended_info': {'key': 'extendedInfo', 'type': 'DpmJobExtendedInfo'},
    }

    def __init__(self, *, entity_friendly_name: str=None, backup_management_type=None, operation: str=None, status: str=None, start_time=None, end_time=None, activity_id: str=None, duration=None, dpm_server_name: str=None, container_name: str=None, container_type: str=None, workload_type: str=None, actions_info=None, error_details=None, extended_info=None, **kwargs) -> None:
        super(DpmJob, self).__init__(entity_friendly_name=entity_friendly_name, backup_management_type=backup_management_type, operation=operation, status=status, start_time=start_time, end_time=end_time, activity_id=activity_id, **kwargs)
        self.duration = duration
        self.dpm_server_name = dpm_server_name
        self.container_name = container_name
        self.container_type = container_type
        self.workload_type = workload_type
        self.actions_info = actions_info
        self.error_details = error_details
        self.extended_info = extended_info
        self.job_type = 'DpmJob'


class DpmJobExtendedInfo(Model):
    """Additional information on the DPM workload-specific job.

    :param tasks_list: List of tasks associated with this job.
    :type tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.models.DpmJobTaskDetails]
    :param property_bag: The job properties.
    :type property_bag: dict[str, str]
    :param dynamic_error_message: Non localized error message on job
     execution.
    :type dynamic_error_message: str
    """

    _attribute_map = {
        'tasks_list': {'key': 'tasksList', 'type': '[DpmJobTaskDetails]'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'dynamic_error_message': {'key': 'dynamicErrorMessage', 'type': 'str'},
    }

    def __init__(self, *, tasks_list=None, property_bag=None, dynamic_error_message: str=None, **kwargs) -> None:
        super(DpmJobExtendedInfo, self).__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class DpmJobTaskDetails(Model):
    """DPM workload-specific job task details.

    :param task_id: The task display name.
    :type task_id: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param duration: Time elapsed for task.
    :type duration: timedelta
    :param status: The status.
    :type status: str
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, task_id: str=None, start_time=None, end_time=None, duration=None, status: str=None, **kwargs) -> None:
        super(DpmJobTaskDetails, self).__init__(**kwargs)
        self.task_id = task_id
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.status = status


class DPMProtectedItem(ProtectedItem):
    """Additional information on Backup engine specific backup item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the managed item
    :type friendly_name: str
    :param backup_engine_name: Backup Management server protecting this backup
     item
    :type backup_engine_name: str
    :param protection_state: Protection state of the backup engine. Possible
     values include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemState
    :param extended_info: Extended info of the backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.DPMProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_engine_name': {'key': 'backupEngineName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'DPMProtectedItemExtendedInfo'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, backup_engine_name: str=None, protection_state=None, extended_info=None, **kwargs) -> None:
        super(DPMProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, **kwargs)
        self.friendly_name = friendly_name
        self.backup_engine_name = backup_engine_name
        self.protection_state = protection_state
        self.extended_info = extended_info
        self.protected_item_type = 'DPMProtectedItem'


class DPMProtectedItemExtendedInfo(Model):
    """Additional information of DPM Protected item.

    :param protectable_object_load_path: Attribute to provide information on
     various DBs.
    :type protectable_object_load_path: dict[str, str]
    :param protected: To check if backup item is disk protected.
    :type protected: bool
    :param is_present_on_cloud: To check if backup item is cloud protected.
    :type is_present_on_cloud: bool
    :param last_backup_status: Last backup status information on backup item.
    :type last_backup_status: str
    :param last_refreshed_at: Last refresh time on backup item.
    :type last_refreshed_at: datetime
    :param oldest_recovery_point: Oldest cloud recovery point time.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: cloud recovery point count.
    :type recovery_point_count: int
    :param on_premise_oldest_recovery_point: Oldest disk recovery point time.
    :type on_premise_oldest_recovery_point: datetime
    :param on_premise_latest_recovery_point: latest disk recovery point time.
    :type on_premise_latest_recovery_point: datetime
    :param on_premise_recovery_point_count: disk recovery point count.
    :type on_premise_recovery_point_count: int
    :param is_collocated: To check if backup item is collocated.
    :type is_collocated: bool
    :param protection_group_name: Protection group name of the backup item.
    :type protection_group_name: str
    :param disk_storage_used_in_bytes: Used Disk storage in bytes.
    :type disk_storage_used_in_bytes: str
    :param total_disk_storage_size_in_bytes: total Disk storage in bytes.
    :type total_disk_storage_size_in_bytes: str
    """

    _attribute_map = {
        'protectable_object_load_path': {'key': 'protectableObjectLoadPath', 'type': '{str}'},
        'protected': {'key': 'protected', 'type': 'bool'},
        'is_present_on_cloud': {'key': 'isPresentOnCloud', 'type': 'bool'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_refreshed_at': {'key': 'lastRefreshedAt', 'type': 'iso-8601'},
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'on_premise_oldest_recovery_point': {'key': 'onPremiseOldestRecoveryPoint', 'type': 'iso-8601'},
        'on_premise_latest_recovery_point': {'key': 'onPremiseLatestRecoveryPoint', 'type': 'iso-8601'},
        'on_premise_recovery_point_count': {'key': 'onPremiseRecoveryPointCount', 'type': 'int'},
        'is_collocated': {'key': 'isCollocated', 'type': 'bool'},
        'protection_group_name': {'key': 'protectionGroupName', 'type': 'str'},
        'disk_storage_used_in_bytes': {'key': 'diskStorageUsedInBytes', 'type': 'str'},
        'total_disk_storage_size_in_bytes': {'key': 'totalDiskStorageSizeInBytes', 'type': 'str'},
    }

    def __init__(self, *, protectable_object_load_path=None, protected: bool=None, is_present_on_cloud: bool=None, last_backup_status: str=None, last_refreshed_at=None, oldest_recovery_point=None, recovery_point_count: int=None, on_premise_oldest_recovery_point=None, on_premise_latest_recovery_point=None, on_premise_recovery_point_count: int=None, is_collocated: bool=None, protection_group_name: str=None, disk_storage_used_in_bytes: str=None, total_disk_storage_size_in_bytes: str=None, **kwargs) -> None:
        super(DPMProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.protectable_object_load_path = protectable_object_load_path
        self.protected = protected
        self.is_present_on_cloud = is_present_on_cloud
        self.last_backup_status = last_backup_status
        self.last_refreshed_at = last_refreshed_at
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.on_premise_oldest_recovery_point = on_premise_oldest_recovery_point
        self.on_premise_latest_recovery_point = on_premise_latest_recovery_point
        self.on_premise_recovery_point_count = on_premise_recovery_point_count
        self.is_collocated = is_collocated
        self.protection_group_name = protection_group_name
        self.disk_storage_used_in_bytes = disk_storage_used_in_bytes
        self.total_disk_storage_size_in_bytes = total_disk_storage_size_in_bytes


class EncryptionDetails(Model):
    """Details needed if the VM was encrypted at the time of backup.

    :param encryption_enabled: Identifies whether this backup copy represents
     an encrypted VM at the time of backup.
    :type encryption_enabled: bool
    :param kek_url: Key Url.
    :type kek_url: str
    :param secret_key_url: Secret Url.
    :type secret_key_url: str
    :param kek_vault_id: ID of Key Vault where KEK is stored.
    :type kek_vault_id: str
    :param secret_key_vault_id: ID of Key Vault where Secret is stored.
    :type secret_key_vault_id: str
    """

    _attribute_map = {
        'encryption_enabled': {'key': 'encryptionEnabled', 'type': 'bool'},
        'kek_url': {'key': 'kekUrl', 'type': 'str'},
        'secret_key_url': {'key': 'secretKeyUrl', 'type': 'str'},
        'kek_vault_id': {'key': 'kekVaultId', 'type': 'str'},
        'secret_key_vault_id': {'key': 'secretKeyVaultId', 'type': 'str'},
    }

    def __init__(self, *, encryption_enabled: bool=None, kek_url: str=None, secret_key_url: str=None, kek_vault_id: str=None, secret_key_vault_id: str=None, **kwargs) -> None:
        super(EncryptionDetails, self).__init__(**kwargs)
        self.encryption_enabled = encryption_enabled
        self.kek_url = kek_url
        self.secret_key_url = secret_key_url
        self.kek_vault_id = kek_vault_id
        self.secret_key_vault_id = secret_key_vault_id


class ErrorAdditionalInfo(Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(Model):
    """Error Detail class which encapsulates Code, Message and Recommendations.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error Message related to the Code.
    :vartype message: str
    :ivar recommendations: List of recommendation strings.
    :vartype recommendations: list[str]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'recommendations': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.recommendations = None


class OperationResultInfoBase(Model):
    """Base class for operation result info.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ExportJobsOperationResultInfo, OperationResultInfo

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'ExportJobsOperationResultInfo': 'ExportJobsOperationResultInfo', 'OperationResultInfo': 'OperationResultInfo'}
    }

    def __init__(self, **kwargs) -> None:
        super(OperationResultInfoBase, self).__init__(**kwargs)
        self.object_type = None


class ExportJobsOperationResultInfo(OperationResultInfoBase):
    """This class is used to send blob details after exporting jobs.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param blob_url: URL of the blob into which the serialized string of list
     of jobs is exported.
    :type blob_url: str
    :param blob_sas_key: SAS key to access the blob. It expires in 15 mins.
    :type blob_sas_key: str
    :param excel_file_blob_url: URL of the blob into which the ExcelFile is
     uploaded.
    :type excel_file_blob_url: str
    :param excel_file_blob_sas_key: SAS key to access the blob. It expires in
     15 mins.
    :type excel_file_blob_sas_key: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'blob_url': {'key': 'blobUrl', 'type': 'str'},
        'blob_sas_key': {'key': 'blobSasKey', 'type': 'str'},
        'excel_file_blob_url': {'key': 'excelFileBlobUrl', 'type': 'str'},
        'excel_file_blob_sas_key': {'key': 'excelFileBlobSasKey', 'type': 'str'},
    }

    def __init__(self, *, blob_url: str=None, blob_sas_key: str=None, excel_file_blob_url: str=None, excel_file_blob_sas_key: str=None, **kwargs) -> None:
        super(ExportJobsOperationResultInfo, self).__init__(**kwargs)
        self.blob_url = blob_url
        self.blob_sas_key = blob_sas_key
        self.excel_file_blob_url = excel_file_blob_url
        self.excel_file_blob_sas_key = excel_file_blob_sas_key
        self.object_type = 'ExportJobsOperationResultInfo'


class ExtendedProperties(Model):
    """Extended Properties for Azure IaasVM Backup.

    :param disk_exclusion_properties: Extended Properties for Disk Exclusion.
    :type disk_exclusion_properties:
     ~azure.mgmt.recoveryservicesbackup.models.DiskExclusionProperties
    """

    _attribute_map = {
        'disk_exclusion_properties': {'key': 'diskExclusionProperties', 'type': 'DiskExclusionProperties'},
    }

    def __init__(self, *, disk_exclusion_properties=None, **kwargs) -> None:
        super(ExtendedProperties, self).__init__(**kwargs)
        self.disk_exclusion_properties = disk_exclusion_properties


class GenericContainer(ProtectionContainer):
    """Base class for generic container of backup items.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param fabric_name: Name of the container's fabric
    :type fabric_name: str
    :param extended_information: Extended information (not returned in List
     container API calls)
    :type extended_information:
     ~azure.mgmt.recoveryservicesbackup.models.GenericContainerExtendedInfo
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'extended_information': {'key': 'extendedInformation', 'type': 'GenericContainerExtendedInfo'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, fabric_name: str=None, extended_information=None, **kwargs) -> None:
        super(GenericContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, **kwargs)
        self.fabric_name = fabric_name
        self.extended_information = extended_information
        self.container_type = 'GenericContainer'


class GenericContainerExtendedInfo(Model):
    """Container extended information.

    :param raw_cert_data: Public key of container cert
    :type raw_cert_data: str
    :param container_identity_info: Container identity information
    :type container_identity_info:
     ~azure.mgmt.recoveryservicesbackup.models.ContainerIdentityInfo
    :param service_endpoints: Azure Backup Service Endpoints for the container
    :type service_endpoints: dict[str, str]
    """

    _attribute_map = {
        'raw_cert_data': {'key': 'rawCertData', 'type': 'str'},
        'container_identity_info': {'key': 'containerIdentityInfo', 'type': 'ContainerIdentityInfo'},
        'service_endpoints': {'key': 'serviceEndpoints', 'type': '{str}'},
    }

    def __init__(self, *, raw_cert_data: str=None, container_identity_info=None, service_endpoints=None, **kwargs) -> None:
        super(GenericContainerExtendedInfo, self).__init__(**kwargs)
        self.raw_cert_data = raw_cert_data
        self.container_identity_info = container_identity_info
        self.service_endpoints = service_endpoints


class GenericProtectedItem(ProtectedItem):
    """Base class for backup items.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param policy_state: Indicates consistency of policy object and policy
     applied to this backup item.
    :type policy_state: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param protected_item_id: Data Plane Service ID of the protected item.
    :type protected_item_id: long
    :param source_associations: Loosely coupled (type, value) associations
     (example - parent of a protected item)
    :type source_associations: dict[str, str]
    :param fabric_name: Name of this backup item's fabric.
    :type fabric_name: str
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'policy_state': {'key': 'policyState', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protected_item_id': {'key': 'protectedItemId', 'type': 'long'},
        'source_associations': {'key': 'sourceAssociations', 'type': '{str}'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, policy_state: str=None, protection_state=None, protected_item_id: int=None, source_associations=None, fabric_name: str=None, **kwargs) -> None:
        super(GenericProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, **kwargs)
        self.friendly_name = friendly_name
        self.policy_state = policy_state
        self.protection_state = protection_state
        self.protected_item_id = protected_item_id
        self.source_associations = source_associations
        self.fabric_name = fabric_name
        self.protected_item_type = 'GenericProtectedItem'


class GenericProtectionPolicy(ProtectionPolicy):
    """Azure VM (Mercury) workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param sub_protection_policy: List of sub-protection policies which
     includes schedule and retention
    :type sub_protection_policy:
     list[~azure.mgmt.recoveryservicesbackup.models.SubProtectionPolicy]
    :param time_zone: TimeZone optional input as string. For example: TimeZone
     = "Pacific Standard Time".
    :type time_zone: str
    :param fabric_name: Name of this policy's fabric.
    :type fabric_name: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'sub_protection_policy': {'key': 'subProtectionPolicy', 'type': '[SubProtectionPolicy]'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
    }

    def __init__(self, *, protected_items_count: int=None, sub_protection_policy=None, time_zone: str=None, fabric_name: str=None, **kwargs) -> None:
        super(GenericProtectionPolicy, self).__init__(protected_items_count=protected_items_count, **kwargs)
        self.sub_protection_policy = sub_protection_policy
        self.time_zone = time_zone
        self.fabric_name = fabric_name
        self.backup_management_type = 'GenericProtectionPolicy'


class GenericRecoveryPoint(RecoveryPoint):
    """Generic backup copy.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param friendly_name: Friendly name of the backup copy.
    :type friendly_name: str
    :param recovery_point_type: Type of the backup copy.
    :type recovery_point_type: str
    :param recovery_point_time: Time at which this backup copy was created.
    :type recovery_point_time: datetime
    :param recovery_point_additional_info: Additional information associated
     with this backup copy.
    :type recovery_point_additional_info: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
        'recovery_point_additional_info': {'key': 'recoveryPointAdditionalInfo', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, recovery_point_type: str=None, recovery_point_time=None, recovery_point_additional_info: str=None, **kwargs) -> None:
        super(GenericRecoveryPoint, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.recovery_point_type = recovery_point_type
        self.recovery_point_time = recovery_point_time
        self.recovery_point_additional_info = recovery_point_additional_info
        self.object_type = 'GenericRecoveryPoint'


class GetProtectedItemQueryObject(Model):
    """Filters to list backup items.

    :param expand: Specifies if the additional information should be provided
     for this item.
    :type expand: str
    """

    _attribute_map = {
        'expand': {'key': 'expand', 'type': 'str'},
    }

    def __init__(self, *, expand: str=None, **kwargs) -> None:
        super(GetProtectedItemQueryObject, self).__init__(**kwargs)
        self.expand = expand


class IaasVMBackupRequest(BackupRequest):
    """IaaS VM workload-specific backup request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_expiry_time_in_utc: Backup copy will expire after
     the time specified (UTC).
    :type recovery_point_expiry_time_in_utc: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_expiry_time_in_utc': {'key': 'recoveryPointExpiryTimeInUTC', 'type': 'iso-8601'},
    }

    def __init__(self, *, recovery_point_expiry_time_in_utc=None, **kwargs) -> None:
        super(IaasVMBackupRequest, self).__init__(**kwargs)
        self.recovery_point_expiry_time_in_utc = recovery_point_expiry_time_in_utc
        self.object_type = 'IaasVMBackupRequest'


class IaasVMILRRegistrationRequest(ILRRequest):
    """Restore files/folders from a backup copy of IaaS VM.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_id: ID of the IaaS VM backup copy from where the
     files/folders have to be restored.
    :type recovery_point_id: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine
     whose the files / folders have to be restored.
    :type virtual_machine_id: str
    :param initiator_name: iSCSI initiator name.
    :type initiator_name: str
    :param renew_existing_registration: Whether to renew existing registration
     with the iSCSI server.
    :type renew_existing_registration: bool
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'initiator_name': {'key': 'initiatorName', 'type': 'str'},
        'renew_existing_registration': {'key': 'renewExistingRegistration', 'type': 'bool'},
    }

    def __init__(self, *, recovery_point_id: str=None, virtual_machine_id: str=None, initiator_name: str=None, renew_existing_registration: bool=None, **kwargs) -> None:
        super(IaasVMILRRegistrationRequest, self).__init__(**kwargs)
        self.recovery_point_id = recovery_point_id
        self.virtual_machine_id = virtual_machine_id
        self.initiator_name = initiator_name
        self.renew_existing_registration = renew_existing_registration
        self.object_type = 'IaasVMILRRegistrationRequest'


class IaasVMRecoveryPoint(RecoveryPoint):
    """IaaS VM workload specific backup copy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_type: Type of the backup copy.
    :vartype recovery_point_type: str
    :ivar recovery_point_time: Time at which this backup copy was created.
    :vartype recovery_point_time: datetime
    :ivar recovery_point_additional_info: Additional information associated
     with this backup copy.
    :vartype recovery_point_additional_info: str
    :ivar source_vm_storage_type: Storage type of the VM whose backup copy is
     created.
    :vartype source_vm_storage_type: str
    :ivar is_source_vm_encrypted: Identifies whether the VM was encrypted when
     the backup copy is created.
    :vartype is_source_vm_encrypted: bool
    :param key_and_secret: Required details for recovering an encrypted VM.
     Applicable only when IsSourceVMEncrypted is true.
    :type key_and_secret:
     ~azure.mgmt.recoveryservicesbackup.models.KeyAndSecretDetails
    :param is_instant_ilr_session_active: Is the session to recover items from
     this backup copy still active.
    :type is_instant_ilr_session_active: bool
    :param recovery_point_tier_details: Recovery point tier information.
    :type recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierInformation]
    :param is_managed_virtual_machine: Whether VM is with Managed Disks
    :type is_managed_virtual_machine: bool
    :param virtual_machine_size: Virtual Machine Size
    :type virtual_machine_size: str
    :param original_storage_account_option: Original Storage Account Option
    :type original_storage_account_option: bool
    :param os_type: OS type
    :type os_type: str
    :param recovery_point_disk_configuration: Disk configuration
    :type recovery_point_disk_configuration:
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointDiskConfiguration
    :param zones: Identifies the zone of the VM at the time of backup.
     Applicable only for zone-pinned Vms
    :type zones: list[str]
    :param recovery_point_move_readiness_info: Eligibility of RP to be moved
     to another tier
    :type recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointMoveReadinessInfo]
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_type': {'readonly': True},
        'recovery_point_time': {'readonly': True},
        'recovery_point_additional_info': {'readonly': True},
        'source_vm_storage_type': {'readonly': True},
        'is_source_vm_encrypted': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
        'recovery_point_additional_info': {'key': 'recoveryPointAdditionalInfo', 'type': 'str'},
        'source_vm_storage_type': {'key': 'sourceVMStorageType', 'type': 'str'},
        'is_source_vm_encrypted': {'key': 'isSourceVMEncrypted', 'type': 'bool'},
        'key_and_secret': {'key': 'keyAndSecret', 'type': 'KeyAndSecretDetails'},
        'is_instant_ilr_session_active': {'key': 'isInstantIlrSessionActive', 'type': 'bool'},
        'recovery_point_tier_details': {'key': 'recoveryPointTierDetails', 'type': '[RecoveryPointTierInformation]'},
        'is_managed_virtual_machine': {'key': 'isManagedVirtualMachine', 'type': 'bool'},
        'virtual_machine_size': {'key': 'virtualMachineSize', 'type': 'str'},
        'original_storage_account_option': {'key': 'originalStorageAccountOption', 'type': 'bool'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'recovery_point_disk_configuration': {'key': 'recoveryPointDiskConfiguration', 'type': 'RecoveryPointDiskConfiguration'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'recovery_point_move_readiness_info': {'key': 'recoveryPointMoveReadinessInfo', 'type': '{RecoveryPointMoveReadinessInfo}'},
    }

    def __init__(self, *, key_and_secret=None, is_instant_ilr_session_active: bool=None, recovery_point_tier_details=None, is_managed_virtual_machine: bool=None, virtual_machine_size: str=None, original_storage_account_option: bool=None, os_type: str=None, recovery_point_disk_configuration=None, zones=None, recovery_point_move_readiness_info=None, **kwargs) -> None:
        super(IaasVMRecoveryPoint, self).__init__(**kwargs)
        self.recovery_point_type = None
        self.recovery_point_time = None
        self.recovery_point_additional_info = None
        self.source_vm_storage_type = None
        self.is_source_vm_encrypted = None
        self.key_and_secret = key_and_secret
        self.is_instant_ilr_session_active = is_instant_ilr_session_active
        self.recovery_point_tier_details = recovery_point_tier_details
        self.is_managed_virtual_machine = is_managed_virtual_machine
        self.virtual_machine_size = virtual_machine_size
        self.original_storage_account_option = original_storage_account_option
        self.os_type = os_type
        self.recovery_point_disk_configuration = recovery_point_disk_configuration
        self.zones = zones
        self.recovery_point_move_readiness_info = recovery_point_move_readiness_info
        self.object_type = 'IaasVMRecoveryPoint'


class IaasVMRestoreRequest(RestoreRequest):
    """IaaS VM workload-specific restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: IaasVMRestoreWithRehydrationRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_id: ID of the backup copy to be recovered.
    :type recovery_point_id: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM which is being
     recovered.
    :type source_resource_id: str
    :param target_virtual_machine_id: This is the complete ARM Id of the VM
     that will be created.
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param target_resource_group_id: This is the ARM Id of the resource group
     that you want to create for this Virtual machine and other artifacts.
     For e.g. /subscriptions/{subId}/resourcegroups/{rg}
    :type target_resource_group_id: str
    :param storage_account_id: Fully qualified ARM ID of the storage account
     to which the VM has to be restored.
    :type storage_account_id: str
    :param virtual_network_id: This is the virtual network Id of the vnet that
     will be attached to the virtual machine.
     User will be validated for join action permissions in the linked access.
    :type virtual_network_id: str
    :param subnet_id: Subnet ID, is the subnet ID associated with the to be
     restored VM. For Classic VMs it would be
     {VnetID}/Subnet/{SubnetName} and, for the Azure Resource Manager VMs it
     would be ARM resource ID used to represent
     the subnet.
    :type subnet_id: str
    :param target_domain_name_id: Fully qualified ARM ID of the domain name to
     be associated to the VM being restored. This applies only to Classic
     Virtual Machines.
    :type target_domain_name_id: str
    :param region: Region in which the virtual machine is restored.
    :type region: str
    :param affinity_group: Affinity group associated to VM to be restored.
     Used only for Classic Compute Virtual Machines.
    :type affinity_group: str
    :param create_new_cloud_service: Should a new cloud service be created
     while restoring the VM. If this is false, VM will be restored to the same
     cloud service as it was at the time of backup.
    :type create_new_cloud_service: bool
    :param original_storage_account_option: Original Storage Account Option
    :type original_storage_account_option: bool
    :param encryption_details: Details needed if the VM was encrypted at the
     time of backup.
    :type encryption_details:
     ~azure.mgmt.recoveryservicesbackup.models.EncryptionDetails
    :param restore_disk_lun_list: List of Disk LUNs for partial restore
    :type restore_disk_lun_list: list[int]
    :param restore_with_managed_disks: Flag to denote of an Unmanaged disk VM
     should be restored with Managed disks.
    :type restore_with_managed_disks: bool
    :param disk_encryption_set_id: DiskEncryptionSet's ID - needed if the VM
     needs to be encrypted at rest during restore with customer managed key.
    :type disk_encryption_set_id: str
    :param zones: Target zone where the VM and its disks should be restored.
    :type zones: list[str]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'target_resource_group_id': {'key': 'targetResourceGroupId', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'virtual_network_id': {'key': 'virtualNetworkId', 'type': 'str'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'target_domain_name_id': {'key': 'targetDomainNameId', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'affinity_group': {'key': 'affinityGroup', 'type': 'str'},
        'create_new_cloud_service': {'key': 'createNewCloudService', 'type': 'bool'},
        'original_storage_account_option': {'key': 'originalStorageAccountOption', 'type': 'bool'},
        'encryption_details': {'key': 'encryptionDetails', 'type': 'EncryptionDetails'},
        'restore_disk_lun_list': {'key': 'restoreDiskLunList', 'type': '[int]'},
        'restore_with_managed_disks': {'key': 'restoreWithManagedDisks', 'type': 'bool'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    _subtype_map = {
        'object_type': {'IaasVMRestoreWithRehydrationRequest': 'IaasVMRestoreWithRehydrationRequest'}
    }

    def __init__(self, *, recovery_point_id: str=None, recovery_type=None, source_resource_id: str=None, target_virtual_machine_id: str=None, target_resource_group_id: str=None, storage_account_id: str=None, virtual_network_id: str=None, subnet_id: str=None, target_domain_name_id: str=None, region: str=None, affinity_group: str=None, create_new_cloud_service: bool=None, original_storage_account_option: bool=None, encryption_details=None, restore_disk_lun_list=None, restore_with_managed_disks: bool=None, disk_encryption_set_id: str=None, zones=None, **kwargs) -> None:
        super(IaasVMRestoreRequest, self).__init__(**kwargs)
        self.recovery_point_id = recovery_point_id
        self.recovery_type = recovery_type
        self.source_resource_id = source_resource_id
        self.target_virtual_machine_id = target_virtual_machine_id
        self.target_resource_group_id = target_resource_group_id
        self.storage_account_id = storage_account_id
        self.virtual_network_id = virtual_network_id
        self.subnet_id = subnet_id
        self.target_domain_name_id = target_domain_name_id
        self.region = region
        self.affinity_group = affinity_group
        self.create_new_cloud_service = create_new_cloud_service
        self.original_storage_account_option = original_storage_account_option
        self.encryption_details = encryption_details
        self.restore_disk_lun_list = restore_disk_lun_list
        self.restore_with_managed_disks = restore_with_managed_disks
        self.disk_encryption_set_id = disk_encryption_set_id
        self.zones = zones
        self.object_type = 'IaasVMRestoreRequest'


class IaasVMRestoreWithRehydrationRequest(IaasVMRestoreRequest):
    """IaaS VM workload-specific restore with integrated rehydration of recovery
    point.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_id: ID of the backup copy to be recovered.
    :type recovery_point_id: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM which is being
     recovered.
    :type source_resource_id: str
    :param target_virtual_machine_id: This is the complete ARM Id of the VM
     that will be created.
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param target_resource_group_id: This is the ARM Id of the resource group
     that you want to create for this Virtual machine and other artifacts.
     For e.g. /subscriptions/{subId}/resourcegroups/{rg}
    :type target_resource_group_id: str
    :param storage_account_id: Fully qualified ARM ID of the storage account
     to which the VM has to be restored.
    :type storage_account_id: str
    :param virtual_network_id: This is the virtual network Id of the vnet that
     will be attached to the virtual machine.
     User will be validated for join action permissions in the linked access.
    :type virtual_network_id: str
    :param subnet_id: Subnet ID, is the subnet ID associated with the to be
     restored VM. For Classic VMs it would be
     {VnetID}/Subnet/{SubnetName} and, for the Azure Resource Manager VMs it
     would be ARM resource ID used to represent
     the subnet.
    :type subnet_id: str
    :param target_domain_name_id: Fully qualified ARM ID of the domain name to
     be associated to the VM being restored. This applies only to Classic
     Virtual Machines.
    :type target_domain_name_id: str
    :param region: Region in which the virtual machine is restored.
    :type region: str
    :param affinity_group: Affinity group associated to VM to be restored.
     Used only for Classic Compute Virtual Machines.
    :type affinity_group: str
    :param create_new_cloud_service: Should a new cloud service be created
     while restoring the VM. If this is false, VM will be restored to the same
     cloud service as it was at the time of backup.
    :type create_new_cloud_service: bool
    :param original_storage_account_option: Original Storage Account Option
    :type original_storage_account_option: bool
    :param encryption_details: Details needed if the VM was encrypted at the
     time of backup.
    :type encryption_details:
     ~azure.mgmt.recoveryservicesbackup.models.EncryptionDetails
    :param restore_disk_lun_list: List of Disk LUNs for partial restore
    :type restore_disk_lun_list: list[int]
    :param restore_with_managed_disks: Flag to denote of an Unmanaged disk VM
     should be restored with Managed disks.
    :type restore_with_managed_disks: bool
    :param disk_encryption_set_id: DiskEncryptionSet's ID - needed if the VM
     needs to be encrypted at rest during restore with customer managed key.
    :type disk_encryption_set_id: str
    :param zones: Target zone where the VM and its disks should be restored.
    :type zones: list[str]
    :param recovery_point_rehydration_info: RP Rehydration Info
    :type recovery_point_rehydration_info:
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointRehydrationInfo
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'target_resource_group_id': {'key': 'targetResourceGroupId', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'virtual_network_id': {'key': 'virtualNetworkId', 'type': 'str'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'target_domain_name_id': {'key': 'targetDomainNameId', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'affinity_group': {'key': 'affinityGroup', 'type': 'str'},
        'create_new_cloud_service': {'key': 'createNewCloudService', 'type': 'bool'},
        'original_storage_account_option': {'key': 'originalStorageAccountOption', 'type': 'bool'},
        'encryption_details': {'key': 'encryptionDetails', 'type': 'EncryptionDetails'},
        'restore_disk_lun_list': {'key': 'restoreDiskLunList', 'type': '[int]'},
        'restore_with_managed_disks': {'key': 'restoreWithManagedDisks', 'type': 'bool'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'recovery_point_rehydration_info': {'key': 'recoveryPointRehydrationInfo', 'type': 'RecoveryPointRehydrationInfo'},
    }

    def __init__(self, *, recovery_point_id: str=None, recovery_type=None, source_resource_id: str=None, target_virtual_machine_id: str=None, target_resource_group_id: str=None, storage_account_id: str=None, virtual_network_id: str=None, subnet_id: str=None, target_domain_name_id: str=None, region: str=None, affinity_group: str=None, create_new_cloud_service: bool=None, original_storage_account_option: bool=None, encryption_details=None, restore_disk_lun_list=None, restore_with_managed_disks: bool=None, disk_encryption_set_id: str=None, zones=None, recovery_point_rehydration_info=None, **kwargs) -> None:
        super(IaasVMRestoreWithRehydrationRequest, self).__init__(recovery_point_id=recovery_point_id, recovery_type=recovery_type, source_resource_id=source_resource_id, target_virtual_machine_id=target_virtual_machine_id, target_resource_group_id=target_resource_group_id, storage_account_id=storage_account_id, virtual_network_id=virtual_network_id, subnet_id=subnet_id, target_domain_name_id=target_domain_name_id, region=region, affinity_group=affinity_group, create_new_cloud_service=create_new_cloud_service, original_storage_account_option=original_storage_account_option, encryption_details=encryption_details, restore_disk_lun_list=restore_disk_lun_list, restore_with_managed_disks=restore_with_managed_disks, disk_encryption_set_id=disk_encryption_set_id, zones=zones, **kwargs)
        self.recovery_point_rehydration_info = recovery_point_rehydration_info
        self.object_type = 'IaasVMRestoreWithRehydrationRequest'


class ILRRequestResource(Resource):
    """Parameters to Provision ILR API.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ILRRequestResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.ILRRequest
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ILRRequest'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(ILRRequestResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class InquiryInfo(Model):
    """Details about inquired protectable items under a given container.

    :param status: Inquiry Status for this container such as
     InProgress | Failed | Succeeded
    :type status: str
    :param error_detail: Error Details if the Status is non-success.
    :type error_detail: ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param inquiry_details: Inquiry Details which will have workload specific
     details.
     For e.g. - For SQL and oracle this will contain different details.
    :type inquiry_details:
     list[~azure.mgmt.recoveryservicesbackup.models.WorkloadInquiryDetails]
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error_detail': {'key': 'errorDetail', 'type': 'ErrorDetail'},
        'inquiry_details': {'key': 'inquiryDetails', 'type': '[WorkloadInquiryDetails]'},
    }

    def __init__(self, *, status: str=None, error_detail=None, inquiry_details=None, **kwargs) -> None:
        super(InquiryInfo, self).__init__(**kwargs)
        self.status = status
        self.error_detail = error_detail
        self.inquiry_details = inquiry_details


class InquiryValidation(Model):
    """Validation for inquired protectable items under a given container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param status: Status for the Inquiry Validation.
    :type status: str
    :param error_detail: Error Detail in case the status is non-success.
    :type error_detail: ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :ivar additional_detail: Error Additional Detail in case the status is
     non-success.
    :vartype additional_detail: str
    """

    _validation = {
        'additional_detail': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error_detail': {'key': 'errorDetail', 'type': 'ErrorDetail'},
        'additional_detail': {'key': 'additionalDetail', 'type': 'str'},
    }

    def __init__(self, *, status: str=None, error_detail=None, **kwargs) -> None:
        super(InquiryValidation, self).__init__(**kwargs)
        self.status = status
        self.error_detail = error_detail
        self.additional_detail = None


class InstantItemRecoveryTarget(Model):
    """Target details for file / folder restore.

    :param client_scripts: List of client scripts.
    :type client_scripts:
     list[~azure.mgmt.recoveryservicesbackup.models.ClientScriptForConnect]
    """

    _attribute_map = {
        'client_scripts': {'key': 'clientScripts', 'type': '[ClientScriptForConnect]'},
    }

    def __init__(self, *, client_scripts=None, **kwargs) -> None:
        super(InstantItemRecoveryTarget, self).__init__(**kwargs)
        self.client_scripts = client_scripts


class InstantRPAdditionalDetails(Model):
    """InstantRPAdditionalDetails.

    :param azure_backup_rg_name_prefix:
    :type azure_backup_rg_name_prefix: str
    :param azure_backup_rg_name_suffix:
    :type azure_backup_rg_name_suffix: str
    """

    _attribute_map = {
        'azure_backup_rg_name_prefix': {'key': 'azureBackupRGNamePrefix', 'type': 'str'},
        'azure_backup_rg_name_suffix': {'key': 'azureBackupRGNameSuffix', 'type': 'str'},
    }

    def __init__(self, *, azure_backup_rg_name_prefix: str=None, azure_backup_rg_name_suffix: str=None, **kwargs) -> None:
        super(InstantRPAdditionalDetails, self).__init__(**kwargs)
        self.azure_backup_rg_name_prefix = azure_backup_rg_name_prefix
        self.azure_backup_rg_name_suffix = azure_backup_rg_name_suffix


class JobQueryObject(Model):
    """Filters to list the jobs.

    :param status: Status of the job. Possible values include: 'Invalid',
     'InProgress', 'Completed', 'Failed', 'CompletedWithWarnings', 'Cancelled',
     'Cancelling'
    :type status: str or ~azure.mgmt.recoveryservicesbackup.models.JobStatus
    :param backup_management_type: Type of backup management for the job.
     Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: Type of operation. Possible values include: 'Invalid',
     'Register', 'UnRegister', 'ConfigureBackup', 'Backup', 'Restore',
     'DisableBackup', 'DeleteBackupData', 'CrossRegionRestore', 'Undelete',
     'UpdateCustomerManagedKey'
    :type operation: str or
     ~azure.mgmt.recoveryservicesbackup.models.JobOperationType
    :param job_id: JobID represents the job uniquely.
    :type job_id: str
    :param start_time: Job has started at this time. Value is in UTC.
    :type start_time: datetime
    :param end_time: Job has ended at this time. Value is in UTC.
    :type end_time: datetime
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, status=None, backup_management_type=None, operation=None, job_id: str=None, start_time=None, end_time=None, **kwargs) -> None:
        super(JobQueryObject, self).__init__(**kwargs)
        self.status = status
        self.backup_management_type = backup_management_type
        self.operation = operation
        self.job_id = job_id
        self.start_time = start_time
        self.end_time = end_time


class JobResource(Resource):
    """Defines workload agnostic properties for a job.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: JobResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.Job
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Job'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(JobResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class KEKDetails(Model):
    """KEK is encryption key for BEK.

    :param key_url: Key is KEK.
    :type key_url: str
    :param key_vault_id: Key Vault ID where this Key is stored.
    :type key_vault_id: str
    :param key_backup_data: KEK data.
    :type key_backup_data: str
    """

    _attribute_map = {
        'key_url': {'key': 'keyUrl', 'type': 'str'},
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'key_backup_data': {'key': 'keyBackupData', 'type': 'str'},
    }

    def __init__(self, *, key_url: str=None, key_vault_id: str=None, key_backup_data: str=None, **kwargs) -> None:
        super(KEKDetails, self).__init__(**kwargs)
        self.key_url = key_url
        self.key_vault_id = key_vault_id
        self.key_backup_data = key_backup_data


class KeyAndSecretDetails(Model):
    """BEK is bitlocker key.
    KEK is encryption key for BEK
    If the VM was encrypted then we will store following details :
    1. Secret(BEK) - Url + Backup Data + vaultId.
    2. Key(KEK) - Url + Backup Data + vaultId.
    3. EncryptionMechanism
    BEK and KEK can potentially have different vault ids.

    :param kek_details: KEK is encryption key for BEK.
    :type kek_details: ~azure.mgmt.recoveryservicesbackup.models.KEKDetails
    :param bek_details: BEK is bitlocker encryption key.
    :type bek_details: ~azure.mgmt.recoveryservicesbackup.models.BEKDetails
    :param encryption_mechanism: Encryption mechanism: None/ SinglePass/
     DoublePass
    :type encryption_mechanism: str
    """

    _attribute_map = {
        'kek_details': {'key': 'kekDetails', 'type': 'KEKDetails'},
        'bek_details': {'key': 'bekDetails', 'type': 'BEKDetails'},
        'encryption_mechanism': {'key': 'encryptionMechanism', 'type': 'str'},
    }

    def __init__(self, *, kek_details=None, bek_details=None, encryption_mechanism: str=None, **kwargs) -> None:
        super(KeyAndSecretDetails, self).__init__(**kwargs)
        self.kek_details = kek_details
        self.bek_details = bek_details
        self.encryption_mechanism = encryption_mechanism


class KPIResourceHealthDetails(Model):
    """KPI Resource Health Details.

    :param resource_health_status: Resource Health Status. Possible values
     include: 'Healthy', 'TransientDegraded', 'PersistentDegraded',
     'TransientUnhealthy', 'PersistentUnhealthy', 'Invalid'
    :type resource_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ResourceHealthStatus
    :param resource_health_details: Resource Health Status
    :type resource_health_details:
     list[~azure.mgmt.recoveryservicesbackup.models.ResourceHealthDetails]
    """

    _attribute_map = {
        'resource_health_status': {'key': 'resourceHealthStatus', 'type': 'str'},
        'resource_health_details': {'key': 'resourceHealthDetails', 'type': '[ResourceHealthDetails]'},
    }

    def __init__(self, *, resource_health_status=None, resource_health_details=None, **kwargs) -> None:
        super(KPIResourceHealthDetails, self).__init__(**kwargs)
        self.resource_health_status = resource_health_status
        self.resource_health_details = resource_health_details


class ListRecoveryPointsRecommendedForMoveRequest(Model):
    """ListRecoveryPointsRecommendedForMoveRequest Request.

    :param object_type: Gets the class type.
    :type object_type: str
    :param excluded_rp_list: List of Recovery Points excluded from Move
    :type excluded_rp_list: list[str]
    """

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'excluded_rp_list': {'key': 'excludedRPList', 'type': '[str]'},
    }

    def __init__(self, *, object_type: str=None, excluded_rp_list=None, **kwargs) -> None:
        super(ListRecoveryPointsRecommendedForMoveRequest, self).__init__(**kwargs)
        self.object_type = object_type
        self.excluded_rp_list = excluded_rp_list


class SchedulePolicy(Model):
    """Base class for backup schedule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LogSchedulePolicy, LongTermSchedulePolicy,
    SimpleSchedulePolicy

    All required parameters must be populated in order to send to Azure.

    :param schedule_policy_type: Required. Constant filled by server.
    :type schedule_policy_type: str
    """

    _validation = {
        'schedule_policy_type': {'required': True},
    }

    _attribute_map = {
        'schedule_policy_type': {'key': 'schedulePolicyType', 'type': 'str'},
    }

    _subtype_map = {
        'schedule_policy_type': {'LogSchedulePolicy': 'LogSchedulePolicy', 'LongTermSchedulePolicy': 'LongTermSchedulePolicy', 'SimpleSchedulePolicy': 'SimpleSchedulePolicy'}
    }

    def __init__(self, **kwargs) -> None:
        super(SchedulePolicy, self).__init__(**kwargs)
        self.schedule_policy_type = None


class LogSchedulePolicy(SchedulePolicy):
    """Log policy schedule.

    All required parameters must be populated in order to send to Azure.

    :param schedule_policy_type: Required. Constant filled by server.
    :type schedule_policy_type: str
    :param schedule_frequency_in_mins: Frequency of the log schedule operation
     of this policy in minutes.
    :type schedule_frequency_in_mins: int
    """

    _validation = {
        'schedule_policy_type': {'required': True},
    }

    _attribute_map = {
        'schedule_policy_type': {'key': 'schedulePolicyType', 'type': 'str'},
        'schedule_frequency_in_mins': {'key': 'scheduleFrequencyInMins', 'type': 'int'},
    }

    def __init__(self, *, schedule_frequency_in_mins: int=None, **kwargs) -> None:
        super(LogSchedulePolicy, self).__init__(**kwargs)
        self.schedule_frequency_in_mins = schedule_frequency_in_mins
        self.schedule_policy_type = 'LogSchedulePolicy'


class RetentionPolicy(Model):
    """Base class for retention policy.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LongTermRetentionPolicy, SimpleRetentionPolicy

    All required parameters must be populated in order to send to Azure.

    :param retention_policy_type: Required. Constant filled by server.
    :type retention_policy_type: str
    """

    _validation = {
        'retention_policy_type': {'required': True},
    }

    _attribute_map = {
        'retention_policy_type': {'key': 'retentionPolicyType', 'type': 'str'},
    }

    _subtype_map = {
        'retention_policy_type': {'LongTermRetentionPolicy': 'LongTermRetentionPolicy', 'SimpleRetentionPolicy': 'SimpleRetentionPolicy'}
    }

    def __init__(self, **kwargs) -> None:
        super(RetentionPolicy, self).__init__(**kwargs)
        self.retention_policy_type = None


class LongTermRetentionPolicy(RetentionPolicy):
    """Long term retention policy.

    All required parameters must be populated in order to send to Azure.

    :param retention_policy_type: Required. Constant filled by server.
    :type retention_policy_type: str
    :param daily_schedule: Daily retention schedule of the protection policy.
    :type daily_schedule:
     ~azure.mgmt.recoveryservicesbackup.models.DailyRetentionSchedule
    :param weekly_schedule: Weekly retention schedule of the protection
     policy.
    :type weekly_schedule:
     ~azure.mgmt.recoveryservicesbackup.models.WeeklyRetentionSchedule
    :param monthly_schedule: Monthly retention schedule of the protection
     policy.
    :type monthly_schedule:
     ~azure.mgmt.recoveryservicesbackup.models.MonthlyRetentionSchedule
    :param yearly_schedule: Yearly retention schedule of the protection
     policy.
    :type yearly_schedule:
     ~azure.mgmt.recoveryservicesbackup.models.YearlyRetentionSchedule
    """

    _validation = {
        'retention_policy_type': {'required': True},
    }

    _attribute_map = {
        'retention_policy_type': {'key': 'retentionPolicyType', 'type': 'str'},
        'daily_schedule': {'key': 'dailySchedule', 'type': 'DailyRetentionSchedule'},
        'weekly_schedule': {'key': 'weeklySchedule', 'type': 'WeeklyRetentionSchedule'},
        'monthly_schedule': {'key': 'monthlySchedule', 'type': 'MonthlyRetentionSchedule'},
        'yearly_schedule': {'key': 'yearlySchedule', 'type': 'YearlyRetentionSchedule'},
    }

    def __init__(self, *, daily_schedule=None, weekly_schedule=None, monthly_schedule=None, yearly_schedule=None, **kwargs) -> None:
        super(LongTermRetentionPolicy, self).__init__(**kwargs)
        self.daily_schedule = daily_schedule
        self.weekly_schedule = weekly_schedule
        self.monthly_schedule = monthly_schedule
        self.yearly_schedule = yearly_schedule
        self.retention_policy_type = 'LongTermRetentionPolicy'


class LongTermSchedulePolicy(SchedulePolicy):
    """Long term policy schedule.

    All required parameters must be populated in order to send to Azure.

    :param schedule_policy_type: Required. Constant filled by server.
    :type schedule_policy_type: str
    """

    _validation = {
        'schedule_policy_type': {'required': True},
    }

    _attribute_map = {
        'schedule_policy_type': {'key': 'schedulePolicyType', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(LongTermSchedulePolicy, self).__init__(**kwargs)
        self.schedule_policy_type = 'LongTermSchedulePolicy'


class MabContainer(ProtectionContainer):
    """Container with items backed up using MAB backup engine.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param can_re_register: Can the container be registered one more time.
    :type can_re_register: bool
    :param container_id: ContainerID represents the container.
    :type container_id: long
    :param protected_item_count: Number of items backed up in this container.
    :type protected_item_count: long
    :param agent_version: Agent version of this container.
    :type agent_version: str
    :param extended_info: Additional information for this container
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.MabContainerExtendedInfo
    :param mab_container_health_details: Health details on this mab container.
    :type mab_container_health_details:
     list[~azure.mgmt.recoveryservicesbackup.models.MABContainerHealthDetails]
    :param container_health_state: Health state of mab container.
    :type container_health_state: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'container_id': {'key': 'containerId', 'type': 'long'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'long'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'MabContainerExtendedInfo'},
        'mab_container_health_details': {'key': 'mabContainerHealthDetails', 'type': '[MABContainerHealthDetails]'},
        'container_health_state': {'key': 'containerHealthState', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, backup_management_type=None, registration_status: str=None, health_status: str=None, can_re_register: bool=None, container_id: int=None, protected_item_count: int=None, agent_version: str=None, extended_info=None, mab_container_health_details=None, container_health_state: str=None, **kwargs) -> None:
        super(MabContainer, self).__init__(friendly_name=friendly_name, backup_management_type=backup_management_type, registration_status=registration_status, health_status=health_status, **kwargs)
        self.can_re_register = can_re_register
        self.container_id = container_id
        self.protected_item_count = protected_item_count
        self.agent_version = agent_version
        self.extended_info = extended_info
        self.mab_container_health_details = mab_container_health_details
        self.container_health_state = container_health_state
        self.container_type = 'Windows'


class MabContainerExtendedInfo(Model):
    """Additional information of the container.

    :param last_refreshed_at: Time stamp when this container was refreshed.
    :type last_refreshed_at: datetime
    :param backup_item_type: Type of backup items associated with this
     container. Possible values include: 'Invalid', 'VM', 'FileFolder',
     'AzureSqlDb', 'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM',
     'SystemState', 'Client', 'GenericDataSource', 'SQLDataBase',
     'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type backup_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupItemType
    :param backup_items: List of backup items associated with this container.
    :type backup_items: list[str]
    :param policy_name: Backup policy associated with this container.
    :type policy_name: str
    :param last_backup_status: Latest backup status of this container.
    :type last_backup_status: str
    """

    _attribute_map = {
        'last_refreshed_at': {'key': 'lastRefreshedAt', 'type': 'iso-8601'},
        'backup_item_type': {'key': 'backupItemType', 'type': 'str'},
        'backup_items': {'key': 'backupItems', 'type': '[str]'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
    }

    def __init__(self, *, last_refreshed_at=None, backup_item_type=None, backup_items=None, policy_name: str=None, last_backup_status: str=None, **kwargs) -> None:
        super(MabContainerExtendedInfo, self).__init__(**kwargs)
        self.last_refreshed_at = last_refreshed_at
        self.backup_item_type = backup_item_type
        self.backup_items = backup_items
        self.policy_name = policy_name
        self.last_backup_status = last_backup_status


class MABContainerHealthDetails(Model):
    """MAB workload-specific Health Details.

    :param code: Health Code
    :type code: int
    :param title: Health Title
    :type title: str
    :param message: Health Message
    :type message: str
    :param recommendations: Health Recommended Actions
    :type recommendations: list[str]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'int'},
        'title': {'key': 'title', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, *, code: int=None, title: str=None, message: str=None, recommendations=None, **kwargs) -> None:
        super(MABContainerHealthDetails, self).__init__(**kwargs)
        self.code = code
        self.title = title
        self.message = message
        self.recommendations = recommendations


class MabErrorInfo(Model):
    """MAB workload-specific error information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations.
    :vartype recommendations: list[str]
    """

    _validation = {
        'error_string': {'readonly': True},
        'recommendations': {'readonly': True},
    }

    _attribute_map = {
        'error_string': {'key': 'errorString', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs) -> None:
        super(MabErrorInfo, self).__init__(**kwargs)
        self.error_string = None
        self.recommendations = None


class MabFileFolderProtectedItem(ProtectedItem):
    """MAB workload-specific backup item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of this backup item.
    :type friendly_name: str
    :param computer_name: Name of the computer associated with this backup
     item.
    :type computer_name: str
    :param last_backup_status: Status of last backup operation.
    :type last_backup_status: str
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param protection_state: Protected, ProtectionStopped, IRPending or
     ProtectionError
    :type protection_state: str
    :param deferred_delete_sync_time_in_utc: Sync time for deferred deletion
     in UTC
    :type deferred_delete_sync_time_in_utc: long
    :param extended_info: Additional information with this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.MabFileFolderProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'deferred_delete_sync_time_in_utc': {'key': 'deferredDeleteSyncTimeInUTC', 'type': 'long'},
        'extended_info': {'key': 'extendedInfo', 'type': 'MabFileFolderProtectedItemExtendedInfo'},
    }

    def __init__(self, *, backup_management_type=None, workload_type=None, container_name: str=None, source_resource_id: str=None, policy_id: str=None, last_recovery_point=None, backup_set_name: str=None, create_mode=None, deferred_delete_time_in_utc=None, is_scheduled_for_deferred_delete: bool=None, deferred_delete_time_remaining: str=None, is_deferred_delete_schedule_upcoming: bool=None, is_rehydrate: bool=None, friendly_name: str=None, computer_name: str=None, last_backup_status: str=None, last_backup_time=None, protection_state: str=None, deferred_delete_sync_time_in_utc: int=None, extended_info=None, **kwargs) -> None:
        super(MabFileFolderProtectedItem, self).__init__(backup_management_type=backup_management_type, workload_type=workload_type, container_name=container_name, source_resource_id=source_resource_id, policy_id=policy_id, last_recovery_point=last_recovery_point, backup_set_name=backup_set_name, create_mode=create_mode, deferred_delete_time_in_utc=deferred_delete_time_in_utc, is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete, deferred_delete_time_remaining=deferred_delete_time_remaining, is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming, is_rehydrate=is_rehydrate, **kwargs)
        self.friendly_name = friendly_name
        self.computer_name = computer_name
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.protection_state = protection_state
        self.deferred_delete_sync_time_in_utc = deferred_delete_sync_time_in_utc
        self.extended_info = extended_info
        self.protected_item_type = 'MabFileFolderProtectedItem'


class MabFileFolderProtectedItemExtendedInfo(Model):
    """Additional information on the backed up item.

    :param last_refreshed_at: Last time when the agent data synced to service.
    :type last_refreshed_at: datetime
    :param oldest_recovery_point: The oldest backup copy available.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: Number of backup copies associated with the
     backup item.
    :type recovery_point_count: int
    """

    _attribute_map = {
        'last_refreshed_at': {'key': 'lastRefreshedAt', 'type': 'iso-8601'},
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
    }

    def __init__(self, *, last_refreshed_at=None, oldest_recovery_point=None, recovery_point_count: int=None, **kwargs) -> None:
        super(MabFileFolderProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.last_refreshed_at = last_refreshed_at
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count


class MabJob(Job):
    """MAB workload-specific job.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param duration: Time taken by job to run.
    :type duration: timedelta
    :param actions_info: The state/actions applicable on jobs like
     cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param mab_server_name: Name of server protecting the DS.
    :type mab_server_name: str
    :param mab_server_type: Server type of MAB container. Possible values
     include: 'Invalid', 'Unknown', 'IaasVMContainer',
     'IaasVMServiceContainer', 'DPMContainer', 'AzureBackupServerContainer',
     'MABContainer', 'Cluster', 'AzureSqlContainer', 'Windows', 'VCenter',
     'VMAppContainer', 'SQLAGWorkLoadContainer', 'StorageContainer',
     'GenericContainer'
    :type mab_server_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.MabServerType
    :param workload_type: Workload type of backup item. Possible values
     include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange',
     'Sharepoint', 'VMwareVM', 'SystemState', 'Client', 'GenericDataSource',
     'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param error_details: The errors.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.MabErrorInfo]
    :param extended_info: Additional information on the job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.MabJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'mab_server_name': {'key': 'mabServerName', 'type': 'str'},
        'mab_server_type': {'key': 'mabServerType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'error_details': {'key': 'errorDetails', 'type': '[MabErrorInfo]'},
        'extended_info': {'key': 'extendedInfo', 'type': 'MabJobExtendedInfo'},
    }

    def __init__(self, *, entity_friendly_name: str=None, backup_management_type=None, operation: str=None, status: str=None, start_time=None, end_time=None, activity_id: str=None, duration=None, actions_info=None, mab_server_name: str=None, mab_server_type=None, workload_type=None, error_details=None, extended_info=None, **kwargs) -> None:
        super(MabJob, self).__init__(entity_friendly_name=entity_friendly_name, backup_management_type=backup_management_type, operation=operation, status=status, start_time=start_time, end_time=end_time, activity_id=activity_id, **kwargs)
        self.duration = duration
        self.actions_info = actions_info
        self.mab_server_name = mab_server_name
        self.mab_server_type = mab_server_type
        self.workload_type = workload_type
        self.error_details = error_details
        self.extended_info = extended_info
        self.job_type = 'MabJob'


class MabJobExtendedInfo(Model):
    """Additional information for the MAB workload-specific job.

    :param tasks_list: List of tasks for this job.
    :type tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.models.MabJobTaskDetails]
    :param property_bag: The job properties.
    :type property_bag: dict[str, str]
    :param dynamic_error_message: Non localized error message specific to this
     job.
    :type dynamic_error_message: str
    """

    _attribute_map = {
        'tasks_list': {'key': 'tasksList', 'type': '[MabJobTaskDetails]'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'dynamic_error_message': {'key': 'dynamicErrorMessage', 'type': 'str'},
    }

    def __init__(self, *, tasks_list=None, property_bag=None, dynamic_error_message: str=None, **kwargs) -> None:
        super(MabJobExtendedInfo, self).__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class MabJobTaskDetails(Model):
    """MAB workload-specific job task details.

    :param task_id: The task display name.
    :type task_id: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param duration: Time elapsed for task.
    :type duration: timedelta
    :param status: The status.
    :type status: str
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, task_id: str=None, start_time=None, end_time=None, duration=None, status: str=None, **kwargs) -> None:
        super(MabJobTaskDetails, self).__init__(**kwargs)
        self.task_id = task_id
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.status = status


class MabProtectionPolicy(ProtectionPolicy):
    """Mab container-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param schedule_policy: Backup schedule of backup policy.
    :type schedule_policy:
     ~azure.mgmt.recoveryservicesbackup.models.SchedulePolicy
    :param retention_policy: Retention policy details.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'schedule_policy': {'key': 'schedulePolicy', 'type': 'SchedulePolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, *, protected_items_count: int=None, schedule_policy=None, retention_policy=None, **kwargs) -> None:
        super(MabProtectionPolicy, self).__init__(protected_items_count=protected_items_count, **kwargs)
        self.schedule_policy = schedule_policy
        self.retention_policy = retention_policy
        self.backup_management_type = 'MAB'


class MonthlyRetentionSchedule(Model):
    """Monthly retention schedule.

    :param retention_schedule_format_type: Retention schedule format type for
     monthly retention policy. Possible values include: 'Invalid', 'Daily',
     'Weekly'
    :type retention_schedule_format_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RetentionScheduleFormat
    :param retention_schedule_daily: Daily retention format for monthly
     retention policy.
    :type retention_schedule_daily:
     ~azure.mgmt.recoveryservicesbackup.models.DailyRetentionFormat
    :param retention_schedule_weekly: Weekly retention format for monthly
     retention policy.
    :type retention_schedule_weekly:
     ~azure.mgmt.recoveryservicesbackup.models.WeeklyRetentionFormat
    :param retention_times: Retention times of retention policy.
    :type retention_times: list[datetime]
    :param retention_duration: Retention duration of retention Policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _attribute_map = {
        'retention_schedule_format_type': {'key': 'retentionScheduleFormatType', 'type': 'str'},
        'retention_schedule_daily': {'key': 'retentionScheduleDaily', 'type': 'DailyRetentionFormat'},
        'retention_schedule_weekly': {'key': 'retentionScheduleWeekly', 'type': 'WeeklyRetentionFormat'},
        'retention_times': {'key': 'retentionTimes', 'type': '[iso-8601]'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, *, retention_schedule_format_type=None, retention_schedule_daily=None, retention_schedule_weekly=None, retention_times=None, retention_duration=None, **kwargs) -> None:
        super(MonthlyRetentionSchedule, self).__init__(**kwargs)
        self.retention_schedule_format_type = retention_schedule_format_type
        self.retention_schedule_daily = retention_schedule_daily
        self.retention_schedule_weekly = retention_schedule_weekly
        self.retention_times = retention_times
        self.retention_duration = retention_duration


class MoveRPAcrossTiersRequest(Model):
    """MoveRPAcrossTiersRequest.

    :param object_type: Gets the class type.
    :type object_type: str
    :param source_tier_type: Source tier from where RP needs to be moved.
     Possible values include: 'Invalid', 'InstantRP', 'HardenedRP',
     'ArchivedRP'
    :type source_tier_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierType
    :param target_tier_type: Target tier where RP needs to be moved. Possible
     values include: 'Invalid', 'InstantRP', 'HardenedRP', 'ArchivedRP'
    :type target_tier_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierType
    """

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'source_tier_type': {'key': 'sourceTierType', 'type': 'RecoveryPointTierType'},
        'target_tier_type': {'key': 'targetTierType', 'type': 'RecoveryPointTierType'},
    }

    def __init__(self, *, object_type: str=None, source_tier_type=None, target_tier_type=None, **kwargs) -> None:
        super(MoveRPAcrossTiersRequest, self).__init__(**kwargs)
        self.object_type = object_type
        self.source_tier_type = source_tier_type
        self.target_tier_type = target_tier_type


class NameInfo(Model):
    """The name of usage.

    :param value: Value of usage.
    :type value: str
    :param localized_value: Localized value of usage.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, *, value: str=None, localized_value: str=None, **kwargs) -> None:
        super(NameInfo, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class NewErrorResponse(Model):
    """The resource management error response.

    :param error: The error object.
    :type error:
     ~azure.mgmt.recoveryservicesbackup.models.NewErrorResponseError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'NewErrorResponseError'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(NewErrorResponse, self).__init__(**kwargs)
        self.error = error


class NewErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'NewErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(NewErrorResponseException, self).__init__(deserialize, response, 'NewErrorResponse', *args)


class NewErrorResponseError(Model):
    """The error object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details:
     list[~azure.mgmt.recoveryservicesbackup.models.NewErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.recoveryservicesbackup.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[NewErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(self, **kwargs) -> None:
        super(NewErrorResponseError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class OperationResultInfo(OperationResultInfoBase):
    """Operation result info.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param job_list: List of jobs created by this operation.
    :type job_list: list[str]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'job_list': {'key': 'jobList', 'type': '[str]'},
    }

    def __init__(self, *, job_list=None, **kwargs) -> None:
        super(OperationResultInfo, self).__init__(**kwargs)
        self.job_list = job_list
        self.object_type = 'OperationResultInfo'


class OperationWorkerResponse(Model):
    """This is the base class for operation result responses.

    :param status_code: HTTP Status Code of the operation. Possible values
     include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted',
     'NonAuthoritativeInformation', 'NoContent', 'ResetContent',
     'PartialContent', 'MultipleChoices', 'Ambiguous', 'MovedPermanently',
     'Moved', 'Found', 'Redirect', 'SeeOther', 'RedirectMethod', 'NotModified',
     'UseProxy', 'Unused', 'TemporaryRedirect', 'RedirectKeepVerb',
     'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound',
     'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired',
     'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired',
     'PreconditionFailed', 'RequestEntityTooLarge', 'RequestUriTooLong',
     'UnsupportedMediaType', 'RequestedRangeNotSatisfiable',
     'ExpectationFailed', 'UpgradeRequired', 'InternalServerError',
     'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout',
     'HttpVersionNotSupported'
    :type status_code: str or
     ~azure.mgmt.recoveryservicesbackup.models.HttpStatusCode
    :param headers: HTTP headers associated with this operation.
    :type headers: dict[str, list[str]]
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'HttpStatusCode'},
        'headers': {'key': 'headers', 'type': '{[str]}'},
    }

    def __init__(self, *, status_code=None, headers=None, **kwargs) -> None:
        super(OperationWorkerResponse, self).__init__(**kwargs)
        self.status_code = status_code
        self.headers = headers


class OperationResultInfoBaseResource(OperationWorkerResponse):
    """Base class for operation result info.

    :param status_code: HTTP Status Code of the operation. Possible values
     include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted',
     'NonAuthoritativeInformation', 'NoContent', 'ResetContent',
     'PartialContent', 'MultipleChoices', 'Ambiguous', 'MovedPermanently',
     'Moved', 'Found', 'Redirect', 'SeeOther', 'RedirectMethod', 'NotModified',
     'UseProxy', 'Unused', 'TemporaryRedirect', 'RedirectKeepVerb',
     'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound',
     'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired',
     'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired',
     'PreconditionFailed', 'RequestEntityTooLarge', 'RequestUriTooLong',
     'UnsupportedMediaType', 'RequestedRangeNotSatisfiable',
     'ExpectationFailed', 'UpgradeRequired', 'InternalServerError',
     'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout',
     'HttpVersionNotSupported'
    :type status_code: str or
     ~azure.mgmt.recoveryservicesbackup.models.HttpStatusCode
    :param headers: HTTP headers associated with this operation.
    :type headers: dict[str, list[str]]
    :param operation: OperationResultInfoBaseResource operation
    :type operation:
     ~azure.mgmt.recoveryservicesbackup.models.OperationResultInfoBase
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'HttpStatusCode'},
        'headers': {'key': 'headers', 'type': '{[str]}'},
        'operation': {'key': 'operation', 'type': 'OperationResultInfoBase'},
    }

    def __init__(self, *, status_code=None, headers=None, operation=None, **kwargs) -> None:
        super(OperationResultInfoBaseResource, self).__init__(status_code=status_code, headers=headers, **kwargs)
        self.operation = operation


class OperationStatus(Model):
    """Operation status.

    :param id: ID of the operation.
    :type id: str
    :param name: Name of the operation.
    :type name: str
    :param status: Operation status. Possible values include: 'Invalid',
     'InProgress', 'Succeeded', 'Failed', 'Canceled'
    :type status: str or
     ~azure.mgmt.recoveryservicesbackup.models.OperationStatusValues
    :param start_time: Operation start time. Format: ISO-8601.
    :type start_time: datetime
    :param end_time: Operation end time. Format: ISO-8601.
    :type end_time: datetime
    :param error: Error information related to this operation.
    :type error:
     ~azure.mgmt.recoveryservicesbackup.models.OperationStatusError
    :param properties: Additional information associated with this operation.
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.OperationStatusExtendedInfo
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'OperationStatusError'},
        'properties': {'key': 'properties', 'type': 'OperationStatusExtendedInfo'},
    }

    def __init__(self, *, id: str=None, name: str=None, status=None, start_time=None, end_time=None, error=None, properties=None, **kwargs) -> None:
        super(OperationStatus, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.error = error
        self.properties = properties


class OperationStatusError(Model):
    """Error information associated with operation status call.

    :param code: Error code of the operation failure.
    :type code: str
    :param message: Error message displayed if the operation failure.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(OperationStatusError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class OperationStatusExtendedInfo(Model):
    """Base class for additional information of operation status.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: OperationStatusJobExtendedInfo,
    OperationStatusJobsExtendedInfo, OperationStatusProvisionILRExtendedInfo,
    OperationStatusRecoveryPointExtendedInfo

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'OperationStatusJobExtendedInfo': 'OperationStatusJobExtendedInfo', 'OperationStatusJobsExtendedInfo': 'OperationStatusJobsExtendedInfo', 'OperationStatusProvisionILRExtendedInfo': 'OperationStatusProvisionILRExtendedInfo', 'OperationStatusRecoveryPointExtendedInfo': 'OperationStatusRecoveryPointExtendedInfo'}
    }

    def __init__(self, **kwargs) -> None:
        super(OperationStatusExtendedInfo, self).__init__(**kwargs)
        self.object_type = None


class OperationStatusJobExtendedInfo(OperationStatusExtendedInfo):
    """Operation status job extended info.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param job_id: ID of the job created for this protected item.
    :type job_id: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
    }

    def __init__(self, *, job_id: str=None, **kwargs) -> None:
        super(OperationStatusJobExtendedInfo, self).__init__(**kwargs)
        self.job_id = job_id
        self.object_type = 'OperationStatusJobExtendedInfo'


class OperationStatusJobsExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for list of jobs.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param job_ids: IDs of the jobs created for the protected item.
    :type job_ids: list[str]
    :param failed_jobs_error: Stores all the failed jobs along with the
     corresponding error codes.
    :type failed_jobs_error: dict[str, str]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'job_ids': {'key': 'jobIds', 'type': '[str]'},
        'failed_jobs_error': {'key': 'failedJobsError', 'type': '{str}'},
    }

    def __init__(self, *, job_ids=None, failed_jobs_error=None, **kwargs) -> None:
        super(OperationStatusJobsExtendedInfo, self).__init__(**kwargs)
        self.job_ids = job_ids
        self.failed_jobs_error = failed_jobs_error
        self.object_type = 'OperationStatusJobsExtendedInfo'


class OperationStatusProvisionILRExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for ILR provision action.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_target: Target details for file / folder restore.
    :type recovery_target:
     ~azure.mgmt.recoveryservicesbackup.models.InstantItemRecoveryTarget
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_target': {'key': 'recoveryTarget', 'type': 'InstantItemRecoveryTarget'},
    }

    def __init__(self, *, recovery_target=None, **kwargs) -> None:
        super(OperationStatusProvisionILRExtendedInfo, self).__init__(**kwargs)
        self.recovery_target = recovery_target
        self.object_type = 'OperationStatusProvisionILRExtendedInfo'


class OperationStatusRecoveryPointExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for Updated Recovery Point.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param updated_recovery_point: Recovery Point info with updated source
     snapshot URI
    :type updated_recovery_point:
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPoint
    :param deleted_backup_item_version: In case the share is in soft-deleted
     state, populate this field with deleted backup item
    :type deleted_backup_item_version: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'updated_recovery_point': {'key': 'updatedRecoveryPoint', 'type': 'RecoveryPoint'},
        'deleted_backup_item_version': {'key': 'deletedBackupItemVersion', 'type': 'str'},
    }

    def __init__(self, *, updated_recovery_point=None, deleted_backup_item_version: str=None, **kwargs) -> None:
        super(OperationStatusRecoveryPointExtendedInfo, self).__init__(**kwargs)
        self.updated_recovery_point = updated_recovery_point
        self.deleted_backup_item_version = deleted_backup_item_version
        self.object_type = 'OperationStatusRecoveryPointExtendedInfo'


class PointInTimeRange(Model):
    """Provides details for log ranges.

    :param start_time: Start time of the time range for log recovery.
    :type start_time: datetime
    :param end_time: End time of the time range for log recovery.
    :type end_time: datetime
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, start_time=None, end_time=None, **kwargs) -> None:
        super(PointInTimeRange, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time


class PreBackupValidation(Model):
    """Pre-backup validation for Azure VM Workload provider.

    :param status: Status of protectable item, i.e.
     InProgress,Succeeded,Failed. Possible values include: 'Invalid',
     'Success', 'Failed'
    :type status: str or
     ~azure.mgmt.recoveryservicesbackup.models.InquiryStatus
    :param code: Error code of protectable item
    :type code: str
    :param message: Message corresponding to the error code for the
     protectable item
    :type message: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, status=None, code: str=None, message: str=None, **kwargs) -> None:
        super(PreBackupValidation, self).__init__(**kwargs)
        self.status = status
        self.code = code
        self.message = message


class PrepareDataMoveRequest(Model):
    """Prepare DataMove Request.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. ARM Id of target vault
    :type target_resource_id: str
    :param target_region: Required. Target Region
    :type target_region: str
    :param data_move_level: Required. DataMove Level. Possible values include:
     'Invalid', 'Vault', 'Container'
    :type data_move_level: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataMoveLevel
    :param source_container_arm_ids: Source Container ArmIds
     This needs to be populated only if DataMoveLevel is set to container
    :type source_container_arm_ids: list[str]
    :param ignore_moved: Ignore the artifacts which are already moved.
    :type ignore_moved: bool
    """

    _validation = {
        'target_resource_id': {'required': True},
        'target_region': {'required': True},
        'data_move_level': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'target_region': {'key': 'targetRegion', 'type': 'str'},
        'data_move_level': {'key': 'dataMoveLevel', 'type': 'str'},
        'source_container_arm_ids': {'key': 'sourceContainerArmIds', 'type': '[str]'},
        'ignore_moved': {'key': 'ignoreMoved', 'type': 'bool'},
    }

    def __init__(self, *, target_resource_id: str, target_region: str, data_move_level, source_container_arm_ids=None, ignore_moved: bool=None, **kwargs) -> None:
        super(PrepareDataMoveRequest, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.target_region = target_region
        self.data_move_level = data_move_level
        self.source_container_arm_ids = source_container_arm_ids
        self.ignore_moved = ignore_moved


class VaultStorageConfigOperationResultResponse(Model):
    """Operation result response for Vault Storage Config.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PrepareDataMoveResponse

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'PrepareDataMoveResponse': 'PrepareDataMoveResponse'}
    }

    def __init__(self, **kwargs) -> None:
        super(VaultStorageConfigOperationResultResponse, self).__init__(**kwargs)
        self.object_type = None


class PrepareDataMoveResponse(VaultStorageConfigOperationResultResponse):
    """Prepare DataMove Response.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param correlation_id: Co-relationId for move operation
    :type correlation_id: str
    :param source_vault_properties: Source Vault Properties
    :type source_vault_properties: dict[str, str]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'source_vault_properties': {'key': 'sourceVaultProperties', 'type': '{str}'},
    }

    def __init__(self, *, correlation_id: str=None, source_vault_properties=None, **kwargs) -> None:
        super(PrepareDataMoveResponse, self).__init__(**kwargs)
        self.correlation_id = correlation_id
        self.source_vault_properties = source_vault_properties
        self.object_type = 'PrepareDataMoveResponse'


class PreValidateEnableBackupRequest(Model):
    """Contract to validate if backup can be enabled on the given resource in a
    given vault and given configuration.
    It will validate followings
    1. Vault capacity
    2. VM is already protected
    3. Any VM related configuration passed in properties.

    :param resource_type: ProtectedItem Type- VM, SqlDataBase, AzureFileShare
     etc. Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type resource_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param resource_id: ARM Virtual Machine Id
    :type resource_id: str
    :param vault_id: ARM id of the Recovery Services Vault
    :type vault_id: str
    :param properties: Configuration of VM if any needs to be validated like
     OS type etc
    :type properties: str
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'vault_id': {'key': 'vaultId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'str'},
    }

    def __init__(self, *, resource_type=None, resource_id: str=None, vault_id: str=None, properties: str=None, **kwargs) -> None:
        super(PreValidateEnableBackupRequest, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.vault_id = vault_id
        self.properties = properties


class PreValidateEnableBackupResponse(Model):
    """Response contract for enable backup validation request.

    :param status: Validation Status. Possible values include: 'Invalid',
     'Succeeded', 'Failed'
    :type status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ValidationStatus
    :param error_code: Response error code
    :type error_code: str
    :param error_message: Response error message
    :type error_message: str
    :param recommendation: Recommended action for user
    :type recommendation: str
    :param container_name: Specifies the product specific container name. E.g.
     iaasvmcontainer;iaasvmcontainer;rgname;vmname. This is required
     for portal
    :type container_name: str
    :param protected_item_name: Specifies the product specific ds name. E.g.
     vm;iaasvmcontainer;rgname;vmname. This is required for portal
    :type protected_item_name: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'recommendation': {'key': 'recommendation', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'protected_item_name': {'key': 'protectedItemName', 'type': 'str'},
    }

    def __init__(self, *, status=None, error_code: str=None, error_message: str=None, recommendation: str=None, container_name: str=None, protected_item_name: str=None, **kwargs) -> None:
        super(PreValidateEnableBackupResponse, self).__init__(**kwargs)
        self.status = status
        self.error_code = error_code
        self.error_message = error_message
        self.recommendation = recommendation
        self.container_name = container_name
        self.protected_item_name = protected_item_name


class PrivateEndpoint(Model):
    """The Private Endpoint network resource that is linked to the Private
    Endpoint connection.

    :param id: Gets or sets id
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(Model):
    """Private Endpoint Connection Response Properties.

    :param provisioning_state: Gets or sets provisioning state of the private
     endpoint connection. Possible values include: 'Succeeded', 'Deleting',
     'Failed', 'Pending'
    :type provisioning_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProvisioningState
    :param private_endpoint: Gets or sets private endpoint associated with the
     private endpoint connection
    :type private_endpoint:
     ~azure.mgmt.recoveryservicesbackup.models.PrivateEndpoint
    :param private_link_service_connection_state: Gets or sets private link
     service connection state
    :type private_link_service_connection_state:
     ~azure.mgmt.recoveryservicesbackup.models.PrivateLinkServiceConnectionState
    """

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(self, *, provisioning_state=None, private_endpoint=None, private_link_service_connection_state=None, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateEndpointConnectionResource(Resource):
    """Private Endpoint Connection Response Properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: PrivateEndpointConnectionResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.PrivateEndpointConnection
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnection'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(PrivateEndpointConnectionResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class PrivateLinkServiceConnectionState(Model):
    """Private Link Service Connection State.

    :param status: Gets or sets the status. Possible values include:
     'Pending', 'Approved', 'Rejected', 'Disconnected'
    :type status: str or
     ~azure.mgmt.recoveryservicesbackup.models.PrivateEndpointConnectionStatus
    :param description: Gets or sets description
    :type description: str
    :param action_required: Gets or sets actions required
    :type action_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'action_required': {'key': 'actionRequired', 'type': 'str'},
    }

    def __init__(self, *, status=None, description: str=None, action_required: str=None, **kwargs) -> None:
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.action_required = action_required


class ProtectableContainerResource(Resource):
    """Protectable Container Class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ProtectableContainerResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.ProtectableContainer
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectableContainer'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(ProtectableContainerResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectedItemQueryObject(Model):
    """Filters to list backup items.

    :param health_state: Health State for the backed up item. Possible values
     include: 'Passed', 'ActionRequired', 'ActionSuggested', 'Invalid'
    :type health_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.HealthState
    :param backup_management_type: Backup management type for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param item_type: Type of workload this item represents. Possible values
     include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange',
     'Sharepoint', 'VMwareVM', 'SystemState', 'Client', 'GenericDataSource',
     'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type item_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param policy_name: Backup policy name associated with the backup item.
    :type policy_name: str
    :param container_name: Name of the container.
    :type container_name: str
    :param backup_engine_name: Backup Engine name
    :type backup_engine_name: str
    :param friendly_name: Friendly name of protected item
    :type friendly_name: str
    :param fabric_name: Name of the fabric.
    :type fabric_name: str
    :param backup_set_name: Name of the backup set.
    :type backup_set_name: str
    """

    _attribute_map = {
        'health_state': {'key': 'healthState', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'item_type': {'key': 'itemType', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'backup_engine_name': {'key': 'backupEngineName', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
    }

    def __init__(self, *, health_state=None, backup_management_type=None, item_type=None, policy_name: str=None, container_name: str=None, backup_engine_name: str=None, friendly_name: str=None, fabric_name: str=None, backup_set_name: str=None, **kwargs) -> None:
        super(ProtectedItemQueryObject, self).__init__(**kwargs)
        self.health_state = health_state
        self.backup_management_type = backup_management_type
        self.item_type = item_type
        self.policy_name = policy_name
        self.container_name = container_name
        self.backup_engine_name = backup_engine_name
        self.friendly_name = friendly_name
        self.fabric_name = fabric_name
        self.backup_set_name = backup_set_name


class ProtectedItemResource(Resource):
    """Base class for backup items.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ProtectedItemResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.ProtectedItem
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectedItem'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(ProtectedItemResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectionContainerResource(Resource):
    """Base class for container with backup items. Containers with specific
    workloads are derived from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ProtectionContainerResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionContainer
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectionContainer'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(ProtectionContainerResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectionIntentQueryObject(Model):
    """Filters to list protection intent.

    :param backup_management_type: Backup management type for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param item_type: Type of workload this item represents. Possible values
     include: 'Invalid', 'SQLInstance', 'SQLAvailabilityGroupContainer'
    :type item_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.IntentItemType
    :param parent_name: Parent name of the intent
    :type parent_name: str
    :param item_name: Item name of the intent
    :type item_name: str
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'item_type': {'key': 'itemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'item_name': {'key': 'itemName', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, item_type=None, parent_name: str=None, item_name: str=None, **kwargs) -> None:
        super(ProtectionIntentQueryObject, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.item_type = item_type
        self.parent_name = parent_name
        self.item_name = item_name


class ProtectionIntentResource(Resource):
    """Base class for backup ProtectionIntent.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ProtectionIntentResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionIntent
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectionIntent'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(ProtectionIntentResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectionPolicyQueryObject(Model):
    """Filters the list backup policies API.

    :param backup_management_type: Backup management type for the backup
     policy. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param fabric_name: Fabric name for filter
    :type fabric_name: str
    :param workload_type: Workload type for the backup policy. Possible values
     include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange',
     'Sharepoint', 'VMwareVM', 'SystemState', 'Client', 'GenericDataSource',
     'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type=None, fabric_name: str=None, workload_type=None, **kwargs) -> None:
        super(ProtectionPolicyQueryObject, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.fabric_name = fabric_name
        self.workload_type = workload_type


class ProtectionPolicyResource(Resource):
    """Base class for backup policy. Workload-specific backup policies are derived
    from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ProtectionPolicyResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectionPolicy'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(ProtectionPolicyResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class RecoveryPointDiskConfiguration(Model):
    """Disk configuration.

    :param number_of_disks_included_in_backup: Number of disks included in
     backup
    :type number_of_disks_included_in_backup: int
    :param number_of_disks_attached_to_vm: Number of disks attached to the VM
    :type number_of_disks_attached_to_vm: int
    :param included_disk_list: Information of disks included in backup
    :type included_disk_list:
     list[~azure.mgmt.recoveryservicesbackup.models.DiskInformation]
    :param excluded_disk_list: Information of disks excluded from backup
    :type excluded_disk_list:
     list[~azure.mgmt.recoveryservicesbackup.models.DiskInformation]
    """

    _attribute_map = {
        'number_of_disks_included_in_backup': {'key': 'numberOfDisksIncludedInBackup', 'type': 'int'},
        'number_of_disks_attached_to_vm': {'key': 'numberOfDisksAttachedToVm', 'type': 'int'},
        'included_disk_list': {'key': 'includedDiskList', 'type': '[DiskInformation]'},
        'excluded_disk_list': {'key': 'excludedDiskList', 'type': '[DiskInformation]'},
    }

    def __init__(self, *, number_of_disks_included_in_backup: int=None, number_of_disks_attached_to_vm: int=None, included_disk_list=None, excluded_disk_list=None, **kwargs) -> None:
        super(RecoveryPointDiskConfiguration, self).__init__(**kwargs)
        self.number_of_disks_included_in_backup = number_of_disks_included_in_backup
        self.number_of_disks_attached_to_vm = number_of_disks_attached_to_vm
        self.included_disk_list = included_disk_list
        self.excluded_disk_list = excluded_disk_list


class RecoveryPointMoveReadinessInfo(Model):
    """RecoveryPointMoveReadinessInfo.

    :param is_ready_for_move:
    :type is_ready_for_move: bool
    :param additional_info:
    :type additional_info: str
    """

    _attribute_map = {
        'is_ready_for_move': {'key': 'isReadyForMove', 'type': 'bool'},
        'additional_info': {'key': 'additionalInfo', 'type': 'str'},
    }

    def __init__(self, *, is_ready_for_move: bool=None, additional_info: str=None, **kwargs) -> None:
        super(RecoveryPointMoveReadinessInfo, self).__init__(**kwargs)
        self.is_ready_for_move = is_ready_for_move
        self.additional_info = additional_info


class RecoveryPointRehydrationInfo(Model):
    """RP Rehydration Info.

    :param rehydration_retention_duration: How long the rehydrated RP should
     be kept
     Should be ISO8601 Duration format e.g. "P7D"
    :type rehydration_retention_duration: str
    :param rehydration_priority: Rehydration Priority. Possible values
     include: 'Standard', 'High'
    :type rehydration_priority: str or
     ~azure.mgmt.recoveryservicesbackup.models.RehydrationPriority
    """

    _attribute_map = {
        'rehydration_retention_duration': {'key': 'rehydrationRetentionDuration', 'type': 'str'},
        'rehydration_priority': {'key': 'rehydrationPriority', 'type': 'str'},
    }

    def __init__(self, *, rehydration_retention_duration: str=None, rehydration_priority=None, **kwargs) -> None:
        super(RecoveryPointRehydrationInfo, self).__init__(**kwargs)
        self.rehydration_retention_duration = rehydration_retention_duration
        self.rehydration_priority = rehydration_priority


class RecoveryPointResource(Resource):
    """Base class for backup copies. Workload-specific backup copies are derived
    from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: RecoveryPointResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.RecoveryPoint
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'RecoveryPoint'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(RecoveryPointResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class RecoveryPointTierInformation(Model):
    """Recovery point tier information.

    :param type: Recovery point tier type. Possible values include: 'Invalid',
     'InstantRP', 'HardenedRP', 'ArchivedRP'
    :type type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierType
    :param status: Recovery point tier status. Possible values include:
     'Invalid', 'Valid', 'Disabled', 'Deleted', 'Rehydrated'
    :type status: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierStatus
    :param extended_info: Recovery point tier status.
    :type extended_info: dict[str, str]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'RecoveryPointTierType'},
        'status': {'key': 'status', 'type': 'RecoveryPointTierStatus'},
        'extended_info': {'key': 'extendedInfo', 'type': '{str}'},
    }

    def __init__(self, *, type=None, status=None, extended_info=None, **kwargs) -> None:
        super(RecoveryPointTierInformation, self).__init__(**kwargs)
        self.type = type
        self.status = status
        self.extended_info = extended_info


class ResourceList(Model):
    """Base for all lists of resources.

    :param next_link: The uri to fetch the next page of resources. Call
     ListNext() fetches next page of resources.
    :type next_link: str
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, next_link: str=None, **kwargs) -> None:
        super(ResourceList, self).__init__(**kwargs)
        self.next_link = next_link


class RestoreFileSpecs(Model):
    """Restore file specs like file path, type and target folder path info.

    :param path: Source File/Folder path
    :type path: str
    :param file_spec_type: Indicates what the Path variable stands for
    :type file_spec_type: str
    :param target_folder_path: Destination folder path in target FileShare
    :type target_folder_path: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'file_spec_type': {'key': 'fileSpecType', 'type': 'str'},
        'target_folder_path': {'key': 'targetFolderPath', 'type': 'str'},
    }

    def __init__(self, *, path: str=None, file_spec_type: str=None, target_folder_path: str=None, **kwargs) -> None:
        super(RestoreFileSpecs, self).__init__(**kwargs)
        self.path = path
        self.file_spec_type = file_spec_type
        self.target_folder_path = target_folder_path


class RestoreRequestResource(Resource):
    """Base class for restore request. Workload-specific restore requests are
    derived from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: RestoreRequestResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.RestoreRequest
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'RestoreRequest'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(RestoreRequestResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class RetentionDuration(Model):
    """Retention duration.

    :param count: Count of duration types. Retention duration is obtained by
     the counting the duration type Count times.
     For example, when Count = 3 and DurationType = Weeks, retention duration
     will be three weeks.
    :type count: int
    :param duration_type: Retention duration type of retention policy.
     Possible values include: 'Invalid', 'Days', 'Weeks', 'Months', 'Years'
    :type duration_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDurationType
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'duration_type': {'key': 'durationType', 'type': 'str'},
    }

    def __init__(self, *, count: int=None, duration_type=None, **kwargs) -> None:
        super(RetentionDuration, self).__init__(**kwargs)
        self.count = count
        self.duration_type = duration_type


class Settings(Model):
    """Common settings field for backup management.

    :param time_zone: TimeZone optional input as string. For example: TimeZone
     = "Pacific Standard Time".
    :type time_zone: str
    :param issqlcompression: SQL compression flag
    :type issqlcompression: bool
    :param is_compression: Workload compression flag. This has been added so
     that 'isSqlCompression'
     will be deprecated once clients upgrade to consider this flag.
    :type is_compression: bool
    """

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'issqlcompression': {'key': 'issqlcompression', 'type': 'bool'},
        'is_compression': {'key': 'isCompression', 'type': 'bool'},
    }

    def __init__(self, *, time_zone: str=None, issqlcompression: bool=None, is_compression: bool=None, **kwargs) -> None:
        super(Settings, self).__init__(**kwargs)
        self.time_zone = time_zone
        self.issqlcompression = issqlcompression
        self.is_compression = is_compression


class SimpleRetentionPolicy(RetentionPolicy):
    """Simple policy retention.

    All required parameters must be populated in order to send to Azure.

    :param retention_policy_type: Required. Constant filled by server.
    :type retention_policy_type: str
    :param retention_duration: Retention duration of the protection policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _validation = {
        'retention_policy_type': {'required': True},
    }

    _attribute_map = {
        'retention_policy_type': {'key': 'retentionPolicyType', 'type': 'str'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, *, retention_duration=None, **kwargs) -> None:
        super(SimpleRetentionPolicy, self).__init__(**kwargs)
        self.retention_duration = retention_duration
        self.retention_policy_type = 'SimpleRetentionPolicy'


class SimpleSchedulePolicy(SchedulePolicy):
    """Simple policy schedule.

    All required parameters must be populated in order to send to Azure.

    :param schedule_policy_type: Required. Constant filled by server.
    :type schedule_policy_type: str
    :param schedule_run_frequency: Frequency of the schedule operation of this
     policy. Possible values include: 'Invalid', 'Daily', 'Weekly'
    :type schedule_run_frequency: str or
     ~azure.mgmt.recoveryservicesbackup.models.ScheduleRunType
    :param schedule_run_days: List of days of week this schedule has to be
     run.
    :type schedule_run_days: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.DayOfWeek]
    :param schedule_run_times: List of times of day this schedule has to be
     run.
    :type schedule_run_times: list[datetime]
    :param schedule_weekly_frequency: At every number weeks this schedule has
     to be run.
    :type schedule_weekly_frequency: int
    """

    _validation = {
        'schedule_policy_type': {'required': True},
    }

    _attribute_map = {
        'schedule_policy_type': {'key': 'schedulePolicyType', 'type': 'str'},
        'schedule_run_frequency': {'key': 'scheduleRunFrequency', 'type': 'str'},
        'schedule_run_days': {'key': 'scheduleRunDays', 'type': '[DayOfWeek]'},
        'schedule_run_times': {'key': 'scheduleRunTimes', 'type': '[iso-8601]'},
        'schedule_weekly_frequency': {'key': 'scheduleWeeklyFrequency', 'type': 'int'},
    }

    def __init__(self, *, schedule_run_frequency=None, schedule_run_days=None, schedule_run_times=None, schedule_weekly_frequency: int=None, **kwargs) -> None:
        super(SimpleSchedulePolicy, self).__init__(**kwargs)
        self.schedule_run_frequency = schedule_run_frequency
        self.schedule_run_days = schedule_run_days
        self.schedule_run_times = schedule_run_times
        self.schedule_weekly_frequency = schedule_weekly_frequency
        self.schedule_policy_type = 'SimpleSchedulePolicy'


class SQLDataDirectory(Model):
    """SQLDataDirectory info.

    :param type: Type of data directory mapping. Possible values include:
     'Invalid', 'Data', 'Log'
    :type type: str or
     ~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectoryType
    :param path: File path
    :type path: str
    :param logical_name: Logical name of the file
    :type logical_name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'logical_name': {'key': 'logicalName', 'type': 'str'},
    }

    def __init__(self, *, type=None, path: str=None, logical_name: str=None, **kwargs) -> None:
        super(SQLDataDirectory, self).__init__(**kwargs)
        self.type = type
        self.path = path
        self.logical_name = logical_name


class SQLDataDirectoryMapping(Model):
    """Encapsulates information regarding data directory.

    :param mapping_type: Type of data directory mapping. Possible values
     include: 'Invalid', 'Data', 'Log'
    :type mapping_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectoryType
    :param source_logical_name: Restore source logical name path
    :type source_logical_name: str
    :param source_path: Restore source path
    :type source_path: str
    :param target_path: Target path
    :type target_path: str
    """

    _attribute_map = {
        'mapping_type': {'key': 'mappingType', 'type': 'str'},
        'source_logical_name': {'key': 'sourceLogicalName', 'type': 'str'},
        'source_path': {'key': 'sourcePath', 'type': 'str'},
        'target_path': {'key': 'targetPath', 'type': 'str'},
    }

    def __init__(self, *, mapping_type=None, source_logical_name: str=None, source_path: str=None, target_path: str=None, **kwargs) -> None:
        super(SQLDataDirectoryMapping, self).__init__(**kwargs)
        self.mapping_type = mapping_type
        self.source_logical_name = source_logical_name
        self.source_path = source_path
        self.target_path = target_path


class SubProtectionPolicy(Model):
    """Sub-protection policy which includes schedule and retention.

    :param policy_type: Type of backup policy type. Possible values include:
     'Invalid', 'Full', 'Differential', 'Log', 'CopyOnlyFull', 'Incremental'
    :type policy_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.PolicyType
    :param schedule_policy: Backup schedule specified as part of backup
     policy.
    :type schedule_policy:
     ~azure.mgmt.recoveryservicesbackup.models.SchedulePolicy
    :param retention_policy: Retention policy with the details on backup copy
     retention ranges.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    """

    _attribute_map = {
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'schedule_policy': {'key': 'schedulePolicy', 'type': 'SchedulePolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, *, policy_type=None, schedule_policy=None, retention_policy=None, **kwargs) -> None:
        super(SubProtectionPolicy, self).__init__(**kwargs)
        self.policy_type = policy_type
        self.schedule_policy = schedule_policy
        self.retention_policy = retention_policy


class TargetAFSRestoreInfo(Model):
    """Target Azure File Share Info.

    :param name: File share name
    :type name: str
    :param target_resource_id: Target file share resource ARM ID
    :type target_resource_id: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, target_resource_id: str=None, **kwargs) -> None:
        super(TargetAFSRestoreInfo, self).__init__(**kwargs)
        self.name = name
        self.target_resource_id = target_resource_id


class TargetRestoreInfo(Model):
    """Details about target workload during restore operation.

    :param overwrite_option: Can Overwrite if Target DataBase already exists.
     Possible values include: 'Invalid', 'FailOnConflict', 'Overwrite'
    :type overwrite_option: str or
     ~azure.mgmt.recoveryservicesbackup.models.OverwriteOptions
    :param container_id: Resource Id name of the container in which Target
     DataBase resides
    :type container_id: str
    :param database_name: Database name InstanceName/DataBaseName for SQL or
     System/DbName for SAP Hana
    :type database_name: str
    :param target_directory_for_file_restore: Target directory location for
     restore as files.
    :type target_directory_for_file_restore: str
    """

    _attribute_map = {
        'overwrite_option': {'key': 'overwriteOption', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'target_directory_for_file_restore': {'key': 'targetDirectoryForFileRestore', 'type': 'str'},
    }

    def __init__(self, *, overwrite_option=None, container_id: str=None, database_name: str=None, target_directory_for_file_restore: str=None, **kwargs) -> None:
        super(TargetRestoreInfo, self).__init__(**kwargs)
        self.overwrite_option = overwrite_option
        self.container_id = container_id
        self.database_name = database_name
        self.target_directory_for_file_restore = target_directory_for_file_restore


class TokenInformation(Model):
    """The token information details.

    :param token: Token value.
    :type token: str
    :param expiry_time_in_utc_ticks: Expiry time of token.
    :type expiry_time_in_utc_ticks: long
    :param security_pin: Security PIN
    :type security_pin: str
    """

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
        'expiry_time_in_utc_ticks': {'key': 'expiryTimeInUtcTicks', 'type': 'long'},
        'security_pin': {'key': 'securityPIN', 'type': 'str'},
    }

    def __init__(self, *, token: str=None, expiry_time_in_utc_ticks: int=None, security_pin: str=None, **kwargs) -> None:
        super(TokenInformation, self).__init__(**kwargs)
        self.token = token
        self.expiry_time_in_utc_ticks = expiry_time_in_utc_ticks
        self.security_pin = security_pin


class TriggerDataMoveRequest(Model):
    """Trigger DataMove Request.

    All required parameters must be populated in order to send to Azure.

    :param source_resource_id: Required. ARM Id of source vault
    :type source_resource_id: str
    :param source_region: Required. Source Region
    :type source_region: str
    :param data_move_level: Required. DataMove Level. Possible values include:
     'Invalid', 'Vault', 'Container'
    :type data_move_level: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataMoveLevel
    :param correlation_id: Required. Correlation Id
    :type correlation_id: str
    :param source_container_arm_ids: Source Container ArmIds
    :type source_container_arm_ids: list[str]
    :param pause_gc: Pause GC
    :type pause_gc: bool
    """

    _validation = {
        'source_resource_id': {'required': True},
        'source_region': {'required': True},
        'data_move_level': {'required': True},
        'correlation_id': {'required': True},
    }

    _attribute_map = {
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'source_region': {'key': 'sourceRegion', 'type': 'str'},
        'data_move_level': {'key': 'dataMoveLevel', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'source_container_arm_ids': {'key': 'sourceContainerArmIds', 'type': '[str]'},
        'pause_gc': {'key': 'pauseGC', 'type': 'bool'},
    }

    def __init__(self, *, source_resource_id: str, source_region: str, data_move_level, correlation_id: str, source_container_arm_ids=None, pause_gc: bool=None, **kwargs) -> None:
        super(TriggerDataMoveRequest, self).__init__(**kwargs)
        self.source_resource_id = source_resource_id
        self.source_region = source_region
        self.data_move_level = data_move_level
        self.correlation_id = correlation_id
        self.source_container_arm_ids = source_container_arm_ids
        self.pause_gc = pause_gc


class ValidateOperationRequest(Model):
    """Base class for validate operation request.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ValidateRestoreOperationRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'ValidateRestoreOperationRequest': 'ValidateRestoreOperationRequest'}
    }

    def __init__(self, **kwargs) -> None:
        super(ValidateOperationRequest, self).__init__(**kwargs)
        self.object_type = None


class ValidateRestoreOperationRequest(ValidateOperationRequest):
    """AzureRestoreValidation request.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ValidateIaasVMRestoreOperationRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param restore_request: Sets restore request to be validated
    :type restore_request:
     ~azure.mgmt.recoveryservicesbackup.models.RestoreRequest
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'restore_request': {'key': 'restoreRequest', 'type': 'RestoreRequest'},
    }

    _subtype_map = {
        'object_type': {'ValidateIaasVMRestoreOperationRequest': 'ValidateIaasVMRestoreOperationRequest'}
    }

    def __init__(self, *, restore_request=None, **kwargs) -> None:
        super(ValidateRestoreOperationRequest, self).__init__(**kwargs)
        self.restore_request = restore_request
        self.object_type = 'ValidateRestoreOperationRequest'


class ValidateIaasVMRestoreOperationRequest(ValidateRestoreOperationRequest):
    """AzureRestoreValidation request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param restore_request: Sets restore request to be validated
    :type restore_request:
     ~azure.mgmt.recoveryservicesbackup.models.RestoreRequest
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'restore_request': {'key': 'restoreRequest', 'type': 'RestoreRequest'},
    }

    def __init__(self, *, restore_request=None, **kwargs) -> None:
        super(ValidateIaasVMRestoreOperationRequest, self).__init__(restore_request=restore_request, **kwargs)
        self.object_type = 'ValidateIaasVMRestoreOperationRequest'


class ValidateOperationResponse(Model):
    """Base class for validate operation response.

    :param validation_results: Gets the validation result
    :type validation_results:
     list[~azure.mgmt.recoveryservicesbackup.models.ErrorDetail]
    """

    _attribute_map = {
        'validation_results': {'key': 'validationResults', 'type': '[ErrorDetail]'},
    }

    def __init__(self, *, validation_results=None, **kwargs) -> None:
        super(ValidateOperationResponse, self).__init__(**kwargs)
        self.validation_results = validation_results


class ValidateOperationsResponse(Model):
    """ValidateOperationsResponse.

    :param validate_operation_response:
    :type validate_operation_response:
     ~azure.mgmt.recoveryservicesbackup.models.ValidateOperationResponse
    """

    _attribute_map = {
        'validate_operation_response': {'key': 'validateOperationResponse', 'type': 'ValidateOperationResponse'},
    }

    def __init__(self, *, validate_operation_response=None, **kwargs) -> None:
        super(ValidateOperationsResponse, self).__init__(**kwargs)
        self.validate_operation_response = validate_operation_response


class VaultJob(Job):
    """Vault level Job.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param duration: Time elapsed during the execution of this job.
    :type duration: timedelta
    :param actions_info: Gets or sets the state/actions applicable on this job
     like cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param error_details: Error details on execution of this job.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.VaultJobErrorInfo]
    :param extended_info: Additional information about the job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.VaultJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'error_details': {'key': 'errorDetails', 'type': '[VaultJobErrorInfo]'},
        'extended_info': {'key': 'extendedInfo', 'type': 'VaultJobExtendedInfo'},
    }

    def __init__(self, *, entity_friendly_name: str=None, backup_management_type=None, operation: str=None, status: str=None, start_time=None, end_time=None, activity_id: str=None, duration=None, actions_info=None, error_details=None, extended_info=None, **kwargs) -> None:
        super(VaultJob, self).__init__(entity_friendly_name=entity_friendly_name, backup_management_type=backup_management_type, operation=operation, status=status, start_time=start_time, end_time=end_time, activity_id=activity_id, **kwargs)
        self.duration = duration
        self.actions_info = actions_info
        self.error_details = error_details
        self.extended_info = extended_info
        self.job_type = 'VaultJob'


class VaultJobErrorInfo(Model):
    """Vault Job specific error information.

    :param error_code: Error code.
    :type error_code: int
    :param error_string: Localized error string.
    :type error_string: str
    :param recommendations: List of localized recommendations for above error
     code.
    :type recommendations: list[str]
    """

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'error_string': {'key': 'errorString', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, *, error_code: int=None, error_string: str=None, recommendations=None, **kwargs) -> None:
        super(VaultJobErrorInfo, self).__init__(**kwargs)
        self.error_code = error_code
        self.error_string = error_string
        self.recommendations = recommendations


class VaultJobExtendedInfo(Model):
    """Vault Job for CMK - has CMK specific info.

    :param property_bag: Job properties.
    :type property_bag: dict[str, str]
    """

    _attribute_map = {
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
    }

    def __init__(self, *, property_bag=None, **kwargs) -> None:
        super(VaultJobExtendedInfo, self).__init__(**kwargs)
        self.property_bag = property_bag


class WeeklyRetentionFormat(Model):
    """Weekly retention format.

    :param days_of_the_week: List of days of the week.
    :type days_of_the_week: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.DayOfWeek]
    :param weeks_of_the_month: List of weeks of month.
    :type weeks_of_the_month: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.WeekOfMonth]
    """

    _attribute_map = {
        'days_of_the_week': {'key': 'daysOfTheWeek', 'type': '[DayOfWeek]'},
        'weeks_of_the_month': {'key': 'weeksOfTheMonth', 'type': '[WeekOfMonth]'},
    }

    def __init__(self, *, days_of_the_week=None, weeks_of_the_month=None, **kwargs) -> None:
        super(WeeklyRetentionFormat, self).__init__(**kwargs)
        self.days_of_the_week = days_of_the_week
        self.weeks_of_the_month = weeks_of_the_month


class WeeklyRetentionSchedule(Model):
    """Weekly retention schedule.

    :param days_of_the_week: List of days of week for weekly retention policy.
    :type days_of_the_week: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.DayOfWeek]
    :param retention_times: Retention times of retention policy.
    :type retention_times: list[datetime]
    :param retention_duration: Retention duration of retention Policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _attribute_map = {
        'days_of_the_week': {'key': 'daysOfTheWeek', 'type': '[DayOfWeek]'},
        'retention_times': {'key': 'retentionTimes', 'type': '[iso-8601]'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, *, days_of_the_week=None, retention_times=None, retention_duration=None, **kwargs) -> None:
        super(WeeklyRetentionSchedule, self).__init__(**kwargs)
        self.days_of_the_week = days_of_the_week
        self.retention_times = retention_times
        self.retention_duration = retention_duration


class WorkloadCrrAccessToken(CrrAccessToken):
    """WorkloadCrrAccessToken.

    All required parameters must be populated in order to send to Azure.

    :param access_token_string: Access token used for authentication
    :type access_token_string: str
    :param subscription_id: Subscription Id of the source vault
    :type subscription_id: str
    :param resource_group_name: Resource Group name of the source vault
    :type resource_group_name: str
    :param resource_name: Resource Name of the source vault
    :type resource_name: str
    :param resource_id: Resource Id of the source vault
    :type resource_id: str
    :param protection_container_id: Protected item container id
    :type protection_container_id: long
    :param recovery_point_id: Recovery Point Id
    :type recovery_point_id: str
    :param recovery_point_time: Recovery Point Time
    :type recovery_point_time: str
    :param container_name: Container Unique name
    :type container_name: str
    :param container_type: Container Type
    :type container_type: str
    :param backup_management_type: Backup Management Type
    :type backup_management_type: str
    :param datasource_type: Datasource Type
    :type datasource_type: str
    :param datasource_name: Datasource Friendly Name
    :type datasource_name: str
    :param datasource_id: Datasource Id
    :type datasource_id: str
    :param datasource_container_name: Datasource Container Unique Name
    :type datasource_container_name: str
    :param coordinator_service_stamp_id: CoordinatorServiceStampId to be used
     by BCM in restore call
    :type coordinator_service_stamp_id: str
    :param coordinator_service_stamp_uri: CoordinatorServiceStampUri to be
     used by BCM in restore call
    :type coordinator_service_stamp_uri: str
    :param protection_service_stamp_id: ProtectionServiceStampId to be used by
     BCM in restore call
    :type protection_service_stamp_id: str
    :param protection_service_stamp_uri: ProtectionServiceStampUri to be used
     by BCM in restore call
    :type protection_service_stamp_uri: str
    :param token_extended_information: Extended Information about the token
     like FileSpec etc.
    :type token_extended_information: str
    :param rp_tier_information: Recovery point Tier Information
    :type rp_tier_information: dict[str, str]
    :param rp_original_sa_option: Recovery point information: Original SA
     option
    :type rp_original_sa_option: bool
    :param rp_is_managed_virtual_machine: Recovery point information: Managed
     virtual machine
    :type rp_is_managed_virtual_machine: bool
    :param rp_vm_size_description: Recovery point information: VM size
     description
    :type rp_vm_size_description: str
    :param b_ms_active_region: Active region name of BMS Stamp
    :type b_ms_active_region: str
    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param protectable_object_unique_name:
    :type protectable_object_unique_name: str
    :param protectable_object_friendly_name:
    :type protectable_object_friendly_name: str
    :param protectable_object_workload_type:
    :type protectable_object_workload_type: str
    :param protectable_object_protection_state:
    :type protectable_object_protection_state: str
    :param protectable_object_container_host_os_name:
    :type protectable_object_container_host_os_name: str
    :param protectable_object_parent_logical_container_name:
    :type protectable_object_parent_logical_container_name: str
    :param container_id: Container Id
    :type container_id: str
    :param policy_name: Policy Name
    :type policy_name: str
    :param policy_id: Policy Id
    :type policy_id: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'access_token_string': {'key': 'accessTokenString', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'protection_container_id': {'key': 'protectionContainerId', 'type': 'long'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'datasource_type': {'key': 'datasourceType', 'type': 'str'},
        'datasource_name': {'key': 'datasourceName', 'type': 'str'},
        'datasource_id': {'key': 'datasourceId', 'type': 'str'},
        'datasource_container_name': {'key': 'datasourceContainerName', 'type': 'str'},
        'coordinator_service_stamp_id': {'key': 'coordinatorServiceStampId', 'type': 'str'},
        'coordinator_service_stamp_uri': {'key': 'coordinatorServiceStampUri', 'type': 'str'},
        'protection_service_stamp_id': {'key': 'protectionServiceStampId', 'type': 'str'},
        'protection_service_stamp_uri': {'key': 'protectionServiceStampUri', 'type': 'str'},
        'token_extended_information': {'key': 'tokenExtendedInformation', 'type': 'str'},
        'rp_tier_information': {'key': 'rpTierInformation', 'type': '{str}'},
        'rp_original_sa_option': {'key': 'rpOriginalSAOption', 'type': 'bool'},
        'rp_is_managed_virtual_machine': {'key': 'rpIsManagedVirtualMachine', 'type': 'bool'},
        'rp_vm_size_description': {'key': 'rpVMSizeDescription', 'type': 'str'},
        'b_ms_active_region': {'key': 'bMSActiveRegion', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'protectable_object_unique_name': {'key': 'protectableObjectUniqueName', 'type': 'str'},
        'protectable_object_friendly_name': {'key': 'protectableObjectFriendlyName', 'type': 'str'},
        'protectable_object_workload_type': {'key': 'protectableObjectWorkloadType', 'type': 'str'},
        'protectable_object_protection_state': {'key': 'protectableObjectProtectionState', 'type': 'str'},
        'protectable_object_container_host_os_name': {'key': 'protectableObjectContainerHostOsName', 'type': 'str'},
        'protectable_object_parent_logical_container_name': {'key': 'protectableObjectParentLogicalContainerName', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
    }

    def __init__(self, *, access_token_string: str=None, subscription_id: str=None, resource_group_name: str=None, resource_name: str=None, resource_id: str=None, protection_container_id: int=None, recovery_point_id: str=None, recovery_point_time: str=None, container_name: str=None, container_type: str=None, backup_management_type: str=None, datasource_type: str=None, datasource_name: str=None, datasource_id: str=None, datasource_container_name: str=None, coordinator_service_stamp_id: str=None, coordinator_service_stamp_uri: str=None, protection_service_stamp_id: str=None, protection_service_stamp_uri: str=None, token_extended_information: str=None, rp_tier_information=None, rp_original_sa_option: bool=None, rp_is_managed_virtual_machine: bool=None, rp_vm_size_description: str=None, b_ms_active_region: str=None, protectable_object_unique_name: str=None, protectable_object_friendly_name: str=None, protectable_object_workload_type: str=None, protectable_object_protection_state: str=None, protectable_object_container_host_os_name: str=None, protectable_object_parent_logical_container_name: str=None, container_id: str=None, policy_name: str=None, policy_id: str=None, **kwargs) -> None:
        super(WorkloadCrrAccessToken, self).__init__(access_token_string=access_token_string, subscription_id=subscription_id, resource_group_name=resource_group_name, resource_name=resource_name, resource_id=resource_id, protection_container_id=protection_container_id, recovery_point_id=recovery_point_id, recovery_point_time=recovery_point_time, container_name=container_name, container_type=container_type, backup_management_type=backup_management_type, datasource_type=datasource_type, datasource_name=datasource_name, datasource_id=datasource_id, datasource_container_name=datasource_container_name, coordinator_service_stamp_id=coordinator_service_stamp_id, coordinator_service_stamp_uri=coordinator_service_stamp_uri, protection_service_stamp_id=protection_service_stamp_id, protection_service_stamp_uri=protection_service_stamp_uri, token_extended_information=token_extended_information, rp_tier_information=rp_tier_information, rp_original_sa_option=rp_original_sa_option, rp_is_managed_virtual_machine=rp_is_managed_virtual_machine, rp_vm_size_description=rp_vm_size_description, b_ms_active_region=b_ms_active_region, **kwargs)
        self.protectable_object_unique_name = protectable_object_unique_name
        self.protectable_object_friendly_name = protectable_object_friendly_name
        self.protectable_object_workload_type = protectable_object_workload_type
        self.protectable_object_protection_state = protectable_object_protection_state
        self.protectable_object_container_host_os_name = protectable_object_container_host_os_name
        self.protectable_object_parent_logical_container_name = protectable_object_parent_logical_container_name
        self.container_id = container_id
        self.policy_name = policy_name
        self.policy_id = policy_id
        self.object_type = 'WorkloadCrrAccessToken'


class WorkloadInquiryDetails(Model):
    """Details of an inquired protectable item.

    :param type: Type of the Workload such as SQL, Oracle etc.
    :type type: str
    :param item_count: Contains the protectable item Count inside this
     Container.
    :type item_count: long
    :param inquiry_validation: Inquiry validation such as permissions and
     other backup validations.
    :type inquiry_validation:
     ~azure.mgmt.recoveryservicesbackup.models.InquiryValidation
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'item_count': {'key': 'itemCount', 'type': 'long'},
        'inquiry_validation': {'key': 'inquiryValidation', 'type': 'InquiryValidation'},
    }

    def __init__(self, *, type: str=None, item_count: int=None, inquiry_validation=None, **kwargs) -> None:
        super(WorkloadInquiryDetails, self).__init__(**kwargs)
        self.type = type
        self.item_count = item_count
        self.inquiry_validation = inquiry_validation


class WorkloadItemResource(Resource):
    """Base class for backup item. Workload-specific backup items are derived from
    this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: WorkloadItemResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.WorkloadItem
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'WorkloadItem'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(WorkloadItemResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class WorkloadProtectableItemResource(Resource):
    """Base class for backup item. Workload-specific backup items are derived from
    this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: WorkloadProtectableItemResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadProtectableItem
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'WorkloadProtectableItem'},
    }

    def __init__(self, *, location: str=None, tags=None, e_tag: str=None, properties=None, **kwargs) -> None:
        super(WorkloadProtectableItemResource, self).__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class YearlyRetentionSchedule(Model):
    """Yearly retention schedule.

    :param retention_schedule_format_type: Retention schedule format for
     yearly retention policy. Possible values include: 'Invalid', 'Daily',
     'Weekly'
    :type retention_schedule_format_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RetentionScheduleFormat
    :param months_of_year: List of months of year of yearly retention policy.
    :type months_of_year: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.MonthOfYear]
    :param retention_schedule_daily: Daily retention format for yearly
     retention policy.
    :type retention_schedule_daily:
     ~azure.mgmt.recoveryservicesbackup.models.DailyRetentionFormat
    :param retention_schedule_weekly: Weekly retention format for yearly
     retention policy.
    :type retention_schedule_weekly:
     ~azure.mgmt.recoveryservicesbackup.models.WeeklyRetentionFormat
    :param retention_times: Retention times of retention policy.
    :type retention_times: list[datetime]
    :param retention_duration: Retention duration of retention Policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _attribute_map = {
        'retention_schedule_format_type': {'key': 'retentionScheduleFormatType', 'type': 'str'},
        'months_of_year': {'key': 'monthsOfYear', 'type': '[MonthOfYear]'},
        'retention_schedule_daily': {'key': 'retentionScheduleDaily', 'type': 'DailyRetentionFormat'},
        'retention_schedule_weekly': {'key': 'retentionScheduleWeekly', 'type': 'WeeklyRetentionFormat'},
        'retention_times': {'key': 'retentionTimes', 'type': '[iso-8601]'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, *, retention_schedule_format_type=None, months_of_year=None, retention_schedule_daily=None, retention_schedule_weekly=None, retention_times=None, retention_duration=None, **kwargs) -> None:
        super(YearlyRetentionSchedule, self).__init__(**kwargs)
        self.retention_schedule_format_type = retention_schedule_format_type
        self.months_of_year = months_of_year
        self.retention_schedule_daily = retention_schedule_daily
        self.retention_schedule_weekly = retention_schedule_weekly
        self.retention_times = retention_times
        self.retention_duration = retention_duration
