# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-20 16:05
from __future__ import unicode_literals

from django.db import migrations
from django.contrib.auth.hashers import make_password

from weblate.appsettings import ANONYMOUS_USER_NAME


def add_anonymous_profile(apps, schema_editor):
    """Ensure anonymous user has profile"""
    User = apps.get_model('auth', 'User')
    Group = apps.get_model('auth', 'Group')
    Profile = apps.get_model('accounts', 'Profile')
    anon_user = User.objects.get_or_create(
        username=ANONYMOUS_USER_NAME,
        defaults={
            'is_active': False,
            'password': make_password(None),
            'email': 'noreply@weblate.org',
        }
    )[0]
    guest_group = Group.objects.get_or_create(name='Guests')[0]
    anon_user.groups.clear()
    anon_user.groups.add(guest_group)
    Profile.objects.get_or_create(user=anon_user)


class Migration(migrations.Migration):

    dependencies = [
        ('accounts', '0016_add-api-keys'),
        ('auth', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(add_anonymous_profile),
    ]
