/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job;

import java.io.Serializable;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.job.JobState;

@PublicAPI
public enum JobStatus implements Serializable
{
    PENDING("Pending", true, JobState.PENDING_RANK),
    RUNNING("Running", true, JobState.RUNNING_RANK),
    STALLED("Stalled", true, JobState.RUNNING_RANK),
    FINISHED("Finished", false, JobState.FINISHED_RANK),
    PAUSED("Paused", true, JobState.RUNNING_RANK),
    CANCELED("Canceled", false, JobState.FINISHED_RANK),
    FAILED("Failed", false, JobState.FINISHED_RANK),
    KILLED("Killed", false, JobState.FINISHED_RANK),
    IN_ERROR("In-Error", true, JobState.RUNNING_RANK);

    private final String definition;
    private final boolean jobAlive;
    private final int rank;

    private JobStatus(String def, boolean jobAlive, int rank) {
        this.definition = def;
        this.jobAlive = jobAlive;
        this.rank = rank;
    }

    public static JobStatus findStatus(String name) {
        for (JobStatus jobStatus : JobStatus.values()) {
            if (!name.equalsIgnoreCase(jobStatus.toString())) continue;
            return jobStatus;
        }
        return KILLED;
    }

    public String toString() {
        return this.definition;
    }

    public boolean isJobAlive() {
        return this.jobAlive;
    }

    public int getRank() {
        return this.rank;
    }
}

