# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import RecoveryServicesBackupClientConfiguration
from .operations import BackupResourceVaultConfigsOperations
from .operations import BackupResourceEncryptionConfigsOperations
from .operations import PrivateEndpointConnectionOperations
from .operations import PrivateEndpointOperations
from .operations import RecoveryServicesBackupClientOperationsMixin
from .operations import BMSPrepareDataMoveOperationResultOperations
from .operations import ProtectedItemsOperations
from .operations import ProtectedItemOperationResultsOperations
from .operations import RecoveryPointsOperations
from .operations import RestoresOperations
from .operations import BackupPoliciesOperations
from .operations import ProtectionPoliciesOperations
from .operations import ProtectionPolicyOperationResultsOperations
from .operations import BackupJobsOperations
from .operations import JobDetailsOperations
from .operations import JobCancellationsOperations
from .operations import JobOperationResultsOperations
from .operations import ExportJobsOperationResultsOperations
from .operations import JobsOperations
from .operations import BackupProtectedItemsOperations
from .operations import OperationOperations
from .operations import BackupEnginesOperations
from .operations import ProtectionContainerRefreshOperationResultsOperations
from .operations import ProtectableContainersOperations
from .operations import ProtectionContainersOperations
from .operations import BackupWorkloadItemsOperations
from .operations import ProtectionContainerOperationResultsOperations
from .operations import BackupsOperations
from .operations import ProtectedItemOperationStatusesOperations
from .operations import ItemLevelRecoveryConnectionsOperations
from .operations import BackupOperationResultsOperations
from .operations import BackupOperationStatusesOperations
from .operations import ProtectionPolicyOperationStatusesOperations
from .operations import BackupProtectableItemsOperations
from .operations import BackupProtectionContainersOperations
from .operations import SecurityPINsOperations
from .operations import RecoveryPointsRecommendedForMoveOperations
from .operations import BackupUsageSummariesCRROperations
from .operations import AadPropertiesOperations
from .operations import CrossRegionRestoreOperations
from .operations import BackupCrrJobDetailsOperations
from .operations import BackupCrrJobsOperations
from .operations import CrrOperationResultsOperations
from .operations import CrrOperationStatusOperations
from .operations import BackupResourceStorageConfigsOperations
from .operations import RecoveryPointsCrrOperations
from .operations import BackupProtectedItemsCrrOperations
from .operations import ProtectionIntentOperations
from .operations import BackupStatusOperations
from .operations import FeatureSupportOperations
from .operations import BackupProtectionIntentOperations
from .operations import BackupUsageSummariesOperations
from .operations import Operations
from .. import models


class RecoveryServicesBackupClient(RecoveryServicesBackupClientOperationsMixin):
    """Open API 2.0 Specs for Azure RecoveryServices Backup service.

    :ivar backup_resource_vault_configs: BackupResourceVaultConfigsOperations operations
    :vartype backup_resource_vault_configs: azure.mgmt.recoveryservicesbackup.aio.operations.BackupResourceVaultConfigsOperations
    :ivar backup_resource_encryption_configs: BackupResourceEncryptionConfigsOperations operations
    :vartype backup_resource_encryption_configs: azure.mgmt.recoveryservicesbackup.aio.operations.BackupResourceEncryptionConfigsOperations
    :ivar private_endpoint_connection: PrivateEndpointConnectionOperations operations
    :vartype private_endpoint_connection: azure.mgmt.recoveryservicesbackup.aio.operations.PrivateEndpointConnectionOperations
    :ivar private_endpoint: PrivateEndpointOperations operations
    :vartype private_endpoint: azure.mgmt.recoveryservicesbackup.aio.operations.PrivateEndpointOperations
    :ivar bms_prepare_data_move_operation_result: BMSPrepareDataMoveOperationResultOperations operations
    :vartype bms_prepare_data_move_operation_result: azure.mgmt.recoveryservicesbackup.aio.operations.BMSPrepareDataMoveOperationResultOperations
    :ivar protected_items: ProtectedItemsOperations operations
    :vartype protected_items: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectedItemsOperations
    :ivar protected_item_operation_results: ProtectedItemOperationResultsOperations operations
    :vartype protected_item_operation_results: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectedItemOperationResultsOperations
    :ivar recovery_points: RecoveryPointsOperations operations
    :vartype recovery_points: azure.mgmt.recoveryservicesbackup.aio.operations.RecoveryPointsOperations
    :ivar restores: RestoresOperations operations
    :vartype restores: azure.mgmt.recoveryservicesbackup.aio.operations.RestoresOperations
    :ivar backup_policies: BackupPoliciesOperations operations
    :vartype backup_policies: azure.mgmt.recoveryservicesbackup.aio.operations.BackupPoliciesOperations
    :ivar protection_policies: ProtectionPoliciesOperations operations
    :vartype protection_policies: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectionPoliciesOperations
    :ivar protection_policy_operation_results: ProtectionPolicyOperationResultsOperations operations
    :vartype protection_policy_operation_results: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectionPolicyOperationResultsOperations
    :ivar backup_jobs: BackupJobsOperations operations
    :vartype backup_jobs: azure.mgmt.recoveryservicesbackup.aio.operations.BackupJobsOperations
    :ivar job_details: JobDetailsOperations operations
    :vartype job_details: azure.mgmt.recoveryservicesbackup.aio.operations.JobDetailsOperations
    :ivar job_cancellations: JobCancellationsOperations operations
    :vartype job_cancellations: azure.mgmt.recoveryservicesbackup.aio.operations.JobCancellationsOperations
    :ivar job_operation_results: JobOperationResultsOperations operations
    :vartype job_operation_results: azure.mgmt.recoveryservicesbackup.aio.operations.JobOperationResultsOperations
    :ivar export_jobs_operation_results: ExportJobsOperationResultsOperations operations
    :vartype export_jobs_operation_results: azure.mgmt.recoveryservicesbackup.aio.operations.ExportJobsOperationResultsOperations
    :ivar jobs: JobsOperations operations
    :vartype jobs: azure.mgmt.recoveryservicesbackup.aio.operations.JobsOperations
    :ivar backup_protected_items: BackupProtectedItemsOperations operations
    :vartype backup_protected_items: azure.mgmt.recoveryservicesbackup.aio.operations.BackupProtectedItemsOperations
    :ivar operation: OperationOperations operations
    :vartype operation: azure.mgmt.recoveryservicesbackup.aio.operations.OperationOperations
    :ivar backup_engines: BackupEnginesOperations operations
    :vartype backup_engines: azure.mgmt.recoveryservicesbackup.aio.operations.BackupEnginesOperations
    :ivar protection_container_refresh_operation_results: ProtectionContainerRefreshOperationResultsOperations operations
    :vartype protection_container_refresh_operation_results: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectionContainerRefreshOperationResultsOperations
    :ivar protectable_containers: ProtectableContainersOperations operations
    :vartype protectable_containers: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectableContainersOperations
    :ivar protection_containers: ProtectionContainersOperations operations
    :vartype protection_containers: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectionContainersOperations
    :ivar backup_workload_items: BackupWorkloadItemsOperations operations
    :vartype backup_workload_items: azure.mgmt.recoveryservicesbackup.aio.operations.BackupWorkloadItemsOperations
    :ivar protection_container_operation_results: ProtectionContainerOperationResultsOperations operations
    :vartype protection_container_operation_results: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectionContainerOperationResultsOperations
    :ivar backups: BackupsOperations operations
    :vartype backups: azure.mgmt.recoveryservicesbackup.aio.operations.BackupsOperations
    :ivar protected_item_operation_statuses: ProtectedItemOperationStatusesOperations operations
    :vartype protected_item_operation_statuses: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectedItemOperationStatusesOperations
    :ivar item_level_recovery_connections: ItemLevelRecoveryConnectionsOperations operations
    :vartype item_level_recovery_connections: azure.mgmt.recoveryservicesbackup.aio.operations.ItemLevelRecoveryConnectionsOperations
    :ivar backup_operation_results: BackupOperationResultsOperations operations
    :vartype backup_operation_results: azure.mgmt.recoveryservicesbackup.aio.operations.BackupOperationResultsOperations
    :ivar backup_operation_statuses: BackupOperationStatusesOperations operations
    :vartype backup_operation_statuses: azure.mgmt.recoveryservicesbackup.aio.operations.BackupOperationStatusesOperations
    :ivar protection_policy_operation_statuses: ProtectionPolicyOperationStatusesOperations operations
    :vartype protection_policy_operation_statuses: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectionPolicyOperationStatusesOperations
    :ivar backup_protectable_items: BackupProtectableItemsOperations operations
    :vartype backup_protectable_items: azure.mgmt.recoveryservicesbackup.aio.operations.BackupProtectableItemsOperations
    :ivar backup_protection_containers: BackupProtectionContainersOperations operations
    :vartype backup_protection_containers: azure.mgmt.recoveryservicesbackup.aio.operations.BackupProtectionContainersOperations
    :ivar security_pins: SecurityPINsOperations operations
    :vartype security_pins: azure.mgmt.recoveryservicesbackup.aio.operations.SecurityPINsOperations
    :ivar recovery_points_recommended_for_move: RecoveryPointsRecommendedForMoveOperations operations
    :vartype recovery_points_recommended_for_move: azure.mgmt.recoveryservicesbackup.aio.operations.RecoveryPointsRecommendedForMoveOperations
    :ivar backup_usage_summaries_crr: BackupUsageSummariesCRROperations operations
    :vartype backup_usage_summaries_crr: azure.mgmt.recoveryservicesbackup.aio.operations.BackupUsageSummariesCRROperations
    :ivar aad_properties: AadPropertiesOperations operations
    :vartype aad_properties: azure.mgmt.recoveryservicesbackup.aio.operations.AadPropertiesOperations
    :ivar cross_region_restore: CrossRegionRestoreOperations operations
    :vartype cross_region_restore: azure.mgmt.recoveryservicesbackup.aio.operations.CrossRegionRestoreOperations
    :ivar backup_crr_job_details: BackupCrrJobDetailsOperations operations
    :vartype backup_crr_job_details: azure.mgmt.recoveryservicesbackup.aio.operations.BackupCrrJobDetailsOperations
    :ivar backup_crr_jobs: BackupCrrJobsOperations operations
    :vartype backup_crr_jobs: azure.mgmt.recoveryservicesbackup.aio.operations.BackupCrrJobsOperations
    :ivar crr_operation_results: CrrOperationResultsOperations operations
    :vartype crr_operation_results: azure.mgmt.recoveryservicesbackup.aio.operations.CrrOperationResultsOperations
    :ivar crr_operation_status: CrrOperationStatusOperations operations
    :vartype crr_operation_status: azure.mgmt.recoveryservicesbackup.aio.operations.CrrOperationStatusOperations
    :ivar backup_resource_storage_configs: BackupResourceStorageConfigsOperations operations
    :vartype backup_resource_storage_configs: azure.mgmt.recoveryservicesbackup.aio.operations.BackupResourceStorageConfigsOperations
    :ivar recovery_points_crr: RecoveryPointsCrrOperations operations
    :vartype recovery_points_crr: azure.mgmt.recoveryservicesbackup.aio.operations.RecoveryPointsCrrOperations
    :ivar backup_protected_items_crr: BackupProtectedItemsCrrOperations operations
    :vartype backup_protected_items_crr: azure.mgmt.recoveryservicesbackup.aio.operations.BackupProtectedItemsCrrOperations
    :ivar protection_intent: ProtectionIntentOperations operations
    :vartype protection_intent: azure.mgmt.recoveryservicesbackup.aio.operations.ProtectionIntentOperations
    :ivar backup_status: BackupStatusOperations operations
    :vartype backup_status: azure.mgmt.recoveryservicesbackup.aio.operations.BackupStatusOperations
    :ivar feature_support: FeatureSupportOperations operations
    :vartype feature_support: azure.mgmt.recoveryservicesbackup.aio.operations.FeatureSupportOperations
    :ivar backup_protection_intent: BackupProtectionIntentOperations operations
    :vartype backup_protection_intent: azure.mgmt.recoveryservicesbackup.aio.operations.BackupProtectionIntentOperations
    :ivar backup_usage_summaries: BackupUsageSummariesOperations operations
    :vartype backup_usage_summaries: azure.mgmt.recoveryservicesbackup.aio.operations.BackupUsageSummariesOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.recoveryservicesbackup.aio.operations.Operations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The subscription Id.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = RecoveryServicesBackupClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.backup_resource_vault_configs = BackupResourceVaultConfigsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_resource_encryption_configs = BackupResourceEncryptionConfigsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.private_endpoint_connection = PrivateEndpointConnectionOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.private_endpoint = PrivateEndpointOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.bms_prepare_data_move_operation_result = BMSPrepareDataMoveOperationResultOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protected_items = ProtectedItemsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protected_item_operation_results = ProtectedItemOperationResultsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.recovery_points = RecoveryPointsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.restores = RestoresOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_policies = BackupPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protection_policies = ProtectionPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protection_policy_operation_results = ProtectionPolicyOperationResultsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_jobs = BackupJobsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.job_details = JobDetailsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.job_cancellations = JobCancellationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.job_operation_results = JobOperationResultsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.export_jobs_operation_results = ExportJobsOperationResultsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.jobs = JobsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_protected_items = BackupProtectedItemsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operation = OperationOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_engines = BackupEnginesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protection_container_refresh_operation_results = ProtectionContainerRefreshOperationResultsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protectable_containers = ProtectableContainersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protection_containers = ProtectionContainersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_workload_items = BackupWorkloadItemsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protection_container_operation_results = ProtectionContainerOperationResultsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backups = BackupsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protected_item_operation_statuses = ProtectedItemOperationStatusesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.item_level_recovery_connections = ItemLevelRecoveryConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_operation_results = BackupOperationResultsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_operation_statuses = BackupOperationStatusesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protection_policy_operation_statuses = ProtectionPolicyOperationStatusesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_protectable_items = BackupProtectableItemsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_protection_containers = BackupProtectionContainersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.security_pins = SecurityPINsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.recovery_points_recommended_for_move = RecoveryPointsRecommendedForMoveOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_usage_summaries_crr = BackupUsageSummariesCRROperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.aad_properties = AadPropertiesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.cross_region_restore = CrossRegionRestoreOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_crr_job_details = BackupCrrJobDetailsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_crr_jobs = BackupCrrJobsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.crr_operation_results = CrrOperationResultsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.crr_operation_status = CrrOperationStatusOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_resource_storage_configs = BackupResourceStorageConfigsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.recovery_points_crr = RecoveryPointsCrrOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_protected_items_crr = BackupProtectedItemsCrrOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.protection_intent = ProtectionIntentOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_status = BackupStatusOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.feature_support = FeatureSupportOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_protection_intent = BackupProtectionIntentOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_usage_summaries = BackupUsageSummariesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)

    async def _send_request(self, http_request: HttpRequest, **kwargs: Any) -> AsyncHttpResponse:
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.AsyncHttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = await self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "RecoveryServicesBackupClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
