# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CloudJobSchedule(Model):
    """
    A job schedule that allows recurring jobs by specifying when to run jobs
    and a specification used to create each job.

    :param id: Gets or sets a string that uniquely identifies the schedule
     within the account. A GUID is recommended.
    :type id: str
    :param display_name: Gets or sets the display name for the schedule.
    :type display_name: str
    :param url: Gets or sets the URL of the job schedule.
    :type url: str
    :param e_tag: Gets or sets the ETag of the job schedule.
    :type e_tag: str
    :param last_modified: Gets or sets the last modified time of the job
     schedule.
    :type last_modified: datetime
    :param creation_time: Gets or sets the creation time of the job schedule.
    :type creation_time: datetime
    :param state: Gets or sets the current state of the job schedule.
     Possible values include: 'active', 'completed', 'disabled',
     'terminating', 'deleting'
    :type state: str
    :param state_transition_time: Gets or sets the time at which the job
     schedule entered the current state.
    :type state_transition_time: datetime
    :param previous_state: Gets or sets the previous state of the job
     schedule. Possible values include: 'active', 'completed', 'disabled',
     'terminating', 'deleting'
    :type previous_state: str
    :param previous_state_transition_time: Gets or sets the time at which the
     job schedule entered its previous state.
    :type previous_state_transition_time: datetime
    :param schedule: Gets or sets the schedule according to which jobs will
     be created.
    :type schedule: :class:`Schedule <azure.batch.models.Schedule>`
    :param job_specification: Gets or sets the details of the jobs to be
     created on this schedule.
    :type job_specification: :class:`JobSpecification
     <azure.batch.models.JobSpecification>`
    :param execution_info: Gets or sets information about jobs that have been
     and will be run under this schedule.
    :type execution_info: :class:`JobScheduleExecutionInformation
     <azure.batch.models.JobScheduleExecutionInformation>`
    :param metadata: Gets or sets a list of name-value pairs associated with
     the schedule as metadata.
    :type metadata: list of :class:`MetadataItem
     <azure.batch.models.MetadataItem>`
    :param stats: Gets or sets the lifetime resource usage statistics for the
     job schedule.
    :type stats: :class:`JobScheduleStatistics
     <azure.batch.models.JobScheduleStatistics>`
    """ 

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'JobScheduleState'},
        'state_transition_time': {'key': 'stateTransitionTime', 'type': 'iso-8601'},
        'previous_state': {'key': 'previousState', 'type': 'JobScheduleState'},
        'previous_state_transition_time': {'key': 'previousStateTransitionTime', 'type': 'iso-8601'},
        'schedule': {'key': 'schedule', 'type': 'Schedule'},
        'job_specification': {'key': 'jobSpecification', 'type': 'JobSpecification'},
        'execution_info': {'key': 'executionInfo', 'type': 'JobScheduleExecutionInformation'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
        'stats': {'key': 'stats', 'type': 'JobScheduleStatistics'},
    }

    def __init__(self, id=None, display_name=None, url=None, e_tag=None, last_modified=None, creation_time=None, state=None, state_transition_time=None, previous_state=None, previous_state_transition_time=None, schedule=None, job_specification=None, execution_info=None, metadata=None, stats=None):
        self.id = id
        self.display_name = display_name
        self.url = url
        self.e_tag = e_tag
        self.last_modified = last_modified
        self.creation_time = creation_time
        self.state = state
        self.state_transition_time = state_transition_time
        self.previous_state = previous_state
        self.previous_state_transition_time = previous_state_transition_time
        self.schedule = schedule
        self.job_specification = job_specification
        self.execution_info = execution_info
        self.metadata = metadata
        self.stats = stats
