# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResizeError(Model):
    """
    An error that occurred when resizing a pool.

    :param code: Gets or sets an identifier for the pool resize error.  Codes
     are invariant and are intended to be consumed programmatically.
    :type code: str
    :param message: Gets or sets a message describing the pool resize error,
     intended to be suitable for display in a user interface.
    :type message: str
    :param values: Gets or sets a list of additional error details related to
     the pool resize error.
    :type values: list of :class:`NameValuePair
     <azure.batch.models.NameValuePair>`
    """ 

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'values': {'key': 'values', 'type': '[NameValuePair]'},
    }

    def __init__(self, code=None, message=None, values=None):
        self.code = code
        self.message = message
        self.values = values
