/* /////////////////////////////////////////////////////////////////////////
 * File:        winstl/shims/conversion/to_DATE.hpp
 *
 * Purpose:     Includes all winstl::to_DATE conversion shims.
 *
 * Created:     21st October 2007
 * Updated:     10th August 2009
 *
 * Home:        http://stlsoft.org/
 *
 * Copyright (c) 2007-2009, Matthew Wilson and Synesis Software
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * - Neither the name(s) of Matthew Wilson and Synesis Software nor the names of
 *   any contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * ////////////////////////////////////////////////////////////////////// */


/** \file winstl/shims/conversion/to_DATE.hpp
 *
 * \brief [C++] Includes all winstl::to_DATE conversion shims
 *   (\ref group__concept__shim__time_conversion__to_FILETIME "winstl::to_DATE" Time Conversion Shim).
 */

#ifndef WINSTL_INCL_WINSTL_SHIMS_CONVERSION_HPP_TO_DATE
#define WINSTL_INCL_WINSTL_SHIMS_CONVERSION_HPP_TO_DATE

#ifndef STLSOFT_DOCUMENTATION_SKIP_SECTION
# define WINSTL_VER_WINSTL_SHIMS_CONVERSION_HPP_TO_DATE_MAJOR       1
# define WINSTL_VER_WINSTL_SHIMS_CONVERSION_HPP_TO_DATE_MINOR       0
# define WINSTL_VER_WINSTL_SHIMS_CONVERSION_HPP_TO_DATE_REVISION    2
# define WINSTL_VER_WINSTL_SHIMS_CONVERSION_HPP_TO_DATE_EDIT        3
#endif /* !STLSOFT_DOCUMENTATION_SKIP_SECTION */

/* /////////////////////////////////////////////////////////////////////////
 * Auto-generation and compatibility
 */

/*
[Incompatibilies-start]
STLSOFT_COMPILER_IS_GCC:
[Incompatibilies-end]
 */

/* /////////////////////////////////////////////////////////////////////////
 * Includes
 */

#ifdef WINSTL_UDATE_DEFINED
# ifndef WINSTL_INCL_WINSTL_SHIMS_CONVERSION_TO_DATE_HPP_DATE
#  include <winstl/shims/conversion/to_DATE/DATE.hpp>
# endif /* !WINSTL_INCL_WINSTL_SHIMS_CONVERSION_TO_DATE_HPP_DATE */
#endif /* WINSTL_UDATE_DEFINED */
#ifndef WINSTL_INCL_WINSTL_SHIMS_CONVERSION_TO_DATE_HPP_FILETIME
# include <winstl/shims/conversion/to_DATE/FILETIME.hpp>
#endif /* !WINSTL_INCL_WINSTL_SHIMS_CONVERSION_TO_DATE_HPP_FILETIME */
#ifndef WINSTL_INCL_WINSTL_SHIMS_CONVERSION_TO_DATE_HPP_SYSTEMTIME
# include <winstl/shims/conversion/to_DATE/SYSTEMTIME.hpp>
#endif /* !WINSTL_INCL_WINSTL_SHIMS_CONVERSION_TO_DATE_HPP_SYSTEMTIME */
#ifdef WINSTL_UDATE_DEFINED
# ifndef WINSTL_INCL_WINSTL_SHIMS_CONVERSION_TO_DATE_HPP_UDATE
#  include <winstl/shims/conversion/to_DATE/UDATE.hpp>
# endif /* !WINSTL_INCL_WINSTL_SHIMS_CONVERSION_TO_DATE_HPP_UDATE */
#endif /* WINSTL_UDATE_DEFINED */

/* ////////////////////////////////////////////////////////////////////// */

#endif /* !WINSTL_INCL_WINSTL_SHIMS_CONVERSION_HPP_TO_DATE */

/* ///////////////////////////// end of file //////////////////////////// */
