# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GenerateCredentialsParameters(Model):
    """The parameters used to generate credentials for a specified token or user
    of a container registry.

    :param token_id: The resource ID of the token for which credentials have
     to be generated.
    :type token_id: str
    :param expiry: The expiry date of the generated credentials after which
     the credentials become invalid. Default value:
     "9999-12-31T15:59:59.9999999-08:00" .
    :type expiry: datetime
    :param name: Specifies name of the password which should be regenerated if
     any -- password or password2. Possible values include: 'password1',
     'password2'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenPasswordName
    """

    _attribute_map = {
        'token_id': {'key': 'tokenId', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GenerateCredentialsParameters, self).__init__(**kwargs)
        self.token_id = kwargs.get('token_id', None)
        self.expiry = kwargs.get('expiry', "9999-12-31T15:59:59.9999999-08:00")
        self.name = kwargs.get('name', None)
