# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TokenPassword(Model):
    """The password that will be used for authenticating the token of a container
    registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param creation_time: The password created datetime of the password.
    :type creation_time: datetime
    :param expiry: The expiry datetime of the password.
    :type expiry: datetime
    :param name: The password name "password" or "password2". Possible values
     include: 'password1', 'password2'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenPasswordName
    :ivar value: The password value.
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TokenPassword, self).__init__(**kwargs)
        self.creation_time = kwargs.get('creation_time', None)
        self.expiry = kwargs.get('expiry', None)
        self.name = kwargs.get('name', None)
        self.value = None
