/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.smartproxy.common;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.objectweb.proactive.utils.NamedThreadFactory;
import org.ow2.proactive.authentication.ConnectionInfo;
import org.ow2.proactive.db.SortParameter;
import org.ow2.proactive.scheduler.common.JobFilterCriteria;
import org.ow2.proactive.scheduler.common.JobSortParameter;
import org.ow2.proactive.scheduler.common.NotificationData;
import org.ow2.proactive.scheduler.common.Page;
import org.ow2.proactive.scheduler.common.Scheduler;
import org.ow2.proactive.scheduler.common.SchedulerEvent;
import org.ow2.proactive.scheduler.common.SchedulerEventListener;
import org.ow2.proactive.scheduler.common.SchedulerState;
import org.ow2.proactive.scheduler.common.SchedulerStatus;
import org.ow2.proactive.scheduler.common.TaskDescriptor;
import org.ow2.proactive.scheduler.common.exception.JobAlreadyFinishedException;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.exception.SchedulerException;
import org.ow2.proactive.scheduler.common.exception.SubmissionClosedException;
import org.ow2.proactive.scheduler.common.exception.UnknownJobException;
import org.ow2.proactive.scheduler.common.exception.UnknownTaskException;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobInfo;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobResult;
import org.ow2.proactive.scheduler.common.job.JobState;
import org.ow2.proactive.scheduler.common.job.JobStatus;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.UserIdentification;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.common.task.TaskInfo;
import org.ow2.proactive.scheduler.common.task.TaskResult;
import org.ow2.proactive.scheduler.common.task.TaskState;
import org.ow2.proactive.scheduler.common.task.TaskStatus;
import org.ow2.proactive.scheduler.common.usage.JobUsage;
import org.ow2.proactive.scheduler.common.util.logforwarder.AppenderProvider;
import org.ow2.proactive.scheduler.job.SchedulerUserInfo;
import org.ow2.proactive.scheduler.smartproxy.common.AwaitedJob;
import org.ow2.proactive.scheduler.smartproxy.common.AwaitedTask;
import org.ow2.proactive.scheduler.smartproxy.common.JobTracker;
import org.ow2.proactive.scheduler.smartproxy.common.SchedulerEventListenerExtended;
import org.ow2.proactive.utils.Tools;

public abstract class AbstractSmartProxy<T extends JobTracker>
implements Scheduler,
SchedulerEventListener {
    public static final String GENERIC_INFO_INPUT_FOLDER_PROPERTY_NAME = "client_input_data_folder";
    public static final String GENERIC_INFO_OUTPUT_FOLDER_PROPERTY_NAME = "client_output_data_folder";
    public static final String GENERIC_INFO_PUSH_URL_PROPERTY_NAME = "push_url";
    public static final String GENERIC_INFO_PULL_URL_PROPERTY_NAME = "pull_url";
    public static final int MAX_NB_OF_DATA_TRANSFER_THREADS = 3 * Runtime.getRuntime().availableProcessors();
    protected static final SchedulerEvent[] PROXY_SCHED_EVENTS = SchedulerEvent.values();
    protected SchedulerEvent[] configuredEvents = PROXY_SCHED_EVENTS;
    private static final Logger log = Logger.getLogger(AbstractSmartProxy.class);
    protected T jobTracker;
    protected ConnectionInfo connectionInfo;
    protected Set<SchedulerEventListenerExtended> eventListeners = Collections.synchronizedSet(new HashSet());
    private ThreadFactory threadFactory = new NamedThreadFactory("SmartProxyDataTransferThread");
    protected final ExecutorService threadPool = Executors.newFixedThreadPool(MAX_NB_OF_DATA_TRANSFER_THREADS, this.threadFactory);
    private boolean initialized = false;
    protected boolean terminated = false;
    protected boolean terminating = false;

    public AbstractSmartProxy() {
    }

    public AbstractSmartProxy(T jobTracker) {
        this.jobTracker = jobTracker;
    }

    public void cleanDatabase() {
        ((JobTracker)this.jobTracker).cleanDataBase();
    }

    public void terminate() {
        this.terminating = true;
        try {
            this.removeEventListener();
        }
        catch (Exception e) {
            log.trace((Object)e);
        }
        ((JobTracker)this.jobTracker).close();
        this.threadPool.shutdownNow();
        this.terminated = true;
    }

    public void setSessionName(String name) {
        ((JobTracker)this.jobTracker).setSessionName(name);
    }

    public void configureEvents(SchedulerEvent ... events) {
        this.configuredEvents = events;
    }

    public abstract void init(ConnectionInfo var1) throws SchedulerException, LoginException;

    public abstract void disconnect() throws PermissionException, NotConnectedException;

    public boolean isConnected() {
        if (!this.initialized) {
            return false;
        }
        if (this.terminated) {
            return false;
        }
        return this.getScheduler().isConnected();
    }

    public void renewSession() throws NotConnectedException {
        this.getScheduler().renewSession();
    }

    public String getJobServerLogs(String id) throws UnknownJobException, NotConnectedException, PermissionException {
        return this.getScheduler().getJobServerLogs(id);
    }

    public String getTaskServerLogs(String id, String taskName) throws UnknownJobException, UnknownTaskException, NotConnectedException, PermissionException {
        return this.getScheduler().getTaskServerLogs(id, taskName);
    }

    public String getTaskServerLogsByTag(String id, String taskTag) throws UnknownJobException, NotConnectedException, PermissionException {
        return this.getScheduler().getTaskServerLogsByTag(id, taskTag);
    }

    public Page<JobInfo> getJobs(int offset, int limit, JobFilterCriteria filterCriteria, List<SortParameter<JobSortParameter>> sortParameters) throws NotConnectedException, PermissionException {
        return this.getScheduler().getJobs(offset, limit, filterCriteria, sortParameters);
    }

    public List<JobInfo> getJobsInfoList(List<String> jobsId) throws PermissionException, NotConnectedException {
        return this.getScheduler().getJobsInfoList(jobsId);
    }

    public List<SchedulerUserInfo> getUsers() throws NotConnectedException, PermissionException {
        return this.getScheduler().getUsers();
    }

    public List<SchedulerUserInfo> getUsersWithJobs() throws NotConnectedException, PermissionException {
        return this.getScheduler().getUsersWithJobs();
    }

    public void reconnect() throws SchedulerException, LoginException {
        this.disconnect();
        this.init(this.connectionInfo);
    }

    public JobId submit(TaskFlowJob job, String localInputFolderPath, String localOutputFolderPath, boolean isolateTaskOutputs, boolean automaticTransfer) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException, Exception {
        return this.submit(job, localInputFolderPath, null, localOutputFolderPath, null, isolateTaskOutputs, automaticTransfer);
    }

    public JobId submit(TaskFlowJob job, String localInputFolderPath, String pushUrl, String localOutputFolderPath, String pullUrl, boolean isolateTaskOutputs, boolean automaticTransfer) throws Exception, SubmissionClosedException, JobCreationException {
        this.checkInitialized();
        List<String> pushUrls = Strings.isNullOrEmpty((String)pushUrl) ? this.getUserSpaceURIs() : Arrays.asList(Tools.dataSpaceConfigPropertyToUrls((String)pushUrl));
        List<String> pullUrls = Strings.isNullOrEmpty((String)pullUrl) ? this.getUserSpaceURIs() : Arrays.asList(Tools.dataSpaceConfigPropertyToUrls((String)pullUrl));
        String newFolderName = this.createNewFolderName();
        String pushUrlUpdate = this.prepareJobInput((Job)job, localInputFolderPath, pushUrls, newFolderName);
        String pullUrlUpdate = this.prepareJobOutput(job, localOutputFolderPath, pullUrls, newFolderName, isolateTaskOutputs);
        this.uploadInputfiles(job, localInputFolderPath);
        JobId id = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Job Contents before submission:");
            log.trace((Object)job.display());
        }
        try {
            id = this.submit((Job)job);
        }
        catch (Exception e) {
            log.error((Object)"Error while submitting job", (Throwable)e);
            try {
                this.removeJobIO((Job)job, pushUrl, pullUrl, newFolderName);
            }
            catch (Exception e2) {
                log.error((Object)"Error while removing job IO", (Throwable)e2);
            }
            Throwables.propagateIfInstanceOf((Throwable)e, NotConnectedException.class);
            Throwables.propagateIfInstanceOf((Throwable)e, PermissionException.class);
            Throwables.propagateIfInstanceOf((Throwable)e, SubmissionClosedException.class);
            Throwables.propagateIfInstanceOf((Throwable)e, JobCreationException.class);
            Throwables.propagateIfInstanceOf((Throwable)e, RuntimeException.class);
            Throwables.propagate((Throwable)e);
        }
        HashMap<String, AwaitedTask> awaitedTaskMap = new HashMap<String, AwaitedTask>();
        for (Task t : job.getTasks()) {
            awaitedTaskMap.put(t.getName(), new AwaitedTask(t.getName(), t.getOutputFilesList()));
        }
        AwaitedJob awaitedJob = new AwaitedJob(id.toString(), localInputFolderPath, job.getInputSpace(), pushUrlUpdate, localOutputFolderPath, job.getOutputSpace(), pullUrlUpdate, isolateTaskOutputs, automaticTransfer, awaitedTaskMap);
        ((JobTracker)this.jobTracker).putAwaitedJob(id.toString(), awaitedJob);
        return id;
    }

    public void pullData(String jobId, String t_name, String localFolder) throws Exception {
        this.checkInitialized();
        AwaitedJob awaitedjob = ((JobTracker)this.jobTracker).getAwaitedJob(jobId);
        if (awaitedjob == null) {
            throw new IllegalArgumentException("The job " + jobId + " is unknown or has been removed");
        }
        if (awaitedjob.isAutomaticTransfer()) {
            throw new UnsupportedOperationException("Transfer of input files with job " + jobId + " is handled automatically.");
        }
        String localOutFolderPath = null;
        localOutFolderPath = localFolder == null ? awaitedjob.getLocalOutputFolder() : localFolder;
        if (localOutFolderPath == null) {
            throw new IllegalArgumentException("The job " + awaitedjob.getJobId() + " does not define an output folder on local machine, please provide an outputFolder.");
        }
        this.downloadTaskOutputFiles(awaitedjob, jobId, t_name, localOutFolderPath);
    }

    protected void checkInitialized() {
        if (this.terminated) {
            throw new IllegalStateException("This SmartProxy instance has been terminated and cannot be used any more.");
        }
        if (!this.initialized) {
            throw new IllegalStateException("This SmartProxy instance has not been initialized.");
        }
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected void reinitializeState() throws NotConnectedException, PermissionException {
        ((JobTracker)this.jobTracker).loadJobs();
        this.registerAsListener();
        this.syncAwaitedJobs();
    }

    public void syncAwaitedJobs() {
        Set<String> awaitedJobsIds = ((JobTracker)this.jobTracker).getAwaitedJobsIds();
        for (String id : awaitedJobsIds) {
            this.syncAwaitedJob(id);
        }
    }

    private void syncAwaitedJob(String id) {
        AwaitedJob awaitedJob = ((JobTracker)this.jobTracker).getAwaitedJob(id);
        try {
            JobState js = this.getJobState(id);
            for (TaskState ts : js.getTasks()) {
                String tname = ts.getName();
                AwaitedTask at = awaitedJob.getAwaitedTask(tname);
                if (at == null || at.isTransferring()) continue;
                TaskResult tres = null;
                try {
                    tres = this.getTaskResult(id, tname);
                    if (tres == null) continue;
                    log.debug((Object)("Synchonizing task " + tname + " of job " + id));
                    this.taskStateUpdatedEvent((NotificationData<TaskInfo>)new NotificationData(SchedulerEvent.TASK_RUNNING_TO_FINISHED, (Object)ts.getTaskInfo()));
                }
                catch (NotConnectedException e) {
                    log.error((Object)"Scheduler connection error", (Throwable)e);
                }
                catch (UnknownJobException e) {
                    log.error((Object)("Could not retrieve output data for job " + id + " because this job is not known by the Scheduler. \n "), (Throwable)e);
                }
                catch (UnknownTaskException e) {
                    log.error((Object)("Could not retrieve output data for task " + tname + " of job " + id + " because this task is not known by the Scheduler. \n "), (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)("Unexpected error while getting the output data for task " + tname + " of job " + id), (Throwable)e);
                }
            }
            if (js.isFinished()) {
                this.jobStateUpdatedEvent((NotificationData<JobInfo>)new NotificationData(SchedulerEvent.JOB_RUNNING_TO_FINISHED, (Object)js.getJobInfo()));
            }
        }
        catch (NotConnectedException e) {
            log.error((Object)("A connection error occured while trying to download output data of Job " + id + ". This job will remain in the list of awaited jobs. Another attempt to dowload the output data will be made next time the application is initialized. "), (Throwable)e);
        }
        catch (UnknownJobException e) {
            log.error((Object)("Could not retrieve output data for job " + id + " because this job is not known by the Scheduler. \n "), (Throwable)e);
            log.warn((Object)("Job  " + id + " will be removed from the known job list. The system will not attempt again to retrieve data for this job. You could try to manually copy the data from the location  " + awaitedJob.getPullURL()));
            ((JobTracker)this.jobTracker).removeAwaitedJob(id);
        }
        catch (PermissionException e) {
            log.error((Object)("Could not retrieve output data for job " + id + " because you don't have permmission to access this job. You need to use the same connection credentials you used for submitting the job.  \n Another attempt to dowload the output data for this job will be made next time the application is initialized. "), (Throwable)e);
        }
    }

    protected String prepareJobOutput(TaskFlowJob job, String localOutputFolder, List<String> pull_urls, String newFolderName, boolean isolateTaskOutputs) throws NotConnectedException, PermissionException {
        String pull_url_updated = "";
        String outputFolder = "";
        if (localOutputFolder != null && pull_urls != null && pull_urls.size() > 0) {
            outputFolder = isolateTaskOutputs ? newFolderName + "/output/" + "TASKID" : newFolderName + "/output";
            pull_url_updated = this.appendSlashIfNeeded(pull_urls.get(0)) + outputFolder;
            this.createFolder(pull_url_updated);
            this.updateOutputSpace((Job)job, outputFolder);
            job.addGenericInformation(GENERIC_INFO_OUTPUT_FOLDER_PROPERTY_NAME, new File(localOutputFolder).getAbsolutePath());
            job.addGenericInformation(GENERIC_INFO_PULL_URL_PROPERTY_NAME, pull_url_updated);
        }
        return pull_url_updated;
    }

    protected String prepareJobInput(Job job, String localInputFolder, List<String> pushURLs, String newFolderName) throws NotConnectedException, PermissionException {
        String push_url_updated = "";
        String inputFolder = "";
        if (localInputFolder != null && pushURLs != null && pushURLs.size() > 0) {
            inputFolder = newFolderName + "/input";
            push_url_updated = this.appendSlashIfNeeded(pushURLs.get(0)) + inputFolder;
            this.createFolder(push_url_updated);
            this.updateInputSpace(job, inputFolder);
            job.addGenericInformation(GENERIC_INFO_INPUT_FOLDER_PROPERTY_NAME, new File(localInputFolder).getAbsolutePath());
            job.addGenericInformation(GENERIC_INFO_PUSH_URL_PROPERTY_NAME, push_url_updated);
        }
        return push_url_updated;
    }

    private String appendSlashIfNeeded(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return url + "/";
    }

    private void updateInputSpace(Job job, String inputFolder) throws NotConnectedException, PermissionException {
        List<String> inputSpaces = job.getInputSpace() != null ? Arrays.asList(Tools.dataSpaceConfigPropertyToUrls((String)job.getInputSpace())) : this.getUserSpaceURIs();
        StringBuilder inputSpace_url_updated = this.buildUpdatedSpaceConfiguration(inputFolder, inputSpaces);
        job.setInputSpace(inputSpace_url_updated.toString());
        log.debug((Object)("Input space of job " + job.getName() + " will be " + inputSpace_url_updated));
    }

    private StringBuilder buildUpdatedSpaceConfiguration(String folder, List<String> spaceUrls) {
        StringBuilder inputSpace_url_updated = new StringBuilder();
        for (String inputSpace : spaceUrls) {
            if (inputSpace_url_updated.length() > 0) {
                inputSpace_url_updated.append(" ");
            }
            inputSpace_url_updated.append(this.appendSlashIfNeeded(inputSpace));
            inputSpace_url_updated.append(folder);
        }
        return inputSpace_url_updated;
    }

    private void updateOutputSpace(Job job, String outputFolder) throws NotConnectedException, PermissionException {
        List<String> outputSpaces = job.getOutputSpace() != null ? Arrays.asList(Tools.dataSpaceConfigPropertyToUrls((String)job.getOutputSpace())) : this.getUserSpaceURIs();
        StringBuilder outputSpace_url_updated = this.buildUpdatedSpaceConfiguration(outputFolder, outputSpaces);
        job.setOutputSpace(outputSpace_url_updated.toString());
        log.debug((Object)("Output space of job " + job.getName() + " will be " + outputSpace_url_updated));
    }

    protected String createNewFolderName() {
        String user = System.getProperty("user.name");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss.SSS");
        Date now = new Date();
        String strDate = sdf.format(now);
        String newFolderName = user + "_" + strDate;
        return UrlEscapers.urlPathSegmentEscaper().escape(newFolderName);
    }

    public void addEventListener(SchedulerEventListenerExtended sel) throws NotConnectedException, PermissionException {
        this.eventListeners.add(sel);
    }

    public void removeEventListener(SchedulerEventListenerExtended sel) {
        this.eventListeners.remove(sel);
    }

    public void schedulerStateUpdatedEvent(SchedulerEvent eventType) {
        Iterator<SchedulerEventListenerExtended> it = this.eventListeners.iterator();
        while (it.hasNext()) {
            SchedulerEventListenerExtended l = it.next();
            try {
                l.schedulerStateUpdatedEvent(eventType);
            }
            catch (Exception e) {
                it.remove();
            }
        }
    }

    public void jobSubmittedEvent(JobState job) {
        Iterator<SchedulerEventListenerExtended> it = this.eventListeners.iterator();
        while (it.hasNext()) {
            SchedulerEventListenerExtended l = it.next();
            try {
                l.jobSubmittedEvent(job);
            }
            catch (Exception e) {
                it.remove();
            }
        }
    }

    public void jobStateUpdatedEvent(NotificationData<JobInfo> notification) {
        this.updateJob(notification);
        Iterator<SchedulerEventListenerExtended> it = this.eventListeners.iterator();
        while (it.hasNext()) {
            SchedulerEventListenerExtended l = it.next();
            try {
                l.jobStateUpdatedEvent(notification);
            }
            catch (Exception e) {
                it.remove();
            }
        }
    }

    public void jobUpdatedFullDataEvent(JobState job) {
        Iterator<SchedulerEventListenerExtended> it = this.eventListeners.iterator();
        while (it.hasNext()) {
            SchedulerEventListenerExtended l = it.next();
            try {
                l.jobUpdatedFullDataEvent(job);
            }
            catch (Exception e) {
                it.remove();
            }
        }
    }

    public void taskStateUpdatedEvent(NotificationData<TaskInfo> notification) {
        this.updateTask(notification);
        Iterator<SchedulerEventListenerExtended> it = this.eventListeners.iterator();
        while (it.hasNext()) {
            SchedulerEventListenerExtended l = it.next();
            try {
                l.taskStateUpdatedEvent(notification);
            }
            catch (Exception e) {
                it.remove();
            }
        }
    }

    public void usersUpdatedEvent(NotificationData<UserIdentification> notification) {
        Iterator<SchedulerEventListenerExtended> it = this.eventListeners.iterator();
        while (it.hasNext()) {
            SchedulerEventListenerExtended l = it.next();
            try {
                l.usersUpdatedEvent(notification);
            }
            catch (Exception e) {
                it.remove();
            }
        }
    }

    protected void updateJob(NotificationData<?> notification) {
        JobId id = ((JobInfo)notification.getData()).getJobId();
        AwaitedJob aj = ((JobTracker)this.jobTracker).getAwaitedJob(id.toString());
        if (aj == null) {
            return;
        }
        JobStatus status = ((JobInfo)notification.getData()).getStatus();
        switch (status) {
            case KILLED: {
                log.debug((Object)("The job " + id + "has been killed."));
                ((JobTracker)this.jobTracker).removeAwaitedJob(id.toString());
                break;
            }
            case FINISHED: {
                log.debug((Object)("The job " + id + " is finished."));
                break;
            }
            case CANCELED: {
                log.debug((Object)("The job " + id + " is canceled."));
                ((JobTracker)this.jobTracker).removeAwaitedJob(id.toString());
                break;
            }
            case FAILED: {
                log.debug((Object)("The job " + id + " is failed."));
                ((JobTracker)this.jobTracker).removeAwaitedJob(id.toString());
                break;
            }
            default: {
                log.trace((Object)("The job " + id + " is in state " + status));
            }
        }
    }

    protected void updateTask(NotificationData<TaskInfo> notification) {
        TaskInfo taskInfoData = (TaskInfo)notification.getData();
        JobId id = taskInfoData.getJobId();
        TaskId tid = taskInfoData.getTaskId();
        String tname = tid.getReadableName();
        TaskStatus status = taskInfoData.getStatus();
        AwaitedJob aj = ((JobTracker)this.jobTracker).getAwaitedJob(id.toString());
        if (aj == null) {
            return;
        }
        AwaitedTask at = aj.getAwaitedTask(tname);
        if (at == null) {
            return;
        }
        at.setTaskId(tid.toString());
        ((JobTracker)this.jobTracker).putAwaitedJob(id.toString(), aj);
        switch (status) {
            case ABORTED: 
            case NOT_RESTARTED: 
            case NOT_STARTED: 
            case SKIPPED: {
                log.debug((Object)("The task " + tname + " from job " + id + " couldn't start. No data will be transfered"));
                ((JobTracker)this.jobTracker).removeAwaitedTask(id.toString(), tname);
                break;
            }
            case FINISHED: {
                log.debug((Object)("The task " + tname + " from job " + id + " is finished."));
                if (!aj.isAutomaticTransfer()) break;
                log.debug((Object)("Transferring data for finished task " + tname + " from job " + id));
                try {
                    this.downloadTaskOutputFiles(aj, id.toString(), tname, aj.getLocalOutputFolder());
                }
                catch (Throwable t) {
                    log.error((Object)("Error while handling data for finished task " + tname + " for job " + id + ", task will be removed"));
                    ((JobTracker)this.jobTracker).removeAwaitedTask(id.toString(), tname);
                }
                break;
            }
            case FAILED: 
            case FAULTY: {
                log.debug((Object)("The task " + tname + " from job " + id + " is faulty."));
                ((JobTracker)this.jobTracker).removeAwaitedTask(id.toString(), tname);
                break;
            }
            default: {
                log.trace((Object)("The task " + tname + " from job " + id + " is in status : " + status));
            }
        }
    }

    protected void removeAwaitedTask(String jobId, String taskName) {
        ((JobTracker)this.jobTracker).removeAwaitedTask(jobId, taskName);
    }

    protected abstract Scheduler _getScheduler();

    private Scheduler getScheduler() {
        Scheduler scheduler = this._getScheduler();
        if (scheduler == null) {
            throw new IllegalStateException("No connection to the scheduler has been established yet. Have you initialized the smartproxy with a call to the init method?");
        }
        return scheduler;
    }

    public abstract void registerAsListener() throws NotConnectedException, PermissionException;

    public abstract boolean uploadInputfiles(TaskFlowJob var1, String var2) throws Exception;

    protected abstract void downloadTaskOutputFiles(AwaitedJob var1, String var2, String var3, String var4) throws Exception;

    public abstract JobId submit(Job var1) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException;

    public JobResult getJobResult(String jobId) throws NotConnectedException, PermissionException, UnknownJobException {
        return this.getScheduler().getJobResult(jobId);
    }

    public abstract JobState getJobState(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public SchedulerStatus getStatus() throws NotConnectedException, PermissionException {
        return this.getScheduler().getStatus();
    }

    public JobState getJobState(JobId jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().getJobState(jobId);
    }

    public TaskState getTaskState(JobId jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().getTaskState(jobId, taskName);
    }

    public SchedulerState getState() throws NotConnectedException, PermissionException {
        return this.getScheduler().getState();
    }

    public SchedulerState getState(boolean myJobsOnly) throws NotConnectedException, PermissionException {
        return this.getScheduler().getState(myJobsOnly);
    }

    public void addEventListener(SchedulerEventListener sel, boolean myEventsOnly, SchedulerEvent ... events) throws NotConnectedException, PermissionException {
        this.getScheduler().addEventListener(sel, myEventsOnly, events);
    }

    public SchedulerState addEventListener(SchedulerEventListener sel, boolean myEventsOnly, boolean getCurrentState, SchedulerEvent ... events) throws NotConnectedException, PermissionException {
        return this.getScheduler().addEventListener(sel, myEventsOnly, getCurrentState, events);
    }

    public void removeEventListener() throws NotConnectedException, PermissionException {
        this.getScheduler().removeEventListener();
    }

    public abstract TaskResult getTaskResult(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public TaskResult getTaskResult(JobId jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().getTaskResult(jobId, taskName);
    }

    public TaskResult getTaskResultFromIncarnation(String jobId, String taskName, int inc) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().getTaskResultFromIncarnation(jobId, taskName, inc);
    }

    public boolean removeJob(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().removeJob(jobId);
    }

    public void listenJobLogs(String jobId, AppenderProvider appenderProvider) throws NotConnectedException, UnknownJobException, PermissionException {
        this.getScheduler().listenJobLogs(jobId, appenderProvider);
    }

    public boolean killJob(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().killJob(jobId);
    }

    public boolean killJobs(List<String> jobsId) throws NotConnectedException, PermissionException {
        return this.getScheduler().killJobs(jobsId);
    }

    public boolean killTask(String jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().killTask(jobId, taskName);
    }

    public boolean restartTask(String jobId, String taskName, int restartDelay) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().restartTask(jobId, taskName, restartDelay);
    }

    public boolean preemptTask(String jobId, String taskName, int restartDelay) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().preemptTask(jobId, taskName, restartDelay);
    }

    public boolean pauseJob(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().pauseJob(jobId);
    }

    public boolean resumeJob(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().resumeJob(jobId);
    }

    public void changeJobPriority(String jobId, JobPriority priority) throws NotConnectedException, UnknownJobException, PermissionException, JobAlreadyFinishedException {
        this.getScheduler().changeJobPriority(jobId, priority);
    }

    public abstract List<String> getUserSpaceURIs() throws NotConnectedException, PermissionException;

    public abstract List<String> getGlobalSpaceURIs() throws NotConnectedException, PermissionException;

    public JobResult getJobResult(JobId jobId) throws NotConnectedException, PermissionException, UnknownJobException {
        return this.getScheduler().getJobResult(jobId);
    }

    public TaskResult getTaskResultFromIncarnation(JobId jobId, String taskName, int inc) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().getTaskResultFromIncarnation(jobId, taskName, inc);
    }

    public List<TaskResult> getTaskResultAllIncarnations(JobId jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().getTaskResultAllIncarnations(jobId, taskName);
    }

    public List<TaskResult> getTaskResultAllIncarnations(String jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().getTaskResultAllIncarnations(jobId, taskName);
    }

    public boolean killTask(JobId jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().killTask(jobId, taskName);
    }

    public boolean restartTask(JobId jobId, String taskName, int restartDelay) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().restartTask(jobId, taskName, restartDelay);
    }

    public boolean preemptTask(JobId jobId, String taskName, int restartDelay) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getScheduler().preemptTask(jobId, taskName, restartDelay);
    }

    public boolean removeJob(JobId jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().removeJob(jobId);
    }

    public boolean removeJobs(List<JobId> jobIds) throws NotConnectedException, PermissionException {
        return this.getScheduler().removeJobs(jobIds);
    }

    public boolean removeJobs(long olderThan) throws NotConnectedException, PermissionException {
        return this.getScheduler().removeJobs(olderThan);
    }

    public void listenJobLogs(JobId jobId, AppenderProvider appenderProvider) throws NotConnectedException, UnknownJobException, PermissionException {
        this.getScheduler().listenJobLogs(jobId, appenderProvider);
    }

    public boolean killJob(JobId jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().killJob(jobId);
    }

    public boolean pauseJob(JobId jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().pauseJob(jobId);
    }

    public boolean resumeJob(JobId jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().resumeJob(jobId);
    }

    public void changeJobPriority(JobId jobId, JobPriority priority) throws NotConnectedException, UnknownJobException, PermissionException, JobAlreadyFinishedException {
        this.getScheduler().changeJobPriority(jobId, priority);
    }

    public boolean changePolicy(String policyClassName) throws NotConnectedException, PermissionException {
        return this.getScheduler().changePolicy(policyClassName);
    }

    public boolean start() throws NotConnectedException, PermissionException {
        return this.getScheduler().start();
    }

    public boolean stop() throws NotConnectedException, PermissionException {
        return this.getScheduler().stop();
    }

    public boolean pause() throws NotConnectedException, PermissionException {
        return this.getScheduler().pause();
    }

    public boolean freeze() throws NotConnectedException, PermissionException {
        return this.getScheduler().freeze();
    }

    public boolean resume() throws NotConnectedException, PermissionException {
        return this.getScheduler().resume();
    }

    public boolean shutdown() throws NotConnectedException, PermissionException {
        return this.getScheduler().shutdown();
    }

    public boolean kill() throws NotConnectedException, PermissionException {
        return this.getScheduler().kill();
    }

    public boolean linkResourceManager(String rmURL) throws NotConnectedException, PermissionException {
        return this.getScheduler().linkResourceManager(rmURL);
    }

    public String getCurrentPolicy() throws NotConnectedException, PermissionException {
        return this.getScheduler().getCurrentPolicy();
    }

    public Map getJobsToSchedule() throws NotConnectedException, PermissionException {
        return this.getScheduler().getJobsToSchedule();
    }

    public List<TaskDescriptor> getTasksToSchedule() throws NotConnectedException, PermissionException {
        return this.getScheduler().getTasksToSchedule();
    }

    public boolean reloadPolicyConfiguration() throws NotConnectedException, PermissionException {
        return this.getScheduler().reloadPolicyConfiguration();
    }

    public abstract void addEventListener(SchedulerEventListenerExtended var1, boolean var2, SchedulerEvent[] var3) throws NotConnectedException, PermissionException;

    protected abstract void removeJobIO(Job var1, String var2, String var3, String var4);

    protected abstract void createFolder(String var1) throws NotConnectedException, PermissionException;

    public List<JobUsage> getMyAccountUsage(Date startDate, Date endDate) throws NotConnectedException, PermissionException {
        return this.getScheduler().getMyAccountUsage(startDate, endDate);
    }

    public List<JobUsage> getAccountUsage(String user, Date startDate, Date endDate) throws NotConnectedException, PermissionException {
        return this.getScheduler().getAccountUsage(user, startDate, endDate);
    }

    public void putThirdPartyCredential(String key, String value) throws SchedulerException {
        this.getScheduler().putThirdPartyCredential(key, value);
    }

    public Set<String> thirdPartyCredentialsKeySet() throws SchedulerException {
        return this.getScheduler().thirdPartyCredentialsKeySet();
    }

    public void removeThirdPartyCredential(String key) throws SchedulerException {
        this.getScheduler().removeThirdPartyCredential(key);
    }

    public List<TaskResult> getTaskResultsByTag(JobId jobId, String taskTag) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().getTaskResultsByTag(jobId, taskTag);
    }

    public List<TaskResult> getTaskResultsByTag(String jobId, String taskTag) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getScheduler().getTaskResultsByTag(jobId, taskTag);
    }

    public Map<String, Map<String, Boolean>> checkJobsPermissionMethods(List<String> jobIds, List<String> methods) throws NotConnectedException, UnknownJobException {
        return this.getScheduler().checkJobsPermissionMethods(jobIds, methods);
    }
}

