# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2016, Lars Asplund lars.anders.asplund@gmail.com

"""
Verilog tokens
"""

from vunit.parsing.tokenizer import new_token_kind


def __token(kind):
    """
    Create non keyword token kind
    """
    return new_token_kind(kind)


def __keyword(kind):
    """
    Create keyword token kind
    """
    token_kind = new_token_kind(kind)
    KEYWORDS[kind] = token_kind
    return token_kind

KEYWORDS = {}

PREPROCESSOR = __token("preprocessor")
STRING = __token("string")
COMMENT = __token("comment")
IDENTIFIER = __token("identifier")
ESCAPED_NEWLINE = __token("escaped_newline")
NEWLINE = __token("newline")
WHITESPACE = __token("whitespace")
MULTI_COMMENT = __token("multi_comment")
SEMI_COLON = __token("semi_colon")
DOUBLE_COLON = __token("double_colon")
HASH = __token("hash")
EQUAL = __token("equal")
LPAR = __token("lpar")
RPAR = __token("rpar")
COMMA = __token("comma")
OTHER = __token("other")

MODULE = __keyword("module")
ENDMODULE = __keyword("endmodule")
PACKAGE = __keyword("package")
IMPORT = __keyword("import")
ENDPACKAGE = __keyword("endpackage")
PARAMETER = __keyword("parameter")
ACCEPT_ON = __keyword("accept_on")
ALIAS = __keyword("alias")
ALWAYS = __keyword("always")
ALWAYS_COMB = __keyword("always_comb")
ALWAYS_FF = __keyword("always_ff")
ALWAYS_LATCH = __keyword("always_latch")
AND = __keyword("and")
ASSERT = __keyword("assert")
ASSIGN = __keyword("assign")
ASSUME = __keyword("assume")
AUTOMATIC = __keyword("automatic")
BEFORE = __keyword("before")
BEGIN = __keyword("begin")
BIND = __keyword("bind")
BINS = __keyword("bins")
BINSOF = __keyword("binsof")
BIT = __keyword("bit")
BREAK = __keyword("break")
BUF = __keyword("buf")
BUFIF0 = __keyword("bufif0")
BUFIF1 = __keyword("bufif1")
BYTE = __keyword("byte")
CASE = __keyword("case")
CASEX = __keyword("casex")
CASEZ = __keyword("casez")
CELL = __keyword("cell")
CHANDLE = __keyword("chandle")
CHECKER = __keyword("checker")
CLASS = __keyword("class")
CLOCKING = __keyword("clocking")
CMOS = __keyword("cmos")
CONFIG = __keyword("config")
CONST = __keyword("const")
CONSTRAINT = __keyword("constraint")
CONTEXT = __keyword("context")
CONTINUE = __keyword("continue")
COVER = __keyword("cover")
COVERGROUP = __keyword("covergroup")
COVERPOINT = __keyword("coverpoint")
CROSS = __keyword("cross")
DEASSIGN = __keyword("deassign")
DEFAULT = __keyword("default")
DEFPARAM = __keyword("defparam")
DESIGN = __keyword("design")
DISABLE = __keyword("disable")
DIST = __keyword("dist")
DO = __keyword("do")
EDGE = __keyword("edge")
ELSE = __keyword("else")
END = __keyword("end")
ENDCASE = __keyword("endcase")
ENDCHECKER = __keyword("endchecker")
ENDCLASS = __keyword("endclass")
ENDCLOCKING = __keyword("endclocking")
ENDCONFIG = __keyword("endconfig")
ENDFUNCTION = __keyword("endfunction")
ENDGENERATE = __keyword("endgenerate")
ENDGROUP = __keyword("endgroup")
ENDINTERFACE = __keyword("endinterface")
ENDMODULE = __keyword("endmodule")
ENDPACKAGE = __keyword("endpackage")
ENDPRIMITIVE = __keyword("endprimitive")
ENDPROGRAM = __keyword("endprogram")
ENDPROPERTY = __keyword("endproperty")
ENDSPECIFY = __keyword("endspecify")
ENDSEQUENCE = __keyword("endsequence")
ENDTABLE = __keyword("endtable")
ENDTASK = __keyword("endtask")
ENUM = __keyword("enum")
EVENT = __keyword("event")
EVENTUALLY = __keyword("eventually")
EXPECT = __keyword("expect")
EXPORT = __keyword("export")
EXTENDS = __keyword("extends")
EXTERN = __keyword("extern")
FINAL = __keyword("final")
FIRST_MATCH = __keyword("first_match")
FOR = __keyword("for")
FORCE = __keyword("force")
FOREACH = __keyword("foreach")
FOREVER = __keyword("forever")
FORK = __keyword("fork")
FORKJOIN = __keyword("forkjoin")
FUNCTION = __keyword("function")
GENERATE = __keyword("generate")
GENVAR = __keyword("genvar")
GLOBAL = __keyword("global")
HIGHZ0 = __keyword("highz0")
HIGHZ1 = __keyword("highz1")
IF = __keyword("if")
IFF = __keyword("iff")
IFNONE = __keyword("ifnone")
IGNORE_BINS = __keyword("ignore_bins")
ILLEGAL_BINS = __keyword("illegal_bins")
IMPLEMENTS = __keyword("implements")
IMPLIES = __keyword("implies")
IMPORT = __keyword("import")
INCDIR = __keyword("incdir")
INCLUDE = __keyword("include")
INITIAL = __keyword("initial")
INOUT = __keyword("inout")
INPUT = __keyword("input")
INSIDE = __keyword("inside")
INSTANCE = __keyword("instance")
INT = __keyword("int")
INTEGER = __keyword("integer")
INTERCONNECT = __keyword("interconnect")
INTERFACE = __keyword("interface")
INTERSECT = __keyword("intersect")
JOIN = __keyword("join")
JOIN_ANY = __keyword("join_any")
JOIN_NONE = __keyword("join_none")
LARGE = __keyword("large")
LET = __keyword("let")
LIBLIST = __keyword("liblist")
LIBRARY = __keyword("library")
LOCAL = __keyword("local")
LOCALPARAM = __keyword("localparam")
LOGIC = __keyword("logic")
LONGINT = __keyword("longint")
MACROMODULE = __keyword("macromodule")
MATCHES = __keyword("matches")
MEDIUM = __keyword("medium")
MODPORT = __keyword("modport")
MODULE = __keyword("module")
NAND = __keyword("nand")
NEGEDGE = __keyword("negedge")
NETTYPE = __keyword("nettype")
NEW = __keyword("new")
NEXTTIME = __keyword("nexttime")
NMOS = __keyword("nmos")
NOR = __keyword("nor")
NOSHOWCANCELLED = __keyword("noshowcancelled")
NOT = __keyword("not")
NOTIF0 = __keyword("notif0")
NOTIF1 = __keyword("notif1")
NULL = __keyword("null")
OR = __keyword("or")
OUTPUT = __keyword("output")
PACKAGE = __keyword("package")
PACKED = __keyword("packed")
PARAMETER = __keyword("parameter")
PMOS = __keyword("pmos")
POSEDGE = __keyword("posedge")
PRIMITIVE = __keyword("primitive")
PRIORITY = __keyword("priority")
PROGRAM = __keyword("program")
PROPERTY = __keyword("property")
PROTECTED = __keyword("protected")
PULL0 = __keyword("pull0")
PULL1 = __keyword("pull1")
PULLDOWN = __keyword("pulldown")
PULLUP = __keyword("pullup")
PULSESTYLE_ONDETECT = __keyword("pulsestyle_ondetect")
PULSESTYLE_ONEVENT = __keyword("pulsestyle_onevent")
PURE = __keyword("pure")
RAND = __keyword("rand")
RANDC = __keyword("randc")
RANDCASE = __keyword("randcase")
RANDSEQUENCE = __keyword("randsequence")
RCMOS = __keyword("rcmos")
REAL = __keyword("real")
REALTIME = __keyword("realtime")
REF = __keyword("ref")
REG = __keyword("reg")
REJECT_ON = __keyword("reject_on")
RELEASE = __keyword("release")
REPEAT = __keyword("repeat")
RESTRICT = __keyword("restrict")
RETURN = __keyword("return")
RNMOS = __keyword("rnmos")
RPMOS = __keyword("rpmos")
RTRAN = __keyword("rtran")
RTRANIF0 = __keyword("rtranif0")
RTRANIF1 = __keyword("rtranif1")
S_ALWAYS = __keyword("s_always")
S_EVENTUALLY = __keyword("s_eventually")
S_NEXTTIME = __keyword("s_nexttime")
S_UNTIL = __keyword("s_until")
S_UNTIL_WITH = __keyword("s_until_with")
SCALARED = __keyword("scalared")
SEQUENCE = __keyword("sequence")
SHORTINT = __keyword("shortint")
SHORTREAL = __keyword("shortreal")
SHOWCANCELLED = __keyword("showcancelled")
SIGNED = __keyword("signed")
SMALL = __keyword("small")
SOFT = __keyword("soft")
SOLVE = __keyword("solve")
SPECIFY = __keyword("specify")
SPECPARAM = __keyword("specparam")
STATIC = __keyword("static")
STRING = __keyword("string")
STRONG = __keyword("strong")
STRONG0 = __keyword("strong0")
STRONG1 = __keyword("strong1")
STRUCT = __keyword("struct")
SUPER = __keyword("super")
SUPPLY0 = __keyword("supply0")
SUPPLY1 = __keyword("supply1")
SYNC_ACCEPT_ON = __keyword("sync_accept_on")
SYNC_REJECT_ON = __keyword("sync_reject_on")
TABLE = __keyword("table")
TAGGED = __keyword("tagged")
TASK = __keyword("task")
THIS = __keyword("this")
THROUGHOUT = __keyword("throughout")
TIME = __keyword("time")
TIMEPRECISION = __keyword("timeprecision")
TIMEUNIT = __keyword("timeunit")
TRAN = __keyword("tran")
TRANIF0 = __keyword("tranif0")
TRANIF1 = __keyword("tranif1")
TRI = __keyword("tri")
TRI0 = __keyword("tri0")
TRI1 = __keyword("tri1")
TRIAND = __keyword("triand")
TRIOR = __keyword("trior")
TRIREG = __keyword("trireg")
TYPE = __keyword("type")
TYPEDEF = __keyword("typedef")
UNION = __keyword("union")
UNIQUE = __keyword("unique")
UNIQUE0 = __keyword("unique0")
UNSIGNED = __keyword("unsigned")
UNTIL = __keyword("until")
UNTIL_WITH = __keyword("until_with")
UNTYPED = __keyword("untyped")
USE = __keyword("use")
UWIRE = __keyword("uwire")
VAR = __keyword("var")
VECTORED = __keyword("vectored")
VIRTUAL = __keyword("virtual")
VOID = __keyword("void")
WAIT = __keyword("wait")
WAIT_ORDER = __keyword("wait_order")
WAND = __keyword("wand")
WEAK = __keyword("weak")
WEAK0 = __keyword("weak0")
WEAK1 = __keyword("weak1")
WHILE = __keyword("while")
WILDCARD = __keyword("wildcard")
WIRE = __keyword("wire")
WITH = __keyword("with")
WITHIN = __keyword("within")
WOR = __keyword("wor")
XNOR = __keyword("xnor")
XOR = __keyword("xor")
