# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MonitorConfig(Model):
    """Class containing endpoint monitoring settings in a Traffic Manager profile.

    :param profile_monitor_status: Gets or sets the profile-level monitoring
     status of the Traffic Manager profile.
    :type profile_monitor_status: str
    :param protocol: Gets or sets the protocol (HTTP or HTTPS) used to probe
     for endpoint health.
    :type protocol: str
    :param port: Gets or sets the TCP port used to probe for endpoint health.
    :type port: long
    :param path: Gets or sets the path relative to the endpoint domain name
     used to probe for endpoint health.
    :type path: str
    """

    _attribute_map = {
        'profile_monitor_status': {'key': 'profileMonitorStatus', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'port': {'key': 'port', 'type': 'long'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(self, profile_monitor_status=None, protocol=None, port=None, path=None):
        self.profile_monitor_status = profile_monitor_status
        self.protocol = protocol
        self.port = port
        self.path = path
