# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class TrafficManagerGeographicHierarchy(Resource):
    """Class representing the Geographic hierarchy used with the Geographic
    traffic routing method.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :param geographic_hierarchy: The region at the root of the hierarchy from
     all the regions in the hierarchy can be retrieved.
    :type geographic_hierarchy: :class:`Region
     <azure.mgmt.trafficmanager.models.Region>`
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'geographic_hierarchy': {'key': 'properties.geographicHierarchy', 'type': 'Region'},
    }

    def __init__(self, location=None, tags=None, geographic_hierarchy=None):
        super(TrafficManagerGeographicHierarchy, self).__init__(location=location, tags=tags)
        self.geographic_hierarchy = geographic_hierarchy
