# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CognitiveServicesAccount(Model):
    """Cognitive Services Account is an Azure resource representing the
    provisioned account, its type, location and SKU.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param etag: Entity Tag
    :type etag: str
    :param id: The id of the created account
    :type id: str
    :param kind: Type of cognitive service account.
    :type kind: str
    :param location: The location of the resource
    :type location: str
    :param name: The name of the created account
    :type name: str
    :ivar provisioning_state: Gets the status of the cognitive services
     account at the time the operation was called. Possible values include:
     'Creating', 'ResolvingDNS', 'Succeeded', 'Failed'
    :vartype provisioning_state: str or :class:`ProvisioningState
     <azure.mgmt.cognitiveservices.models.ProvisioningState>`
    :param endpoint: Endpoint of the created account
    :type endpoint: str
    :param sku:
    :type sku: :class:`Sku <azure.mgmt.cognitiveservices.models.Sku>`
    :param tags: Gets or sets a list of key value pairs that describe the
     resource. These tags can be used in viewing and grouping this resource
     (across resource groups). A maximum of 15 tags can be provided for a
     resource. Each tag must have a key no greater than 128 characters and
     value no greater than 256 characters.
    :type tags: dict
    :param type: Resource type
    :type type: str
    """ 

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, etag=None, id=None, kind=None, location=None, name=None, endpoint=None, sku=None, tags=None, type=None):
        self.etag = etag
        self.id = id
        self.kind = kind
        self.location = location
        self.name = name
        self.provisioning_state = None
        self.endpoint = endpoint
        self.sku = sku
        self.tags = tags
        self.type = type
