# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._sql_vulnerability_assessment_baselines_operations import build_create_or_update_request

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class SqlVulnerabilityAssessmentBaselinesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.sql.aio.SqlManagementClient`'s
        :attr:`sql_vulnerability_assessment_baselines` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        server_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        baseline_name: Union[str, _models.BaselineName],
        parameters: _models.DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseSqlVulnerabilityAssessmentBaselineSet:
        """Add a database's vulnerability assessment rule baseline list.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param server_name: The name of the server. Required.
        :type server_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param baseline_name: "default" Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.BaselineName
        :param parameters: The requested rule baseline resource. Required.
        :type parameters:
         ~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword system_database_name: The vulnerability assessment system database name. Default value
         is "master". Note that overriding this default value may result in unsupported behavior.
        :paramtype system_database_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DatabaseSqlVulnerabilityAssessmentBaselineSet or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentBaselineSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        server_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        baseline_name: Union[str, _models.BaselineName],
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseSqlVulnerabilityAssessmentBaselineSet:
        """Add a database's vulnerability assessment rule baseline list.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param server_name: The name of the server. Required.
        :type server_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param baseline_name: "default" Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.BaselineName
        :param parameters: The requested rule baseline resource. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword system_database_name: The vulnerability assessment system database name. Default value
         is "master". Note that overriding this default value may result in unsupported behavior.
        :paramtype system_database_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DatabaseSqlVulnerabilityAssessmentBaselineSet or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentBaselineSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        server_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        baseline_name: Union[str, _models.BaselineName],
        parameters: Union[_models.DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput, IO],
        **kwargs: Any
    ) -> _models.DatabaseSqlVulnerabilityAssessmentBaselineSet:
        """Add a database's vulnerability assessment rule baseline list.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param server_name: The name of the server. Required.
        :type server_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param baseline_name: "default" Required.
        :type baseline_name: str or ~azure.mgmt.sql.models.BaselineName
        :param parameters: The requested rule baseline resource. Is either a model type or a IO type.
         Required.
        :type parameters:
         ~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput or IO
        :keyword system_database_name: The vulnerability assessment system database name. Default value
         is "master". Note that overriding this default value may result in unsupported behavior.
        :paramtype system_database_name: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DatabaseSqlVulnerabilityAssessmentBaselineSet or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentBaselineSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        system_database_name = kwargs.pop(
            "system_database_name", _params.pop("systemDatabaseName", "master")
        )  # type: Literal["master"]
        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", "2022-02-01-preview")
        )  # type: Literal["2022-02-01-preview"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DatabaseSqlVulnerabilityAssessmentBaselineSet]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput")

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            server_name=server_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            baseline_name=baseline_name,
            subscription_id=self._config.subscription_id,
            system_database_name=system_database_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseSqlVulnerabilityAssessmentBaselineSet", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}"}  # type: ignore
