/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;

public class BoundedStringWriter
extends Writer {
    private final PrintStream outputSink;
    private final StringBuilder content;
    private final int maxSize;

    public BoundedStringWriter(PrintStream outputSink, int maxSize) {
        this.outputSink = outputSink;
        this.maxSize = maxSize;
        this.content = new StringBuilder();
    }

    @Override
    public void write(char[] c, int off, int len) {
        int nextLen = this.content.length() + len;
        if (nextLen <= this.maxSize) {
            this.content.append(c, off, len);
        } else if (len <= this.maxSize) {
            this.content.delete(0, nextLen - this.maxSize);
            this.content.append(c, off, len);
        } else {
            this.content.delete(0, this.maxSize);
            this.content.append(c, len - this.maxSize, this.maxSize);
        }
        this.outputSink.print(new String(c, off, len));
    }

    public StringBuilder getBuilder() {
        return this.content;
    }

    public String toString() {
        return this.content.toString();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }
}

