/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobType;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.task.CommonAttribute;
import org.ow2.proactive.scheduler.common.task.OnTaskError;
import org.ow2.proactive.scheduler.common.task.util.IntegerWrapper;

@PublicAPI
public abstract class Job
extends CommonAttribute {
    protected String name = "NOT SET";
    protected String description = "No description";
    protected String projectName = "Not Assigned";
    protected JobPriority priority = JobPriority.NORMAL;
    protected String inputSpace = null;
    protected String outputSpace = null;
    protected String globalSpace = null;
    protected String userSpace = null;
    protected Map<String, JobVariable> variables = Collections.synchronizedMap(new LinkedHashMap());
    private static final long serialVersionUID = 810L;

    public abstract JobType getType();

    public abstract JobId getId();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobPriority getPriority() {
        return this.priority;
    }

    public void setPriority(JobPriority priority) {
        this.priority = priority;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getInputSpace() {
        return this.inputSpace;
    }

    public void setInputSpace(String inputSpace) {
        this.inputSpace = inputSpace;
    }

    public String getOutputSpace() {
        return this.outputSpace;
    }

    public void setOutputSpace(String outputSpace) {
        this.outputSpace = outputSpace;
    }

    public String getGlobalSpace() {
        return this.globalSpace;
    }

    public void setGlobalSpace(String globalSpace) {
        this.globalSpace = globalSpace;
    }

    public String getUserSpace() {
        return this.userSpace;
    }

    public void setUserSpace(String userSpace) {
        this.userSpace = userSpace;
    }

    public void setVariables(Map<String, JobVariable> variables) {
        Job.verifyVariableMap(variables);
        this.variables = Collections.synchronizedMap(new LinkedHashMap<String, JobVariable>(variables));
    }

    public static void verifyVariableMap(Map<String, ? extends JobVariable> variables) {
        for (Map.Entry<String, ? extends JobVariable> entry : variables.entrySet()) {
            if (entry.getKey().equals(entry.getValue().getName())) continue;
            throw new IllegalArgumentException("Variables map entry key (" + entry.getKey() + ") is different from variable name (" + entry.getValue().getName() + ")");
        }
    }

    public Map<String, JobVariable> getVariables() {
        return this.variables;
    }

    public Map<String, String> getVariablesAsReplacementMap() {
        LinkedHashMap<String, String> replacementVariables = new LinkedHashMap<String, String>(this.variables.size());
        for (JobVariable variable : this.variables.values()) {
            replacementVariables.put(variable.getName(), variable.getValue());
        }
        return replacementVariables;
    }

    public String toString() {
        return this.name;
    }

    public String display() {
        String nl = System.lineSeparator();
        return "Job '" + this.name + "' : " + nl + "\tDescription = '" + this.description + '\'' + nl + "\tProjectName = '" + this.projectName + '\'' + nl + (this.onTaskError.isSet() ? "\tonTaskError = '" + ((OnTaskError)this.onTaskError.getValue()).toString() + '\'' + nl : "") + (this.restartTaskOnError.isSet() ? "\trestartTaskOnError = '" + this.restartTaskOnError.getValue() + '\'' + nl : "") + (this.maxNumberOfExecution.isSet() ? "\tmaxNumberOfExecution = '" + ((IntegerWrapper)this.maxNumberOfExecution.getValue()).getIntegerValue() + '\'' + nl : "") + "\tgenericInformation = {" + nl + Joiner.on((char)'\n').withKeyValueSeparator("=").join(this.genericInformation) + nl + "}" + nl + "\tPriority = " + this.priority + nl + "\tInputSpace = '" + this.inputSpace + '\'' + nl + "\tOutputSpace = '" + this.outputSpace + '\'' + nl + "\tGlobalSpace = '" + this.globalSpace + '\'' + nl + "\tUserSpace = '" + this.userSpace + '\'' + nl + "\tVariables = {" + nl + Joiner.on((char)'\n').withKeyValueSeparator("=").join(this.variables) + nl + "}";
    }
}

