/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

public class TimeoutAccounter {
    private final long timeout;
    private long start;
    private static final TimeoutAccounter NO_TIMEOUT = new TimeoutAccounter(0L);

    private TimeoutAccounter(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout: " + timeout);
        }
        this.timeout = timeout;
        if (this.timeout != 0L) {
            this.start = System.nanoTime() / 1000000L;
        }
    }

    public static TimeoutAccounter getAccounter(long timeout) {
        if (timeout == 0L) {
            return NO_TIMEOUT;
        }
        return new TimeoutAccounter(timeout);
    }

    public boolean isTimeoutElapsed() {
        return this.timeout != 0L && System.nanoTime() / 1000000L - this.start >= this.timeout;
    }

    public long getRemainingTimeout() {
        long elapsedTime;
        long remainingTimeout = 0L;
        if (this.timeout != 0L && (remainingTimeout = this.timeout - (elapsedTime = System.nanoTime() / 1000000L - this.start)) <= 0L) {
            remainingTimeout = 1L;
        }
        return remainingTimeout;
    }
}

