#!/usr/bin/env python
# Generated by jaraco.develop (https://bitbucket.org/jaraco/jaraco.develop)
import os
import functools

from setuptools import find_packages

here = functools.partial(os.path.join, os.path.dirname(__file__))

with open(here('README')) as readme:
	long_description = readme.read()
with open(here('CHANGES.txt')) as changes:
	long_description += '\n' + changes.read()

setup_params = dict(
	name='jaraco.modb',
	description="MongoDB Object DataBase (MODB) for Python objects",
	long_description=long_description,
	use_hg_version=dict(increment='0.1'),
	packages=find_packages(),
	namespace_packages=['jaraco'],
	zip_safe=False,
	classifiers = [
		"Development Status :: 5 - Production/Stable",
		"Intended Audience :: Developers",
		"Programming Language :: Python :: 2.7",
		"Programming Language :: Python :: 3",
	],
	find_links=[
		'https://dl.dropboxusercontent.com/u/54081/cheeseshop/index.html',
	],
	install_requires=[
		'jsonpickle>=0.6.1p-20131118',
		'pymongo',
		'jaraco.util',
		'six',
	],
	setup_requires=[
		'hgtools',
		'pytest-runner',
	],
)
if __name__ == '__main__':
	from setuptools import setup
	setup(**setup_params)
