/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.util.ArrayList;
import java.util.List;

public class ObjectArrayFormatter {
    private List<String> title;
    private List<List<String>> lines = new ArrayList<List<String>>();
    private int spaces;
    private int maxColumnLength = 20;

    public void setTitle(List<String> title) {
        this.title = title;
    }

    public void addLine(List<String> lines) {
        if (lines == null || lines.size() == 0) {
            throw new IllegalArgumentException("Lines must be a non-empty list.");
        }
        this.lines.add(lines);
    }

    public void addEmptyLine() {
        this.lines.add(null);
    }

    public void setSpace(int spaces) {
        if (spaces < 1) {
            throw new IllegalArgumentException("spaces must be a positive value.");
        }
        this.spaces = spaces;
    }

    public void setMaxColumnLength(int maxColumnLength) {
        if (maxColumnLength < 1) {
            throw new IllegalArgumentException("maxColumnLength must be a positive");
        }
        this.maxColumnLength = maxColumnLength;
    }

    public String getAsString() {
        if (this.title == null || this.title.size() == 0) {
            throw new IllegalStateException("Title array does not contain anything !");
        }
        for (List<String> l : this.lines) {
            if (l == null || l.size() == this.title.size()) continue;
            throw new IllegalStateException("One of the line is not as long as the other or the title array !");
        }
        int[] columnLengths = new int[this.title.size()];
        for (int i = 0; i < columnLengths.length; ++i) {
            columnLengths[i] = this.title.get(i).length();
        }
        for (List<String> l : this.lines) {
            if (l == null) continue;
            int i = 0;
            for (String s : l) {
                columnLengths[i] = s.length() > columnLengths[i] ? s.length() : columnLengths[i];
                ++i;
            }
        }
        int i = 0;
        while (i < columnLengths.length) {
            if (columnLengths[i] > this.maxColumnLength) {
                columnLengths[i] = this.maxColumnLength;
            }
            int n = i++;
            columnLengths[n] = columnLengths[n] + this.spaces;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\t");
        for (int i2 = 0; i2 < this.title.size(); ++i2) {
            sb.append(String.format(" %1$-" + columnLengths[i2] + "s", this.cutNchar(this.title.get(i2), this.maxColumnLength)));
        }
        sb.append(System.lineSeparator());
        for (List<String> l : this.lines) {
            if (l == null) {
                sb.append(System.lineSeparator());
                continue;
            }
            sb.append("\t");
            for (int i3 = 0; i3 < l.size(); ++i3) {
                sb.append(String.format(" %1$-" + columnLengths[i3] + "s", this.cutNchar(l.get(i3), this.maxColumnLength)));
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private String cutNchar(String str, int nbChar) {
        if (str == null) {
            return "";
        }
        if (str.length() <= --nbChar) {
            return str;
        }
        return str.substring(0, nbChar - 3) + "...";
    }
}

