/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.util.AllObjects2BytesConverterHandler;

@PublicAPI
public class JavaTask
extends Task {
    protected String executableClassName = null;
    private final HashMap<String, byte[]> serializedArguments = new HashMap();
    public static final String ARGS_FIELD_NAME = "serializedArguments";
    private static final long serialVersionUID = 100L;

    public String getExecutableClassName() {
        return this.executableClassName;
    }

    public void setExecutableClassName(String executableClassName) {
        if (executableClassName == null) {
            throw new IllegalArgumentException("Executable class name must be set for JavaTask: " + this.name);
        }
        if (executableClassName.length() > 255) {
            throw new IllegalArgumentException("Class name is too long, it must have 255 chars length max: " + executableClassName);
        }
        this.executableClassName = executableClassName;
    }

    public Map<String, Serializable> getArguments() throws IOException, ClassNotFoundException {
        Set<String> allNames = this.serializedArguments.keySet();
        HashMap<String, Serializable> deserialized = new HashMap<String, Serializable>(allNames.size());
        for (String name : allNames) {
            deserialized.put(name, this.getArgument(name));
        }
        return Collections.unmodifiableMap(deserialized);
    }

    public HashMap<String, byte[]> getSerializedArguments() {
        return new HashMap<String, byte[]>(this.serializedArguments);
    }

    public void addArgument(String name, Serializable value) {
        byte[] serialized = null;
        try {
            serialized = AllObjects2BytesConverterHandler.convertObject2Byte(name, value);
            this.serializedArguments.put(name, serialized);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot add argument " + name + " in task " + this.name, e);
        }
    }

    public Serializable getArgument(String name) throws IOException, ClassNotFoundException {
        byte[] serializedValue = this.serializedArguments.get(name);
        if (serializedValue != null) {
            return AllObjects2BytesConverterHandler.convertByte2Object(serializedValue);
        }
        return null;
    }

    public Serializable removeArgument(String name) throws IOException, ClassNotFoundException {
        byte[] serializedValue = this.serializedArguments.remove(name);
        if (serializedValue != null) {
            return AllObjects2BytesConverterHandler.convertByte2Object(serializedValue);
        }
        return null;
    }

    public boolean isFork() {
        return this.forkEnvironment != null || super.isWallTimeSet() || super.isRunAsMe();
    }

    @Override
    public String display() {
        String nl = System.lineSeparator();
        String answer = super.display();
        return answer + nl + "\tExecutableClassName = '" + this.executableClassName + '\'' + nl + "\tArguments = " + this.serializedArguments.keySet() + nl + "\tForkEnvironment = " + this.forkEnvironment;
    }
}

