AW = {'Ni': 57.9353462, 'Na': 22.9897677, 'Mg': 23.9850423, 'Li': 7.016003, 'Fe': 55.9349393, 'Br': 78.9183361, 'Hg': 201.970617, 'C': 12.0, 'B': 11.0093055, 'F': 18.99840322, 'I': 126.904473, 'H': 1.007825035, 'K': 38.9637074, 'Mn': 54.9380471, '18O': 17.9991603, 'O': 15.99491463, 'N': 14.003074, 'P': 30.973762, 'S': 31.9720707, 'Co': 58.9331976, '2H': 2.014101779, 'Se': 79.9165196, '13C': 13.00335483, 'Zn': 63.9291448, 'e': 0.000549, 'Ag': 106.905092, 'Cl': 34.96885272, 'Ca': 39.9625906, 'Cd': 113.903357, 'As': 74.9215942, 'Au': 196.966543, 'Mo': 97.9054073, 'Cr': 51.9405098, 'Cu': 62.9295989, '15N': 15.00010897} ;
amino_acids = {'-': 0.0, 'C-term': 17.00274, 'A': 71.037114, 'C': 103.009185, 'E': 129.042593, 'D': 115.026943, 'G': 57.021464, 'F': 147.068414, 'I': 113.084064, 'H': 137.058912, 'K': 128.094963, 'N-term': 1.007825, 'M': 131.040485, 'L': 113.084064, 'N': 114.042927, 'Q': 128.058578, 'P': 97.052764, 'S': 87.032028, 'R': 156.101111, 'T': 101.047679, 'W': 186.079313, 'V': 99.068414, 'Y': 163.063329} ;
name = ['Acetyl', 'Amidated', 'Biotin', 'Carbamidomethyl', 'Carbamyl', 'Carboxymethyl', 'Deamidated', 'ICAT-G', 'ICAT-G:2H(8)', 'Met->Hse', 'Met->Hsl', 'ICAT-D:2H(8)', 'ICAT-D', 'NIPCAM', 'PEO-Iodoacetyl-LC-Biotin', 'Phospho', 'Dehydrated', 'Propionamide', 'Pyridylacetyl', 'Pyro-carbamidomethyl', 'Glu->pyro-Glu', 'Gln->pyro-Glu', 'SMA', 'Cation:Na', 'Pyridylethyl', 'Methyl', 'Oxidation', 'Dimethyl', 'Trimethyl', 'Methylthio', 'Sulfo', 'Hex', 'Lipoyl', 'HexNAc', 'Farnesyl', 'Myristoyl', 'PyridoxalPhosphate', 'Palmitoyl', 'GeranylGeranyl', 'Phosphopantetheine', 'FAD', 'Tripalmitate', 'Guanidinyl', 'HNE', 'Glucuronyl', 'Glutathione', 'Acetyl:2H(3)', 'Propionyl', 'Propionyl:13C(3)', 'GIST-Quat', 'GIST-Quat:2H(3)', 'GIST-Quat:2H(6)', 'GIST-Quat:2H(9)', 'Succinyl', 'Succinyl:2H(4)', 'Succinyl:13C(4)', 'probiotinhydrazide', 'Pro->pyro-Glu', 'His->Asn', 'His->Asp', 'Trp->Hydroxykynurenin', 'Delta:H(4)C(3)', 'Delta:H(4)C(2)', 'Cys->Dha', 'Arg->GluSA', 'Trioxidation', 'Iminobiotin', 'ESP', 'ESP:2H(10)', 'NHS-LC-Biotin', 'EDT-maleimide-PEO-biotin', 'IMID', 'IMID:2H(4)', 'Lysbiotinhydrazide', 'Propionamide:2H(3)', 'Nitro', 'ICAT-C', 'Delta:H(2)C(2)', 'Trp->Kynurenin', 'Lys->Allysine', 'ICAT-C:13C(9)', 'FormylMet', 'Nethylmaleimide', 'OxLysBiotinRed', 'IBTP', 'OxLysBiotin', 'OxProBiotinRed', 'OxProBiotin', 'OxArgBiotin', 'OxArgBiotinRed', 'EDT-iodoacetyl-PEO-biotin', 'GlyGly', 'Formyl', 'ICAT-H', 'ICAT-H:13C(6)', 'Cation:K', 'Thioacyl', 'Fluoro', 'Fluorescein', 'Iodo', 'Diiodo', 'Triiodo', 'Myristoleyl', 'Pro->Pyrrolidinone', 'Myristoyl+Delta:H(-4)', 'Benzoyl', 'Hex(5)HexNAc(2)', 'Dansyl', 'a-type-ion', 'Amidine', 'HexNAc(1)dHex(1)', 'HexNAc(2)', 'Hex(3)', 'HexNAc(1)dHex(2)', 'Hex(1)HexNAc(1)dHex(1)', 'HexNAc(2)dHex(1)', 'Hex(1)HexNAc(2)', 'Hex(1)HexNAc(1)NeuAc(1)', 'HexNAc(2)dHex(2)', 'Hex(1)HexNAc(2)Pent(1)', 'Hex(1)HexNAc(2)dHex(1)', 'Hex(2)HexNAc(2)', 'Hex(3)HexNAc(1)Pent(1)', 'Hex(1)HexNAc(2)dHex(1)Pent(1)', 'Hex(1)HexNAc(2)dHex(2)', 'Hex(2)HexNAc(2)Pent(1)', 'Hex(2)HexNAc(2)dHex(1)', 'Hex(3)HexNAc(2)', 'Hex(1)HexNAc(1)NeuAc(2)', 'Hex(3)HexNAc(2)P(1)', 'Delta:S(-1)Se(1)', 'NBS:13C(6)', 'Methyl:2H(3)13C(1)', 'Dimethyl:2H(6)13C(2)', 'NBS', 'Delta:H(1)O(-1)18O(1)', 'QAT', 'BHT', 'Delta:H(4)C(2)O(-1)S(1)', 'DAET', 'Pro->Pyrrolidone', 'Label:13C(9)', 'Label:13C(9)+Phospho', 'Label:13C(6)', 'HPG', '2HPG', 'QAT:2H(3)', 'Label:18O(2)', 'AccQTag', 'Dimethyl:2H(4)', 'EQAT', 'EQAT:2H(5)', 'Ethanedithiol', 'NEIAA:2H(5)', 'Delta:H(6)C(6)O(1)', 'Delta:H(4)C(3)O(1)', 'Delta:H(2)C(3)', 'Delta:H(4)C(6)', 'Delta:H(8)C(6)O(2)', 'ADP-Ribosyl', 'NEIAA', 'iTRAQ4plex', 'Crotonaldehyde', 'Bromo', 'Amino', 'Argbiotinhydrazide', 'Label:18O(1)', 'Label:13C(6)15N(2)', 'Thiophospho', 'SPITC', 'IGBP', 'Cytopiloyne', 'Cytopiloyne+water', 'Label:13C(6)15N(4)', 'Label:13C(9)15N(1)', 'Label:2H(3)', 'Label:13C(5)15N(1)', 'PET', 'CAF', 'Xlink:SSD', 'Nitrosyl', 'AEBS', 'Ethanolyl', 'HMVK', 'Ethyl', 'CoenzymeA', 'Methyl+Deamidated', 'Delta:H(5)C(2)', 'Methyl:2H(2)', 'SulfanilicAcid', 'SulfanilicAcid:13C(6)', 'Biotin-PEO-Amine', 'Trp->Oxolactone', 'Biotin-HPDP', 'Delta:Hg(1)', 'IodoU-AMP', 'CAMthiopropanoyl', 'IED-Biotin', 'dHex', 'Methyl:2H(3)', 'Carboxy', 'Bromobimane', 'Menadione', 'DeStreak', 'dHex(1)Hex(3)HexNAc(4)', 'dHex(1)Hex(4)HexNAc(4)', 'dHex(1)Hex(5)HexNAc(4)', 'Hex(3)HexNAc(4)', 'Hex(4)HexNAc(4)', 'Hex(5)HexNAc(4)', 'Cysteinyl', 'Lys-loss', 'Nmethylmaleimide', 'CyDye-Cy3', 'DimethylpyrroleAdduct', 'Delta:H(2)C(5)', 'Delta:H(2)C(3)O(1)', 'Nethylmaleimide+water', 'Methyl+Acetyl:2H(3)', 'Xlink:B10621', 'DTBP', 'FP-Biotin', 'Thiophos-S-S-biotin', 'Can-FP-biotin', 'HNE+Delta:H(2)', 'Thrbiotinhydrazide', 'Methylamine', 'Diisopropylphosphate', 'Isopropylphospho', 'ICPL:13C(6)', 'CarbamidomethylDTT', 'ICPL', 'Deamidated:18O(1)', 'Arg->Orn', 'Cation:Cu[I]', 'Dehydro', 'Diphthamide', 'Hydroxyfarnesyl', 'Diacylglycerol', 'Carboxyethyl', 'Hypusine', 'Retinylidene', 'Lys->AminoadipicAcid', 'Cys->PyruvicAcid', 'Ammonia-loss', 'Phycocyanobilin', 'Phycoerythrobilin', 'Phytochromobilin', 'Heme', 'Molybdopterin', 'Quinone', 'Glucosylgalactosyl', 'GPIanchor', 'PhosphoribosyldephosphoCoA', 'GlycerylPE', 'Triiodothyronine', 'Thyroxine', 'Tyr->Dha', 'Didehydro', 'Cys->Oxoalanine', 'Ser->LacticAcid', 'GluGlu', 'Phosphoadenosine', 'Glu', 'Hydroxycinnamyl', 'Glycosyl', 'FMNH', 'Archaeol', 'Phenylisocyanate', 'Phenylisocyanate:2H(5)', 'Phosphoguanosine', 'Hydroxymethyl', 'MolybdopterinGD+Delta:S(-1)Se(1)', 'Dipyrrolylmethanemethyl', 'PhosphoUridine', 'Glycerophospho', 'Carboxy->Thiocarboxy', 'Sulfide', 'PyruvicAcidIminyl', 'Delta:Se(1)', 'MolybdopterinGD', 'Dioxidation', 'Octanoyl', 'PhosphoHexNAc', 'PhosphoHex', 'Palmitoleyl', 'Cholesterol', 'Didehydroretinylidene', 'CHDH', 'Methylpyrroline', 'Hydroxyheme', 'MicrocinC7', 'Cyano', 'Diironsubcluster', 'Amidino', 'FMN', 'FMNC', 'CuSMo', 'Hydroxytrimethyl', 'Deoxy', 'Microcin', 'Decanoyl', 'GluGluGlu', 'GluGluGluGlu', 'HexN', 'Xlink:DMP-s', 'Xlink:DMP', 'NDA', 'SPITC:13C(6)', 'TMAB:2H(9)', 'TMAB', 'FTC', 'AEC-MAEC', 'BADGE', 'Label:2H(4)', 'Hep', 'CyDye-Cy5', 'DHP', 'BHTOH', 'IGBP:13C(2)', 'Nmethylmaleimide+water', 'PyMIC', 'LG-lactam-K', 'BisANS', 'Piperidine', 'Diethyl', 'LG-Hlactam-K', 'Dimethyl:2H(4)13C(2)', 'C8-QAT', 'Hex(2)', 'LG-lactam-R', 'CLIP_TRAQ_1', 'CLIP_TRAQ_2', 'LG-Hlactam-R', 'Maleimide-PEO2-Biotin', 'Sulfo-NHS-LC-LC-Biotin', 'FNEM', 'PropylNAGthiazoline', 'Dethiomethyl', 'iTRAQ4plex114', 'iTRAQ4plex115', 'Dibromo', 'LeuArgGlyGly', 'CLIP_TRAQ_3', 'CLIP_TRAQ_4', '15dB-biotin', 'PGA1-biotin', 'Ala->Ser', 'Ala->Thr', 'Ala->Asp', 'Ala->Pro', 'Ala->Gly', 'Ala->Glu', 'Ala->Val', 'Cys->Phe', 'Cys->Ser', 'Cys->Trp', 'Cys->Tyr', 'Cys->Arg', 'Cys->Gly', 'Asp->Ala', 'Asp->His', 'Asp->Asn', 'Asp->Gly', 'Asp->Tyr', 'Asp->Glu', 'Asp->Val', 'Glu->Ala', 'Glu->Gln', 'Glu->Asp', 'Glu->Lys', 'Glu->Gly', 'Glu->Val', 'Phe->Ser', 'Phe->Cys', 'Phe->Ile', 'Phe->Tyr', 'Phe->Val', 'Gly->Ala', 'Gly->Ser', 'Gly->Trp', 'Gly->Glu', 'Gly->Val', 'Gly->Asp', 'Gly->Cys', 'Gly->Arg', 'dNIC', 'His->Pro', 'His->Tyr', 'His->Gln', 'NIC', 'His->Arg', 'His->Leu', 'Ile->Phe', 'Ile->Ser', 'Ile->Thr', 'Ile->Asn', 'Ile->Lys', 'Ile->Val', 'Ile->Met', 'Ile->Arg', 'Lys->Thr', 'Lys->Asn', 'Lys->Glu', 'Lys->Gln', 'Lys->Met', 'Lys->Arg', 'Lys->Ile', 'Leu->Ser', 'Leu->Phe', 'Leu->Trp', 'Leu->Pro', 'Leu->Val', 'Leu->His', 'Leu->Gln', 'Leu->Met', 'Leu->Arg', 'Met->Thr', 'Met->Arg', 'Met->Ile', 'Met->Lys', 'Met->Leu', 'Met->Val', 'Asn->Ser', 'Asn->Thr', 'Asn->Lys', 'Asn->Tyr', 'Asn->His', 'Asn->Asp', 'Asn->Ile', 'Pro->Ser', 'Pro->Ala', 'Pro->His', 'Pro->Gln', 'Pro->Thr', 'Pro->Arg', 'Pro->Leu', 'Gln->Pro', 'Gln->Lys', 'Gln->Glu', 'Gln->His', 'Gln->Arg', 'Gln->Leu', 'Arg->Ser', 'Arg->Trp', 'Arg->Thr', 'Arg->Pro', 'Arg->Lys', 'Arg->His', 'Arg->Gln', 'Arg->Met', 'Arg->Cys', 'Arg->Ile', 'Arg->Gly', 'Ser->Phe', 'Ser->Ala', 'Ser->Trp', 'Ser->Thr', 'Ser->Asn', 'Ser->Pro', 'Ser->Tyr', 'Ser->Cys', 'Ser->Arg', 'Ser->Ile', 'Ser->Gly', 'Thr->Ser', 'Thr->Ala', 'Thr->Asn', 'Thr->Lys', 'Thr->Pro', 'Thr->Met', 'Thr->Ile', 'Thr->Arg', 'Val->Phe', 'Val->Ala', 'Val->Glu', 'Val->Met', 'Val->Asp', 'Val->Ile', 'Val->Gly', 'Trp->Ser', 'Trp->Cys', 'Trp->Arg', 'Trp->Gly', 'Trp->Leu', 'Tyr->Phe', 'Tyr->Ser', 'Tyr->Asn', 'Tyr->His', 'Tyr->Asp', 'Tyr->Cys', 'BDMAPP', 'NA-LNO2', 'NA-OA-NO2', 'ICPL:2H(4)', 'CarboxymethylDTT', 'iTRAQ8plex', 'Label:13C(6)15N(1)', 'Label:2H(9)13C(6)15N(2)', 'HNE-Delta:H(2)O', '4-ONE', 'O-Dimethylphosphate', 'O-Methylphosphate', 'O-Diethylphosphate', 'O-Ethylphosphate', 'O-pinacolylmethylphosphonate', 'Methylphosphonate', 'O-Isopropylmethylphosphonate', 'iTRAQ8plex:13C(6)15N(2)', 'DTT_ST', 'Ethanolamine', 'TMT6plex', 'DTT_C', 'TMT2plex', 'TMT', 'ExacTagThiol', 'ExacTagAmine', 'NO_SMX_SEMD', '4-ONE+Delta:H(-2)O(-1)', 'NO_SMX_SMCT', 'NO_SMX_SIMD', 'Malonyl', '3sulfo', 'trifluoro', 'TNBS', 'Biotin-phenacyl', 'DTT_C:2H(6)', 'lapachenole', 'Label:13C(5)', 'maleimide', 'IDEnT', 'DTT_ST:2H(6)', 'Met-loss', 'Met-loss+Acetyl', 'Menadione-HQ', 'Carboxymethyl:13C(2)', 'NEM:2H(5)', 'Gly-loss+Amide', 'TMPP-Ac', 'Label:13C(6)+GlyGly', 'Arg->Npo', 'Label:2H(4)+Acetyl', 'Pentylamine', 'PentylamineBiotin', 'Dihydroxyimidazolidine', 'DFDNB', 'Cy3b-maleimide', 'Hex1HexNAc1', 'AEC-MAEC:2H(4)', 'BMOE', 'Biotin-PEO4-hydrazide', 'Label:13C(6)+Acetyl', 'Label:13C(6)15N(2)+Acetyl', 'EQIGG', 'cGMP', 'cGMP+RMP-loss', 'mTRAQ', 'Arg2PG', 'Label:2H(4)+GlyGly', 'Label:13C(8)15N(2)', 'Label:13C(1)2H(3)', 'ZGB', 'MG-H1', 'G-H1', 'Label:13C(6)15N(2)+GlyGly', 'ICPL:13C(6)2H(4)', 'DyLight-maleimide', 'mTRAQ:13C(3)15N(1)', 'Methyl-PEO12-Maleimide', 'MDCC', 'QQQTGG', 'QEQTGG', 'HydroxymethylOP', 'ChromoBiotin', 'Label:13C(1)2H(3)+Oxidation', 'Bodipy', 'Biotin-PEG-PRA', 'Met->Aha', 'Label:15N(4)', 'pyrophospho', 'Met->Hpg', '4AcAllylGal', 'DimethylArsino', 'Lys->CamCys', 'Phe->CamCys', 'Leu->MetOx', 'Lys->MetOx', 'Galactosyl', 'SMCC-maleimide', 'Bacillosamine', 'MTSL', 'HNE-BAHAH', 'Ethoxyformyl', 'Methylmalonylation', 'AROD', 'Cys->methylaminoAla', 'Cys->ethylaminoAla', 'Label:13C(4)15N(2)+GlyGly', 'ethylamino', 'MercaptoEthanol', 'Atto495Maleimide', 'GalNAzBiotin', 'EthylAmide', 'VFQQQTGG', 'VIEVYQEQTGG', 'Chlorination', 'dichlorination', 'DNPS', 'SulfoGMBS', 'DimethylamineGMBS', 'Label:15N(2)2H(9)', 'LG-anhydrolactam', 'LG-pyrrole', 'LG-anhyropyrrole', '3-deoxyglucosone', 'Cation:Li', 'Cation:Ca[II]', 'Cation:Fe[II]', 'Cation:Ni[II]', 'Cation:Zn[II]', 'Cation:Ag', 'Cation:Mg[II]', '2-succinyl', 'Propargylamine', 'Phosphopropargyl'] ;
delta = {'SPITC': 214.971084, 'Lysbiotinhydrazide': 241.088497, 'Dimethyl:2H(4)': 32.056407, 'Trp->Oxolactone': 13.979265, 'Cys->Gly': -45.987721, 'EQAT:2H(5)': 189.188947, 'Ser->Tyr': 76.0313, 'Label:13C(6)15N(2)': 8.014199, 'Diacylglycerol': 576.511761, 'Hex(3)': 486.158471, 'HexNAc(2)dHex(2)': 698.274563, 'Arg->Gln': -28.042534, 'Cysteinyl': 119.004099, 'TMT': 224.152478, 'Delta:H(6)C(6)O(1)': 94.041865, 'HexNAc(2)': 406.158745, '4AcAllylGal': 372.142033, 'Arg->Gly': -99.079647, 'Tyr->Cys': -60.054144, 'Hex(1)HexNAc(2)dHex(1)Pent(1)': 846.311736, 'FormylMet': 159.035399, 'Glutathione': 305.068156, 'DTBP': 87.01427, 'Met->Arg': 25.060626, 'Dioxidation': 31.989829, 'C8-QAT': 227.224915, 'ChromoBiotin': 695.310118, 'Trp->Gly': -129.057849, '3sulfo': 183.983029, 'NEIAA': 85.052764, 'dHex(1)Hex(5)HexNAc(4)': 1768.639517, 'Cation:Mg[II]': 21.969392, 'Propionyl': 56.026215, 'cGMP+RMP-loss': 150.041585, 'Dimethyl': 28.0313, 'Fluoro': 17.990578, 'Formyl': 27.994915, 'ICPL:13C(6)2H(4)': 115.0667, 'Carboxymethyl': 58.005479, 'Methyl:2H(3)13C(1)': 18.037835, 'NO_SMX_SEMD': 252.044287, 'Lys-loss': -128.094963, 'OxProBiotinRed': 371.199111, 'Cys->Arg': 53.091927, 'Leu->Met': 17.956421, 'ICAT-D:2H(8)': 450.275205, 'Delta:H(4)C(3)': 40.0313, 'Gly->Trp': 129.057849, 'Met->Val': -31.972071, 'Tyr->Phe': -15.994915, 'PEO-Iodoacetyl-LC-Biotin': 414.193691, 'iTRAQ4plex115': 144.099599, 'iTRAQ4plex114': 144.105918, 'Label:15N(4)': 3.98814, 'Archaeol': 634.662782, 'HexN': 161.068808, 'Palmitoyl': 238.229666, 'IMID:2H(4)': 72.062555, 'Ser->Arg': 69.069083, 'Dehydro': -1.007825, 'AROD': 820.336015, 'Benzoyl': 104.026215, 'IBTP': 316.138088, 'Carboxymethyl:13C(2)': 60.012189, 'Leu->Pro': -16.0313, 'Arg->Ile': -43.017047, 'Quinone': 29.974179, 'DTT_C:2H(6)': 126.062161, 'FTC': 421.073241, 'Asp->His': 22.031969, 'O-Isopropylmethylphosphonate': 120.034017, 'Ala->Glu': 58.005479, 'OxLysBiotinRed': 354.172562, 'Amidated': -0.984016, 'Ala->Gly': -14.01565, 'Met->Leu': -17.956421, 'Deoxy': -15.994915, 'Methyl:2H(3)': 17.03448, 'Deamidated:18O(1)': 2.988261, 'Trioxidation': 47.984744, 'Didehydroretinylidene': 264.187801, 'Thr->Met': 29.992806, 'Carbamidomethyl': 57.021464, 'Asp->Glu': 14.01565, 'mTRAQ': 140.094963, 'His->Tyr': 26.004417, 'Carboxy->Thiocarboxy': 15.977156, 'Cyano': 24.995249, 'SMA': 127.063329, 'Phe->CamCys': 12.962234, 'Cy3b-maleimide': 796.238984, 'NEM:2H(5)': 130.079062, 'Arg->Npo': 80.985078, 'Arg->Ser': -69.069083, 'Label:2H(4)': 4.025107, 'Galactosyl': 178.047738, 'Ala->Pro': 26.01565, 'EDT-maleimide-PEO-biotin': 601.206246, 'Gly->Arg': 99.079647, 'Label:13C(6)': 6.020129, 'Delta:H(4)C(2)O(-1)S(1)': 44.008456, 'NHS-LC-Biotin': 339.161662, 'Gln->Pro': -31.005814, 'Lys->Thr': -27.047285, 'Cation:Na': 21.981943, 'Hex(5)HexNAc(2)': 1216.422863, 'QQQTGG': 599.266339, 'Thiophospho': 95.943487, 'Asp->Val': -15.958529, 'Cation:K': 37.955882, 'Delta:H(2)C(3)': 38.01565, 'FMN': 438.094051, 'Lys->Allysine': -1.031634, 'Methylthio': 45.987721, 'Methyl+Deamidated': 14.999666, 'Lys->MetOx': 18.940436, 'HexNAc(2)dHex(1)': 552.216654, 'BisANS': 592.076278, 'Phosphoguanosine': 345.047435, 'Palmitoleyl': 236.214016, 'ZGB': 758.380841, 'Nethylmaleimide+water': 143.058243, 'His->Gln': -9.000334, 'EQAT': 184.157563, 'Ethanedithiol': 75.980527, 'Delta:H(8)C(6)O(2)': 112.05243, 'Phe->Val': -48.0, 'Hex(1)HexNAc(2)': 568.211569, 'NA-LNO2': 325.225309, 'Cys->Phe': 44.059229, 'Dipyrrolylmethanemethyl': 418.137616, 'CAF': 135.983029, 'DeStreak': 75.998285, 'MolybdopterinGD+Delta:S(-1)Se(1)': 1620.930224, 'ICAT-H:13C(6)': 351.118044, 'Label:13C(6)15N(2)+Acetyl': 50.024764, 'Leu->Ser': -26.052036, 'Heme': 616.177295, 'MDCC': 383.148121, 'Trp->Cys': -83.070128, 'O-pinacolylmethylphosphonate': 162.080967, 'FP-Biotin': 572.316129, '15dB-biotin': 626.386577, 'Label:13C(1)2H(3)': 4.022185, 'Gly->Ser': 30.010565, 'dichlorination': 69.937705, 'Hex(2)HexNAc(2)': 730.264392, 'His->Pro': -40.006148, 'Arg->Orn': -42.021798, 'HNE-Delta:H(2)O': 138.104465, 'Glu': 129.042593, 'Atto495Maleimide': 474.250515, 'Ammonia-loss': -17.026549, 'AEBS': 183.035399, 'LG-anhydrolactam': 314.188195, 'Met->Aha': -4.986324, 'Gly->Ala': 14.01565, 'Arg->His': -19.042199, 'Ile->Met': 17.956421, 'Deamidated': 0.984016, 'Hydroxyheme': 614.161645, 'BHT': 218.167065, 'AccQTag': 170.048013, 'IGBP': 296.016039, 'Menadione-HQ': 172.05243, 'Trp->Leu': -72.995249, 'Phosphopantetheine': 340.085794, 'Dehydrated': -18.010565, 'Leu->MetOx': 33.951335, 'Iminobiotin': 225.093583, 'HNE-BAHAH': 511.319226, 'MercaptoEthanol': 60.003371, 'PhosphoHex': 242.019154, 'DTT_C': 120.0245, 'Hex(3)HexNAc(2)P(1)': 923.290978, 'Crotonaldehyde': 70.041865, 'Phytochromobilin': 584.263485, 'Glycosyl': 148.037173, 'ICPL:2H(4)': 109.046571, 'Iodo': 125.896648, 'Myristoyl': 210.198366, 'Gln->Leu': -14.974514, 'Phosphopropargyl': 116.997965, 'Biotin-PEG-PRA': 578.317646, 'Pentylamine': 85.089149, 'AEC-MAEC': 59.019355, 'Cholesterol': 368.344302, 'Hex(2)': 324.105647, 'trifluoro': 53.971735, 'iTRAQ8plex:13C(6)15N(2)': 304.19904, 'Cys->Oxoalanine': -17.992806, 'Bromobimane': 190.074228, 'Label:13C(9)': 9.030193, 'Pro->Arg': 59.048347, 'Xlink:SSD': 253.095023, 'pyrophospho': 159.932662, 'LeuArgGlyGly': 383.228103, 'Label:2H(4)+Acetyl': 46.035672, 'Glu->Asp': -14.01565, 'ICAT-G:2H(8)': 494.30142, 'Met-loss+Acetyl': -89.02992, 'Gly->Val': 42.04695, 'MicrocinC7': 386.110369, 'LG-Hlactam-K': 348.193674, 'BHTOH': 234.16198, 'Hypusine': 87.068414, 'Label:18O(1)': 2.004246, 'LG-Hlactam-R': 306.171876, 'Biotin-phenacyl': 626.263502, 'Leu->Val': -14.01565, 'Propionamide': 71.037114, 'Tyr->Asn': -49.020401, 'PyMIC': 134.048013, 'Farnesyl': 204.187801, 'Trp->Arg': -29.978202, 'LG-pyrrole': 316.203845, 'Label:13C(8)15N(2)': 10.020909, 'Tyr->Asp': -48.036386, 'Thr->Arg': 55.053433, 'Hex(3)HexNAc(1)Pent(1)': 821.280102, 'Cys->Ser': -15.977156, 'Trp->Hydroxykynurenin': 19.989829, 'Dansyl': 233.051049, '3-deoxyglucosone': 144.042259, 'Tyr->Dha': -94.041865, 'Hex(1)HexNAc(2)dHex(1)': 714.269478, 'Methylmalonylation': 100.016044, 'IMID': 68.037448, 'Hex(4)HexNAc(4)': 1460.528784, 'DyLight-maleimide': 940.1999, 'Fluorescein': 388.082112, 'QEQTGG': 600.250354, 'Label:2H(9)13C(6)15N(2)': 17.07069, 'Asn->Thr': -12.995249, 'Can-FP-biotin': 447.195679, 'Label:13C(1)2H(3)+Oxidation': 20.0171, 'DTT_ST:2H(6)': 142.039317, 'Glu->Val': -29.974179, 'Propargylamine': 37.031634, 'Glu->Ala': -58.005479, 'Cytopiloyne': 362.136553, 'GlyGly': 114.042927, 'MolybdopterinGD': 1572.985775, 'Cys->PyruvicAcid': -33.003705, 'His->Leu': -23.974848, 'Hex(1)HexNAc(2)Pent(1)': 700.253828, 'Menadione': 170.036779, 'PyruvicAcidIminyl': 70.005479, 'Cation:Zn[II]': 61.913495, 'Cation:Cu[I]': 61.921774, 'Ile->Val': -14.01565, 'Thiophos-S-S-biotin': 525.142894, 'HPG': 132.021129, 'OxProBiotin': 369.183461, 'O-Diethylphosphate': 136.028931, 'Acetyl': 42.010565, 'Gln->pyro-Glu': -17.026549, 'Methyl:2H(2)': 16.028204, 'DAET': 87.050655, 'GPIanchor': 123.00853, 'TMT6plex': 229.162932, 'Ser->Asn': 27.010899, 'PropylNAGthiazoline': 232.064354, 'Hydroxycinnamyl': 146.036779, 'OxArgBiotin': 310.135113, 'EQIGG': 484.228162, 'Pyridylacetyl': 119.037114, 'a-type-ion': -29.00274, 'CLIP_TRAQ_3': 271.148736, 'CLIP_TRAQ_2': 141.098318, 'CLIP_TRAQ_1': 140.094963, 'Label:2H(4)+GlyGly': 118.068034, 'Biotin-PEO-Amine': 356.188212, 'Biotin-PEO4-hydrazide': 487.246455, 'Amidino': 42.021798, 'Asn->Asp': 0.984016, 'Ala->Ser': 15.994915, 'Met-loss': -131.040485, 'Gly->Glu': 72.021129, 'Glu->Gln': -0.984016, 'Methyl-PEO12-Maleimide': 710.383719, 'Amidine': 41.026549, 'PGA1-biotin': 660.428442, 'Glu->Gly': -72.021129, 'Thioacyl': 87.998285, 'dHex(1)Hex(3)HexNAc(4)': 1444.53387, 'Dihydroxyimidazolidine': 72.021129, 'SulfanilicAcid:13C(6)': 161.024228, 'Succinyl': 100.016044, 'Ethanolyl': 44.026215, 'Label:13C(6)15N(4)': 10.008269, 'Asp->Asn': -0.984016, 'Leu->Trp': 72.995249, 'mTRAQ:13C(3)15N(1)': 144.102063, 'Hex(5)HexNAc(4)': 1622.581608, 'Cation:Ni[II]': 55.919696, 'Glu->Lys': -0.94763, 'Hydroxytrimethyl': 59.04969, 'GIST-Quat:2H(9)': 136.156205, 'O-Dimethylphosphate': 107.997631, 'Sulfo-NHS-LC-LC-Biotin': 452.245726, 'Microcin': 831.197041, 'Ile->Lys': 15.010899, 'ADP-Ribosyl': 541.06111, 'EDT-iodoacetyl-PEO-biotin': 490.174218, 'Asn->Ile': -0.958863, 'Arg->GluSA': -43.053433, 'Label:18O(2)': 4.008491, 'Asn->Lys': 14.052036, 'Methyl': 14.01565, 'Biotin-HPDP': 428.191582, 'DHP': 118.065674, 'NO_SMX_SMCT': 268.039202, 'NEIAA:2H(5)': 90.084148, 'Cys->Trp': 83.070128, 'Glu->pyro-Glu': -18.010565, 'Hex(2)HexNAc(2)dHex(1)': 876.322301, 'DimethylpyrroleAdduct': 78.04695, 'Pro->His': 40.006148, 'Propionyl:13C(3)': 59.036279, 'Pro->pyro-Glu': 13.979265, 'CyDye-Cy3': 672.298156, 'Gly->Asp': 58.005479, 'Gln->Glu': 0.984016, 'Ser->LacticAcid': -15.010899, 'Isopropylphospho': 122.013281, 'QAT': 171.149738, 'GluGlu': 258.085186, 'Cys->Tyr': 60.054144, 'Carbamyl': 43.005814, 'DimethylamineGMBS': 267.158292, 'Thrbiotinhydrazide': 240.104482, 'EthylAmide': 29.039125, 'Methylphosphonate': 77.987066, 'Label:13C(4)15N(2)+GlyGly': 120.050417, 'Arg->Trp': 29.978202, 'Pro->Leu': 16.0313, 'Hex(1)HexNAc(1)NeuAc(1)': 656.227613, 'Retinylidene': 266.203451, 'Phenylisocyanate:2H(5)': 124.068498, 'TNBS': 210.986535, 'NBS:13C(6)': 159.008578, 'GIST-Quat:2H(3)': 130.118544, 'Val->Gly': -42.04695, 'FNEM': 427.069202, 'CLIP_TRAQ_4': 244.101452, 'Val->Glu': 29.974179, 'ICPL:13C(6)': 111.041593, 'Diisopropylphosphate': 164.060231, 'Hydroxyfarnesyl': 220.182715, 'IED-Biotin': 326.141261, 'Lys->Arg': 28.006148, 'NIPCAM': 99.068414, 'Myristoleyl': 208.182715, 'NIC': 105.021464, 'Delta:S(-1)Se(1)': 47.944449, 'Triiodothyronine': 469.716159, 'Label:13C(6)+Acetyl': 48.030694, 'Met->Hpg': -21.987721, 'Ala->Asp': 43.989829, 'HMVK': 86.036779, 'Ser->Trp': 99.047285, 'DFDNB': 203.998263, 'probiotinhydrazide': 258.115047, 'Label:13C(5)': 5.016774, 'Tripalmitate': 788.725777, '4-ONE': 154.09938, 'Didehydro': -2.01565, 'Ala->Thr': 30.010565, 'G-H1': 39.994915, 'Propionamide:2H(3)': 74.055944, 'Thyroxine': 595.612807, 'Leu->Gln': 14.974514, 'Arg2PG': 266.057909, 'Cation:Li': 6.008178, 'SulfoGMBS': 458.162391, 'Biotin': 226.077598, 'TMPP-Ac': 572.181134, 'Delta:H(4)C(3)O(1)': 56.026215, 'Diphthamide': 143.118438, 'Dimethyl:2H(4)13C(2)': 34.063117, 'Thr->Pro': -3.994915, 'Xlink:B10621': 713.093079, 'PhosphoribosyldephosphoCoA': 881.146904, 'Hex(1)HexNAc(1)dHex(1)': 511.190105, 'Delta:Hg(1)': 201.970617, 'CAMthiopropanoyl': 145.019749, 'HexNAc': 203.079373, 'Nitrosyl': 28.990164, 'Ile->Phe': 33.98435, 'NO_SMX_SIMD': 267.031377, 'Label:13C(6)15N(2)+GlyGly': 122.057126, 'Asn->Tyr': 49.020401, 'Dimethyl:2H(6)13C(2)': 36.07567, 'Decanoyl': 154.135765, 'Amino': 15.010899, 'Val->Asp': 15.958529, 'Val->Met': 31.972071, 'Phe->Cys': -44.059229, 'HNE': 156.11503, 'BDMAPP': 253.010225, 'PET': 121.035005, 'Acetyl:2H(3)': 45.029395, 'Gly->Cys': 45.987721, 'Sulfo': 79.956815, 'Ser->Gly': -30.010565, 'Gln->Arg': 28.042534, 'Hex(1)HexNAc(2)dHex(2)': 860.327386, 'Tyr->His': -26.004417, 'Ala->Val': 28.0313, 'Leu->Arg': 43.017047, 'Lys->CamCys': 31.935685, 'Gln->Lys': 0.036386, 'NA-OA-NO2': 327.240959, 'Octanoyl': 126.104465, 'Thr->Ala': -30.010565, 'Met->Hsl': -48.003371, 'Thr->Ile': 12.036386, 'Met->Hse': -29.992806, 'GeranylGeranyl': 272.250401, 'VFQQQTGG': 845.403166, 'Cys->ethylaminoAla': 11.070128, 'Arg->Pro': -59.048347, 'NDA': 175.042199, 'Glucuronyl': 176.032088, 'PentylamineBiotin': 311.166748, 'Nethylmaleimide': 125.047679, 'Label:13C(5)15N(1)': 6.013809, 'Ser->Phe': 60.036386, 'GIST-Quat:2H(6)': 133.137375, 'BADGE': 340.167459, 'Hex(1)HexNAc(1)NeuAc(2)': 947.323029, 'His->Arg': 19.042199, 'Hex(2)HexNAc(2)Pent(1)': 862.306651, 'Phe->Ser': -60.036386, 'Pyro-carbamidomethyl': 39.994915, 'ExacTagThiol': 972.365219, 'Thr->Asn': 12.995249, 'Ile->Asn': 0.958863, 'Dethiomethyl': -48.003371, 'PhosphoHexNAc': 283.045704, 'Val->Ala': -28.0313, 'Hex1HexNAc1': 365.132196, 'Delta:H(2)C(3)O(1)': 54.010565, 'Asp->Tyr': 48.036386, 'Label:2H(3)': 3.01883, 'OxLysBiotin': 352.156911, 'Val->Ile': 14.01565, 'O-Ethylphosphate': 107.997631, 'Phosphoadenosine': 329.05252, 'dHex(1)Hex(4)HexNAc(4)': 1606.586693, 'Glycerophospho': 154.00311, 'Hex(3)HexNAc(4)': 1298.475961, 'HexNAc(1)dHex(1)': 349.137281, 'Lys->Met': 2.945522, 'Cys->Dha': -33.987721, 'Met->Lys': -2.945522, 'Bromo': 77.910511, 'FAD': 783.141486, 'Cation:Ag': 105.897267, 'ICPL': 105.021464, 'cGMP': 344.03961, 'Thr->Lys': 27.047285, 'LG-lactam-K': 332.19876, 'Arg->Met': -25.060626, 'LG-lactam-R': 290.176961, 'PhosphoUridine': 306.025302, 'Bacillosamine': 228.111007, 'SMCC-maleimide': 321.205242, 'GlycerylPE': 197.04531, 'Xlink:DMP-s': 154.110613, 'QAT:2H(3)': 174.168569, 'Cytopiloyne+water': 380.147118, 'Asp->Gly': -58.005479, 'Carboxyethyl': 72.021129, 'Pro->Pyrrolidone': -27.994915, 'CyDye-Cy5': 684.298156, '4-ONE+Delta:H(-2)O(-1)': 136.088815, 'Asn->His': 23.015984, 'Nmethylmaleimide': 111.032028, 'Ethyl': 28.0313, 'CuSMo': 922.834855, 'Ile->Thr': -12.036386, 'Cation:Fe[II]': 53.919289, 'Lys->Asn': -14.052036, 'VIEVYQEQTGG': 1203.577168, 'Hep': 192.063388, 'GIST-Quat': 127.099714, 'ICAT-C:13C(9)': 236.157185, 'Arg->Thr': -55.053433, 'Pyridylethyl': 105.057849, 'CoenzymeA': 765.09956, 'Trimethyl': 42.04695, 'Phycoerythrobilin': 588.294785, 'Ser->Pro': 10.020735, 'HydroxymethylOP': 108.021129, 'Asn->Ser': -27.010899, 'Phe->Tyr': 15.994915, 'Phycocyanobilin': 586.279135, 'ethylamino': 27.047285, 'Delta:H(4)C(2)': 28.0313, 'Thr->Ser': -14.01565, 'Hex': 162.052824, 'Succinyl:13C(4)': 104.029463, 'Cys->methylaminoAla': -2.945522, 'CarbamidomethylDTT': 209.018035, 'Label:13C(9)+Phospho': 88.996524, 'Triiodo': 377.689944, 'Trp->Kynurenin': 3.994915, 'Sulfide': 31.972071, 'iTRAQ4plex': 144.102063, 'Label:13C(9)15N(1)': 10.027228, 'Trp->Ser': -99.047285, 'CarboxymethylDTT': 210.00205, '2HPG': 282.052824, 'IDEnT': 214.990469, 'Ser->Thr': 14.01565, 'Label:15N(2)2H(9)': 11.050561, 'O-Methylphosphate': 93.981981, 'Met->Thr': -29.992806, 'Glucosylgalactosyl': 340.100562, 'Pro->Ser': -10.020735, 'Phospho': 79.966331, 'Ile->Arg': 43.017047, 'IodoU-AMP': 322.020217, 'Delta:H(1)O(-1)18O(1)': 2.988261, 'Phe->Ile': -33.98435, 'ESP:2H(10)': 348.240414, 'Label:13C(6)15N(1)': 7.017164, 'Diironsubcluster': 342.786916, 'TMAB:2H(9)': 137.16403, 'CHDH': 294.183109, 'Delta:H(2)C(5)': 62.01565, 'Ile->Ser': -26.052036, 'Methylamine': 13.031634, 'FMNH': 454.088965, 'Pro->Gln': 31.005814, 'FMNC': 456.104615, 'Guanidinyl': 42.021798, 'Ser->Ile': 26.052036, 'PyridoxalPhosphate': 229.014009, 'Delta:H(2)C(2)': 26.01565, 'Diiodo': 251.793296, 'Leu->Phe': 33.98435, 'Ser->Ala': -15.994915, 'OxArgBiotinRed': 312.150763, 'Xlink:DMP': 122.084398, 'Maleimide-PEO2-Biotin': 525.225719, 'Diethyl': 56.0626, 'DimethylArsino': 103.960719, 'His->Asn': -23.015984, 'Ethanolamine': 43.042199, 'Nitro': 44.985078, 'iTRAQ8plex': 304.20536, 'NBS': 152.988449, 'Label:13C(6)+GlyGly': 120.063056, 'His->Asp': -22.031969, 'Gln->His': 9.000334, 'ICAT-G': 486.251206, 'ICAT-D': 442.224991, 'Hydroxymethyl': 30.010565, 'DTT_ST': 136.001656, 'ICAT-C': 227.126991, 'Lys->Glu': 0.94763, 'IGBP:13C(2)': 298.022748, 'ICAT-H': 345.097915, 'AEC-MAEC:2H(4)': 63.044462, 'Argbiotinhydrazide': 199.066699, 'Lys->Gln': -0.036386, 'Cation:Ca[II]': 37.946941, 'Delta:H(4)C(6)': 76.0313, 'Succinyl:2H(4)': 104.041151, 'Ethoxyformyl': 73.028954, 'Pro->Pyrrolidinone': -30.010565, 'dHex': 146.057909, 'maleimide': 97.016378, 'lapachenole': 240.11503, 'Phenylisocyanate': 119.037114, 'Dibromo': 155.821022, 'Nmethylmaleimide+water': 129.042593, 'Lys->AminoadipicAcid': 14.96328, 'Piperidine': 68.0626, 'Val->Phe': 48.0, 'Chlorination': 34.968853, 'Met->Ile': -17.956421, 'TMT2plex': 225.155833, 'Leu->His': 23.974848, 'MTSL': 184.07961, 'Molybdopterin': 521.884073, 'Pro->Ala': -26.01565, 'Pro->Thr': 3.994915, 'Gly-loss+Amide': -58.005479, 'HNE+Delta:H(2)': 158.13068, 'Oxidation': 15.994915, 'Lys->Ile': -15.010899, 'Malonyl': 86.000394, '2-succinyl': 116.010959, 'Delta:H(5)C(2)': 29.039125, 'Asp->Ala': -43.989829, 'Tyr->Ser': -76.0313, 'GalNAzBiotin': 502.202341, 'Carboxy': 43.989829, 'ESP': 338.177647, 'dNIC': 109.048119, 'BMOE': 220.048407, 'ExacTagAmine': 1046.347854, 'DNPS': 198.981352, 'MG-H1': 54.010565, 'Delta:Se(1)': 79.91652, 'GluGluGlu': 387.127779, 'Myristoyl+Delta:H(-4)': 206.167065, 'Arg->Lys': -28.006148, 'Hex(3)HexNAc(2)': 892.317216, 'Methylpyrroline': 109.052764, 'HexNAc(1)dHex(2)': 495.19519, 'Arg->Cys': -53.091927, 'Bodipy': 414.167478, 'GluGluGluGlu': 516.170373, 'Ser->Cys': 15.977156, 'TMAB': 128.107539, 'LG-anhyropyrrole': 298.19328, 'SPITC:13C(6)': 220.991213, 'SulfanilicAcid': 155.004099, 'Lipoyl': 188.032956, 'Methyl+Acetyl:2H(3)': 59.045045} ;
sites = {'SPITC': ['K', 'N-term'], 'Lysbiotinhydrazide': ['K'], 'Dimethyl:2H(4)': ['K', 'N-term'], 'Trp->Oxolactone': ['W'], 'Cys->Gly': ['C'], 'EQAT:2H(5)': ['C'], 'Ser->Tyr': ['S'], 'Label:13C(6)15N(2)': ['K'], 'Diacylglycerol': ['C'], 'Hex(3)': ['N'], 'HexNAc(2)dHex(2)': ['N'], 'Arg->Gln': ['R'], 'Cysteinyl': ['C'], 'TMT': ['K', 'N-term'], 'Delta:H(6)C(6)O(1)': ['K'], 'HexNAc(2)': ['N'], '4AcAllylGal': ['C'], 'Arg->Gly': ['R'], 'Tyr->Cys': ['Y'], 'Hex(1)HexNAc(2)dHex(1)Pent(1)': ['N'], 'FormylMet': ['N-term'], 'Glutathione': ['C'], 'DTBP': ['Q', 'N-term', 'K', 'R', 'N'], 'Met->Arg': ['M'], 'Dioxidation': ['C', 'F', 'K', 'M', 'P', 'R', 'W', 'Y'], 'C8-QAT': ['K', 'N-term'], 'ChromoBiotin': ['K'], 'Trp->Gly': ['W'], '3sulfo': ['N-term'], 'NEIAA': ['Y', 'C'], 'dHex(1)Hex(5)HexNAc(4)': ['N'], 'Cation:Mg[II]': ['C-term', 'E', 'D'], 'Propionyl': ['K', 'N-term', 'S'], 'cGMP+RMP-loss': ['C', 'S'], 'Dimethyl': ['N-term', 'K', 'R', 'P', 'N'], 'Fluoro': ['Y', 'W', 'F'], 'Formyl': ['K', 'N-term', 'S', 'T'], 'ICPL:13C(6)2H(4)': ['K', 'N-term'], 'Carboxymethyl': ['C', 'N-term', 'K', 'W'], 'Methyl:2H(3)13C(1)': ['R'], 'NO_SMX_SEMD': ['C'], 'Lys-loss': ['K'], 'OxProBiotinRed': ['P'], 'Cys->Arg': ['C'], 'Leu->Met': ['L'], 'ICAT-D:2H(8)': ['C'], 'Delta:H(4)C(3)': ['H', 'K'], 'Gly->Trp': ['G'], 'Met->Val': ['M'], 'Tyr->Phe': ['Y'], 'PEO-Iodoacetyl-LC-Biotin': ['C'], 'iTRAQ4plex115': ['Y', 'K', 'N-term'], 'iTRAQ4plex114': ['Y', 'K', 'N-term'], 'Label:15N(4)': ['R'], 'Archaeol': ['C'], 'HexN': ['K', 'T', 'W', 'N'], 'Palmitoyl': ['S', 'C', 'N-term', 'K', 'T'], 'IMID:2H(4)': ['K'], 'Ser->Arg': ['S'], 'Dehydro': ['C'], 'AROD': ['C'], 'Benzoyl': ['K', 'N-term'], 'IBTP': ['C'], 'Carboxymethyl:13C(2)': ['C'], 'Leu->Pro': ['L'], 'Arg->Ile': ['R'], 'Quinone': ['Y', 'W'], 'DTT_C:2H(6)': ['C'], 'FTC': ['S', 'P', 'C', 'R', 'K'], 'Asp->His': ['D'], 'O-Isopropylmethylphosphonate': ['Y', 'S', 'T'], 'Ala->Glu': ['A'], 'OxLysBiotinRed': ['K'], 'Amidated': ['C-term'], 'Ala->Gly': ['A'], 'Met->Leu': ['M'], 'Deoxy': ['S', 'D', 'T'], 'Methyl:2H(3)': ['E', 'C-term', 'D'], 'Deamidated:18O(1)': ['Q', 'N'], 'Trioxidation': ['C'], 'Didehydroretinylidene': ['K'], 'Thr->Met': ['T'], 'Carbamidomethyl': ['C', 'E', 'D', 'H', 'K', 'N-term'], 'Asp->Glu': ['D'], 'mTRAQ': ['Y', 'K', 'N-term'], 'His->Tyr': ['H'], 'Carboxy->Thiocarboxy': ['G'], 'Cyano': ['C'], 'SMA': ['K', 'N-term'], 'Phe->CamCys': ['F'], 'Cy3b-maleimide': ['C'], 'NEM:2H(5)': ['C'], 'Arg->Npo': ['R'], 'Arg->Ser': ['R'], 'Label:2H(4)': ['K'], 'Galactosyl': ['K'], 'Ala->Pro': ['A'], 'EDT-maleimide-PEO-biotin': ['S', 'T'], 'Gly->Arg': ['G'], 'Label:13C(6)': ['I', 'K', 'R', 'L'], 'Delta:H(4)C(2)O(-1)S(1)': ['S'], 'NHS-LC-Biotin': ['K', 'N-term'], 'Gln->Pro': ['Q'], 'Lys->Thr': ['K'], 'Cation:Na': ['E', 'C-term', 'D'], 'Hex(5)HexNAc(2)': ['N'], 'QQQTGG': ['K'], 'Thiophospho': ['Y', 'S', 'T'], 'Asp->Val': ['D'], 'Cation:K': ['C-term', 'E', 'D'], 'Delta:H(2)C(3)': ['K'], 'FMN': ['S', 'T'], 'Lys->Allysine': ['K'], 'Methylthio': ['C', 'D', 'N'], 'Methyl+Deamidated': ['Q', 'N'], 'Lys->MetOx': ['K'], 'HexNAc(2)dHex(1)': ['N'], 'BisANS': ['K'], 'Phosphoguanosine': ['H', 'K'], 'Palmitoleyl': ['C', 'S', 'T'], 'ZGB': ['K', 'N-term'], 'Nethylmaleimide+water': ['C', 'K'], 'His->Gln': ['H'], 'EQAT': ['C'], 'Ethanedithiol': ['S', 'T'], 'Delta:H(8)C(6)O(2)': ['K'], 'Phe->Val': ['F'], 'Hex(1)HexNAc(2)': ['N'], 'NA-LNO2': ['H', 'C'], 'Cys->Phe': ['C'], 'Dipyrrolylmethanemethyl': ['C'], 'CAF': ['N-term'], 'DeStreak': ['C'], 'MolybdopterinGD+Delta:S(-1)Se(1)': ['C'], 'ICAT-H:13C(6)': ['C'], 'Label:13C(6)15N(2)+Acetyl': ['K'], 'Leu->Ser': ['L'], 'Heme': ['H', 'C'], 'MDCC': ['C'], 'Trp->Cys': ['W'], 'O-pinacolylmethylphosphonate': ['Y', 'S', 'T'], 'FP-Biotin': ['Y', 'S', 'K', 'T'], '15dB-biotin': ['C'], 'Label:13C(1)2H(3)': ['M'], 'Gly->Ser': ['G'], 'dichlorination': ['Y'], 'Hex(2)HexNAc(2)': ['N'], 'His->Pro': ['H'], 'Arg->Orn': ['R'], 'HNE-Delta:H(2)O': ['H', 'C', 'K'], 'Glu': ['E', 'C-term'], 'Atto495Maleimide': ['C'], 'Ammonia-loss': ['C', 'S', 'T', 'N'], 'AEBS': ['Y', 'H', 'K', 'N-term', 'S'], 'LG-anhydrolactam': ['K', 'N-term'], 'Met->Aha': ['M'], 'Gly->Ala': ['G'], 'Arg->His': ['R'], 'Ile->Met': ['I'], 'Deamidated': ['Q', 'F', 'R', 'N'], 'Hydroxyheme': ['E'], 'BHT': ['H', 'K', 'C'], 'AccQTag': ['K', 'N-term'], 'IGBP': ['C'], 'Menadione-HQ': ['C', 'K'], 'Trp->Leu': ['W'], 'Phosphopantetheine': ['S'], 'Dehydrated': ['C', 'D', 'N', 'Q', 'S', 'T', 'Y'], 'Leu->MetOx': ['L'], 'Iminobiotin': ['K', 'N-term'], 'HNE-BAHAH': ['H', 'C', 'K'], 'MercaptoEthanol': ['S', 'T'], 'PhosphoHex': ['S'], 'DTT_C': ['C'], 'Hex(3)HexNAc(2)P(1)': ['N'], 'Crotonaldehyde': ['H', 'C', 'K'], 'Phytochromobilin': ['C'], 'Glycosyl': ['P'], 'ICPL:2H(4)': ['K', 'N-term'], 'Iodo': ['Y', 'H'], 'Myristoyl': ['K', 'C', 'G'], 'Gln->Leu': ['Q'], 'Phosphopropargyl': ['Y', 'S', 'T'], 'Biotin-PEG-PRA': ['M'], 'Pentylamine': ['Q'], 'AEC-MAEC': ['S', 'T'], 'Cholesterol': ['C-term'], 'Hex(2)': ['K', 'R'], 'trifluoro': ['L'], 'iTRAQ8plex:13C(6)15N(2)': ['Y', 'K', 'N-term'], 'Cys->Oxoalanine': ['C'], 'Bromobimane': ['C'], 'Label:13C(9)': ['Y', 'F'], 'Pro->Arg': ['P'], 'Xlink:SSD': ['K'], 'pyrophospho': ['S', 'T'], 'LeuArgGlyGly': ['K'], 'Label:2H(4)+Acetyl': ['K'], 'Glu->Asp': ['E'], 'ICAT-G:2H(8)': ['C'], 'Met-loss+Acetyl': ['M'], 'Gly->Val': ['G'], 'MicrocinC7': ['C-term'], 'LG-Hlactam-K': ['K', 'N-term'], 'BHTOH': ['H', 'C', 'K'], 'Hypusine': ['K'], 'Label:18O(1)': ['Y', 'S', 'C-term', 'T'], 'LG-Hlactam-R': ['R'], 'Biotin-phenacyl': ['H', 'C', 'S'], 'Leu->Val': ['L'], 'Propionamide': ['C'], 'Tyr->Asn': ['Y'], 'PyMIC': ['N-term'], 'Farnesyl': ['C'], 'Trp->Arg': ['W'], 'LG-pyrrole': ['K', 'N-term'], 'Label:13C(8)15N(2)': ['R'], 'Tyr->Asp': ['Y'], 'Thr->Arg': ['T'], 'Hex(3)HexNAc(1)Pent(1)': ['N'], 'Cys->Ser': ['C'], 'Trp->Hydroxykynurenin': ['W'], 'Dansyl': ['K', 'N-term'], '3-deoxyglucosone': ['R'], 'Tyr->Dha': ['Y'], 'Hex(1)HexNAc(2)dHex(1)': ['N'], 'Methylmalonylation': ['S'], 'IMID': ['K'], 'Hex(4)HexNAc(4)': ['N'], 'DyLight-maleimide': ['C'], 'Fluorescein': ['C'], 'QEQTGG': ['K'], 'Label:2H(9)13C(6)15N(2)': ['K'], 'Asn->Thr': ['N'], 'Can-FP-biotin': ['Y', 'S', 'T'], 'Label:13C(1)2H(3)+Oxidation': ['M'], 'DTT_ST:2H(6)': ['S', 'T'], 'Glu->Val': ['E'], 'Propargylamine': ['E', 'C-term', 'D'], 'Glu->Ala': ['E'], 'Cytopiloyne': ['C', 'K', 'N-term', 'P', 'S', 'R', 'Y'], 'GlyGly': ['C', 'K', 'S', 'T'], 'MolybdopterinGD': ['C', 'D'], 'Cys->PyruvicAcid': ['C'], 'His->Leu': ['H'], 'Hex(1)HexNAc(2)Pent(1)': ['N'], 'Menadione': ['C', 'K'], 'PyruvicAcidIminyl': ['C', 'K', 'V'], 'Cation:Zn[II]': ['C-term', 'E', 'D'], 'Cation:Cu[I]': ['C-term', 'E', 'D'], 'Ile->Val': ['I'], 'Thiophos-S-S-biotin': ['Y', 'S', 'T'], 'HPG': ['R'], 'OxProBiotin': ['P'], 'O-Diethylphosphate': ['Y', 'S', 'K', 'T'], 'Acetyl': ['C', 'H', 'K', 'N-term', 'S', 'T', 'Y'], 'Gln->pyro-Glu': ['Q'], 'Methyl:2H(2)': ['K'], 'DAET': ['S', 'T'], 'GPIanchor': ['C-term'], 'TMT6plex': ['K', 'N-term'], 'Ser->Asn': ['S'], 'PropylNAGthiazoline': ['C'], 'Hydroxycinnamyl': ['C'], 'OxArgBiotin': ['R'], 'EQIGG': ['K'], 'Pyridylacetyl': ['K', 'N-term'], 'a-type-ion': ['C-term'], 'CLIP_TRAQ_3': ['Y', 'K', 'N-term'], 'CLIP_TRAQ_2': ['Y', 'K', 'N-term'], 'CLIP_TRAQ_1': ['Y', 'K', 'N-term'], 'Label:2H(4)+GlyGly': ['K'], 'Biotin-PEO-Amine': ['E', 'C-term', 'D'], 'Biotin-PEO4-hydrazide': ['C-term'], 'Amidino': ['C'], 'Asn->Asp': ['N'], 'Ala->Ser': ['A'], 'Met-loss': ['M'], 'Gly->Glu': ['G'], 'Glu->Gln': ['E'], 'Methyl-PEO12-Maleimide': ['C'], 'Amidine': ['K', 'N-term'], 'PGA1-biotin': ['C'], 'Glu->Gly': ['E'], 'Thioacyl': ['K', 'N-term'], 'dHex(1)Hex(3)HexNAc(4)': ['N'], 'Dihydroxyimidazolidine': ['R'], 'SulfanilicAcid:13C(6)': ['E', 'C-term', 'D'], 'Succinyl': ['K', 'N-term'], 'Ethanolyl': ['C'], 'Label:13C(6)15N(4)': ['R'], 'Asp->Asn': ['D'], 'Leu->Trp': ['L'], 'mTRAQ:13C(3)15N(1)': ['Y', 'K', 'N-term'], 'Hex(5)HexNAc(4)': ['N'], 'Cation:Ni[II]': ['C-term', 'E', 'D'], 'Glu->Lys': ['E'], 'Hydroxytrimethyl': ['K'], 'GIST-Quat:2H(9)': ['K', 'N-term'], 'O-Dimethylphosphate': ['Y', 'S', 'T'], 'Sulfo-NHS-LC-LC-Biotin': ['K', 'N-term'], 'Microcin': ['C-term'], 'Ile->Lys': ['I'], 'ADP-Ribosyl': ['C', 'R', 'E', 'S', 'N'], 'EDT-iodoacetyl-PEO-biotin': ['S', 'T'], 'Asn->Ile': ['N'], 'Arg->GluSA': ['R'], 'Label:18O(2)': ['C-term'], 'Asn->Lys': ['N'], 'Methyl': ['C', 'E', 'D', 'I', 'H', 'K', 'N-term', 'L', 'N', 'Q', 'S', 'R', 'C-term', 'T'], 'Biotin-HPDP': ['C'], 'DHP': ['C'], 'NO_SMX_SMCT': ['C'], 'NEIAA:2H(5)': ['Y', 'C'], 'Cys->Trp': ['C'], 'Glu->pyro-Glu': ['E'], 'Hex(2)HexNAc(2)dHex(1)': ['N'], 'DimethylpyrroleAdduct': ['K'], 'Pro->His': ['P'], 'Propionyl:13C(3)': ['K', 'N-term'], 'Pro->pyro-Glu': ['P'], 'CyDye-Cy3': ['C'], 'Gly->Asp': ['G'], 'Gln->Glu': ['Q'], 'Ser->LacticAcid': ['S'], 'Isopropylphospho': ['Y', 'S', 'T'], 'QAT': ['C'], 'GluGlu': ['E', 'C-term'], 'Cys->Tyr': ['C'], 'Carbamyl': ['R', 'K', 'N-term', 'M', 'C'], 'DimethylamineGMBS': ['C'], 'Thrbiotinhydrazide': ['T'], 'EthylAmide': ['Q', 'N'], 'Methylphosphonate': ['Y', 'S', 'T'], 'Label:13C(4)15N(2)+GlyGly': ['K'], 'Arg->Trp': ['R'], 'Pro->Leu': ['P'], 'Hex(1)HexNAc(1)NeuAc(1)': ['S', 'T', 'N'], 'Retinylidene': ['K'], 'Phenylisocyanate:2H(5)': ['N-term'], 'TNBS': ['K', 'N-term'], 'NBS:13C(6)': ['W'], 'GIST-Quat:2H(3)': ['K', 'N-term'], 'Val->Gly': ['V'], 'FNEM': ['C'], 'CLIP_TRAQ_4': ['Y', 'K', 'N-term'], 'Val->Glu': ['V'], 'ICPL:13C(6)': ['K', 'N-term'], 'Diisopropylphosphate': ['Y', 'S', 'K', 'T'], 'Hydroxyfarnesyl': ['C'], 'IED-Biotin': ['C'], 'Lys->Arg': ['K'], 'NIPCAM': ['C'], 'Myristoleyl': ['G'], 'NIC': ['N-term'], 'Delta:S(-1)Se(1)': ['C', 'M'], 'Triiodothyronine': ['Y'], 'Label:13C(6)+Acetyl': ['K'], 'Met->Hpg': ['M'], 'Ala->Asp': ['A'], 'HMVK': ['C'], 'Ser->Trp': ['S'], 'DFDNB': ['Q', 'K', 'R', 'N'], 'probiotinhydrazide': ['P'], 'Label:13C(5)': ['P'], 'Tripalmitate': ['C'], '4-ONE': ['H', 'C', 'K'], 'Didehydro': ['Y', 'S', 'K', 'T'], 'Ala->Thr': ['A'], 'G-H1': ['R'], 'Propionamide:2H(3)': ['C'], 'Thyroxine': ['Y'], 'Leu->Gln': ['L'], 'Arg2PG': ['R'], 'Cation:Li': ['C-term', 'E', 'D'], 'SulfoGMBS': ['C'], 'Biotin': ['K', 'N-term'], 'TMPP-Ac': ['N-term'], 'Delta:H(4)C(3)O(1)': ['H', 'C', 'K'], 'Diphthamide': ['H'], 'Dimethyl:2H(4)13C(2)': ['K', 'N-term'], 'Thr->Pro': ['T'], 'Xlink:B10621': ['C'], 'PhosphoribosyldephosphoCoA': ['S'], 'Hex(1)HexNAc(1)dHex(1)': ['N'], 'Delta:Hg(1)': ['C'], 'CAMthiopropanoyl': ['K', 'N-term'], 'HexNAc': ['S', 'T', 'N'], 'Nitrosyl': ['C'], 'Ile->Phe': ['I'], 'NO_SMX_SIMD': ['C'], 'Label:13C(6)15N(2)+GlyGly': ['K'], 'Asn->Tyr': ['N'], 'Dimethyl:2H(6)13C(2)': ['N-term', 'K', 'R'], 'Decanoyl': ['S', 'T'], 'Amino': ['Y'], 'Val->Asp': ['V'], 'Val->Met': ['V'], 'Phe->Cys': ['F'], 'HNE': ['H', 'K', 'C'], 'BDMAPP': ['Y', 'H', 'K', 'N-term', 'W'], 'PET': ['S', 'T'], 'Acetyl:2H(3)': ['K', 'N-term'], 'Gly->Cys': ['G'], 'Sulfo': ['Y', 'C', 'S', 'T'], 'Ser->Gly': ['S'], 'Gln->Arg': ['Q'], 'Hex(1)HexNAc(2)dHex(2)': ['N'], 'Tyr->His': ['Y'], 'Ala->Val': ['A'], 'Leu->Arg': ['L'], 'Lys->CamCys': ['K'], 'Gln->Lys': ['Q'], 'NA-OA-NO2': ['H', 'C'], 'Octanoyl': ['S', 'T'], 'Thr->Ala': ['T'], 'Met->Hsl': ['M'], 'Thr->Ile': ['T'], 'Met->Hse': ['M'], 'GeranylGeranyl': ['C'], 'VFQQQTGG': ['K'], 'Cys->ethylaminoAla': ['C'], 'Arg->Pro': ['R'], 'NDA': ['K', 'N-term'], 'Glucuronyl': ['S', 'N-term'], 'PentylamineBiotin': ['Q'], 'Nethylmaleimide': ['C'], 'Label:13C(5)15N(1)': ['P', 'M', 'V'], 'Ser->Phe': ['S'], 'GIST-Quat:2H(6)': ['K', 'N-term'], 'BADGE': ['C'], 'Hex(1)HexNAc(1)NeuAc(2)': ['S', 'T', 'N'], 'His->Arg': ['H'], 'Hex(2)HexNAc(2)Pent(1)': ['N'], 'Phe->Ser': ['F'], 'Pyro-carbamidomethyl': ['C'], 'ExacTagThiol': ['C'], 'Thr->Asn': ['T'], 'Ile->Asn': ['I'], 'Dethiomethyl': ['M'], 'PhosphoHexNAc': ['S'], 'Val->Ala': ['V'], 'Hex1HexNAc1': ['S', 'T'], 'Delta:H(2)C(3)O(1)': ['K', 'R'], 'Asp->Tyr': ['D'], 'Label:2H(3)': ['L'], 'OxLysBiotin': ['K'], 'Val->Ile': ['V'], 'O-Ethylphosphate': ['Y', 'S', 'T'], 'Phosphoadenosine': ['Y', 'H', 'K', 'T'], 'dHex(1)Hex(4)HexNAc(4)': ['N'], 'Glycerophospho': ['S'], 'Hex(3)HexNAc(4)': ['N'], 'HexNAc(1)dHex(1)': ['N'], 'Lys->Met': ['K'], 'Cys->Dha': ['C'], 'Met->Lys': ['M'], 'Bromo': ['H', 'W', 'F'], 'FAD': ['Y', 'H', 'C'], 'Cation:Ag': ['C-term', 'E', 'D'], 'ICPL': ['K', 'N-term'], 'cGMP': ['C', 'S'], 'Thr->Lys': ['T'], 'LG-lactam-K': ['K', 'N-term'], 'Arg->Met': ['R'], 'LG-lactam-R': ['R'], 'PhosphoUridine': ['Y', 'H'], 'Bacillosamine': ['N'], 'SMCC-maleimide': ['C'], 'GlycerylPE': ['E'], 'Xlink:DMP-s': ['K', 'N-term'], 'QAT:2H(3)': ['C'], 'Cytopiloyne+water': ['C', 'K', 'N-term', 'S', 'R', 'T', 'Y'], 'Asp->Gly': ['D'], 'Carboxyethyl': ['K'], 'Pro->Pyrrolidone': ['P'], 'CyDye-Cy5': ['C'], '4-ONE+Delta:H(-2)O(-1)': ['H', 'C', 'K'], 'Asn->His': ['N'], 'Nmethylmaleimide': ['C', 'K'], 'Ethyl': ['C-term', 'K', 'N-term', 'E', 'D'], 'CuSMo': ['C'], 'Ile->Thr': ['I'], 'Cation:Fe[II]': ['C-term', 'E', 'D'], 'Lys->Asn': ['K'], 'VIEVYQEQTGG': ['K'], 'Hep': ['K', 'N', 'Q', 'S', 'R', 'T'], 'GIST-Quat': ['K', 'N-term'], 'ICAT-C:13C(9)': ['C'], 'Arg->Thr': ['R'], 'Pyridylethyl': ['C'], 'CoenzymeA': ['C'], 'Trimethyl': ['A', 'K', 'R'], 'Phycoerythrobilin': ['C'], 'Ser->Pro': ['S'], 'HydroxymethylOP': ['K'], 'Asn->Ser': ['N'], 'Phe->Tyr': ['F'], 'Phycocyanobilin': ['C'], 'ethylamino': ['S', 'T'], 'Delta:H(4)C(2)': ['H', 'K'], 'Thr->Ser': ['T'], 'Hex': ['C', 'K', 'N-term', 'N', 'R', 'T', 'W', 'Y'], 'Succinyl:13C(4)': ['K', 'N-term'], 'Cys->methylaminoAla': ['C'], 'CarbamidomethylDTT': ['C'], 'Label:13C(9)+Phospho': ['Y'], 'Triiodo': ['Y'], 'Trp->Kynurenin': ['W'], 'Sulfide': ['C'], 'iTRAQ4plex': ['Y', 'K', 'N-term'], 'Label:13C(9)15N(1)': ['F'], 'Trp->Ser': ['W'], 'CarboxymethylDTT': ['C'], '2HPG': ['R'], 'IDEnT': ['C'], 'Ser->Thr': ['S'], 'Label:15N(2)2H(9)': ['K'], 'O-Methylphosphate': ['Y', 'S', 'T'], 'Met->Thr': ['M'], 'Glucosylgalactosyl': ['K'], 'Pro->Ser': ['P'], 'Phospho': ['C', 'D', 'H', 'S', 'R', 'T', 'Y'], 'Ile->Arg': ['I'], 'IodoU-AMP': ['Y', 'W', 'F'], 'Delta:H(1)O(-1)18O(1)': ['N'], 'Phe->Ile': ['F'], 'ESP:2H(10)': ['K', 'N-term'], 'Label:13C(6)15N(1)': ['I', 'L'], 'Diironsubcluster': ['C'], 'TMAB:2H(9)': ['K', 'N-term'], 'CHDH': ['D'], 'Delta:H(2)C(5)': ['K'], 'Ile->Ser': ['I'], 'Methylamine': ['S', 'T'], 'FMNH': ['H', 'C'], 'Pro->Gln': ['P'], 'FMNC': ['C'], 'Guanidinyl': ['K'], 'Ser->Ile': ['S'], 'PyridoxalPhosphate': ['K'], 'Delta:H(2)C(2)': ['H', 'K'], 'Diiodo': ['Y'], 'Leu->Phe': ['L'], 'Ser->Ala': ['S'], 'OxArgBiotinRed': ['R'], 'Xlink:DMP': ['K', 'N-term'], 'Maleimide-PEO2-Biotin': ['C'], 'Diethyl': ['K', 'N-term'], 'DimethylArsino': ['C'], 'His->Asn': ['H'], 'Ethanolamine': ['E', 'C-term', 'D'], 'Nitro': ['Y', 'W'], 'iTRAQ8plex': ['Y', 'K', 'N-term'], 'NBS': ['W'], 'Label:13C(6)+GlyGly': ['K'], 'His->Asp': ['H'], 'Gln->His': ['Q'], 'ICAT-G': ['C'], 'ICAT-D': ['C'], 'Hydroxymethyl': ['N'], 'DTT_ST': ['S', 'T'], 'ICAT-C': ['C'], 'Lys->Glu': ['K'], 'IGBP:13C(2)': ['C'], 'ICAT-H': ['C'], 'AEC-MAEC:2H(4)': ['S', 'T'], 'Argbiotinhydrazide': ['R'], 'Lys->Gln': ['K'], 'Cation:Ca[II]': ['C-term', 'E', 'D'], 'Delta:H(4)C(6)': ['K'], 'Succinyl:2H(4)': ['K', 'N-term'], 'Ethoxyformyl': ['H'], 'Pro->Pyrrolidinone': ['P'], 'dHex': ['S', 'T'], 'maleimide': ['C', 'K'], 'lapachenole': ['C'], 'Phenylisocyanate': ['N-term'], 'Dibromo': ['Y'], 'Nmethylmaleimide+water': ['C'], 'Lys->AminoadipicAcid': ['K'], 'Piperidine': ['K', 'N-term'], 'Val->Phe': ['V'], 'Chlorination': ['Y'], 'Met->Ile': ['M'], 'TMT2plex': ['K', 'N-term'], 'Leu->His': ['L'], 'MTSL': ['C'], 'Molybdopterin': ['C'], 'Pro->Ala': ['P'], 'Pro->Thr': ['P'], 'Gly-loss+Amide': ['G'], 'HNE+Delta:H(2)': ['H', 'C', 'K'], 'Oxidation': ['C', 'D', 'G', 'F', 'H', 'K', 'M', 'N', 'P', 'R', 'W', 'Y'], 'Lys->Ile': ['K'], 'Malonyl': ['C', 'S'], '2-succinyl': ['C'], 'Delta:H(5)C(2)': ['P'], 'Asp->Ala': ['D'], 'Tyr->Ser': ['Y'], 'GalNAzBiotin': ['S', 'T', 'N'], 'Carboxy': ['M', 'K', 'E', 'D', 'W'], 'ESP': ['K', 'N-term'], 'dNIC': ['N-term'], 'BMOE': ['C'], 'ExacTagAmine': ['K'], 'DNPS': ['C', 'W'], 'MG-H1': ['R'], 'Delta:Se(1)': ['C'], 'GluGluGlu': ['E', 'C-term'], 'Myristoyl+Delta:H(-4)': ['G'], 'Arg->Lys': ['R'], 'Hex(3)HexNAc(2)': ['N'], 'Methylpyrroline': ['K'], 'HexNAc(1)dHex(2)': ['N'], 'Arg->Cys': ['R'], 'Bodipy': ['C'], 'GluGluGluGlu': ['E', 'C-term'], 'Ser->Cys': ['S'], 'TMAB': ['K', 'N-term'], 'LG-anhyropyrrole': ['K', 'N-term'], 'SPITC:13C(6)': ['K', 'N-term'], 'SulfanilicAcid': ['E', 'C-term', 'D'], 'Lipoyl': ['K'], 'Methyl+Acetyl:2H(3)': ['K']} ;
neutral_losses = {('FP-Biotin', 'T'): (), ('a-type-ion', 'C-term'): (), ('Oxidation', 'Y'): (), ('EQAT:2H(5)', 'C'): (), ('Tripalmitate', 'C'): (), ('Label:13C(4)15N(2)+GlyGly', 'K'): (), ('Val->Phe', 'V'): (), ('Retinylidene', 'K'): (), ('Xlink:DMP-s', 'N-term'): (), ('mTRAQ:13C(3)15N(1)', 'K'): (), ('Tyr->His', 'Y'): (), ('iTRAQ4plex114', 'Y'): (), ('Dipyrrolylmethanemethyl', 'C'): (), ('Dimethyl:2H(4)', 'N-term'): (), ('OxProBiotinRed', 'P'): (), ('4-ONE', 'H'): (), ('Fluoro', 'Y'): (), ('Methylthio', 'N'): (), ('Methyl', 'C'): (), ('Cation:Li', 'C-term'): (), ('Label:13C(6)15N(2)', 'K'): (), ('BHT', 'H'): (), ('NO_SMX_SEMD', 'C'): (), ('Biotin-PEO4-hydrazide', 'C-term'): (), ('ADP-Ribosyl', 'N'): (), ('DimethylamineGMBS', 'C'): (), ('TMT6plex', 'N-term'): (), ('Ammonia-loss', 'C'): (), ('HexNAc(1)dHex(1)', 'N'): (), ('DeStreak', 'C'): (), ('GIST-Quat', 'K'): (59.073499,), ('Label:13C(9)+Phospho', 'Y'): (), ('Hydroxymethyl', 'N'): (), ('Hex(2)HexNAc(2)', 'N'): (), ('Methylphosphonate', 'Y'): (), ('Methyl', 'D'): (), ('CLIP_TRAQ_4', 'N-term'): (), ('NIC', 'N-term'): (), ('Ethoxyformyl', 'H'): (), ('Thiophos-S-S-biotin', 'Y'): (525.142894,), ('AEBS', 'Y'): (), ('Isopropylphospho', 'S'): (), ('Hex(5)HexNAc(2)', 'N'): (), ('Carbamidomethyl', 'C'): (), ('CAMthiopropanoyl', 'N-term'): (), ('Carboxyethyl', 'K'): (), ('Dehydrated', 'Y'): (), ('CLIP_TRAQ_4', 'K'): (), ('Asn->Asp', 'N'): (), ('QAT', 'C'): (), ('PEO-Iodoacetyl-LC-Biotin', 'C'): (), ('Phenylisocyanate', 'N-term'): (), ('DTBP', 'Q'): (), ('CLIP_TRAQ_2', 'Y'): (), ('Iodo', 'Y'): (), ('GIST-Quat:2H(3)', 'K'): (62.09233,), ('4-ONE+Delta:H(-2)O(-1)', 'H'): (), ('AEC-MAEC', 'S'): (), ('Oxidation', 'R'): (), ('Cytopiloyne', 'K'): (), ('CAMthiopropanoyl', 'K'): (), ('SulfanilicAcid', 'C-term'): (), ('Ethyl', 'C-term'): (), ('Cyano', 'C'): (), ('O-Methylphosphate', 'Y'): (), ('Xlink:DMP', 'K'): (), ('AccQTag', 'K'): (), ('ICAT-D:2H(8)', 'C'): (), ('Ile->Val', 'I'): (), ('Cys->Oxoalanine', 'C'): (), ('BMOE', 'C'): (), ('Nmethylmaleimide', 'C'): (), ('DNPS', 'C'): (), ('FTC', 'S'): (), ('Methyl:2H(3)', 'C-term'): (), ('CAF', 'N-term'): (), ('Carbamyl', 'K'): (), ('Label:13C(5)15N(1)', 'M'): (), ('Gly->Val', 'G'): (), ('ExacTagAmine', 'K'): (), ('Dihydroxyimidazolidine', 'R'): (), ('Dimethyl:2H(4)13C(2)', 'N-term'): (), ('Label:18O(2)', 'C-term'): (), ('GIST-Quat:2H(9)', 'K'): (68.12999,), ('Arg->Pro', 'R'): (), ('mTRAQ', 'Y'): (), ('Leu->Arg', 'L'): (), ('Methyl:2H(3)13C(1)', 'R'): (), ('IED-Biotin', 'C'): (), ('Nitro', 'Y'): (), ('Glu->Val', 'E'): (), ('TMT', 'K'): (), ('Cation:Cu[I]', 'C-term'): (), ('Methyl', 'H'): (), ('Cation:Mg[II]', 'C-term'): (), ('GIST-Quat:2H(9)', 'N-term'): (68.12999,), ('Hydroxyheme', 'E'): (), ('Ile->Met', 'I'): (), ('Carbamyl', 'R'): (), ('maleimide', 'C'): (), ('Ser->Tyr', 'S'): (), ('Ethanolamine', 'C-term'): (), ('FP-Biotin', 'Y'): (), ('Ethyl', 'D'): (), ('IGBP:13C(2)', 'C'): (), ('ICPL:13C(6)2H(4)', 'K'): (), ('Hex(4)HexNAc(4)', 'N'): (), ('OxLysBiotinRed', 'K'): (), ('Delta:S(-1)Se(1)', 'M'): (), ('Diironsubcluster', 'C'): (), ('dHex', 'T'): (), ('Dehydrated', 'T'): (), ('Can-FP-biotin', 'S'): (), ('Cys->Trp', 'C'): (), ('Cytopiloyne', 'R'): (), ('Crotonaldehyde', 'C'): (), ('pyrophospho', 'S'): (176.935402,), ('Acetyl', 'N-term'): (), ('Label:13C(1)2H(3)+Oxidation', 'M'): (), ('Glu->Gln', 'E'): (), ('Thioacyl', 'N-term'): (), ('NEIAA:2H(5)', 'C'): (), ('Thr->Met', 'T'): (), ('OxProBiotin', 'P'): (), ('Isopropylphospho', 'Y'): (), ('Methyl', 'N-term'): (), ('Label:13C(6)', 'L'): (), ('Guanidinyl', 'K'): (), ('Phe->Val', 'F'): (), ('Delta:H(4)C(6)', 'K'): (), ('Glu->Asp', 'E'): (), ('Hex1HexNAc1', 'S'): (), ('Trp->Oxolactone', 'W'): (), ('Thr->Ala', 'T'): (), ('Carbamidomethyl', 'E'): (), ('Ile->Asn', 'I'): (), ('Label:13C(5)', 'P'): (), ('Phospho', 'S'): (0.0, 97.976896), ('Methyl', 'K'): (), ('Palmitoleyl', 'T'): (), ('BHT', 'K'): (), ('Didehydro', 'K'): (), ('Met->Val', 'M'): (), ('Carboxymethyl:13C(2)', 'C'): (), ('Cytopiloyne', 'P'): (), ('Acetyl', 'H'): (), ('Succinyl', 'N-term'): (), ('4-ONE+Delta:H(-2)O(-1)', 'C'): (), ('Carbamidomethyl', 'D'): (), ('HexNAc(1)dHex(2)', 'N'): (), ('Cation:Cu[I]', 'E'): (), ('Arg->Ser', 'R'): (), ('Methyl', 'L'): (), ('Hep', 'N'): (), ('Succinyl:13C(4)', 'N-term'): (), ('Cys->Dha', 'C'): (), ('NHS-LC-Biotin', 'K'): (), ('FormylMet', 'N-term'): (), ('Tyr->Asp', 'Y'): (), ('CHDH', 'D'): (), ('AEBS', 'N-term'): (), ('VFQQQTGG', 'K'): (), ('Hex(2)', 'K'): (), ('Carbamyl', 'M'): (), ('Met->Hsl', 'M'): (), ('Hex', 'N-term'): (), ('Dehydrated', 'Q'): (), ('Asp->Glu', 'D'): (), ('Cation:Ca[II]', 'E'): (), ('Asp->Ala', 'D'): (), ('Phe->CamCys', 'F'): (), ('NHS-LC-Biotin', 'N-term'): (), ('Cation:Fe[II]', 'C-term'): (), ('Hep', 'T'): (), ('Phe->Ile', 'F'): (), ('Arg->Met', 'R'): (), ('Ethanedithiol', 'S'): (), ('ICPL:13C(6)2H(4)', 'N-term'): (), ('CLIP_TRAQ_3', 'N-term'): (), ('Hep', 'Q'): (), ('Methylmalonylation', 'S'): (), ('AEC-MAEC:2H(4)', 'T'): (), ('NEIAA', 'C'): (), ('Cation:Ni[II]', 'E'): (), ('Hex(3)HexNAc(2)', 'N'): (), ('TNBS', 'N-term'): (), ('dHex(1)Hex(3)HexNAc(4)', 'N'): (), ('Ile->Arg', 'I'): (), ('Delta:Hg(1)', 'C'): (), ('GalNAzBiotin', 'N'): (), ('HydroxymethylOP', 'K'): (), ('AEBS', 'S'): (), ('CLIP_TRAQ_3', 'K'): (), ('FP-Biotin', 'S'): (), ('Nmethylmaleimide', 'K'): (), ('Amino', 'Y'): (), ('Leu->Phe', 'L'): (), ('DFDNB', 'K'): (), ('Dimethyl', 'P'): (), ('FTC', 'R'): (), ('Thr->Asn', 'T'): (), ('ICAT-C', 'C'): (), ('Gln->Leu', 'Q'): (), ('G-H1', 'R'): (), ('Propargylamine', 'D'): (), ('O-Diethylphosphate', 'K'): (), ('GlycerylPE', 'E'): (), ('maleimide', 'K'): (), ('Bodipy', 'C'): (), ('NA-LNO2', 'C'): (), ('Asn->Lys', 'N'): (), ('Octanoyl', 'T'): (), ('GIST-Quat:2H(3)', 'N-term'): (62.09233,), ('Phe->Ser', 'F'): (), ('Lys->AminoadipicAcid', 'K'): (), ('Cytopiloyne', 'N-term'): (), ('FMN', 'T'): (), ('CyDye-Cy5', 'C'): (), ('Biotin-HPDP', 'C'): (), ('Xlink:DMP-s', 'K'): (), ('NIPCAM', 'C'): (), ('BDMAPP', 'H'): (), ('IGBP', 'C'): (), ('trifluoro', 'L'): (), ('FMNH', 'C'): (), ('Arg->GluSA', 'R'): (), ('FMNH', 'H'): (), ('Biotin', 'N-term'): (), ('Menadione', 'C'): (), ('O-Methylphosphate', 'T'): (), ('Label:13C(6)15N(1)', 'I'): (), ('Myristoyl+Delta:H(-4)', 'G'): (), ('Val->Ile', 'V'): (), ('Tyr->Asn', 'Y'): (), ('Met->Leu', 'M'): (), ('Cys->Phe', 'C'): (), ('Bromo', 'W'): (), ('Oxidation', 'W'): (), ('Sulfo', 'Y'): (), ('BDMAPP', 'W'): (), ('mTRAQ', 'K'): (), ('Quinone', 'Y'): (), ('Hex(1)HexNAc(2)dHex(2)', 'N'): (), ('Cation:K', 'C-term'): (), ('BDMAPP', 'Y'): (), ('MDCC', 'C'): (), ('Molybdopterin', 'C'): (), ('Asp->Val', 'D'): (), ('Lys->Gln', 'K'): (), ('Methylthio', 'C'): (), ('Amidine', 'K'): (), ('Ile->Lys', 'I'): (), ('PhosphoUridine', 'H'): (), ('IBTP', 'C'): (), ('ADP-Ribosyl', 'R'): (), ('Deamidated:18O(1)', 'Q'): (), ('Asn->Tyr', 'N'): (), ('Label:15N(2)2H(9)', 'K'): (), ('Iodo', 'H'): (), ('BHT', 'C'): (), ('Didehydro', 'S'): (), ('Delta:Se(1)', 'C'): (), ('Hypusine', 'K'): (), ('Thioacyl', 'K'): (), ('Delta:H(4)C(2)', 'H'): (), ('Amidine', 'N-term'): (), ('Lys-loss', 'K'): (), ('Delta:H(4)C(3)', 'K'): (), ('DTT_C', 'C'): (), ('VIEVYQEQTGG', 'K'): (), ('Myristoyl', 'G'): (), ('GalNAzBiotin', 'S'): (), ('Nethylmaleimide', 'C'): (), ('Thr->Ser', 'T'): (), ('iTRAQ4plex', 'Y'): (), ('Bromo', 'F'): (), ('TMT6plex', 'K'): (), ('His->Leu', 'H'): (), ('SulfanilicAcid:13C(6)', 'D'): (), ('Glu', 'E'): (), ('HNE-BAHAH', 'H'): (), ('iTRAQ4plex114', 'K'): (), ('HexN', 'N'): (), ('DTT_ST', 'S'): (), ('Xlink:B10621', 'C'): (), ('IDEnT', 'C'): (), ('O-pinacolylmethylphosphonate', 'T'): (), ('Label:18O(1)', 'Y'): (), ('O-Dimethylphosphate', 'T'): (), ('Palmitoyl', 'N-term'): (), ('SulfanilicAcid:13C(6)', 'C-term'): (), ('CLIP_TRAQ_1', 'Y'): (), ('mTRAQ', 'N-term'): (), ('iTRAQ4plex115', 'N-term'): (), ('Diethyl', 'K'): (), ('Phycocyanobilin', 'C'): (), ('Oxidation', 'P'): (), ('Deamidated', 'Q'): (), ('Quinone', 'W'): (), ('Cation:Na', 'E'): (), ('Delta:H(4)C(2)O(-1)S(1)', 'S'): (), ('Dehydro', 'C'): (), ('GluGluGlu', 'C-term'): (), ('PropylNAGthiazoline', 'C'): (), ('SulfanilicAcid', 'E'): (), ('Oxidation', 'M'): (0.0, 63.998285), ('Succinyl:13C(4)', 'K'): (), ('IodoU-AMP', 'Y'): (), ('PyruvicAcidIminyl', 'C'): (), ('Maleimide-PEO2-Biotin', 'C'): (), ('Dimethyl:2H(6)13C(2)', 'N-term'): (), ('Iminobiotin', 'N-term'): (), ('AEBS', 'K'): (), ('Phospho', 'Y'): (), ('Palmitoleyl', 'C'): (), ('BDMAPP', 'N-term'): (), ('Pyridylethyl', 'C'): (), ('Cys->Tyr', 'C'): (), ('Microcin', 'C-term'): (), ('AccQTag', 'N-term'): (), ('DimethylArsino', 'C'): (), ('Label:13C(6)15N(2)+GlyGly', 'K'): (), ('PhosphoHex', 'S'): (), ('Ser->Cys', 'S'): (), ('Nmethylmaleimide+water', 'C'): (), ('O-Isopropylmethylphosphonate', 'Y'): (), ('SMCC-maleimide', 'C'): (), ('PentylamineBiotin', 'Q'): (), ('Methyl:2H(2)', 'K'): (), ('Dioxidation', 'P'): (), ('Lipoyl', 'K'): (), ('Propionamide:2H(3)', 'C'): (), ('Ser->Arg', 'S'): (), ('Dioxidation', 'F'): (), ('Leu->Trp', 'L'): (), ('DimethylpyrroleAdduct', 'K'): (), ('pyrophospho', 'T'): (176.935402,), ('Delta:H(5)C(2)', 'P'): (), ('O-Dimethylphosphate', 'S'): (), ('Asp->Gly', 'D'): (), ('Hex', 'W'): (), ('Formyl', 'S'): (), ('Label:13C(8)15N(2)', 'R'): (), ('Menadione', 'K'): (), ('NEM:2H(5)', 'C'): (), ('Dehydrated', 'D'): (), ('Ser->Phe', 'S'): (), ('ICPL:13C(6)', 'K'): (), ('Thrbiotinhydrazide', 'T'): (), ('Lys->CamCys', 'K'): (), ('Label:2H(3)', 'L'): (), ('HexNAc(2)dHex(2)', 'N'): (), ('HexNAc(2)dHex(1)', 'N'): (), ('Oxidation', 'F'): (), ('Ethanolamine', 'D'): (), ('Glu->Ala', 'E'): (), ('Cation:Ca[II]', 'C-term'): (), ('Phe->Cys', 'F'): (), ('Hex(3)HexNAc(2)P(1)', 'N'): (), ('cGMP+RMP-loss', 'S'): (), ('Gly->Ala', 'G'): (), ('Label:2H(4)+GlyGly', 'K'): (), ('FAD', 'C'): (), ('Leu->MetOx', 'L'): (), ('Dansyl', 'K'): (), ('Ala->Asp', 'A'): (), ('Deamidated', 'F'): (), ('Phospho', 'R'): (), ('Phe->Tyr', 'F'): (), ('Asn->Ile', 'N'): (), ('Dimethyl', 'N'): (), ('Methyl:2H(3)', 'D'): (), ('Gly->Asp', 'G'): (), ('Carboxy', 'K'): (), ('DFDNB', 'N'): (), ('Hep', 'R'): (), ('DTBP', 'K'): (), ('Ethyl', 'E'): (), ('Arg->Ile', 'R'): (), ('Sulfo-NHS-LC-LC-Biotin', 'N-term'): (), ('Met->Hse', 'M'): (), ('Cation:Li', 'D'): (), ('iTRAQ8plex', 'N-term'): (), ('Bromo', 'H'): (), ('CoenzymeA', 'C'): (), ('Glu->Gly', 'E'): (), ('Tyr->Dha', 'Y'): (), ('Dioxidation', 'M'): (), ('CuSMo', 'C'): (), ('Arg->Npo', 'R'): (), ('Amidino', 'C'): (), ('Glycosyl', 'P'): (), ('Succinyl', 'K'): (), ('NA-OA-NO2', 'C'): (), ('Methylthio', 'D'): (), ('Trp->Gly', 'W'): (), ('Label:18O(1)', 'C-term'): (), ('Cation:Cu[I]', 'D'): (), ('Cys->Gly', 'C'): (), ('Bacillosamine', 'N'): (), ('HMVK', 'C'): (), ('Hydroxyfarnesyl', 'C'): (), ('Cys->methylaminoAla', 'C'): (), ('ICAT-C:13C(9)', 'C'): (), ('Cytopiloyne+water', 'S'): (), ('Nitro', 'W'): (), ('Cation:Zn[II]', 'C-term'): (), ('Phospho', 'D'): (), ('TMAB:2H(9)', 'N-term'): (68.12999,), ('Arg->Gly', 'R'): (), ('Cytopiloyne+water', 'N-term'): (), ('O-Isopropylmethylphosphonate', 'S'): (), ('Oxidation', 'C'): (), ('Gly->Ser', 'G'): (), ('Glucuronyl', 'S'): (), ('Can-FP-biotin', 'T'): (), ('Label:13C(9)', 'F'): (), ('Asp->Tyr', 'D'): (), ('Cholesterol', 'C-term'): (), ('Biotin-phenacyl', 'H'): (), ('DyLight-maleimide', 'C'): (), ('Ile->Thr', 'I'): (), ('Delta:H(2)C(2)', 'H'): (), ('Val->Ala', 'V'): (), ('Crotonaldehyde', 'K'): (), ('Pro->Thr', 'P'): (), ('Met->Lys', 'M'): (), ('Hex(2)', 'R'): (), ('Diisopropylphosphate', 'K'): (), ('Phosphopropargyl', 'Y'): (), ('Label:13C(6)15N(4)', 'R'): (), ('Lys->Allysine', 'K'): (), ('NDA', 'N-term'): (), ('PyruvicAcidIminyl', 'K'): (), ('DTBP', 'R'): (), ('Dimethyl', 'K'): (), ('Hex(1)HexNAc(1)NeuAc(2)', 'S'): (), ('DFDNB', 'Q'): (), ('Gln->pyro-Glu', 'Q'): (), ('Pro->His', 'P'): (), ('Label:13C(6)15N(1)', 'L'): (), ('ICAT-H', 'C'): (), ('4AcAllylGal', 'C'): (), ('Lys->Arg', 'K'): (), ('iTRAQ8plex:13C(6)15N(2)', 'Y'): (), ('Glucuronyl', 'N-term'): (), ('Leu->Met', 'L'): (), ('PyMIC', 'N-term'): (), ('ICAT-G:2H(8)', 'C'): (), ('Cation:Mg[II]', 'E'): (), ('Hex(2)HexNAc(2)Pent(1)', 'N'): (), ('Cation:Zn[II]', 'E'): (), ('Val->Met', 'V'): (), ('Asn->Ser', 'N'): (), ('Lysbiotinhydrazide', 'K'): (), ('Label:18O(1)', 'S'): (), ('Decanoyl', 'T'): (), ('O-pinacolylmethylphosphonate', 'S'): (), ('Dehydrated', 'S'): (), ('IMID:2H(4)', 'K'): (), ('Dimethyl:2H(6)13C(2)', 'K'): (), ('Trp->Ser', 'W'): (), ('DTT_ST:2H(6)', 'T'): (), ('Galactosyl', 'K'): (162.052824,), ('FMNC', 'C'): (), ('Delta:H(2)C(2)', 'K'): (), ('Gln->Pro', 'Q'): (), ('CLIP_TRAQ_2', 'N-term'): (), ('Met->Thr', 'M'): (), ('CyDye-Cy3', 'C'): (), ('Oxidation', 'G'): (), ('Xlink:DMP', 'N-term'): (), ('EthylAmide', 'N'): (), ('O-Diethylphosphate', 'S'): (), ('Oxidation', 'N'): (), ('BHTOH', 'K'): (), ('cGMP', 'C'): (), ('ethylamino', 'T'): (), ('Carboxy', 'D'): (), ('Leu->His', 'L'): (), ('iTRAQ4plex', 'K'): (), ('ZGB', 'K'): (), ('Lys->Met', 'K'): (), ('SMA', 'N-term'): (), ('Ser->Gly', 'S'): (), ('LG-lactam-K', 'N-term'): (), ('Dimethyl:2H(4)13C(2)', 'K'): (), ('Delta:H(4)C(3)O(1)', 'K'): (), ('Delta:H(2)C(3)', 'K'): (), ('O-Dimethylphosphate', 'Y'): (), ('Nethylmaleimide+water', 'C'): (), ('TMAB:2H(9)', 'K'): (68.12999,), ('Gln->Arg', 'Q'): (), ('Deamidated', 'N'): (), ('EDT-maleimide-PEO-biotin', 'T'): (), ('Carboxy', 'E'): (), ('Cytopiloyne+water', 'Y'): (), ('Label:2H(4)+Acetyl', 'K'): (), ('Arg->Cys', 'R'): (), ('Palmitoleyl', 'S'): (), ('Hep', 'S'): (), ('Trp->Cys', 'W'): (), ('Met-loss', 'M'): (), ('Carboxy->Thiocarboxy', 'G'): (), ('BisANS', 'K'): (), ('LG-lactam-K', 'K'): (), ('Ethanolamine', 'E'): (), ('Delta:H(2)C(3)O(1)', 'R'): (), ('Thr->Pro', 'T'): (), ('HexNAc(2)', 'N'): (), ('PhosphoHexNAc', 'S'): (), ('Methyl+Deamidated', 'Q'): (), ('EQAT', 'C'): (), ('Hex(1)HexNAc(1)NeuAc(1)', 'N'): (), ('Myristoleyl', 'G'): (), ('His->Arg', 'H'): (), ('Methylamine', 'S'): (), ('Dibromo', 'Y'): (), ('Ser->Pro', 'S'): (), ('Dehydrated', 'N'): (), ('HNE-Delta:H(2)O', 'C'): (), ('Acetyl:2H(3)', 'K'): (), ('SulfanilicAcid:13C(6)', 'E'): (), ('15dB-biotin', 'C'): (), ('Delta:H(2)C(3)O(1)', 'K'): (), ('Methyl:2H(3)', 'E'): (), ('iTRAQ4plex114', 'N-term'): (), ('LG-Hlactam-K', 'K'): (), ('DTBP', 'N-term'): (), ('dHex(1)Hex(4)HexNAc(4)', 'N'): (), ('ADP-Ribosyl', 'S'): (), ('Arg->His', 'R'): (), ('MolybdopterinGD', 'D'): (), ('FAD', 'H'): (), ('PET', 'T'): (), ('Oxidation', 'K'): (), ('LeuArgGlyGly', 'K'): (), ('Propionyl', 'S'): (), ('Methyl', 'Q'): (), ('LG-pyrrole', 'K'): (), ('FAD', 'Y'): (), ('Val->Asp', 'V'): (), ('Leu->Ser', 'L'): (), ('LG-Hlactam-R', 'R'): (), ('QAT:2H(3)', 'C'): (), ('Label:13C(6)', 'K'): (), ('Carboxymethyl', 'N-term'): (), ('Delta:H(1)O(-1)18O(1)', 'N'): (), ('Cation:K', 'D'): (), ('Diisopropylphosphate', 'S'): (), ('EDT-iodoacetyl-PEO-biotin', 'S'): (), ('Deoxy', 'S'): (), ('Label:13C(6)15N(2)+Acetyl', 'K'): (), ('GIST-Quat:2H(6)', 'K'): (65.11116,), ('Methyl', 'R'): (), ('Iminobiotin', 'K'): (), ('O-Ethylphosphate', 'Y'): (), ('FMN', 'S'): (), ('O-pinacolylmethylphosphonate', 'Y'): (), ('HNE+Delta:H(2)', 'H'): (), ('Lys->Thr', 'K'): (), ('Dioxidation', 'R'): (), ('Cation:K', 'E'): (), ('DNPS', 'W'): (), ('Dioxidation', 'K'): (), ('GeranylGeranyl', 'C'): (), ('Hex(1)HexNAc(2)dHex(1)', 'N'): (), ('Diacylglycerol', 'C'): (), ('Label:2H(9)13C(6)15N(2)', 'K'): (), ('CLIP_TRAQ_4', 'Y'): (), ('Palmitoyl', 'S'): (), ('Cation:Ni[II]', 'D'): (), ('HNE', 'H'): (), ('Archaeol', 'C'): (), ('Label:15N(4)', 'R'): (), ('Cysteinyl', 'C'): (), ('Label:13C(6)', 'I'): (), ('Pyro-carbamidomethyl', 'C'): (), ('Dimethyl', 'N-term'): (), ('Arg->Trp', 'R'): (), ('Xlink:SSD', 'K'): (), ('EthylAmide', 'Q'): (), ('Delta:H(2)C(5)', 'K'): (), ('Pro->Arg', 'P'): (), ('Nitrosyl', 'C'): (), ('ethylamino', 'S'): (), ('Oxidation', 'D'): (), ('Sulfo', 'S'): (), ('Ethyl', 'K'): (), ('Farnesyl', 'C'): (), ('TNBS', 'K'): (), ('BDMAPP', 'K'): (), ('dNIC', 'N-term'): (), ('Ile->Phe', 'I'): (), ('BHTOH', 'C'): (), ('Chlorination', 'Y'): (), ('Glu->pyro-Glu', 'E'): (), ('ICPL', 'K'): (), ('HNE+Delta:H(2)', 'K'): (), ('Leu->Pro', 'L'): (), ('Hydroxycinnamyl', 'C'): (), ('DAET', 'T'): (), ('Fluorescein', 'C'): (), ('Delta:H(4)C(3)O(1)', 'C'): (), ('NBS:13C(6)', 'W'): (), ('Diphthamide', 'H'): (), ('Cys->PyruvicAcid', 'C'): (), ('Succinyl:2H(4)', 'N-term'): (), ('Carboxy', 'M'): (), ('Ser->Thr', 'S'): (), ('EQIGG', 'K'): (), ('dHex(1)Hex(5)HexNAc(4)', 'N'): (), ('Phosphoadenosine', 'T'): (), ('Dioxidation', 'Y'): (), ('Dansyl', 'N-term'): (), ('Cation:Fe[II]', 'E'): (), ('ESP', 'K'): (), ('Delta:H(6)C(6)O(1)', 'K'): (), ('GluGlu', 'E'): (), ('Tyr->Phe', 'Y'): (), ('Cys->Arg', 'C'): (), ('Sulfo-NHS-LC-LC-Biotin', 'K'): (), ('iTRAQ4plex', 'N-term'): (), ('Succinyl:2H(4)', 'K'): (), ('Sulfide', 'C'): (), ('Biotin-PEO-Amine', 'E'): (), ('Formyl', 'N-term'): (), ('Label:13C(9)', 'Y'): (), ('O-Isopropylmethylphosphonate', 'T'): (), ('HexNAc', 'T'): (), ('MolybdopterinGD', 'C'): (), ('Thr->Ile', 'T'): (), ('DAET', 'S'): (), ('Biotin', 'K'): (), ('Acetyl', 'S'): (), ('LG-lactam-R', 'R'): (), ('DTT_C:2H(6)', 'C'): (), ('Cation:Fe[II]', 'D'): (), ('Asn->Thr', 'N'): (), ('Propionyl', 'N-term'): (), ('HNE-Delta:H(2)O', 'K'): (), ('Hex', 'C'): (), ('Arg2PG', 'R'): (), ('Asn->His', 'N'): (), ('Cytopiloyne+water', 'C'): (), ('iTRAQ8plex:13C(6)15N(2)', 'N-term'): (), ('Label:18O(1)', 'T'): (), ('Phospho', 'T'): (97.976896, 0.0), ('Malonyl', 'C'): (), ('Oxidation', 'H'): (), ('O-Ethylphosphate', 'T'): (), ('Cation:Ag', 'E'): (), ('DTT_ST:2H(6)', 'S'): (), ('Propionyl', 'K'): (), ('Ala->Thr', 'A'): (), ('Thyroxine', 'Y'): (), ('Hex', 'T'): (), ('Didehydro', 'T'): (), ('lapachenole', 'C'): (), ('Val->Glu', 'V'): (), ('Met->Ile', 'M'): (), ('GlyGly', 'K'): (), ('Hex(1)HexNAc(1)dHex(1)', 'N'): (), ('Can-FP-biotin', 'Y'): (), ('AEC-MAEC', 'T'): (), ('Ammonia-loss', 'T'): (), ('Trimethyl', 'K'): (), ('Cys->Ser', 'C'): (), ('SulfoGMBS', 'C'): (), ('Deoxy', 'D'): (), ('4-ONE', 'C'): (), ('Deamidated', 'R'): (), ('Carboxymethyl', 'C'): (), ('ICAT-G', 'C'): (), ('Phosphoadenosine', 'Y'): (), ('Label:13C(5)15N(1)', 'P'): (), ('Label:13C(6)', 'R'): (), ('Ammonia-loss', 'N'): (), ('Hex1HexNAc1', 'T'): (), ('NDA', 'K'): (), ('Gln->Lys', 'Q'): (), ('Dioxidation', 'C'): (), ('Cytopiloyne+water', 'R'): (), ('Delta:H(4)C(2)', 'K'): (), ('Lys->Asn', 'K'): (), ('ChromoBiotin', 'K'): (), ('C8-QAT', 'K'): (), ('Glu->Lys', 'E'): (), ('NO_SMX_SMCT', 'C'): (), ('TMAB', 'K'): (59.073499,), ('mTRAQ:13C(3)15N(1)', 'Y'): (), ('Thr->Lys', 'T'): (), ('NBS', 'W'): (), ('His->Gln', 'H'): (), ('Dehydrated', 'C'): (), ('Lys->Glu', 'K'): (), ('Propargylamine', 'E'): (), ('Label:13C(6)+Acetyl', 'K'): (), ('SPITC', 'K'): (), ('Thr->Arg', 'T'): (), ('IMID', 'K'): (), ('Crotonaldehyde', 'H'): (), ('Delta:H(4)C(3)', 'H'): (), ('Diiodo', 'Y'): (), ('FTC', 'K'): (), ('TMAB', 'N-term'): (59.073499,), ('MTSL', 'C'): (), ('Isopropylphospho', 'T'): (), ('PhosphoribosyldephosphoCoA', 'S'): (), ('SPITC:13C(6)', 'K'): (), ('Trp->Arg', 'W'): (), ('Cytopiloyne+water', 'T'): (), ('AROD', 'C'): (), ('cGMP', 'S'): (), ('HNE-BAHAH', 'K'): (), ('Carbamyl', 'N-term'): (), ('Dimethyl:2H(4)', 'K'): (), ('3-deoxyglucosone', 'R'): (), ('HNE+Delta:H(2)', 'C'): (), ('ICAT-H:13C(6)', 'C'): (), ('Pro->Ala', 'P'): (), ('Pro->Gln', 'P'): (), ('Nethylmaleimide+water', 'K'): (), ('Carbamidomethyl', 'N-term'): (), ('Trioxidation', 'C'): (), ('Glu', 'C-term'): (), ('Phosphoguanosine', 'H'): (), ('Label:2H(4)', 'K'): (), ('Hex(1)HexNAc(2)', 'N'): (), ('DTBP', 'N'): (), ('TMT2plex', 'K'): (), ('Glucosylgalactosyl', 'K'): (324.105647, 162.052823), ('SMA', 'K'): (), ('Biotin-phenacyl', 'C'): (), ('dHex', 'S'): (), ('Gly-loss+Amide', 'G'): (), ('ESP', 'N-term'): (), ('dichlorination', 'Y'): (), ('HNE', 'C'): (), ('Methylpyrroline', 'K'): (), ('Met->Hpg', 'M'): (), ('Triiodo', 'Y'): (), ('Ser->Trp', 'S'): (), ('FTC', 'C'): (), ('Palmitoyl', 'T'): (), ('GluGlu', 'C-term'): (), ('Lys->Ile', 'K'): (), ('Pro->Pyrrolidone', 'P'): (), ('Hex(1)HexNAc(1)NeuAc(2)', 'N'): (), ('BADGE', 'C'): (), ('ICPL', 'N-term'): (), ('Deoxy', 'T'): (), ('Phosphopantetheine', 'S'): (), ('Benzoyl', 'N-term'): (), ('Cytopiloyne', 'S'): (), ('Acetyl', 'K'): (), ('NEIAA:2H(5)', 'Y'): (), ('Glutathione', 'C'): (), ('Trimethyl', 'A'): (), ('PyruvicAcidIminyl', 'V'): (), ('Cytopiloyne+water', 'K'): (), ('Hex(1)HexNAc(1)NeuAc(1)', 'S'): (), ('Propargylamine', 'C-term'): (), ('Sulfo', 'T'): (), ('Delta:H(4)C(3)O(1)', 'H'): (), ('ADP-Ribosyl', 'C'): (), ('Ala->Ser', 'A'): (), ('Ethanolyl', 'C'): (), ('HexNAc', 'N'): (), ('mTRAQ:13C(3)15N(1)', 'N-term'): (), ('Phosphoadenosine', 'H'): (), ('Delta:H(8)C(6)O(2)', 'K'): (), ('HexN', 'T'): (), ('Pentylamine', 'Q'): (), ('C8-QAT', 'N-term'): (), ('EDT-iodoacetyl-PEO-biotin', 'T'): (), ('Cation:Ni[II]', 'C-term'): (), ('Methyl', 'C-term'): (), ('His->Tyr', 'H'): (), ('Cys->ethylaminoAla', 'C'): (), ('CarboxymethylDTT', 'C'): (), ('DHP', 'C'): (), ('GlyGly', 'C'): (), ('PyridoxalPhosphate', 'K'): (), ('NO_SMX_SIMD', 'C'): (), ('LG-anhyropyrrole', 'K'): (), ('Gly->Cys', 'G'): (), ('Asp->His', 'D'): (), ('Amidated', 'C-term'): (), ('Carboxymethyl', 'K'): (), ('Pro->Pyrrolidinone', 'P'): (), ('DTT_ST', 'T'): (), ('Hex(1)HexNAc(2)Pent(1)', 'N'): (), ('Glycerophospho', 'S'): (), ('GIST-Quat:2H(6)', 'N-term'): (65.11116,), ('Label:13C(1)2H(3)', 'M'): (), ('QEQTGG', 'K'): (), ('OxArgBiotin', 'R'): (), ('Trp->Leu', 'W'): (), ('Lys->MetOx', 'K'): (), ('Ser->Ala', 'S'): (), ('Tyr->Ser', 'Y'): (), ('HPG', 'R'): (), ('Delta:S(-1)Se(1)', 'C'): (), ('ICPL:2H(4)', 'N-term'): (), ('Propionamide', 'C'): (), ('MercaptoEthanol', 'S'): (), ('Palmitoyl', 'C'): (), ('Acetyl', 'Y'): (), ('Hydroxytrimethyl', 'K'): (), ('LG-pyrrole', 'N-term'): (), ('Hex', 'R'): (), ('Cation:Mg[II]', 'D'): (), ('Deamidated:18O(1)', 'N'): (), ('PhosphoUridine', 'Y'): (), ('Hex(5)HexNAc(4)', 'N'): (), ('His->Asn', 'H'): (), ('Arg->Thr', 'R'): (), ('HexN', 'W'): (), ('Pro->pyro-Glu', 'P'): (), ('Menadione-HQ', 'C'): (), ('NEIAA', 'Y'): (), ('Met->Aha', 'M'): (), ('iTRAQ8plex', 'K'): (), ('Methylamine', 'T'): (), ('Thiophospho', 'T'): (), ('2HPG', 'R'): (), ('MG-H1', 'R'): (), ('Sulfo', 'C'): (), ('Methyl', 'S'): (), ('GIST-Quat', 'N-term'): (59.073499,), ('Bromobimane', 'C'): (), ('HNE-BAHAH', 'C'): (), ('Methyl', 'E'): (), ('CLIP_TRAQ_2', 'K'): (), ('Ethyl', 'N-term'): (), ('Ammonia-loss', 'S'): (), ('Trp->Kynurenin', 'W'): (), ('O-Ethylphosphate', 'S'): (), ('Trimethyl', 'R'): (), ('Trp->Hydroxykynurenin', 'W'): (), ('Piperidine', 'K'): (), ('Methyl', 'T'): (), ('DFDNB', 'R'): (), ('SPITC', 'N-term'): (), ('Methyl-PEO12-Maleimide', 'C'): (), ('Cation:Zn[II]', 'D'): (), ('GalNAzBiotin', 'T'): (), ('CLIP_TRAQ_1', 'N-term'): (), ('Ala->Glu', 'A'): (), ('Thiophospho', 'S'): (), ('Myristoyl', 'C'): (), ('Methyl+Acetyl:2H(3)', 'K'): (), ('HNE', 'K'): (), ('Arg->Gln', 'R'): (), ('Acetyl:2H(3)', 'N-term'): (), ('Fluoro', 'W'): (), ('Ala->Val', 'A'): (), ('4-ONE+Delta:H(-2)O(-1)', 'K'): (), ('Arg->Orn', 'R'): (), ('FNEM', 'C'): (), ('4-ONE', 'K'): (), ('Gln->His', 'Q'): (), ('IodoU-AMP', 'W'): (), ('TMT2plex', 'N-term'): (), ('Biotin-PEO-Amine', 'C-term'): (), ('His->Pro', 'H'): (), ('Fluoro', 'F'): (), ('Pro->Ser', 'P'): (), ('Biotin-phenacyl', 'S'): (), ('Ala->Gly', 'A'): (), ('Methylphosphonate', 'T'): (), ('Hex', 'N'): (), ('MercaptoEthanol', 'T'): (), ('Phospho', 'H'): (), ('Acetyl', 'C'): (), ('Tyr->Cys', 'Y'): (), ('Methylphosphonate', 'S'): (), ('Biotin-PEO-Amine', 'D'): (), ('PET', 'S'): (), ('iTRAQ8plex:13C(6)15N(2)', 'K'): (), ('FP-Biotin', 'K'): (), ('O-Methylphosphate', 'S'): (), ('Malonyl', 'S'): (), ('Propionyl:13C(3)', 'N-term'): (), ('NA-OA-NO2', 'H'): (), ('Cation:Ag', 'C-term'): (), ('Phosphoadenosine', 'K'): (), ('Heme', 'C'): (), ('Label:13C(9)15N(1)', 'F'): (), ('Hex(3)', 'N'): (), ('QQQTGG', 'K'): (), ('Triiodothyronine', 'Y'): (), ('Methyl', 'I'): (), ('Pyridylacetyl', 'K'): (), ('Cation:Na', 'D'): (), ('Formyl', 'T'): (), ('CarbamidomethylDTT', 'C'): (), ('Cation:Ag', 'D'): (), ('probiotinhydrazide', 'P'): (), ('LG-anhydrolactam', 'N-term'): (), ('Ser->Ile', 'S'): (), ('Propionyl:13C(3)', 'K'): (), ('Carboxymethyl', 'W'): (), ('Cytopiloyne', 'Y'): (), ('3sulfo', 'N-term'): (), ('Cation:Na', 'C-term'): (), ('His->Asp', 'H'): (), ('Atto495Maleimide', 'C'): (), ('GluGluGluGlu', 'E'): (), ('Label:13C(5)15N(1)', 'V'): (), ('Pyridylacetyl', 'N-term'): (), ('Hex(1)HexNAc(1)NeuAc(1)', 'T'): (), ('OxLysBiotin', 'K'): (), ('Cation:Li', 'E'): (), ('Gln->Glu', 'Q'): (), ('BHTOH', 'H'): (), ('CLIP_TRAQ_1', 'K'): (), ('Octanoyl', 'S'): (), ('GluGluGlu', 'E'): (), ('HNE-Delta:H(2)O', 'H'): (), ('AEBS', 'H'): (), ('Cy3b-maleimide', 'C'): (), ('Val->Gly', 'V'): (), ('Hep', 'K'): (), ('PGA1-biotin', 'C'): (), ('Palmitoyl', 'K'): (), ('Leu->Gln', 'L'): (), ('Asp->Asn', 'D'): (), ('iTRAQ4plex115', 'K'): (), ('LG-anhyropyrrole', 'N-term'): (), ('Met-loss+Acetyl', 'M'): (), ('LG-Hlactam-K', 'N-term'): (), ('HexNAc', 'S'): (), ('ADP-Ribosyl', 'E'): (), ('SulfanilicAcid', 'D'): (), ('MicrocinC7', 'C-term'): (), ('Thiophos-S-S-biotin', 'S'): (525.142894,), ('TMPP-Ac', 'N-term'): (), ('EDT-maleimide-PEO-biotin', 'S'): (), ('Hex(1)HexNAc(1)NeuAc(2)', 'T'): (), ('Label:13C(6)+GlyGly', 'K'): (), ('Phospho', 'C'): (), ('GluGluGluGlu', 'C-term'): (), ('ICPL:2H(4)', 'K'): (), ('Argbiotinhydrazide', 'R'): (), ('O-Diethylphosphate', 'T'): (), ('Decanoyl', 'S'): (), ('Hex(2)HexNAc(2)dHex(1)', 'N'): (), ('SPITC:13C(6)', 'N-term'): (), ('Dimethyl:2H(6)13C(2)', 'R'): (), ('Diisopropylphosphate', 'Y'): (), ('ICPL:13C(6)', 'N-term'): (), ('Hex(1)HexNAc(2)dHex(1)Pent(1)', 'N'): (), ('Diethyl', 'N-term'): (), ('Heme', 'H'): (), ('Methyl+Deamidated', 'N'): (), ('MolybdopterinGD+Delta:S(-1)Se(1)', 'C'): (), ('Arg->Lys', 'R'): (), ('Methyl', 'N'): (), ('Thiophos-S-S-biotin', 'T'): (525.142894,), ('Myristoyl', 'K'): (), ('ESP:2H(10)', 'K'): (), ('Phycoerythrobilin', 'C'): (), ('Carbamidomethyl', 'K'): (), ('iTRAQ8plex', 'Y'): (), ('Pro->Leu', 'P'): (), ('O-Diethylphosphate', 'Y'): (), ('iTRAQ4plex115', 'Y'): (), ('Didehydroretinylidene', 'K'): (), ('IodoU-AMP', 'F'): (), ('Hex(3)HexNAc(1)Pent(1)', 'N'): (), ('ESP:2H(10)', 'N-term'): (), ('LG-anhydrolactam', 'K'): (), ('Gly->Trp', 'G'): (), ('Cation:Ca[II]', 'D'): (), ('Cytopiloyne', 'C'): (), ('Hex(3)HexNAc(4)', 'N'): (), ('ZGB', 'N-term'): (), ('HexN', 'K'): (), ('Ala->Pro', 'A'): (), ('Benzoyl', 'K'): (), ('ExacTagThiol', 'C'): (), ('Thiophospho', 'Y'): (), ('TMT', 'N-term'): (), ('GPIanchor', 'C-term'): (), ('OxArgBiotinRed', 'R'): (), ('Dethiomethyl', 'M'): (), ('Phytochromobilin', 'C'): (), ('Carbamyl', 'C'): (), ('Phosphoguanosine', 'K'): (), ('GlyGly', 'T'): (), ('Phosphopropargyl', 'T'): (), ('Dimethyl', 'R'): (), ('Gly->Glu', 'G'): (), ('ICAT-D', 'C'): (), ('Carboxy', 'W'): (), ('Phosphopropargyl', 'S'): (), ('Acetyl', 'T'): (), ('Carbamidomethyl', 'H'): (), ('NA-LNO2', 'H'): (), ('Ser->LacticAcid', 'S'): (), ('GlyGly', 'S'): (), ('Gly->Arg', 'G'): (), ('Leu->Val', 'L'): (), ('Met->Arg', 'M'): (), ('FTC', 'P'): (), ('Piperidine', 'N-term'): (), ('CLIP_TRAQ_3', 'Y'): (), ('Dioxidation', 'W'): (), ('Ser->Asn', 'S'): (), ('Hex', 'K'): (), ('2-succinyl', 'C'): (), ('Didehydro', 'Y'): (), ('AEC-MAEC:2H(4)', 'S'): (), ('Ile->Ser', 'I'): (), ('Formyl', 'K'): (), ('Ethanedithiol', 'T'): (), ('Hex', 'Y'): (), ('Biotin-PEG-PRA', 'M'): (), ('Diisopropylphosphate', 'T'): (), ('cGMP+RMP-loss', 'C'): (), ('Phenylisocyanate:2H(5)', 'N-term'): (), ('Menadione-HQ', 'K'): ()} ;
