# Konfuzio SDK

The Konfuzio Software Development Kit (SDK) provides the tools to work with the data layer used by Konfuzio software.
Using the SDK you can communicate with the Konfuzio App and use the data structure in your projects.

## Quickstart

1. `pip install konfuzio-sdk`
2. [Register online for free](https://app.konfuzio.com)
3. `cd <your_working_directory>`
4. `konfuzio_sdk init`

## Roadmap

- [Hello World Konfuzio Tutorial](https://github.com/konfuzio-ai/document-ai-python-sdk/blob/master/docs/QuickStart.md)
- [Source Code Online Documentation](https://konfuzio-ai.github.io/document-ai-python-sdk/)
- [Active Learning Tutorial](https://colab.research.google.com/drive/1JaVL2L6MVUtl-x-8eGJ9FnSkAybHv3nh?usp=sharing): An example of how Konfuzio SDK package can be used in a pipeline to have an easy feedback workflow can be seen in the tutorial bellow.
- [(coming soon): Tutorial: Count number of relevant words per document](https://github.com/konfuzio-ai/document-ai-python-sdk/issues/)
- (coming soon): Tutorial: How to set up a python environment for beginners
- (coming soon): Tutorial: Create a custom AI model with CI Pipeline and Webhook
- (coming soon): Tutorial: Fine tunning a Konfuzio model
- (coming soon): Tutorial: Paragraph tokenization via pretrained faster rCNN API
- We are looking for your challenges - please create issues [here](https://github.com/konfuzio-ai/document-ai-python-sdk/issues)

## References

- [Open API Documentation](https://app.konfuzio.com/v2/swagger/)
- [Configuration](https://github.com/konfuzio-ai/document-ai-python-sdk/blob/master/docs/ConfigurationReference.md)
- [How to Contribute](https://github.com/konfuzio-ai/document-ai-python-sdk/blob/master/CONTRIBUTION.md)
- [Issue Tracker](https://github.com/konfuzio-ai/document-ai-python-sdk/issues)
- [MIT License](https://github.com/konfuzio-ai/document-ai-python-sdk/blob/master/LICENSE.md)
- [Konfuzio Homepage](https://www.konfuzio.com/en/)
